<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv" %>

<fmt:bundle basename="localization.BackupBrowseMessages">
	<jsp:include page="../common/headerV2.jsp">
		<jsp:param value="../browse/css/shareFiles.css" name="css" />
		<jsp:param value="../common/css/headerstyles.css" name="css" />
		<jsp:param value="true" name="includeHistory" />
		<jsp:param value="true" name="includeSecHeader" />
		<jsp:param value="true" name="includeJqueryUI" />
		<jsp:param value="true" name="includeMask" />
		<jsp:param value="${pageTitle}" name="titleLocalized" />
		<jsp:param value="${headerTitle}" name="headerTitleLocalized" />
		<jsp:param value="dialog" name="displayMode" />
		<jsp:param value="../common/js/jquery.tinyscrollbar.min.js" name="js" />
      	<jsp:param value="../common/css/custom-cb.css" name="css" />
      	<jsp:param value="../common/css/changeName.css" name="css" />
      	<jsp:param value="../common/js/encoder.js" name="js"/>
	</jsp:include>

		<fmt:message key="sharing.label.canView" var="canViewLabel" />
		<fmt:message key="sharing.label.canEdit" var="canEditLabel" />
		<fmt:message key="upload.label.untitledFolder" var="untitledFolder" />
		<fmt:message key="sharing.lebel.confirmDeleteText" var="confirmDeleteText" />
		<fmt:message key="sharing.lebel.confirmDeleteDelegateText" var="confirmDeleteDelegateText" />
		<fmt:message key="sharing.label.confirmDeleteTitle" var="confirmDeleteTitle" />
		<fmt:message key="sharing.lebel.confirmLeaveText" var="confirmLeaveText" />
		<fmt:message key="sharing.label.confirmLeaveTitle" var="confirmLeaveTitle" />
		<fmt:message key="sharing.error.text3" var="errorText3" />
		<fmt:message key="sharing.error.text4" var="errorText4" />
		<fmt:message key="sharing.error.text5" var="errorText5" />
		<fmt:message key="sharing.error.text6" var="errorText6" />
		<fmt:message key="sharing.error.text7" var="errorText7" />
		<fmt:message key="sharing.label.untitledFolder" var="untitledFolderText" />
		<fmt:message key="share.label.addUsers" var="addUsers" />
		<fmt:message key="share.error.somethingWentWrong" var="somethingWentWrong" />
		<fmt:message key="share.label.keepDeleteReshareLabel" var="keepDeleteReshareLabel" />
		<fmt:message key="share.label.resharesExist" var="resharesExist" />
		<fmt:message key="share.lebel.delete" var="deleteLabel" />
		<fmt:message key="share.label.keep" var="keepLabel" />

	<c:set var="shareInfo" value="${requestScope.shareFolderInfo}" />

	<!-- MAIN SHARE FOLDER DIV -->
	<div class="shareFileDiv">

		<!-- SHARE FOLDER TITLE DIV -->
		<span id="changeNameTitle" class="changeNameTitleClass vw-change-name">
			<span id="changeName" data-id="${requestScope.shareFolderId}" data-istemplate="1" class="">${requestScope.shareFolderName}</span>
			<input type="text" id="changeFolderNameTextBox" class="hidden" value="${requestScope.shareFolderName}">
		</span>

		<!-- SHARE FOLDER PEOPLE TO SHARE WITH DIV -->
		<div class="peopleToShare">
					<div class="subDivTitle"><fmt:message key="sharing.label.invitePeople" /></div>
			<div class="subDivBody">

						<div id="invitePeopleDiv">
							<div id="inviteAddAreaDiv">
								<div id="inputArea">
									<div id="addButtonDiv"><span class='sprite icon-add_20' title="${addUsers}"></span></div>
									<div class="rightSContainer">
										<div id="userPrivileges" class="inputAreaDivs">
										    <div class="select">
											    <div class="selectIcon viewModeOnly">
											    	<label>${canViewLabel}</label>
											    	<span class="sprite icon-arrow-dropdown" alt="^"></span>
									    		</div>
									    	</div>
										</div>
									</div>
									<div id="searchContainer" class="inputAreaDivs">
									   	<div id="inputTextContainer" class="textbox" >
									   		<!-- <div class="inputItemUser">Siddharth lamba<span class="removeItem">&times;</span></div>  -->
									   		<div class="inputRealContainer" >
 									   			<!--hack to stop chrome from prepopulating usernames -->
									   			<input type="text" id="hacktoworkaroundchromebeingannoying" name="hacktoworkaroundchromebeingannoying" style="opacity:0;position:fixed;pointer-events:none;overflow:hidden;display:block;width:0;height:0;" value=" " />
									   			<input type="text" id="field" name="field" autocomplete="off" value="" placeholder="<fmt:message key='sharing.label.placeHolderTest'/>"/>
								   			</div>
								   		</div>
									</div>
									<div id="userSuggestions">
										<table id="userSuggestionsTable">
											<tbody>
												<!-- <tr class="suggestionsRow">
													<td class="suggestionsData">
														<span class="matchText">test</span><span class="suggestedText"> internet speed</span>
													</td>
												</tr> -->
										</table>
									</div>
								</div>
							</div>


					<div id="scrollbar3" class="tinyScrollbar">
						<div class="scrollbar"><div class="track"><div class="thumb"><div class="end"></div></div></div></div>
						<div class="viewport">
							<div class="overview">
								<c:choose>
						    		<c:when test="${requestScope.isCreateFolder == 'true' || requestScope.appType == 'EXCHANGEMAILBOX'}">
						    			<c:set var="ownerName" value="${requestScope.userName}"/>
						    		</c:when>
						    		<c:otherwise>
					    			<c:set var="ownerName" value="${shareInfo.owner.userName}"/>
						    		</c:otherwise>
					    		</c:choose>
								  <div id="addedPeopleDiv" class="test">
									<div class="peopleInfos ownerInfo" data-loginname="${ownerName}">
									    <div class="select USER">
									    	<span class="sprite icon-user"></span>
									    	<div class="selectText">${ownerName}</div>
									    	<div class="selectIcon disabled ownerRow">
									    		<label><fmt:message key="sharing.label.owner" /></label>
							    			</div>
									    </div>
									</div>
									<c:if test="${requestScope.isCreateFolder == 'false'}">
									<c:forEach var="item" items="${shareInfo.sharedTo}">
											<c:choose>
											    <c:when test="${item.userType == 'USER'}">
											    	<c:set var="loginName" value="${item.user.userName}" />
											    	<c:set var="spriteType" value="user" />
											    </c:when>
											    <c:when test="${item.userType == 'EMAIL'}">
											    	<c:set var="loginName" value="${item.email}" />
											    	<c:set var="spriteType" value="email" />
											    </c:when>
											    <c:when test="${item.userType == 'COMMCELL_GROUP'}">
											    	<c:set var="loginName" value="${item.group.userGroupName}" />
											    	<c:set var="spriteType" value="group" />
											    </c:when>
											    <c:when test="${item.userType == 'EXTERNAL_GROUP'}">
											    	<c:set var="loginName" value="${item.externalGroup.externalGroupName}" />
											    	<c:set var="spriteType" value="group" />
											    </c:when>
										    </c:choose>
											<div class="peopleInfos" data-loginname="${loginName}">
											    <div class="select ${item.userType}">
												    <span class="sprite icon-${spriteType}"></span>
											    	<div class="selectText">${loginName}</div>
													<c:if test="${requestScope.isCreateFolder != 'true' && requestScope.shareFolderInfo.canUserEdit == 'false'}">
														<c:set var="changeModeDisabledClass" value="disabled" />
													</c:if>
													<div class="rightSContainer">
													    <c:choose>
														    <c:when test="${item.permission == 'VIEW'}">
														    	<div class="selectIcon viewModeOnly ${changeModeDisabledClass}">
															    	<label>${canViewLabel}</label>
															    	<span class="sprite icon-arrow-dropdown" alt="^"></span>
													    		</div>
														    </c:when>
															<c:when test="${item.permission == 'EDIT' && !requestScope.isNfsObjectStore}">
														     	<div class="selectIcon editMode ${changeModeDisabledClass}">
															    	<label>${canEditLabel}</label>
															    	<span class="sprite icon-arrow-dropdown" alt="^"></span>
													    		</div>
														    </c:when>
													    </c:choose>
													    <c:if test="${requestScope.isCreateFolder == 'true' || requestScope.shareFolderInfo.canUserEdit == 'true'}">
													   		<div class="deleteItem xButton" data-reshareCount="${item.userHasReshares}">&times;</div>
													    </c:if>
												    </div>
											 	</div>
											</div>
										</c:forEach>
									</c:if>
								</div>
							</div>
						</div>
					</div>

			</div>
		</div>


		<!-- SHARE FOLDER DROP DOWN FOR VIEW/EDIT SELECTION DIV -->
		<div id="dropDownShareDiv">
			<ul role="radiogroup" aria-label="<fmt:message key="sharing.ariaLabel.userPermissions" />">
				<li class="viewModeLI" aria-checked="true" role="radio" tabindex="0">

					<div class="custom-rb checked-rb" data-state="checked" data-id="1"></div>
					<span class="custom-rb-label">
						<label class="modeSetting">${canViewLabel}</label> <br />
						<c:choose>
							<c:when test="${requestScope.appType != 'EXCHANGEMAILBOX'}">
								<span class="noteText"><fmt:message key="sharing.label.canViewText" /></span>
							</c:when>
							<c:otherwise>
								<span class="noteText"><fmt:message key="sharing.label.canViewTextExchange" /></span>
							</c:otherwise>
						</c:choose>
					</span>
					<span class="sprite icon-eye"></span>
				</li>
				<c:if test="${requestScope.isUploadAvailable && !requestScope.isNfsObjectStore}">
					<fmt:bundle basename="localization.BackupBrowseMessages">
						<li class="editModeLI" aria-checked="false" role="radio" tabindex="-1">
							<div class="custom-rb unchecked-rb" data-state="unchecked" data-id="1"></div>
							<span class="custom-rb-label">
								<label class="modeSetting">${canEditLabel}</label> <br />
								<span class="noteText"><fmt:message key="sharing.label.canEditText" /></span>
							</span>
							<span class="sprite icon-edit"></span>

						</li>
					</fmt:bundle>
				</c:if>
			</ul>
		</div>

		<!-- SHARE FOLDER ERROR DIV -->
		<div class="errorDiv">
			<label id="errorMessage"></label>
		</div>


		<div class="btns" >
			<c:choose>
				<c:when test="${requestScope.isCreateFolder == 'true' && requestScope.appType != 'EXCHANGEMAILBOX'}">
					<a type="button" class="shareButton okSaveButton mainBtn" ><fmt:message key="share.label.shareLabel" /></a>
				</c:when>
				<c:when test="${requestScope.isCreateFolder == 'true' && requestScope.appType == 'EXCHANGEMAILBOX'}">
					<a type="button" class="shareButton okSaveButton mainBtn" ><fmt:message key="share.label.delegateLabel" /></a>
				</c:when>
				<c:when test="${shareInfo.canUserEdit == 'true' && !requestScope.isNfsObjectStore}">
					<a type="button" class="updateButton okSaveButton mainBtn" ><fmt:message key="share.label.updateLabel" /></a>
				</c:when>
				<c:otherwise>
					<!-- <a type="button" class="doneButton okSaveButton mainBtn" >Done</a> -->
				</c:otherwise>
			</c:choose>

			<a type="button" class="cancelButton" id="cancelButton"><fmt:message key="upload.label.cancel" /></a>


			<c:if test="${requestScope.isCreateFolder != 'true' && requestScope.shareFolderInfo.canUserEdit == 'true'}">
				<c:choose>
					<c:when test="${requestScope.appType != 'EXCHANGEMAILBOX'}">
						<a type="button" id="deleteButton" class="cancelButton leftButton"><fmt:message key="share.label.deleteShareLabel" /></a>
					</c:when>
					<c:otherwise>
						<a type="button" id="deleteButton" class="cancelButton leftButton"><fmt:message key="share.label.deleteDelegateLabel" /></a>
					</c:otherwise>
				</c:choose>
			</c:if>
		</div>

		</div>

		<c:if test="${requestScope.isEdgeClient && !requestScope.noSelections}">
			<div class="permissionsInfo" >
				<div class="textForText">
					<span>
					  <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 30.75 28.55" fill="#498bf4" style="width: 25px;">
					    <path d="M31.14,27.1,18,2.94a2.19,2.19,0,0,0-3.84,0L.93,27.1a2.16,2.16,0,0,0,0,2.16,2.2,2.2,0,0,0,1.89,1.08H29.22a2.21,2.21,0,0,0,1.89-1.08A2.15,2.15,0,0,0,31.14,27.1ZM17.46,25.49a.75.75,0,0,1-.74.74H15.35a.74.74,0,0,1-.74-.74V24.21a.74.74,0,0,1,.74-.74h1.37a.74.74,0,0,1,.74.74Zm.07-4.67a.78.78,0,0,1-.76.74H15.31a.78.78,0,0,1-.77-.74l-.34-9.24a.71.71,0,0,1,.71-.74h2.23a.71.71,0,0,1,.71.74Z" transform="translate(-0.66 -1.8)"></path>
					  </svg>
					</span>
					<span class="permissionsUserTopText"></span>
				</div>
				<div class="permissionsUserInfo" >
					<span class="permissionsUserText"></span>
					<span class="permissionsUserList" ></span>
				</div>
			</div>
		</c:if>
	</div>


	<!-- ADVANCED OPTIONS DIV -->
	<jsp:include page="../browse/commonShareInfo.jsp" >
		<jsp:param value="${shareInfo.browseInfo.expirationTime.time}" name="timeValue"/>
		<jsp:param value="${shareInfo.canReshare}" name="isReshareEnabled"/>
		<jsp:param value="${requestScope.showReshare}" name="isReshareFeatureEnabled"/>
		<jsp:param value="${requestScope.isCreateFolder}" name="isNewShare" />
		<jsp:param value="${requestScope.appType}" name="appType" />
	</jsp:include>
	<!-- END ADVANCE OPTIONS DIV -->

	<script nonce="${sessionScope.cspNonce}" >
	var clientName = "${requestScope.clientName}";
	var clientId = "${requestScope.clientId}";
	var subClientId = "${requestScope.subclientId}";
	var canUserEdit = "${shareInfo.canUserEdit}";
	var isCreateFolder = "${requestScope.isCreateFolder}";
	var isEdgeClient = "${requestScope.isEdgeClient}";
	var monikerRealPath = "${requestScope.monikerRealPath}";
	var browsePath = "${requestScope.browsePath}";
	var isFolder = "${requestScope.isFolder}";
	var isParentReadOnly = "${requestScope.isParentReadOnly}";
	if (isParentReadOnly === "true"){
		$(".editModeLI").hide();
	}
	var isPwdSet = "${shareInfo.browseInfo.password.isSet}";
	var expirationDate = ("${shareInfo.browseInfo.expirationTime.time == ''}") ? 0 : parseInt("${shareInfo.browseInfo.expirationTime.time}") * 1000;
	var browseParentShareId = "${requestScope.browseParentShareId}";
	var hasNoSelections = ("true" === "${requestScope.noSelections}");
	var shareFiles = shareFiles || {};
	shareFiles.hasReshares ="${shareInfo.hasReshares}";
	shareFiles.reshareOriginalVal = ("true" === "${shareInfo.canReshare}");
	shareFiles.isInheritFromParent = ("true" === "${requestScope.isInheritFromParent}");
	shareFiles.isCustomPermissionsSet = ("true" === "${requestScope.isCustomPermissionsSet}");
	shareFiles.guid = "${requestScope.guid}";
	shareFiles.appType = "${requestScope.appType}";

	<%-- Add remote CommCell details, if present. --%>
	if (typeof cvUtil == "object")
	{
		cvUtil.ccId = "${requestScope._cid}";
		cvUtil.ccName = "${requestScope._cn}";
	}

	var localMsg = localMsg || {};
	localMsg.downloadSubmittedSingleFile = "${downloadSubmittedSingleFile}";
	localMsg.downloadSubmittedMultipleFiles = "${downloadSubmittedMultipleFiles}";
	localMsg.somethingWentWrong = "${somethingWentWrong}";
	localMsg.excludesError = "${excludesError}";
	localMsg.untitledFolder = "${untitledFolder}";

	if ("${appType}" == "EXCHANGEMAILBOX")
		localMsg.confirmDeleteText = "${confirmDeleteDelegateText}";
	else
		localMsg.confirmDeleteText = "${confirmDeleteText}";

	localMsg.confirmDeleteTitle = "${confirmDeleteTitle}";
	localMsg.confirmLeaveText = "${confirmLeaveText}";
	localMsg.confirmLeaveTitle = "${confirmLeaveTitle}";
	localMsg.errorText3 = "${errorText3}";
	localMsg.errorText4 = "${errorText4}";
	localMsg.errorToast5 = "${errorText5}";
	localMsg.errorToast7 = "${errorText7}";
	localMsg.expiredShareUpdateError = "${errorText6}";
	localMsg.canViewText = "${canViewLabel}";
	localMsg.canEditText = "${canEditLabel}";
	localMsg.untitledFolderText = "${untitledFolderText}";
	localMsg.keepDeleteReshareLabel = "${keepDeleteReshareLabel}";
	localMsg.resharesExist = "${resharesExist}";
	localMsg.deleteLabel = "${deleteLabel}";
	localMsg.keepLabel = "${keepLabel}";
	</script>

	<%@ include file="../common/datepicker.jsp" %>
	<jsp:include page="../common/footer.jsp">
		<jsp:param value="../browse/js/shareFiles.js" name="js" />
		<jsp:param value="../common/js/custom-rb.js" name="js" />
		<jsp:param value="../common/js/changeName.js" name="js" />
		<jsp:param value="../common/js/custom-cb.js" name="js" />
		<jsp:param value="../browse/js/browseCommon.js" name="js" />
		<jsp:param value="../common/bootstrap/javascripts/bootstrap.min.js" name="js" />
	</jsp:include>

</fmt:bundle>
