<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<fmt:bundle basename="localization.BackupBrowseMessages">
	<fmt:message key="backupBrowse.label.save" var="save" />
	<fmt:message key="backupBrowse.label.ok" var="ok" />
	<fmt:message key="backupBrowse.label.cancel" var="cancel" />
</fmt:bundle>
<c:set var="clientIdParam" value="${fn:escapeXml(param.clientId)}" />
<fmt:bundle basename="localization.ClientDetailsMessages">
	<fmt:message key="error.passkeysDontMatch" var="passkeysDontMatch"/>
	<fmt:message key="clientlock.info.passkeyDisclaimer" var="passkeyDisclaimer" />
	<fmt:message key="clientDetails.label.note" var="note" />
	<fmt:message key="clientlock.info.passkeyConfirmationDisclaimer" var="passkeyConfirmationDisclaimer" />
</fmt:bundle>
<script nonce="${sessionScope.cspNonce}" >
var clientId = "${clientIdParam}";
function passwordsMatch(pass1,pass2)
{
	return (pass1 === pass2);
}
function showThisError(msg)
{
	$("#setPasskeyErrDiv").html(msg);
	$("#setPasskeyErrDiv").show();
	$("#okButton").removeClass("loading");
}
function clearAllErrorMsgs()
{
	$("#okButton").removeClass("loading");
	$("#setPasskeyErrDiv").html("");
	$("#setPasskeyErrDiv").hide();
}
$("#confirmPassKey").keyup(function(event) {
	if (event.keyCode == 13) {
		submitThis();
	}
});
$("#okButton").on("click keydown",function(e){
	if (e.which == 13 || e.type == "click"){
		submitThis();
	}
});
function submitThis(){
	clearAllErrorMsgs();
	browseMain.privacyChanged = false;
	var passKey = null;

	//validations
	if ($("#passKey")&&($.trim($("#passKey").val())))
		passKey = Base64.encode($.trim($("#passKey").val()));
	var confirmPassKey = null;
	if ($("#confirmPassKey")&&($.trim($("#confirmPassKey").val())))
		confirmPassKey = Base64.encode($.trim($("#confirmPassKey").val()));

	if (!passwordsMatch(passKey,confirmPassKey)){
			showThisError("${passkeysDontMatch}");
			return;
	}
	//validations done

	var userInfo = {};
	userInfo.currentPasskey = cvUtil.toByteArray($.trim($("#passKey").val()));
	userInfo.passkeyOpType = 1;
	var params = {
			clientId : clientId,
			setPasskeyRequest : JSON.stringify(userInfo)
		};
	var options = {	yesText : "${ok}",
					noText : "${cancel}",
					title : "${note}",
					reqParams : params
				}
	var divText = "<div>${passkeyConfirmationDisclaimer}</div><br>";

	//show confirmation disclaimer dialog
	cvUtil.showWarningDialog(options, divText, function(closeFunction) {
		closeFunction();
		$("#okButton").addClass("loading");

		//call api to set the passkey
	 	var result = cvUtil.loadSynchronously('setPasskey.do', options.reqParams, function(
				data) {
	 		showThisError(data);
			return false;
		});
		$("#okButton").removeClass("loading");
		if (result == "Success") {
			browseMain.privacyChanged = true;
			cvUtil.closeModal();
		} else {
			//show error in case api returned one
			showThisError(result);
		}
	});
};

$("#cancelButton").on("click keydown", function(e) {
	if (e.which == 13 || e.type == "click"){
		cvUtil.closeModal();
	}
});

</script>

<fmt:bundle basename="localization.ClientDetailsMessages">
<div id="setPasskeyErrDiv" class="vw-alert vw-message alert-danger vw-start-hidden margin-right-15"></div>
<div id="setPasskeyDiv" class="margin-right-15">
		<br/>
		<div class="infotype pull-left">
			<div class="vw-help-text"><small><span class="vw-underline">${note}</span>&nbsp;${passkeyDisclaimer}</small></div>
			<br/>
		</div>
		<div>
			<div class="infotype pull-left"><fmt:message key="clientlock.label.passKey"/></div>
			<input id="passKey" type="password" class="textbox form-control" autofocus tabindex="1"/>
		</div>
		<div>
			<div class="infotype pull-left"><fmt:message key="clientlock.label.confirmPassKey"/></div>
			<input id="confirmPassKey" type="password" class="textbox form-control" tabindex="2" />
		</div>
</div>
<br/>
</fmt:bundle>
<div class="btns pull-right margin-right-15 margin-bottom-15">
				<a type="button" id="cancelButton" class="vw-btn vw-btn-default" tabindex="4">${cancel}</a>
				<a type="button" id="okButton" class="okSaveButton mainBtn vw-btn vw-btn-primary" tabindex="3"><span class="vw-btn-text">${save}</span><svg xmlns="http://www.w3.org/2000/svg" width="23px" height="23px" viewBox="0 0 100 100" preserveAspectRatio="xMidYMid" class="uil-spin"><g transform="translate(50 50)"><g transform="rotate(0) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.44167 1.44167)"><animate attributeName="opacity" from="1" to="0.1" begin="0s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g><g transform="rotate(45) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.00167 1.00167)"><animate attributeName="opacity" from="1" to="0.1" begin="0.12s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0.12s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g><g transform="rotate(90) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.06667 1.06667)"><animate attributeName="opacity" from="1" to="0.1" begin="0.25s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0.25s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g><g transform="rotate(135) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.12667 1.12667)"><animate attributeName="opacity" from="1" to="0.1" begin="0.37s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0.37s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g><g transform="rotate(180) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.19167 1.19167)"><animate attributeName="opacity" from="1" to="0.1" begin="0.5s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0.5s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g><g transform="rotate(225) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.25167 1.25167)"><animate attributeName="opacity" from="1" to="0.1" begin="0.62s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0.62s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g><g transform="rotate(270) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.31667 1.31667)"><animate attributeName="opacity" from="1" to="0.1" begin="0.75s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0.75s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g><g transform="rotate(315) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.37667 1.37667)"><animate attributeName="opacity" from="1" to="0.1" begin="0.87s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0.87s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g></g></svg></a>
</div>