<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<fmt:bundle basename="localization.BackupBrowseMessages">
	<fmt:message key="backupBrowse.label.save" var="ok" />
	<fmt:message key="backupBrowse.label.cancel" var="cancel" />
</fmt:bundle>
<c:set var="clientIdParam" value="${fn:escapeXml(param.clientId)}" />
<c:set var="clientNameParam" value="${fn:escapeXml(param.clientName)}" />
<c:set var="manualUsernameParam" value="${fn:escapeXml(param.manualUsername)}" />
<fmt:bundle basename="localization.ClientDetailsMessages">
	<fmt:message key="clientDetails.label.note" var="note" />
	<fmt:message key="clientDetails.label.noteMessage" var="accountNoteMessage">
		<fmt:param value="${clientNameParam}" />
	</fmt:message>
</fmt:bundle>
<fmt:message key="Register_Password_error" var="passwordsDontMatch"/>
<script nonce="${sessionScope.cspNonce}" >
var clientId = "${clientIdParam}";
var clientName = "${clientNameParam}" ;
var manualUsername = "${manualUsernameParam}" ;
function passwordsMatch(pass1,pass2)
{
	return (pass1 === pass2);
}
function showThisError(msg)
{
	$("#syncErrDiv").html(msg);
	$("#syncErrDiv").show();
}
function clearAllErrorMsgs()
{
	$("#okButtonForSync").removeClass("loading");
	$("#syncErrDiv").html("");
	$("#syncErrDiv").hide();
}
$("#okButtonForSync").on("click",function(){
	clearAllErrorMsgs();
	var selectedUser = "";
	var password = null;
	if (manualUsername === "true"){
		selectedUser = $("#manualUserName").val().trim();
	} else {
		selectedUser = $("#profileSelection").val();
		//don't save profile if no profile is selected:this happens if no profile is present for a client
		if (!selectedUser){
			return;
		}

		if ($("#password")&&($.trim($("#password").val())))
			password = Base64.encode($.trim($("#password").val()));

		var confirmPassword = null;
		if ($("#confirmPassword")&&($.trim($("#confirmPassword").val())))
			confirmPassword = Base64.encode($.trim($("#confirmPassword").val()));

		if (!passwordsMatch(password,confirmPassword)){
				showThisError("${passwordsDontMatch}");
				return;
		}
	}

	$("#okButtonForSync").addClass("loading");
	var contentsFinal = "clientId=" + clientId +"&clientName=" + encodeURIComponent(clientName) + "&userName=" +encodeURIComponent(selectedUser);
	if (!(manualUsername === "true")){
		contentsFinal += "&password="+encodeURIComponent(password);
	}

	//call to update the mapping
	cvUtil.loadPage(cvUtil.getContextPath() + '/server/doSaveSyncUser?'+contentsFinal,
					function(data){
						//set error string here
						showThisError(data);
					},function(retMsg)
					{
						$("#okButtonForSync").removeClass("loading");
						if ((retMsg)&&(retMsg=="0"))
							{
								browseMain.userProfileMapping = selectedUser;
								cvUtil.closeModal();
							}else{
								showThisError(retMsg);
							}
					});

});
$("#cancelButton").on("click", function() {
	cvUtil.closeModal();
})
$(document).ready(function() {
	if (manualUsername === "true"){
		$(".dropdownUserSelection").hide();
	} else{
		$(".manualUserSelection").hide();
		cvUtil.loadPage(cvUtil.getContextPath() + '/server/syncUserList?clientId='+clientId+'&clientName='+encodeURIComponent(clientName), null, function(data) {
			if (data == null || data == "") {
				return;
			}
			var returnedItems = JSON.parse(data);
			var htmlString="";
			var currentLocalUserProfile = null;
			if ((returnedItems.userProfileMap)&&(returnedItems.userProfileMap.localUserProfile))
						currentLocalUserProfile = returnedItems.userProfileMap.localUserProfile;
			if (returnedItems.availableUserProfiles != null &&	returnedItems.availableUserProfiles.length > 0) {
						for (var i = 0; i < returnedItems.availableUserProfiles.length; i++) {
							var currName = returnedItems.availableUserProfiles[i].name;
							htmlString += "<option title='"+cvUtil.escapeHtml(currName)+"'";
							if (currentLocalUserProfile && (currentLocalUserProfile === currName))
								htmlString+=" selected ";
							htmlString +=">" +cvUtil.escapeHtml(currName)	 + "</option>";
						}
			}
			$("#profileSelection").html(htmlString);

		}, function() {
		}, null);

	}

});

</script>


<div id="syncErrDiv" class="vw-alert vw-message alert-danger vw-start-hidden" style="margin-right: 15px;"></div>
<br/>
<div id="syncProfileDiv" style="margin-right: 15px;">
	<div class="dropdownUserSelection">
		<select id="profileSelection" class="form-control input-sm" tabindex="1"></select>
		<br/>
		<input type="password" id="password" autocomplete="off" placeholder="<fmt:message key="Password" />" name="password" class="textbox form-control" tabindex="2"/>
		<br/>
		<input type="password" id="confirmPassword" autocomplete="off" placeholder="<fmt:message key="Confirm_Password" />" name="password" class="textbox form-control" tabindex="3"/>
		<br/>
	</div>
	<div class="manualUserSelection">
		<input type="text" id="manualUserName" placeholder="<fmt:message key="Username" />" name="manualUserName" class="textbox form-control" tabindex="1"/>
		<br/>
	</div>
	<div class="vw-help-text"><small><span class="vw-underline">${note}</span>&nbsp;${accountNoteMessage}</small></div>
</div>
<br/>
<div class="btns pull-right" style="padding-right:15px; padding-bottom: 15px;">
				<a type="button" id="cancelButton" class="vw-btn vw-btn-default" tabindex="5">${cancel}</a>
				<a type="button" id="okButtonForSync" class="okSaveButton mainBtn vw-btn vw-btn-primary" tabindex="4"><span class="vw-btn-text">${ok}</span><svg xmlns="http://www.w3.org/2000/svg" width="23px" height="23px" viewBox="0 0 100 100" preserveAspectRatio="xMidYMid" class="uil-spin"><g transform="translate(50 50)"><g transform="rotate(0) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.44167 1.44167)"><animate attributeName="opacity" from="1" to="0.1" begin="0s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g><g transform="rotate(45) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.00167 1.00167)"><animate attributeName="opacity" from="1" to="0.1" begin="0.12s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0.12s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g><g transform="rotate(90) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.06667 1.06667)"><animate attributeName="opacity" from="1" to="0.1" begin="0.25s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0.25s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g><g transform="rotate(135) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.12667 1.12667)"><animate attributeName="opacity" from="1" to="0.1" begin="0.37s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0.37s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g><g transform="rotate(180) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.19167 1.19167)"><animate attributeName="opacity" from="1" to="0.1" begin="0.5s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0.5s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g><g transform="rotate(225) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.25167 1.25167)"><animate attributeName="opacity" from="1" to="0.1" begin="0.62s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0.62s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g><g transform="rotate(270) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.31667 1.31667)"><animate attributeName="opacity" from="1" to="0.1" begin="0.75s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0.75s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g><g transform="rotate(315) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.37667 1.37667)"><animate attributeName="opacity" from="1" to="0.1" begin="0.87s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0.87s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g></g></svg></a>
</div>