<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@  taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"%>

<fmt:bundle basename="localization.BackupBrowseMessages">
	<fmt:message key="fsBackupBrowse.title.page" var="pageTitle" />
	<fmt:message key="fsBackupBrowse.title.header" var="headerTitle" />
	<fmt:message key="machineBrowse.error.clientUnreachable" var="clientUnreachableMsg" />
	<fmt:message key="machineBrowse.error.vmClientBrowseFailure" var="clientUnreachableUsernameMsg" />
	<fmt:message key="connectedClients.review.noConfirmText" var="noConfirmText" />
	<fmt:message key="connectedClients.review.yesConfirmText" var="yesConfirmText" />
	<fmt:message key="machineBrowse.error.foldersTitle" var="foldersTitle" />

	<jsp:include page="../common/headerV2.jsp">
		<jsp:param value="css/reviewDeletionBrowse.css" name="css" />
		<jsp:param value="true" name="includeSecHeader" />
		<jsp:param value="true" name="includeHistory" />
		<jsp:param value="true" name="includeJqueryUI" />
		<jsp:param value="true" name="includeMask" />
		<jsp:param value="true" name="includeTableSupport" />
		<jsp:param value="true" name="includeLatestDatatable" />
		<jsp:param value="${pageTitle}" name="titleLocalized" />
		<jsp:param value="${headerTitle}" name="headerTitleLocalized" />
		<jsp:param value="js/reviewDeletionBrowse.js" name="js" />
		<jsp:param value="../common/js/logUtil.js" name="js" />
		<jsp:param value="dialog" name="displayMode" />
		<jsp:param value="../common/js/custom-cb.js" name="js" />
		<jsp:param value="../common/css/custom-cb.css" name="css" />
		<jsp:param value="../common/css/cvdialog.css" name="css" />
		<jsp:param value="../common/css/table.css" name="css" />
	</jsp:include>
		<div id="lookupTable">

			<div id="centercol1" class="" >
				<div id="datatable_wrapper" class="dataTables_wrapper" >
					<table id="browsetable"  class="tablesorter" >
						<thead>
							<tr>
<!-- 								<th class="col-select"><span class=""></span></th> -->
								<th class="col-name"><fmt:message key="backupBrowse.tableColumn.name" /></th>
								<th class="col-folderPath"><fmt:message key="backupBrowse.tableColumn.folderPath" /></th>
							</tr>
						</thead>
					</table>

				</div>
			</div>

	</div>
		<div class="btns" style="display:none;" >
				<a href="#" id="cancelBrowseButton"><fmt:message key="connectedClients.action.admin" /></a>
				<a href="#" id="selectBrowseButton"><fmt:message key="backupBrowse.action.delete" /></a>
		</div>
		<div class="adminNotifiedMsg" style="display:none;" ><fmt:message key="connectedClients.review.adminNotified" /></div>
	</body>
</fmt:bundle>

<script nonce="${sessionScope.cspNonce}"  >

var localMsg = localMsg || {};
localMsg.clientUnreachableMsg = "${clientUnreachableMsg}";
localMsg.clientUnreachableUsernameMsg = "${clientUnreachableUsernameMsg}";
localMsg.noConfirmText = "${noConfirmText}";
localMsg.yesConfirmText = "${yesConfirmText}";
var foldersTitle = "${foldersTitle}";

var ajaxUrl = "doSyncBrowse";
var selectionMode;
var startPath;
var noMonikers = 0;
var showContentLibrary = true;
var valuesRecieved = cvUtil.getInitModalData();
var clientId = cvUtil.getParameter("clientId", null);
var reviewDeletionClientId = cvUtil.getParameter("reviewDeletionClientId", null);

$(document).ready(function() {
	var clientId = cvUtil.getParameterViaHistory("clientId");
	var clientName = cvUtil.getParameterViaHistory("clientName");
	reviewDeletionBrowseModule.initiateBrowse({
		bUrl: ajaxUrl,
		cId: clientId,
		reviewDeletionCId: reviewDeletionClientId
	});
	initActions();
});

var initActions = function() {
	$("#cancelBrowseButton").on("click", function() {
		confirmationDialog(false, localMsg.noConfirmText, cvUtil.closeModal);
	});

	$("#selectBrowseButton").on("click", function() {
		confirmationDialog(true, localMsg.yesConfirmText, cvUtil.closeModal);
	});
};


function confirmationDialog(actionFlag, confirmationText, closeBrowse) {
	// open dialog for confirmation
	var divText = "";
	divText += "<div>" + confirmationText + "<br /> ";
// 	divText += "<div class='confirmSubHeader'><input id='passwordText' class='confirmPasswordText form-control' type='password' autofocus='autofocus'></div>";
// 	divText += "</div><div id='error' class='text-danger'></div>";

	var options = {
		title : "Please confirm:",
		yesText : "Confirm",
		noText : "Cancel",
		additionalClassForNo : "noConfirm",
		additionalClassForOk : "okConfirm"
	};

	cvUtil.showWarningDialog(options, divText, function(closeDialogFn) {
		// call approve/deny handler
		var contents = "clientId=" + clientId;
		contents += "&reviewDeletionClientId=" + reviewDeletionClientId;
		contents += "&actionFlag=" + actionFlag;	// true= approve; false= Deny and notify Admin
		contents += "&clientId=" + clientId;	// drive client id

		// disable buttons
		$(".noConfirm").addClass("disabled");
		$(".okConfirm").addClass("loading");

		cvUtil.loadPageWithGET('reviewDeletionAction.do', contents,
				function(result) {
					// success fn
					if (result === "success") {
						closeDialogFn();
						if (actionFlag === true){
// 							window.top.location.href = cvUtil.getContextPath() + "/mydrive";
							window.top.location.reload(true);
						} else {
							window.top.location.reload(true);
						}
						closeBrowse();
						return true;
					} else {
						closeDialogFn();
						cvUtil.errorToast(result);
						closeBrowse();
						return true;
					}
				}, function(data) {
					// error function
					closeDialogFn();
					cvUtil.errorToast(result);
					closeBrowse();
					return true;
				});

		return false;
	}, null, function() {
		// clicked close (X button)
		// do nothing
	});

};

</script>
