<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
       <%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
       <%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>

<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv" %>


<jsp:include page="../common/headerV2.jsp">
       <jsp:param value="../common/css/headerstyles.css" name="css"/>
       <jsp:param value="../summary/css/summarystyles.css" name="css"/>
       <jsp:param value="Permission Denied" name="titleLocalized" />
</jsp:include>


<fmt:bundle basename="localization.BackupBrowseMessages">
	<fmt:message key="requestInvite.label.requestSent" var="requestSent"/>
	<fmt:message key="requestInvite.label.requestInvitations" var="requestInvitations" />
	<fmt:message key="requestInvite.label.errorInvitation" var="errorInvitations" />

<div class="errorDetails">	
		<div class="header">
			<fmt:message key="requestInvite.label.noPermission" />
		</div>
		<div class="body">
			<div class="bodyText"><fmt:message key="requestInvite.label.noPermissionText"><fmt:param value="${requestScope.ShareFolderName}"></fmt:param></fmt:message></div>
			<div id="inviteLink">
				<a href="#" id="inviteRequest" class="mainBtn"><fmt:message key="requestInvite.label.requestAnInvite"></fmt:message></a>
				<div id="inviteResponse"></div>
			</div>
		</div>
		<div class="footer">
			<div class="followupText">
				<fmt:bundle basename="localization.messages">
					<fmt:message key="common.label.returnToApplicationsPage" var="applicationsPageText" />
					<fmt:message key="common.label.refreshPage" var="refreshPageText" />
					<fmt:message key="common.label.errorLinks">
						<fmt:param value='<a href="${pageContext.request.contextPath}/applications" data-url="/common/apps.jsp">${applicationsPageText}</a>'/>
						<fmt:param value='<a href="javascript:history.go(0)">${refreshPageText}</a>'/>
					</fmt:message>
				</fmt:bundle>
			</div>
		</div>
</div>

</fmt:bundle>
<script nonce="${sessionScope.cspNonce}" >
$('document').ready(function(){
	var requestInvite = requestInvite || {};
	requestInvite.shareInviteUrl = cvUtil.getContextPath() + "/requestInvite.do";
	requestInvite.PARAM_SHARE_FOLDER_ID = "shareFolderId";
	
	//$(".detailsHead").click();
	$("#inviteRequest").on("click", function() {
		var data = {};
		var divRes = $("#inviteResponse");
		data[requestInvite.PARAM_SHARE_FOLDER_ID] = "${requestScope.ShareFolderId}";
		$(this).hide();
		divRes.text("${requestInvitations}");
		cvUtil.loadPageWithPOST(requestInvite.shareInviteUrl, data, function(result) {
			divRes.text("${requestSent}");
		}, function(e) {
			if($.trim(e.responseText) != "") {
				divRes.text($.trim(e.responseText));
			} else {
				divRes.text("${errorInvitations}");
			}
		});
	});
});
</script>
	

<style>
.errorDetails {
    margin: 150px 233px 10px;
    
}
.header {
    font-size: 1.5em;
    color: #D81B38;
    border-bottom: 1px solid #ccc;
    margin-bottom:20px;
    padding-bottom:5px;
}
.footer {
	font-size:0.9em;
	color:#666;
	margin-top:20px;
}
#inviteLink {
    margin: 25px 0 10px;
}
</style>

<jsp:include page="../common/footer.jsp" />
