<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>

<fmt:bundle basename="localization.BackupBrowseMessages">

	<fmt:message key="upload.error.folderNameCannotBeEmpty" var="emptyFolder"/>
	<fmt:message key="upload.error.folderNameNotValid" var="notValidName"/>
	<fmt:message key="backupBrowse.action.rename" var="okText"/>

	<div class="renameDiv vw-start-hidden">
			<div class="renameDialogDiv vw-form-horizontal">
				<div class="line form-group">
					<label class="infoTitle col-sm-4 control-label" for="location"><fmt:message key="backupBrowse.tableColumn.name" />:</label>
					<div class="col-sm-8">
						<input type="text" id="location" class="form-control">
					</div>
				</div>
				<div id="locationError" class="text-danger"></div>
			</div>
	</div>


<script nonce="${sessionScope.cspNonce}" >
	var renameDialogText = {};
	renameDialogText.okButtonText = '${okText}';
	renameDialogText.okButtonClass = 'renameOKButton';
	renameDialogText.notValidName = '${notValidName}';
	renameDialogText.emptyFolder = '${emptyFolder}';
	var selectFileName = function(field) {
	    var fieldVal = field.value;
	    var start = 0;
	    var end = fieldVal.lastIndexOf(".");
	    if(end == -1){
               end = fieldVal.length;
           }
	    if( field.createTextRange ) {
	        var selRange = field.createTextRange();
	        selRange.collapse(true);
	        selRange.moveStart('character', start);
	        selRange.moveEnd('character', end);
	        selRange.select();
	    } else if( field.setSelectionRange ) {
	        field.setSelectionRange(start, end);
	    } else if( field.selectionStart ) {
	        field.selectionStart = start;
	        field.selectionEnd = end;
	    }
	    field.focus();
	};
$("#parentLocation").text($("#parentLocation").text().replace(/\\\\/g,"\\"));

$("#location").keyup(function(e){
	if(e.keyCode == 13){
		$("." + renameDialogText.okButtonClass).click();
    }
});

</script>
</fmt:bundle>