<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@  taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"%>
<html>

<head>
	<jsp:include page="/common/search-engine.jsp" />
	<script nonce="${sessionScope.cspNonce}" src="${pageContext.request.contextPath}/common/js/jquery.min.js"></script>
	<style>
	.noPreview {
		font-size: 2em;
		color: #aaa;
		font-weight: lighter;
		font-family: Helvetica;
		position: absolute;
		top: 50%;
		margin-top: -111px;
		margin-left: -156px;
		left: 50%;
	}
	#downloadButtonSpan .dwnImg{
		padding: 20px 10px;
		display: block;
		cursor: pointer;
		color: #498bf4;
		background: url("${pageContext.request.contextPath}/browse/img/downloadFromPreview.png") no-repeat center center;
		width: 98px;
		height: 98px;
		text-align: center;
		margin: 0 auto;
	}
	#downloadButtonSpan .dwnBtn{
		padding: 10px 20px;
		margin-top: 5px;
		color: #498bf4;
		display: inline-block;
		border: 1px solid;
		font-size: 0.5em;
		cursor: pointer;
	}
	.hidden
	{
		visibility:hidden;
	}
	div#downloadInProgress {
		font-size: 0.45em;
		margin-top: 15px;
		display:none;
	}
	.disabled {
		pointer-events: none;
		opacity:0.4;
	}
	#downloadLink{
		color:#369;
		cursor:pointer;
	}
	.previewWrap {
		overflow: hidden;
		text-align: center;
		height: 100%;
		margin:0px;
		background-color: #fff;
	}
	body, html {
		padding: 0;
		margin: 0;
	}
	</style>
</head>

<body>
<div class="previewWrap">
	<div class="noPreview">
		<fmt:bundle basename="localization.BackupBrowseMessages">
			<fmt:message key="backupBrowse.label.noPreviewAvailable" />
			<br/>
			<c:if test="${clickWrapPage == null}">
				<fmt:message key="backupBrowse.action.download" var="download" />
				<div id="downloadButtonSpan" title="${download}" class="${fn:escapeXml(param.downloadOption)}">
					<span class="dwnImg"></span>
					<span class="dwnBtn">${download}</span>
				</div>
				<div id="downloadInProgress">
					<fmt:message key="backupBrowse.notification.downloadSubmittedFromPreview" />
				</div>
			</c:if>
		</fmt:bundle>

	</div>
</div>
	<script nonce="${sessionScope.cspNonce}" >
		function getTopWindow() {
		if (window.self == window.parent) {
			return window;
		}
		var currWindow = window;
		try {
			while (currWindow.parent.location.href) {
				if (currWindow.document.getElementById('webConsoleIFrame')) {
					return currWindow.document.getElementById('webConsoleIFrame').contentWindow;
				}
				if (currWindow.self == currWindow.parent) {
					return currWindow;
				}
				currWindow = currWindow.parent;

			}
		} catch (err) {
			return currWindow;
		}
	};

	// this is read by cliclWrap report js
	var clickWrapNoContentPage = "${clickWrapPage != null}";

	$(function() {
		$('#downloadButtonSpan').click(function(){
			if ("${standalonePage}" === "true"){
				// In case this page is used with embedded.jsp for full page preview
				// The download is triggered by the download button on the parent of current iFrame.
				$(getTopWindow().document).find("#previewButtonHolder .downloadBtn")[0].click();
			} else {
				submitDownload();
			}
		});
	});

	function getCookie( name ) {
		var parts = document.cookie.split(name + "=");
		if (parts.length == 2) return parts.pop().split(";").shift();
	}

	function expireCookie( cName ) {
		document.cookie =
		encodeURIComponent( cName ) +
		"=deleted; expires=" +
		new Date( 0 ).toUTCString();
	}


	function setFormToken() {
		var downloadToken = new Date().getTime();
		if(typeof parent.browseMain.browseActions.doDownloadWithCookie == 'function') {
			parent.browseMain.browseActions.doDownloadWithCookie(downloadToken);
		} else if(typeof parent.doDownloadWithCookie == 'function') {
			parent.opener.doDownloadWithCookie(downloadToken);
		} else {
			var downloadButton = $(parent.document).find('#downloadButton');
			if(typeof downloadButton !== "undefined" && downloadButton !== null) {
				parent.window.downloadCookieKey = downloadToken;
				downloadButton.trigger('click');
			}
		}
		return downloadToken;
	}

	var downloadTimer;
	var attempts = 120;

	// Prevents double-submits by waiting for a cookie from the server.
	function submitDownload() {
		var downloadToken = setFormToken();
		$("#downloadButtonSpan").addClass("disabled");
		$("#downloadInProgress").show();

		downloadTimer = window.setInterval( function() {
			var token = getCookie(downloadToken.toString());

			if( (token === downloadToken.toString()) || (attempts == 0) ) {
				console.debug("Recall Download may have completed. Attempt: " + attempts + ", token match = " + (token === downloadToken.toString()));
				unblockSubmit();
			}

			attempts--;
		}, 1000 );
	}

	function unblockSubmit() {
		$("#downloadButtonSpan").removeClass("disabled");
		$("#downloadInProgress").hide();
		window.clearInterval( downloadTimer );
		expireCookie( "downloadToken" );
	}
	</script>
</body>
</html>