<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@  taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"%>

<jsp:include page="../common/headerV2.jsp">
	<jsp:param value="true" name="includeJqueryUI" />
	<jsp:param value="true" name="includeTableSupport" />
	<jsp:param value="true" name="includeTreeSupport" />
	<jsp:param value="true" name="includeVistaSkin" />
	<jsp:param value="dialog" name="displayMode" />
	<jsp:param value="true" name="includeMask" />
	<jsp:param value="" name="titleLocalized" />
	<jsp:param value="../common/dynatree/skin-vista/ui.dynatree.css" name="css" />
	<jsp:param value="../common/css/cvdialog.css" name="css" />
</jsp:include>
<fmt:bundle basename="localization.BackupBrowseMessages">
	<fmt:message key="backupBrowse.action.move" var="moveText" />
	<fmt:message key="backupBrowse.action.move.title" var="moveTitleText" />
	
	<div class="moveDiv">
		<c:set var="browseDialogTitle" value='${moveTitleText}' scope="request" />
		<c:set var="showBottomText" value="false" scope="request" />
		<c:set var="browseDialogSaveButton" value='${moveText}' scope="request" />
		<c:set var="browseDialogSaveButtonClass" value='moveButton' scope="request" />
		<jsp:include page="../common/commonBrowseDialog.jsp" />
	</div>
</fmt:bundle>
<script nonce="${sessionScope.cspNonce}" >
	clientName = "${fn:escapeXml(param.clientName)}";
	clientId = "${fn:escapeXml(param.clientId)}";
	shareFolderId = "${fn:escapeXml(param.shareFolderId)}";
	initialPath = "${fn:escapeXml(param.initialPath)}";
	currentBrowsePath = "${fn:escapeXml(param.currentBrowsePath)}";
	$(".okSaveButton").addClass("disabledActions");
	rootName = (shareFolderId == null || shareFolderId == "") ? clientName : cvUtil.getParameterByName("displayName");
	rootIconPath = (shareFolderId == null || shareFolderId == "") ? "../../../common/img/cloud.png" : "../../../common/img/sharedwithme.png"; 
</script>
<style>
#browsetree span.dynatree-icon {
	background-image: url("../common/dynatree/skin-vista/icons.gif");
	margin-right: 0px;
}
</style>
<jsp:include page="../common/footer.jsp">
	<jsp:param value="js/browseCommon.js" name="js"/>
	<jsp:param value="js/moveBrowseDestination.js" name="js"/>
</jsp:include>
