<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@  taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv" %>
<%@ taglib prefix="enhance" uri="http://pukkaone.github.com/jsp" %>

<fmt:message key="My_Backups" var="myBackups" />
<fmt:message key="Summary" var="summary" />
<fmt:message key="VM_Management" var="My_Virtual_Machines" />
<fmt:message key="Virtual_Machine_Details" var="Virtual_Machine_Details" />
<fmt:message key="common.table.noDataAvailable"	var="noDataAvailable" />
<fmt:message key="common.error.incidentId" var="incidentId"/>

<fmt:bundle basename="localization.RestoreMessages">
	<fmt:message key="fsrestore.title.page" var="restoreDialogTitle" />
	<fmt:message key="restoreOptions.title.header"	var="restoreOptionsTitle" />
</fmt:bundle>

<fmt:bundle basename="localization.SearchMessages">
<fmt:message key="exch.keyword.sizeInKB" var="kb"/>
<fmt:message key="exch.keyword.sizeInMB" var="mb"/>
<fmt:message key="exch.keyword.sizeInGB" var="gb"/>
<fmt:message key="exch.keyword.sizeInBYTE" var="bytes"/>
</fmt:bundle>

<fmt:bundle basename="localization.BackupBrowseMessages">
	<fmt:message key="privacy.error.authorizationExpired" var="authorizationExpired"/>
	<fmt:message key="privacy.label.authorizeForRestore" var="authorizeForRestoreDialogTitle"/>
	<fmt:message key="download.notification.livebrowseGatheringFiles" var="livebrowseGatheringFiles"/>
	<fmt:message key="download.error.downloadFailed" var="downloadFailed"/>
	<fmt:message key="download.error.downloadNotAllowed" var="downloadNotAllowed"/>
	<fmt:message key="webedit.notsupported" var="webEditNotSupported" />
	<fmt:message key="backupBrowse.action.viewVersions" var="viewVersionsAction" />
	<fmt:message key="backupBrowse.action.reviewSelectionsWithCount" var="reviewSelectionsWithCount" />
	<fmt:message key="backupBrowse.label.selectSyncProfileTitle" var="selectSyncProfileTitle"/>
	<fmt:message key="backupBrowse.label.restoreSubmittedToast" var="restoreSubmittedToastLabel" />
	<fmt:message key="backupBrowse.label.restoreSubmittedToastCompleted" var="restoreSubmittedToastLabelCompleted" />
	<fmt:message key="backupBrowse.label.restoreJobPollCompleted" var="restoreJobPollCompleted" />
	<fmt:message key="backupBrowse.label.restoreJobPollFailed" var="restoreJobPollFailed" />
	<fmt:message key="backupBrowse.label.loadMoreFolders" var="loadMoreFolders" />
	<fmt:message key="backupBrowse.label.failedBackupItem" var="failedBackupItem" />
	<fmt:message key="backupBrowse.title.timeRangeBasic" var="timeRangeBasicOptionsTitle" />
	<fmt:message key="backupBrowse.title.timeRangeOptions" var="timeRangeAdvancedOptionsTitle" />
	<fmt:message key="backupBrowse.notification.downloadSubmitted" var="downloadSubmitted" />
	<fmt:message key="exchangeMailboxBrowse.label.selectAFolder" var="selectAFolder" />
	<fmt:message key="exchangeMailboxBrowse.label.noData" var="noData" />
	<fmt:message key="backupBrowse.label.copyPreviewURL" var="copyPreviewURL" />
	<fmt:message key="backupBrowse.notification.slowOperation" var="slowOperation" />
	<fmt:message key="upload.title.uploadPageUnload" var="uploadPageUnload" />
	<fmt:message key="upload.title.uploadFilesTitle" var="uploadFilesTitle" />
	<fmt:message key="upload.error.folderUploadError" var="folderUploadError" />
	<fmt:message key="upload.error.assignProfileLink" var="assignProfileLink"/>
	<fmt:message key="upload.error.folderDropUploadError" var="folderDropUploadError" />
	<fmt:message key="upload.error.rootUploadError" var="rootUploadError" />
	<fmt:message key="upload.action.ajaxCancel" var="ajaxCancel" />
	<fmt:message key="backupBrowse.menu.timeRangeLatestData" var="timeRangeLatestData" />
	<fmt:message key="upload.label.createNewFolder" var="createNewFolder" />
	<fmt:message key="upload.label.createFolder" var="createFolder" />
	<fmt:message key="upload.label.NewFolder" var="NewFolder" />
	<fmt:message key="share.label.shareTitle" var="shareTitle" />
	<fmt:message key="share.label.delegateTitle" var="delegateTitle" />
	<fmt:message key="share.label.emailShareTitle" var="emailShareTitle" />
	<fmt:message key="share.error.excludesError" var="excludesError" />
	<fmt:message key="share.error.excludesError1" var="excludesError1" />
	<fmt:message key="backupBrowse.notification.printSubmitted" var="printSubmitted" />
	<fmt:message key="web.print.dialog.title" var="printDialogTitle" />
	<fmt:message key="web.print.dialog.button.print" var="printYesLabel" />
	<fmt:message key="web.print.dialog.button.cancel" var="printCancelLabel" />
	<fmt:message key="upload.label.uploadTitle" var="uploadTitleLabel"/>
	<fmt:message key="upload.label.uploadFolderTitle" var="uploadFolderTitleLabel"/>
	<fmt:message key="backupBrowse.action.delete" var="deleteTitleLabel"/>
	<fmt:message key="share.label.delegateLabel" var="delegateLabelLocalized"/>
    <fmt:message key="share.label.shareLabel" var="shareLabelLocalized"/>
	<fmt:message key="backupBrowse.label.Favorites" var="favorites" />
	<fmt:message key="backupBrowse.label.RecentDocuments" var="recentDocs" />
	<fmt:message key="backupBrowse.label.RecentFiles" var="recentFiles" />
	<fmt:message key="backupBrowse.title.warning" var="warning" />
	<fmt:message key="backupBrowse.msg.deleteMsg" var="deleteMsg" />
	<fmt:message key="backupBrowse.action.more" var="moreTitle" />
	<fmt:message key="backupBrowse.action.move" var="moveLabel" />
	<fmt:message key="backupBrowse.msg.moveMsg" var="moveMsg" />
	<fmt:message key="exchangeMailboxBrowse.msg.eraseMsg" var="eraseMsg" />
	<fmt:message key="exchangeMailboxBrowse.msg.eraseFolderMsg" var="eraseFolderMsg" />
	<fmt:message key="exchangeMailboxBrowse.msg.eraseAllMatchingMsg" var="eraseAllMatchingMsg" />
	<fmt:message key="exchangeMailboxBrowse.msg.deleteAllMatchingSubmittedToast" var="deleteAllMatchingSubmittedToast" />
	<fmt:message key="exchangeMailboxBrowse.erase.sizeInfo" var="eraseSizeInfo" />
	<fmt:message key="backupBrowse.msg.eraseAllConfirm" var="eraseAllConfirm" />
	<fmt:message key="backupBrowse.action.eraseSubmitted" var="eraseSubmitted" />
	<fmt:message key="backupBrowse.action.eraseFailed" var="eraseFailed" />
	<fmt:message key="backupBrowse.action.eraseDone" var="eraseDone" />
	<fmt:message key="backupBrowse.action.rename" var="rename" />
	<fmt:message key="backupBrowse.msg.moveTitle" var="MoveTitle" />
	<fmt:message key="backupBrowse.title.myComputers" var="myComputers" />
	<fmt:message key="backupBrowse.title.myShares" var="myShares" />
	<fmt:message key="backupBrowse.title.myEmails" var="myEmails" />
	<fmt:message key="backupBrowse.title.myVMS" var="myVMS" />
	<fmt:message key="share.label.shared" var="sharedText" />
	<fmt:message key="backupBrowse.label.searchDrive" var="searchDrive" />
	<fmt:message key="backupBrowse.action.showTrash" var="trash" />
	<fmt:message key="backupBrowse.action.unDelete" var="unDeleteTitle" />
	<fmt:message key="backupBrowse.action.emptyTrash" var="emptyTrashTitle" />
	<fmt:message key="backupBrowse.msg.trashDeleteMsg" var="trashDeleteMsg" />
	<fmt:message key="backupBrowse.msg.emptyTrashMsg" var="emptyTrashMsg" />
	<fmt:message key="upload.action.Progress" var="fileProgress" />
	<fmt:message key="upload.action.fileOf" var="fileOf" />
	<fmt:message key="upload.action.Complete" var="uploadCompleted" />
	<fmt:message key="upload.action.cancelError" var="cancelError" />
	<fmt:message key="upload.action.pauseError" var="pauseError" />
	<fmt:message key="upload.action.resumeError" var="resumeError" />
	<fmt:message key="upload.action.fileError" var="fileError" />
	<fmt:message key="upload.action.file0kError" var="file0kError" />
	<fmt:message key="backupBrowse.msg.eraseAllFailed" var="eraseAllFailed" />
	<enhance:out escapeXml="false">
	<fmt:message key="upload.error.folderNameNotValid" var="notValidName"/>
	</enhance:out>
	<fmt:message key="backupBrowse.label.ok" var="ok" />
	<fmt:message key="backupBrowse.label.cancel" var="cancel" />
	<fmt:message key="backupBrowse.label.enterThePassword" var="enterThePassword" />
	<fmt:message key="backupBrowse.label.sharePassword" var="sharePassword" />
	<fmt:message key="backupBrowse.label.sharePasswordMismatch" var="sharePasswordMismatch" />
	<fmt:message key="backupBrowse.action.download" var="downloadLabel" />
	<fmt:message key="backupBrowse.label.modifiedDate" var="modifiedDate" />
	<fmt:message key="backupBrowse.label.filename" var="filename" />
	<fmt:message key="backupBrowse.tableColumn.size" var="size" />
	<fmt:message key="backupBrowse.notification.downloadSizeExceeded" var="downloadSizeExceeded" />
	<fmt:message key="backupBrowse.notification.downloadSizeExceededNoRestore" var="downloadSizeExceededNoRestore" />
	<fmt:message key="backupBrowse.action.edit" var="editLabel" />
	<fmt:message key="backupBrowse.action.wopiEdit" var="wopiEditLabel" />
	<fmt:message key="backupBrowse.label.dataTable" var="dataTable">
		<fmt:param value="_START_" />
		<fmt:param value="_END_" />
		<fmt:param value="_TOTAL_" />
	</fmt:message>
	<fmt:message key="backupBrowse.label.dataTableEmpty" var="dataTableEmpty" />
	<fmt:message key="backupBrowse.action.restore" var="restoreLabel" />
	<fmt:message key="backupBrowse.action.versions" var="versionsLabel" />
	<fmt:message key="share.label.getLink" var="getLinkLabel" />
	<fmt:message key="share.label.copyLinkMessage" var="copyLinkMessage" />

	<fmt:message key="backupBrowse.action.print" var="printLabel" />
	<fmt:message key="backupBrowse.action.erase" var="eraseLabel" />
	<fmt:message key="backupBrowse.msg.tagTitle" var="tagTitle" />
	<fmt:message key="backupBrowse.action.tag" var="tagLabel" />
	<fmt:message key="backupBrowse.label.searchForSpecificTag" var="searchForSpecificTag" />
	<fmt:message key="backupBrowse.label.removeSpecificTag" var="removeSpecificTag" />
	<fmt:message key="backupBrowse.label.reviewSelShowSelLabel" var="reviewSelShowSelLabel" />
	<fmt:message key="backupBrowse.label.reviewSelShowAllLabel" var="reviewSelShowAllLabel" />
	<fmt:message key="backupBrowse.label.reviewSelShowingText" var="reviewSelShowingText" />
	<fmt:message key="edit.label.noEditToolFoundTitle" var="noEditToolFoundTitle" />
	<fmt:message key="edit.label.editToolNotRunning" var="editToolNotRunning" />
	<fmt:message key="backupBrowse.label.noPreviewAvailable" var="noPreviewAvailable" />
	<fmt:message key="backupBrowse.notification.downloadSubmittedFromPreview" var="downloadSubmittedFromPreview" />
	<fmt:message key="backupBrowse.error.restoreFailedGeneric" var="restoreFailedGeneric" />
	<fmt:message key="share.label.privatelyShared" var="privatelySharedText" />
	<fmt:message key="share.label.publiclyShared" var="publiclySharedText" />
	<fmt:message key="dataPane.alternateText.items" var="alternateTextItems" />
	<fmt:message key="exchangeMailboxBrowse.label.deleteAllMatching" var="deleteAllMatching" />
	<fmt:message key="exchangeMailboxBrowse.label.deletedItem" var="deletedItemLabel" />
	<fmt:message key="exchangeMailboxBrowse.label.deletedFolder" var="deletedFolderLabel" />
	<fmt:message key="exchangeMailboxBrowse.label.Inbox" var="inboxLabel" />

	<c:set var="fileOf" value=" ${fileOf} "/>
	<c:set var="navPage" value="myDataNav.jsp" />
	<c:if test="${param.n != null && param.n == 'rec'}">
		<c:set var="navPage" value="../cvlegal/cvlegalNav.jsp" />
	</c:if>
	<jsp:include page="../common/headerV2.jsp">
	 	<jsp:param value="true" name="mobileApp" />
		<jsp:param value="true" name="includeJqueryUI" />
		<jsp:param value="true" name="includeHistory" />
		<jsp:param value="true" name="includeTableSupport" />
		<jsp:param value="true" name="includeLatestDatatable" />
		<jsp:param value="false" name="disableTableColReordering" />
		<jsp:param value="true" name="includeMask" />
		<jsp:param value="true" name="bootstrapped" />
		<jsp:param value="true" name="myDataTitle" />
		<jsp:param value="${navPage}" name="navPage" />
		<jsp:param value="true" name="recordsNav" />
		<jsp:param value="true" name="browsePage" />

		<jsp:param value="../common/css/table.css" name="css" />
		<jsp:param value="../common/css/headerstyles.css" name="css" />
		<jsp:param value="css/browsestylesOverride.css" name="css" />
		<jsp:param value="css/upload.css" name="css" />
		<jsp:param value="css/permissionsDialog.css" name="css" />
		<jsp:param value="../common/thirdParty/selectize/css/selectize.css" name="css" />
		<jsp:param value="../facets/css/facetstyles.css" name="css" />
		<jsp:param value="../common/css/custom-cb.css" name="css" />

		<jsp:param value="../common/css/star-cb.css" name="css" />

		<jsp:param value="css/iconStyles.css" name="css" />
		<jsp:param value="css/switchViews.css" name="css" />
		<jsp:param value="../common/css/magnific-popup.css" name="css" />
		<jsp:param value="../common/qtip/jquery.qtip.min.css" name="css" />

		<jsp:param value="../common/js/jquery-layoutV2.js" name="js" />
		<jsp:param value="../common/css/webprinting.css" name="css"/>
		<jsp:param value="true" name="includeTreeSupport" />
		<jsp:param value="true" name="includeVistaSkin" />
		<jsp:param value="browse" name="sourcePage" />

		<jsp:param value="${requestScope.browse.includeSecHeader}" name="includeSecHeader" />
		<jsp:param value="${requestScope.browse.includeCustomSecHeader}" name="includeCustomSecHeader" />
		<jsp:param value="${requestScope.browse.customHeaderUrl}" name="customHeaderURL" />

		<jsp:param value="${requestScope.browse.pageTitleLocalized}" name="titleLocalized" />
		<jsp:param value="${requestScope.browse.headerTitleLocalized}" name="headerTitleLocalized" />

		<jsp:param value="${((requestScope.APPTYPE == 'FILESYSTEM' && requestScope.isDirectoryShareBrowse =='false')||requestScope.IS_SYNC_FOLDER)}" name="hideSearchBox" />
		<jsp:param value="search" name="searchContext" />
		<jsp:param value="../common/js/jquery.tinyscrollbar.min.js" name="js" />
		<jsp:param value="../common/thirdParty/contextmenu/jquery.contextMenu.js" name="js" />
		<jsp:param value="../common/thirdParty/contextmenu/jquery.ui.position.js" name="js" />
		<jsp:param value="../common/thirdParty/contextmenu/jquery.contextMenu.css" name="css" />
	</jsp:include>

<c:set var="browsestyle" value="" />

<c:set var="escapedClientName" value="${fn:escapeXml(param.clientName)}" />
<c:set var="escapedClientId" value="${fn:escapeXml(param.clientId)}" />
<c:set var="escapedVmClientName" value="${fn:escapeXml(param.vmClientName)}" />
<c:set var="escapedVmName" value="${fn:escapeXml(param.vmName)}" />
<c:set var="vmSource" value="${fn:escapeXml(param.source)}" />
<c:set var="escapedBackupsetId" value="${fn:escapeXml(param.backupsetId)}" />
<c:set var="escapedSubclientId" value="${fn:escapeXml(param.subclientId)}" />
<c:set var="escapedShareFolderId" value="${fn:escapeXml(param.shareFolderId)}" />
<c:set var="escapedShareFolderName" value="${fn:escapeXml(requestScope.shareFolderName)}" />
<c:set var="isShareFolderBrowse" value="${escapedShareFolderId != null && escapedShareFolderId != ''}" />

<%-- Construct URL parameter string with remote CommCell details. --%>
<c:set var="ccParams" value="" scope="request" />
<c:set var="appType" value="${requestScope.appType}" scope="request" />

<c:if test="${requestScope._cid != null}">
	<c:set var="ccParams" value="${requestScope.ccParams}&_cid=${requestScope._cid}" scope="request" />
</c:if>
<c:if test="${requestScope._cn != null}">
	<c:set var="ccParams" value="${requestScope.ccParams}&_cn=${requestScope._cn}" scope="request" />
</c:if>

<!-- vsa browse doesn't support paging so css properties e.g. overflow need to be overridden so add a class to the secbody to selectively override the syle for vsa browse -->
<c:if test='${(requestScope.APPTYPE eq "VIRTUALSERVER")}'>
	<c:set var="browsestyle" value="vsastyle" />
	<script nonce="${sessionScope.cspNonce}" >
	$("#content").addClass("vsastyle");
	$("#pgsearch").attr("placeholder", '<fmt:message key="vsaFindPlaceHolderText" />');
	</script>
</c:if>


	<span id='userName' class='hidden'>${sessionScope.LOGIN_ID}</span>
	<c:set var="isVsaBrowse" value="${cv:isVMImageBrowse(fn:escapeXml(param.applicationId))}" />
	<div class="secbody ${browsestyle}">
	<div id="maincols">
		<div class="dragAndDropOverlay">
			<span class="overlayText"><fmt:message key="upload.label.dropZone" /></span>
		</div>

		<c:set var="myDataPageTitle" value="${myComputers}" />
		<c:if test="${param.adminMode == true}">
			<c:set var="myDataPageURL" value="../summary/adminSummary.jsp" />
		</c:if>

		<c:if test="${param.adminMode != true}">
			<c:set var="myDataPageURL" value="../summary/index.do?page=fs" />
		</c:if>

		<c:choose>
			<c:when test="${isShareFolderBrowse}">
				<c:set var="myDataPageTitle" value="${myShares}" />
				<c:set var="myDataPageURL" value="../summary/index.do?page=shareFolder" />
			</c:when>
			<c:when test="${requestScope.APPTYPE == 'EXCHANGEMAILBOX'}">
				<c:set var="myDataPageTitle" value="${myEmails}" />
				<c:set var="myDataPageURL" value="../summary/index.do?page=email" />
			</c:when>
			<c:when test="${requestScope.APPTYPE == 'VIRTUALSERVER'}">
				<c:set var="myDataPageTitle" value="${myVMS}" />
				<c:set var="myDataPageURL" value="../summary/index.do?page=virtualServer" />
			</c:when>
			<c:when test="${requestScope.APPTYPE == 'SHAREPOINT'}">
				<c:set var="myDataPageTitle" value="${myComputers}" />
				<c:set var="myDataPageURL" value="../summary/index.do?page=sharepoint" />
			</c:when>
		</c:choose>

 <div id="leftcol-overlay"><!-- dummy div used only in FS. no other agent should have issues with this --></div>
 <span class="left-nav-close" id="js-left-close"><!-- dummy span used only in FS. no other agent should have issues with this --></span>
		<div id="leftcol" class="ui-layout-west">
			<c:choose>
				<c:when test='${(requestScope.APPTYPE == "EXCHANGEMAILBOX")}'>
					<div class="${hideSearch}" id="searchBoxNew">
						<label class="sr-only" for="pgsearch"><fmt:message key="exchangeMailboxBrowse.label.searchMails" /></label>
						<input id="pgsearch" type="text" placeholder='<fmt:message key="exchangeMailboxBrowse.label.searchMails" />' name="search" rel="${fn:escapeXml(param.searchContext)}"/>
						<div class="arrowWrap"><div class="arrowDown"></div>
						</div>
                              <input id="searchButtonNew" type="button" value="" aria-label='<fmt:message key="exchangeMailboxBrowse.label.searchMails" />' title='<fmt:message key="exchangeMailboxBrowse.label.searchMails" />'/>
                              <c:if test="${requestScope.ADV_SEARCH_JSP != null && requestScope.ADV_SEARCH_JSP != ''}">
							<jsp:include page="../search/${requestScope.ADV_SEARCH_JSP}" />
						</c:if>
					</div>
				</c:when>
				<c:otherwise>
				<c:choose>
					<c:when test="${requestScope.IS_SYNC_FOLDER}">
						<fmt:message key="backupBrowse.label.searchDrive" var="searchPlaceHolder"/>
						<fmt:message key="backupBrowse.label.searchShare" var="searchHolder"/>
						<c:if test="${isShareFolderBrowse}">
							<c:set var="searchPlaceHolder" value="${searchHolder} ${escapedShareFolderName}"/>
						</c:if>
						<div class="${hideSearch}" id="searchBoxNew">
							<label class="sr-only" for="pgsearch">'${searchPlaceHolder}'</label>
							<input id="pgsearch" type="text" placeholder='${searchPlaceHolder}' name="search" rel="${fn:escapeXml(param.searchContext)}"/>
							<div class="arrowWrap"><div class="arrowDown"></div>
							</div>
                               <input id="searchButtonNew" type="button" value="" aria-label='${searchPlaceHolder}' title='${searchPlaceHolder}'/>
                               <c:if test="${requestScope.ADV_SEARCH_JSP != null && requestScope.ADV_SEARCH_JSP != ''}">
								<jsp:include page="../search/${requestScope.ADV_SEARCH_JSP}" />
							</c:if>
						</div>
					</c:when>
					<c:when test="${requestScope.APPTYPE == 'FILESYSTEM'
								|| requestScope.APPTYPE == 'SHAREPOINT'}">
						<fmt:message key="backupBrowse.label.searchShare" var="searchHolder"/>
						<c:set var="searchPlaceHolder" value="${searchHolder}"/>
						<div class="${hideSearch}" id="searchBoxNew">
						<label class="sr-only" for="pgsearch">'${searchPlaceHolder}'</label>
						<input id="pgsearch" type="text" placeholder='${searchPlaceHolder}' name="search" rel="${fn:escapeXml(param.searchContext)}"/>
						<div class="arrowWrap"><div class="arrowDown"></div>
						</div>
							<input id="searchButtonNew" type="button" value="" aria-label='${searchPlaceHolder}' title='${searchPlaceHolder}'/>
							<c:if test="${requestScope.ADV_SEARCH_JSP != null && requestScope.ADV_SEARCH_JSP != ''}">
								<jsp:include page="../search/${requestScope.ADV_SEARCH_JSP}" />
							</c:if>
						</div>
					</c:when>
					<c:otherwise>
						<ul class="easyLinks">
							<li>
								<a href="${myDataPageURL}"><img src="img/back.png">&nbsp;&nbsp;${myDataPageTitle}</a>
							</li>
						</ul>
					</c:otherwise>
				</c:choose>
					<c:if test="${sessionScope.isPublicShareFolder != 'true'}">
						<c:if test="${requestScope.IS_SYNC_FOLDER}">
							<div id="facetsHolder" style="display:none;">
								<div class="facetsHeader"><fmt:message key="backupBrowse.header.refineSearch" /></div>
								<div id="facets" class="facetsPanel"></div>
							</div>
						</c:if>

						<c:set var="showSummary" value="true" />
						<c:if test="${requestScope.IS_NAS_CLIENT}">
							<c:set var="showSummary" value="false" />
						</c:if>
						<c:if test="${requestScope.IS_SYNC_FOLDER}">
							<c:set var="showSummary" value="false" />
						</c:if>

						<c:if test="${showSummary}">
							<c:if test="${requestScope.APPTYPE == 'FILESYSTEM'}">
								<ul class="easyLinks navigationLinks">
<%-- 									<li class="detailsLink">
										<c:if test="${param.adminMode == true}">
											<a href="../clientDetails/${requestScope.DETAILS_PAGE}?adminMode=true&clientId=${escapedClientId}&clientName=${escapedClientName}"><span class="sprite icon-arrow-left"></span>&nbsp;&nbsp;${summary}</a>
										</c:if>

										<c:if test="${param.adminMode != true}">
											<a href="../clientDetails/${requestScope.DETAILS_PAGE}?clientId=${escapedClientId}&clientName=${escapedClientName}"><span class="sprite icon-arrow-left"></span>&nbsp;&nbsp;${summary}</a>
										</c:if>

									</li> --%>
								</ul>
								<ul class="easyLinks">
								<c:url var="browseURLBase" value="fsBrowse.do"><c:param name="clientId" value="${escapedClientId}"/><c:param name="clientName" value="${escapedClientName}"/></c:url>
									<li id = "regularBrowse" class="regularBrowse">
										<a href="${browseURLBase}"><fmt:message key="sharing.label.BrowseAction" /></a>
									</li>

									<li id = "clientFavorites" class="clientFavorites">
										<a href="${browseURLBase}&showDeletedItems=false&viewFavorites=true"><fmt:message key="backupBrowse.label.Favorites" /></a>
									</li>

									<li id = "recentDocs" class="recentDocs">
										<a href="${browseURLBase}&keyword=Filename%3A*&viewRecentFiles=true&showDeletedItems=false">${recentDocs}</a>
									</li>
									<li id="clientSettingsLi">
										<a href="${pageContext.request.contextPath}/clientDetails/fsDetails.do?clientName=${escapedClientName}&clientId=${escapedClientId}" title="<fmt:message key="backupBrowse.label.settingsTitle"><fmt:param value="${escapedClientName}" /></fmt:message>"><fmt:message key="backupBrowse.label.settings"/></a>
									</li>
								</ul>
							</c:if>

						</c:if>
					</c:if>
				</c:otherwise>
			</c:choose>

			<c:if test="${!requestScope.IS_SYNC_FOLDER}">
				<div id="facetsHolder" style="display:none;">
					<div class="facetsHeader"><fmt:message key="backupBrowse.header.refineSearch" /></div>
					<div id="facets" class="facetsPanel"></div>
				</div>
			</c:if>

			<div id="scrollbar1" class="tinyScrollbar">
				<div class="scrollbar"><div class="track"><div class="thumb"><div class="end"></div></div></div></div>
					<div class="viewport">
						<div class="overview">
							<div id="browsetree" class="activeEdgeNavigation"></div>
							 <c:if test="${requestScope.IS_SYNC_FOLDER}">
							 	<c:choose>
								 	<c:when test="${isShareFolderBrowse}">
										<div id="sharedWithMe" class="activeEdgeNavigation">
											<a href="#" id="sharedWithMeLink">
											<img id="sharedWithMe_icon" src="../common/img/sharedwithme.png">
											<span>${escapedShareFolderName}</span>
											</a>
										</div>
								 	</c:when>
								 	<c:otherwise>
										<div id="mydrive" class="activeEdgeNavigation">
											<a href="#" id="mydriveLink">
											<img id="mydrive_icon" src="../common/img/cloud.png">
											<span><fmt:message key="backupBrowse.label.BreadCrumbDriveEntry" /></span>
											</a>
										</div>
								 	</c:otherwise>
							 	</c:choose>
								<c:if test="${!requestScope.IS_NFS_OBJECT_STORE}">
									<div id="recentFiles" >
										<a href="#" id="recentFilesLink">
										<img id="recentFiles_icon" src="img/recentFiles.png?t1">
										<span>${recentFiles}</span>
										</a>
									</div>
								</c:if>
							</c:if>
							<c:if test="${!requestScope.IS_NFS_OBJECT_STORE && requestScope.IS_SYNC_FOLDER && (!isShareFolderBrowse)}">
								<div class="Trash">
									<a id="showDeletedItems" href="#" >
									<img id="trash_icon" src="../common/img/trash.png">
									<span>${trash}</span>
									</a>
								</div>
							</c:if>
						</div>
					</div>
				</div>
			<div class="clrfloat"></div>
		</div>

		<div id="centercol" class="ui-layout-center">
			<div class="browsetools clearfix">
			<span class="left-nav-menu" id="js-left-nav"></span>
				<ul>
					<li>
						<ul id="breadcrumbStatic" class="breadcrumb"></ul>
						<ul id="breadcrumb" class="breadcrumb"></ul>
					</li>
				</ul>
				<div class="clrfloat"></div>
			</div>
			<c:choose>
				<c:when test='${(requestScope.APPTYPE == "EXCHANGEMAILBOX")}'>
					<div class="emailTableHeader">
						<div class="vw-flex-item">
    				        <div class="vw-flex-content">
								<span class="col-select">
									<cv:cvCheckbox name="headerCb" styleClass="header-cb vw-custom-checkbox"/>
									<span class="custom-cb-label header-cb vw-custom-checkbox" id="headerCb-label"></span>
                        			<input type="hidden" name="headerCb" value="">
								</span>
								<span class="dropdownOpener vw-drop-down-toggle" data-url="/browse/emailSorter.jsp?clientId=${escapedClientId}&clientName=${escapedClientName}&backupsetId=${escapedBakupsetId}&subclientId=${escapedSubclientId}&APPTYPE=${requestScope.APPTYPE}" >
						 			<span><fmt:message key="exchangeMailboxBrowse.label.sortBy" /></span>
						 			<a href="#" class="noVisible"><img src="${pageContext.request.contextPath}/common/img/dropdown_triangle_icon.png" alt="^"></a>
						 			<a id="emailSortText" href="#"><fmt:message key="exchangeMailboxBrowse.tableColumn.date" /></a>
									<span class="dropdown vw-drop-down"></span>
								</span>

								<c:if test="${requestScope.browse.features.isPreviewAvailable()}">
									<span class="maybeNobar"><a href="#" id="previewToggle">&nbsp;</a></span>
								</c:if>
							</div><!-- END .vw-flex-content -->
    					</div><!-- END .vw-flex-item -->
						<div class="vw-flex-item">
            				<div class="vw-flex-content">
								<span id="selectedCount">${selectedCount}</span>
								<c:if test='${requestScope.browse.features.isEndUserEraseAvailable()}'>
							 		<img id="euErase" src="img/erase_icon.png" role="button" tabindex="0" alt="${eraseLabel}" title="${eraseLabel}"  />
								</c:if>
								<c:if test="${requestScope.browse.features.isDownloadAvailable()}">
									<img id="downloadLink" src="img/download_icon.png" role="button" tabindex="0" alt="${downloadLabel}" title="${downloadLabel}"/>
								</c:if>
            					<a class="vw-btn vw-btn-secondary" id="deleteAllMatchingItems" tabindex="0">
                        			<span class="halflings halflings-trash" aria-hidden="true"></span> ${deleteAllMatching}
                  				</a>
							</div><!-- END .vw-flex-content -->
      					</div><!-- END .vw-flex-item -->

					</div><!-- END .emailTableHeader -->
				</c:when>
			</c:choose>
			<div id="iconView"></div>
			<div id="lightboxGallery" style= "display:none" ></div>
			<c:if test="${requestScope.TABLE_JSP != null}">
			<jsp:include page="${requestScope.TABLE_JSP}" />
			</c:if>

			<c:if test="${requestScope.browse.features.isPieChartAvailable()}">
				<div id="chart-container" class="chart-container"></div>
			</c:if>
		</div>

		<c:if test="${requestScope.TABLE2_JSP != null}">
			<jsp:include page="${requestScope.TABLE2_JSP}" />
		</c:if>
	</div>
	</div>

</fmt:bundle>

<!--[if IE 8]>
<script nonce="${sessionScope.cspNonce}" >
	$("#uploadLink").parent().remove();
	$("#createFolder").parent().remove();
	$("#previewToggle").parent().remove();
	previewDisabled = true;
</script>
<![endif]-->
	<jsp:include page="printOptions.jsp"></jsp:include>

<c:set var="slowOperationMessageDelayMs" value="${cvConfig.getSlowOperationMessageDelayMs()}"/>

<script nonce="${sessionScope.cspNonce}"  charset="utf-8">
	var downloadSizeLimitMB = ${not empty applicationScope.WebconsoleDownloadSizeLimitMB ? applicationScope.WebconsoleDownloadSizeLimitMB : 1024};
	var recallDownloadSizeLimitMB = ${not empty applicationScope.WebconsoleRecallDownloadSizeLimitMB ? applicationScope.WebconsoleRecallDownloadSizeLimitMB : 100};

	<%-- Add remote CommCell details, if present. --%>
	if (typeof cvUtil == "object")
	{
		cvUtil.ccId = "${requestScope._cid}";
		cvUtil.ccName = "${requestScope._cn}";
	}

	var localMsg = localMsg || {};
	localMsg.selectSyncProfileTitle = "${selectSyncProfileTitle}";
	localMsg.reviewSelectionsLabel = "${reviewSelectionsWithCount}";
	localMsg.restoreOptionsTitle = "${restoreOptionsTitle}";
	localMsg.noDataAvailable = "${noDataAvailable}";
	localMsg.loadMoreFolders = "${loadMoreFolders}";
	localMsg.failedBackupItem = "${failedBackupItem}";
	localMsg.timeRangeAdvancedOptionsTitle = "${timeRangeAdvancedOptionsTitle}";
	localMsg.timeRangeBasicOptionsTitle = "${timeRangeBasicOptionsTitle}";
	localMsg.downloadSubmitted="${downloadSubmitted}";
	localMsg.selectAFolder="${selectAFolder}";
	localMsg.slowOperation="${slowOperation}";
	localMsg.noData="${noData}";
	localMsg.copyPreviewURL="${copyPreviewURL}";
	localMsg.uploadPageUnload="${uploadPageUnload}";
	localMsg.uploadFilesTitle="${uploadFilesTitle}";
	localMsg.folderUploadError="${folderUploadError}";
	localMsg.folderDropUploadError = "${folderDropUploadError}";
	localMsg.rootUploadError="${rootUploadError}";
	localMsg.ajaxCancel = "${ajaxCancel}";
	localMsg.timeRangeLatestData="${timeRangeLatestData}";

	if ("${appType}" == "EXCHANGEMAILBOX") {
		localMsg.shareTitle = "${delegateTitle}";
		localMsg.shareLabelLocalized ="${delegateLabelLocalized}";

	} else {
		localMsg.shareTitle = "${shareTitle}";
		localMsg.shareLabelLocalized ="${shareLabelLocalized}";
	}

	localMsg.emailShareTitle = "${emailShareTitle}";
	localMsg.excludesError = "${excludesError}";
	localMsg.excludesError1 = "${excludesError1}";
	localMsg.printSubmitted="${printSubmitted}";
	localMsg.printDialogTitle="${printDialogTitle}";
	localMsg.printDialogBtnYes="${printYesLabel}";
	localMsg.printDialogBtnCancel="${printCancelLabel}";
	localMsg.warning="${warning}";
	localMsg.deleteMsg="${deleteMsg}";
	localMsg.trash = "${trash}";
	localMsg.trashDeleteMsg = "${trashDeleteMsg}";
	localMsg.emptyTrashMsg = "${emptyTrashMsg}";
	localMsg.moveMsg="${moveMsg}";
	localMsg.eraseMsg="${eraseMsg}";
	localMsg.eraseFolderMsg="${eraseFolderMsg}";
	localMsg.eraseAllMatchingMsg="${eraseAllMatchingMsg}";
	localMsg.deleteAllMatchingSubmittedToast="${deleteAllMatchingSubmittedToast}"
	localMsg.eraseAllFailed="${eraseAllFailed}";
	localMsg.sizeInfo="${eraseSizeInfo}";
	localMsg.eraseAllConfirm="${eraseAllConfirm}";
	localMsg.eraseSubmitted="${eraseSubmitted}";
	localMsg.eraseFailed="${eraseFailed}";
	localMsg.eraseDone="${eraseDone}";
	localMsg.Rename="${rename}";
	localMsg.CreateFolder="${createFolder}";
	localMsg.MoveTitle="${MoveTitle}";
	localMsg.sharedText="${sharedText}";
	localMsg.searchHolder = "${searchHolder}";

	localMsg.sizeInKB ="${kb}";
	localMsg.sizeInMB ="${mb}";
	localMsg.sizeInGB= "${gb}";
	localMsg.sizeInByte="${bytes}";
	localMsg.fileOf = "${fileOf}";
	localMsg.fileProgress = "${fileProgress}";
	localMsg.uploadCompleted = "${uploadCompleted}";
	localMsg.cancelError = "${cancelError}";
	localMsg.pauseError = "${pauseError}";
	localMsg.resumeError = "${resumeError}";
	localMsg.fileError = "${fileError}";
	localMsg.file0kError = "${file0kError}";
	<cv:localMsg name="notValidName">${notValidName}</cv:localMsg>
	localMsg.sharePassword = "${sharePassword}";
	localMsg.ok = "${ok}";
	localMsg.cancel = "${cancel}";
	localMsg.enterThePassword = "${enterThePassword}";
	localMsg.sharePasswordMismatch = "${sharePasswordMismatch}"
	localMsg.assignProfileLink="${assignProfileLink}";
	localMsg.downloadButtonLabel= "${downloadLabel}";
	localMsg.modifiedDateLabel= "${modifiedDate}";
	localMsg.fileNameLabel= "${filename}";
	localMsg.sizeLabel= "${size}";
	localMsg.downloadSizeExceeded ="${downloadSizeExceeded}";
	localMsg.downloadSizeExceededNoRestore ="${downloadSizeExceededNoRestore}";
	localMsg.dataTable ="${dataTable}";
	localMsg.dataTableEmpty ="${dataTableEmpty}";
	localMsg.searchForSpecificTag ="${searchForSpecificTag}";
	localMsg.removeSpecificTag ="${removeSpecificTag}";
	localMsg.reviewSelShowSelLabel = "${reviewSelShowSelLabel}";
	localMsg.reviewSelShowAllLabel = "${reviewSelShowAllLabel}";
	localMsg.reviewSelShowingText = "${reviewSelShowingText}";
	localMsg.moveLabel ="${moveLabel}";

	localMsg.deleteTitleLabel ="${deleteTitleLabel}";
	localMsg.restoreLabel ="${restoreLabel}";
	localMsg.versionsLabel ="${versionsLabel}";
	localMsg.getLinkLabel ="${getLinkLabel}";
	localMsg.copyLinkMessage ="${copyLinkMessage}";
	localMsg.printLabel ="${printLabel}";
	localMsg.eraseLabel ="${eraseLabel}";
	localMsg.editButtonLabel= "${editLabel}";
	localMsg.editLabel = "${editLabel}";
	localMsg.wopiEditLabel = "${wopiEditLabel}";
	localMsg.noEditToolFoundTitle = "${noEditToolFoundTitle}";
	localMsg.editToolNotRunning = "${editToolNotRunning}";
	localMsg.tagTitle="${tagTitle}";
	localMsg.tagLabel= "${tagLabel}";
	localMsg.restoreJobPollCompleted = "${restoreJobPollCompleted}";
	localMsg.restoreJobPollFailed = "${restoreJobPollFailed}";
	localMsg.noPreviewAvailable = "${noPreviewAvailable}";
	localMsg.downloadSubmittedFromPreview = "${downloadSubmittedFromPreview}";
	localMsg.unDeleteTitle = "${unDeleteTitle}";
	localMsg.restoreFailedGeneric = "${restoreFailedGeneric}";
	localMsg.privatelySharedText = "${privatelySharedText}";
	localMsg.publiclySharedText = "${publiclySharedText}";
	localMsg.downloadFailed = "${downloadFailed}";
	localMsg.incidentId = "${incidentId}";
	localMsg.downloadNotAllowed = "${downloadNotAllowed}";
	localMsg.livebrowseGatheringFiles="${livebrowseGatheringFiles}";
	localMsg.alternateTextItems = "${alternateTextItems}";
	localMsg.deletedItemLabel = "${deletedItemLabel}";
	localMsg.deletedFolderLabel = "${deletedFolderLabel}";
	localMsg.inboxLabel = "${inboxLabel}";

	//have to hard code as localization for Hebrew is not done yet.
	//Once the localization for Hebrew is done, this if statement can be removed.
	if (navigator.language.slice(0, 2) === 'he') {
		localMsg.inboxLabel = "\u05D3\u05D5\u05D0\u05E8 \u05E0\u05DB\u05E0\u05E1";
	}

	<fmt:bundle basename="localization.BackupBrowseMessages">
		<c:choose>
			<c:when test='${(requestScope.APPTYPE == "EXCHANGEMAILBOX")}'>
				<cv:localMsg name="savedFolderCreatedText"><fmt:message key="sharing.label.delegationCreated" /></cv:localMsg>
				<cv:localMsg name="savedFolderUpdatedText"><fmt:message key="sharing.label.delegationUpdated" /></cv:localMsg>
			</c:when>
			<c:otherwise>
				<cv:localMsg name="savedFolderCreatedText"><fmt:message key="sharing.label.savedFolderCreated" /></cv:localMsg>
				<cv:localMsg name="savedFolderUpdatedText"><fmt:message key="sharing.label.savedFolderUpdated" /></cv:localMsg>
			</c:otherwise>
		</c:choose>
		<cv:localMsg name="publicLinkUnShareSuccess"><fmt:message key="share.notification.publicLinkUnShareSuccess" /></cv:localMsg>
		<cv:localMsg name="publicLinkShareSuccess"><fmt:message key="share.notification.publicLinkShareSuccess" /></cv:localMsg>
		<cv:localMsg name="uploadNotAllowed"><fmt:message key="upload.error.uploadNotAllowed" /></cv:localMsg>
	</fmt:bundle>

	var sizeUnitArray = new Array(localMsg.sizeInByte, localMsg.sizeInKB, localMsg.sizeInMB, localMsg.sizeInGB);

	function restoreSubmittedToast(jobId, showJobLink) {
		var label = "${restoreSubmittedToastLabel}".replace('{0}', jobId);
		var context = "clientDetails";
		if ("${isVsaBrowse}" === "true") {
			context = "vmprovisioning";
		}
		var link = "<a class='notificationlink' href='${pageContext.request.contextPath}/" + context + "/${requestScope.DETAILS_PAGE}?" +
				"clientName=${escapedClientName}&clientId=${escapedClientId}${ccParams}'>" + label + "</a>";
		console.debug("Restore jobs link: " + link); // !!!
		//Timeout for IE8. If toast is called directly, IE8 isn't able to recover from rendering the notification
		setTimeout(function() {
			if (browseMain.isShareFolderBrowse() || !showJobLink || browseMain.isSyncFolderBrowse()) {
				// There is no clientDetails page for share folders, so nothing to link to
				// showJobLink will be false if the destination is an agentless VM, where no job status polling is supported
				label = "${restoreSubmittedToastLabelCompleted}".replace('{0}', jobId);
				cvUtil.toast(label, null, null, true);
				browseMain.startPollingForJob(jobId);
			}
			else {
				cvUtil.toast(link, null, null, true);
			}
		}, 10);
	}

	var OS_Delim = "${requestScope.OS_DELIM}";

	var browseFeatures = JSON.parse("${requestScope.browse.features.toEscapedJson()}");

	var browseMain = browseMain || {};
	browseMain.slowOperationMessageDelayMs = ${slowOperationMessageDelayMs};
	browseMain.recallDownloadEnabled = ("true" === "${requestScope.IS_RECALL_DOWNLOAD_ENABLED}");
	browseMain.isSingleFileShareBrowse = false;
	browseMain.displayName = "${escapedShareFolderName}";
	browseMain.showPublicShare = browseMain.showPublicShare || "";
	browseMain.isPwdSet = ("true" == "${requestScope.isPwdSet}");
	browseMain.showReshareFeature = ("true" == "${requestScope.showReshare}");
	browseMain.isLocalEditAvailable = ("true" == "${requestScope.IS_LOCAL_EDIT_AVAIABLE}");
	browseMain.enableEditPageForEmail = ("true" == "${requestScope.enableEditPageForEmail}");
	browseMain.isCvLegalShare = ("true" === "${applicationScope.CvLegalAppShareId == escapedShareFolderId}");

	browseMain.userProfileMapping = "${fn:replace(requestScope.userProfileMapping, '\\', '\\\\')}";
	browseMain.osDelim = "${fn:replace(requestScope.osDelim, '\\', '\\\\')}";
	browseMain.isEdgeQuotaEnabled = ("true" === "${applicationScope.enableEdgeDriveQuote}");
	var userName = $("#userName").html();
	var isArchiver = ("true" === "${requestScope.IS_ARCHIVER}");
	var defaultShowDeleted = ("true" === "${requestScope.SHOW_DELETED_ITEMS_DEFAULT_VALUE}" );
	var isSyncFolder = ("true" === "${requestScope.IS_SYNC_FOLDER}");
	var isNfsObjectStore = ("true" === "${requestScope.IS_NFS_OBJECT_STORE}");

	var search = {};
	search.availableFields = [];
	search.searchMap = {};

	<c:forEach items="${requestScope.SEARCH_KEYS}" var="keyMap">
		search.availableFields.push('${keyMap.key}');
		search.searchMap['${key}'] = '${keyMap.value}';
	</c:forEach>


	<enhance:out escapeXml="false">
	browseMain.browseControlsJson = "${requestScope.browse.controlsJson}";
	browseMain.browseFixedBreadcrumbJson = "${requestScope.browse.fixedBreadcrumbJson}";

	</enhance:out>
	localMsg.webEditNotSupported= "${webEditNotSupported}";
	var isEnablePopoutPreview = "${requestScope.isEnablePopoutPreview}";
	browseMain.localEditPreference = ("${requestScope.localEditPreference}" === "true");
	browseMain.enableEditAuditNotification = ("${applicationScope.EnableEdgeAuditNotification}" === "true");
	browseMain.reuseSessionCacheForSearch = ("${requestScope.reuseSessionCacheForSearch}" === "true");
	browseMain.clientAppTypeId = "${requestScope.clientAppTypeId}";

	browseMain.exchangeFolderDeleteEnabled = ("${requestScope.exchangeFolderDelete}" === "true");

	if ("${requestScope.isOpenMailbox}" === "true")
		sessionStorage.setItem('isOpenMailbox', "true");
	else
		sessionStorage.setItem('isOpenMailbox', "false");

	browseMain.isOpenMailbox = ("${requestScope.isOpenMailbox}" === "true");
	
	var cciClientName = "${requestScope.cciClientName}";

</script>

<!--[if lt IE 9]>
<script nonce="${sessionScope.cspNonce}" >
    var notie9 = true;
</script>
<![endif]-->
<jsp:include page="iconTemplate.jsp"></jsp:include>
<jsp:include page="browseTemplates.jsp"></jsp:include>

<c:if test='${(requestScope.APPTYPE == "FILESYSTEM" || requestScope.APPTYPE == "SYNCFOLDER" || requestScope.APPTYPE == "SHAREPOINT")}'>
	<script nonce="${sessionScope.cspNonce}" >
		$("document").ready(function(){
			$("#previewToggle").remove();
		});
	</script>
	<style>
	#browsetable .fileName span, #browsetable .folder span {
		cursor: pointer;
	}
	#browsetable tbody tr td .fileName span:hover, #browsetable tbody .folder span:hover{
		text-decoration: underline;
	}
	</style>
</c:if>

<div id="actionsMenuHolder">
    <ul class="settingsbox actionsMenu contextMenu dropdown-menu vw-dropdown-menu vw-actions-menu"></ul>
</div>

<c:if test="${(requestScope.APPTYPE == 'FILESYSTEM' || requestScope.APPTYPE == 'SYNCFOLDER') && requestScope.isDirectoryShareBrowse =='false'}">
	<script nonce="${sessionScope.cspNonce}" >
		browseMain.isSingleFileShareBrowse = true;
	</script>
</c:if>

<c:if test="${not empty requestScope.PAGE_LENGTH}">
<script nonce="${sessionScope.cspNonce}" >
	var pageLength = "${requestScope.PAGE_LENGTH}"; //overrides the default val set in js
	pageLength = parseInt(pageLength);
	var tableSettings = {}; //this will make the tables scrollable.
	tableSettings.scroll = true;//used in backupBrowseMain
	browseMain.userId = "${sessionScope.USERID}";
	browseMain.userNameWithoutDomain = "${sessionScope.username}";
	browseMain.userNameWithDomain = "${sessionScope.LOGIN_ID}";
	var userDomain = "${sessionScope.USER_DOMAIN}";
	if (userDomain !== null && userDomain !== ""){
		browseMain.userNameWithDomain.replace("\\\\", "\\");
	}
	var authorizationExpired = "${authorizationExpired}";
	var authorizeForRestoreDialogTitle = "${authorizeForRestoreDialogTitle}";
	var setContentHeight = function() {

		var contentHeight = $("body").height() - ($("#header").outerHeight() + $(".sechead").outerHeight(true));
		$("#maincols").outerHeight(contentHeight);
		$("#rightcol").outerHeight(contentHeight);
		$('.showPieButton').click(function(){
			showPieChart = !showPieChart;
			browseMain.retrieveSizeDistributions = showPieChart;
			if(showPieChart)
			{
				$('.showPieButton').addClass('currentView').parents(".vw-btn").addClass("active");
				browseMain.loadChart(true);
			}
			else
			{
				$('.showPieButton').removeClass('currentView').parents(".vw-btn").removeClass("active");
				browseMain.hidePieChart();
			}
		});
		var viewFavorites=cvUtil.getParameterByName("viewFavorites", window.location.href,false,false);
		var viewRecentFiles=cvUtil.getParameterByName("viewRecentFiles", window.location.href,false,false);
		viewFavorites?$('.clientFavorites').addClass("activeFSNavigation"):viewRecentFiles?$('.recentDocs').addClass("activeFSNavigation"):$('.regularBrowse').addClass("activeFSNavigation");


		//activeFSNavigation

	};

	$("document").ready(setContentHeight);

	$(window).on("resize", function() {
	 	setTimeout(browseMain.resizeTimeOut, 500);
	});
	</script>
	<style>
	#maincols {
		width: 100%;/* 80%; */
	    clear: both;
	    float: left;
	    margin-top: 0;
	}
	#sectionTitle {
		margin-left: 10px;
	}

	#content {
		padding: 0px;
	}

	#browsetable .innerBrowseTable  tbody tr td .fileName {
		overflow-x: auto;
	    white-space: normal;
		text-overflow: ellipsis;
	    height: auto;
	    word-wrap: break-word;
		word-break: break-all;
		margin-right: 30px;
		display: block;
	}

	.innerBrowseTable .ellipsisDiv {
		text-overflow: initial;
		white-space: normal;
		overflow-x: auto;
	}

	#browsetable .innerBrowseTable tbody td {
		padding: 7px;
		position: relative;
	}

	</style>
</c:if>
<div class="clrfloat"></div>
<a id="activityGallery"></a>
<jsp:include page="createFolderDialog.jsp" />
<jsp:include page="renameDialog.jsp" />
<jsp:include page="../common/moment.jsp" />

<jsp:include page="../common/cvUserSuggest.jsp">
	<jsp:param value="selectedUsers" name="fieldIdToSelectize"/>
	<jsp:param value="auto" name="selectizeHeight"/>
	<jsp:param value="100%" name="selectizeWidth"/>
	<jsp:param value="resetCache" name="callbackAfterAdd"/>
	<jsp:param value="true" name="isUserEmailAllowed"/>
</jsp:include>

<%@include file="../common/datepicker.jsp" %>
<%@include file="../upload/index.jsp" %>
<jsp:include page="../common/footer.jsp">
	<jsp:param value="true" name="bootstrapped" />
	<jsp:param value="../common/js/history/json2.js" name="js" />
	<jsp:param value="../common/js/custom-cb.js" name="js" />
	<jsp:param value="../common/js/jquery.magnific-popup.min.js" name="js" />
	<jsp:param value="../common/qtip/jquery.qtip.min.js" name="js" />
	<jsp:param value="js/browseCommon.js" name="js" />
	<jsp:param value="js/selectionManager.js" name="js" />
	<jsp:param value="js/browseActions.js" name="js" />
	<jsp:param value="${pageContext.request.contextPath}/facets/js/facetRenderer.js" name="js" />
	<jsp:param value="${pageContext.request.contextPath}/facets/js/facetManager.js" name="js" />
	<jsp:param value="${pageContext.request.contextPath}/facets/js/facetHandler.js" name="js" />
	<jsp:param value="${pageContext.request.contextPath}/common/js/webprinting.js" name="js" />
	<jsp:param value="js/preview.js" name="js" />
	<jsp:param value="js/iconview.js" name="js" />
	<jsp:param value="js/backupBrowseMain.js" name="js" />
	<jsp:param value="js/uploadFile.js" name="js" />
	<jsp:param value="js/search.js" name="js" />
	<jsp:param value="js/download.js" name="js" />
	<jsp:param value="js/permissionsDialog.js" name="js" />
	<jsp:param value="../browse/includeJs.jsp" name="jsp" />
	<jsp:param value="../common/js/highcharts/highstock.js" name="js" />
	<jsp:param value="../common/js/highcharts/highcharts-3d.js" name="js" />
	<jsp:param value="../common/js/highcharts/no-data-to-display.js" name="js" />
	<jsp:param value="../common/js/encoder.js" name="js"/>
	<jsp:param value="../browse/dataPaneJs.jsp" name="jsp" />
</jsp:include>


