<%@  taglib uri="../WEB-INF/cvtaglib.tld" prefix="cv" %>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>

<fmt:bundle basename="localization.BackupBrowseMessages">
	<ul class="settingsbox vw-dropdown-menu" id="emailSorterDropdown">
		<li><span class="emailSorterHeaderArrowDown" /><a href="#" class="emailDateSorter col-recdsent"><fmt:message key="exchangeMailboxBrowse.tableColumn.date" /></a></li>
		<li class="emailSorterHeaderListWhite"><span class="noVisible" src="" /><a href="#" class="emailSizeSorter col-size"><fmt:message key="exchangeMailboxBrowse.tableColumn.size" /></a></li>
		<li class="emailSorterHeaderListWhite"><span class="noVisible" src="" /><a href="#" class="emailFromSorter col-from"><fmt:message key="exchangeMailboxBrowse.tableColumn.From" /></a></li>
		<li class="emailSorterHeaderListWhite"><span class="noVisible" src="" /><a href="#" class="emailSubjectSorter col-subject"><fmt:message key="exchangeMailboxBrowse.tableColumn.Subject" /></a></li>
	</ul>
</fmt:bundle>

<script nonce="${sessionScope.cspNonce}" >
	$(document).ready(function() {
		$(".emailDateSorter").on("click", function(event) {
			event.preventDefault();
			$('#browsetableheaderrow .col-recdsent:first').click();
			changeEmailSorterImageAndText('.emailDateSorter');
		});
		$(".emailSizeSorter").on("click", function(event) {
			event.preventDefault();
			$('#browsetableheaderrow .col-size:first').click();
			changeEmailSorterImageAndText('.emailSizeSorter');
		});
		$(".emailFromSorter").on("click", function(event) {
			event.preventDefault();
			$('#browsetableheaderrow .col-from:first').click();
			changeEmailSorterImageAndText('.emailFromSorter');
		});
		$(".emailSubjectSorter").on("click", function(event) {
			event.preventDefault();
			$('#browsetableheaderrow .col-subject:first').click();
			changeEmailSorterImageAndText('.emailSubjectSorter');
		});
		
		function changeEmailSorterImageAndText(columnClass)
		{
			if($(columnClass).prev().hasClass('noVisible'))
			{
				$("#emailSorterDropdown li").removeClass('emailSorterHeaderListColor');
				$("#emailSorterDropdown li").addClass('emailSorterHeaderListWhite');
				$('#emailSorterDropdown span').addClass('noVisible');
				$(columnClass).prev().removeClass('noVisible');
				$(columnClass).parent().removeClass('emailSorterHeaderListWhite');
				$(columnClass).parent().addClass('emailSorterHeaderListColor');
				
				$(columnClass).prev().removeClass('emailSorterHeaderArrowDown');
				$(columnClass).prev().addClass('emailSorterHeaderArrowUp');
				
					
			}
			else
			{
				if($(columnClass).prev().hasClass('emailSorterHeaderArrowUp')){
					$(columnClass).prev().removeClass('emailSorterHeaderArrowUp');
					$(columnClass).prev().addClass('emailSorterHeaderArrowDown');
				}
				else{
					$(columnClass).prev().removeClass('emailSorterHeaderArrowDown');
					$(columnClass).prev().addClass('emailSorterHeaderArrowUp');
				}
			}
			$('#emailSortText').html($(columnClass).html());
		}
		
		// Initially color the background for the Date List item
		$('.emailDateSorter').parent().addClass('emailSorterHeaderListColor');
	});
</script>
