<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@  taglib prefix="f" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@  taglib uri="../WEB-INF/cvtaglib.tld" prefix="cv" %>

<f:message key="My_Backups" var="myBackups" />
<f:bundle basename="localization.BackupBrowseMessages">
 	<f:message key="backupBrowse.action.showDeleted" var="showDeleted"/>
 	<f:message key="backupBrowse.action.hideDeleted" var="hideDeleted"/>
</f:bundle>

<link rel="stylesheet" href="${pageContext.request.contextPath}/browse/css/emailEdge.css?${applicationScope.BUILD_TS}" />


<!-- Add seperate secHeader section for new Email Ui look -->

<div class="sechead dynamicDropDown clearFloat">

	<div class="clrfloat"></div>
	<div id="buttonsDivHolder">
		<div id="secTitleDiv">
			<span id="sectionTitle" class="sectiontitle vw-page-title vw-page-title_browse">${fn:escapeXml(param.headerTitleLocalized)}</span>
		</div>
		<div id="aButtons" class="browsetools">
				<c:if test="${!requestScope.hideBrowseToolsOption}">
					<ul class="fltright browseOptList emailPreviewToolbar vw-browse-right-menu pull-right">
								<c:if test='${requestScope.APPTYPE != "SHAREFOLDER"}'>
										<c:if test="${!requestScope.IS_SYNC_FOLDER}">
										<li class="timeRangeMenu">
											<a href="#" class="vw-btn vw-btn-secondary">
											<span class="dropdownOpener vw-drop-down-toggle" data-url="/browse/timeRangeMenu.jsp?clientId=${escapedClientId}&clientName=${escapedClientName}&backupsetId=${escapedBakupsetId}&subclientId=${escapedSubclientId}&APPTYPE=${requestScope.APPTYPE}" >
												<!-- <img class="date-icon" src="../common/img/date.png" alt="date"> -->
										 		<span id="timeRangeText"></span>
												<span class="sprite icon-arrow-dropdown" alt="^"></span>
												<span class="dropdown vw-drop-down"></span>
											</span>
											</a>
										</li>
									    <c:if test="${!requestScope.IS_ARCHIVER}">
											<li id="hideDeletedItemsLi"  ><a id="hideDeletedItems" href="#" class="vw-btn vw-btn-secondary">${hideDeleted}</a></li>
											<li id="showDeletedItemsLi"  style="display:none"><a id="showDeletedItems" href="#" class="vw-btn vw-btn-secondary">${showDeleted}</a></li>
										</c:if>
										</c:if>
										<c:if test="${requestScope.IS_SYNC_FOLDER}">
											<li id="hideDeletedItemsLi"></li>
											<li id="showDeletedItemsLi"  style="display:none"><a id="showDeletedItems" href="#" class="vw-btn vw-btn-secondary"><fmt:message key="backupBrowse.action.showTrash" /></a></li>
										</c:if>
									</c:if>
					</ul>
				</c:if>
		</div>
	</div>
	<div class="clrfloat"></div>
</div>