<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>

<fmt:bundle basename="localization.BackupBrowseMessages">
	<jsp:include page="../common/headerV2.jsp">
		<jsp:param value="../common/css/headerstyles.css" name="css" />
		<jsp:param value="true" name="includeJqueryUI" />
		<jsp:param value="${pageTitle}" name="titleLocalized" />
		<jsp:param value="${headerTitle}" name="headerTitleLocalized" />
		<jsp:param value="dialog" name="displayMode" />
	</jsp:include>

	<c:set var="mode" value="${fn:escapeXml(param.EDIT_LOCAL_MODE)}" />
	<c:set var="url" value="${applicationScope.WebconsoleLocalEditExecutablePathOverride}" />

	<div class="editLocalDiv">
		<div class="infoText">
			<c:choose>
				<c:when test="${mode == 'Login'}">
					<fmt:message key="edit.label.loginText">
						<fmt:param value='<span class="bold">' />
						<fmt:param value="</span>" />
					</fmt:message>
				</c:when>
				<c:when test="${mode == 'Start'}">
					<fmt:message key="edit.label.startToolText">
						<fmt:param value='<span class="bold">' />
						<fmt:param value="</span>" />
					</fmt:message>
				</c:when>
			</c:choose>
		</div>

		<c:if test="${mode == 'Start'}">
			<div class="buttonDiv">
				<a class="mainBtn downloadButton dLink" href=""><fmt:message key="backupBrowse.action.download" /></a>
			</div>
		</c:if>

		<div class="noteText">
			<c:choose>
				<c:when test="${mode == 'Login'}"><fmt:message key="edit.label.noteTextStartTool">
						<fmt:param value='<a href="" class="dLink">' />
						<fmt:param value="</a>" />
					</fmt:message></c:when>
				<c:when test="${mode == 'Start'}">
					<fmt:message key="edit.label.noteTextStartTool">
						<fmt:param value='<a href="" class="dLink">' />
						<fmt:param value="</a>" />
					</fmt:message>
				</c:when>
			</c:choose>
		</div>
	</div>

	<!-- <div class="btns" >
		<a type="button" class="cancelButton" id="cancelButton"><fmt:message key="upload.label.cancel" /></a>
	</div>	 -->
	<jsp:include page="../common/footer.jsp" />

<script nonce="${sessionScope.cspNonce}" >
	$("#cancelButton").on("click", function() {
		cvUtil.closeModal();
	});

	/*
	 * Consider moving to another common file.
	 */
	if (!String.prototype.splice) {
	    /*
	     * {JSDoc}
	     *
	     * The splice() method changes the content of a string by removing a range of
	     * characters and/or adding new characters.
	     *
	     * @this {String}
	     * @param {number} start Index at which to start changing the string.
	     * @param {number} delCount An integer indicating the number of old chars to remove.
	     * @param {string} newSubStr The String that is spliced in.
	     * @return {string} A new string with the spliced substring.
	     */
	    String.prototype.splice = function(start, delCount, newSubStr) {
	        return this.slice(0, start) + newSubStr + this.slice(start + Math.abs(delCount));
	    };
	}


	var url = "${url}";
	var appender = null;
	if (navigator.userAgent.indexOf("WOW64") != -1 ||  navigator.userAgent.indexOf("Win64") != -1) {
	    appender = "_x64";
	} else {
	    appender = "_x86";
	}

	url = url.splice(url.indexOf(".msi"), 0, appender);

	$(".dLink").attr("href", url);
</script>
<style>
.editLocalDiv {
	color: #333333;
}
.buttonDiv {
    text-align: center;
    margin: 20px 0 20px;
}
.noteText {
    color: #999;
    font-size: 0.9em;
    padding-top:10px;
}
#content {
	min-height:0px;
	padding-left:0px;
}
.bold {
	font-weight:bold;
}
</style>
</fmt:bundle>
<c:if test="${mode == 'Start'}">
<style>
.noteText {
    padding-top:15px;
}
</style>
</c:if>