<!doctype html>
<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv" %>

<head>
    <meta charset="utf-8">
	<meta name="description" content="">
    <meta name="viewport"
          content="width=device-width, initial-scale=1, maximum-scale=1, minimum-scale=1, user-scalable=no">
	<!-- Enable IE Standards mode -->
    <meta http-equiv="x-ua-compatible" content="ie=edge">
	<meta name="author" content="CommVault">

	<title>${requestScope.FILE_NAME}</title>

    <link rel="shortcut icon"
          href="${requestScope.FAV_ICON}" />

    <style type="text/css">
        body {
            margin: 0;
            padding: 0;
            overflow:hidden;
            -ms-content-zooming: none;
        }
        #office_frame {
            width: 100%;
            height: 100%;
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            margin: 0;
            border: none;
            display: block;
        }
    </style>

	<fmt:bundle basename="localization.BackupBrowseMessages">
		<fmt:message key="share.label.shareTitle" var="shareTitle" />
	</fmt:bundle>

	<link rel="stylesheet" href="${pageContext.request.contextPath}/common/css/templatestyles.css?${applicationScope.BUILD_TS}" />
	<link rel="stylesheet" href="${pageContext.request.contextPath}/common/css/theme/jquery-ui.css?${applicationScope.BUILD_TS}" />

	<script nonce="${sessionScope.cspNonce}" type="text/javascript" src="${pageContext.request.contextPath}/common/js/jquery.min.js?${applicationScope.BUILD_TS}"></script>
	<script nonce="${sessionScope.cspNonce}" type="text/javascript" src="${pageContext.request.contextPath}/common/js/jquery-migrate-1.2.1.js?${applicationScope.BUILD_TS}"></script>
	<script nonce="${sessionScope.cspNonce}" type="text/javascript" src="${pageContext.request.contextPath}/common/js/cvutil.js?${applicationScope.BUILD_TS}"></script>
	<script nonce="${sessionScope.cspNonce}" >
		cvUtil.CONTEXT_PATH = '/webconsole';
		cvUtil.SESSION_TIMEOUT = cvUtil.DEFAULT_SESSION_TIMEOUT;
		var localMsg = localMsg || {};
		localMsg.shareTitle = "${shareTitle}";
	</script>
	<script nonce="${sessionScope.cspNonce}" type="text/javascript" src="${pageContext.request.contextPath}/common/js/custom-modal.js?${applicationScope.BUILD_TS}"></script>
	<script nonce="${sessionScope.cspNonce}" type="text/javascript" src="${pageContext.request.contextPath}/common/js/jquery.cookie.js?${applicationScope.BUILD_TS}"></script>
	<script nonce="${sessionScope.cspNonce}" type="text/javascript" src="${pageContext.request.contextPath}/common/js/jquery-ui-min.js?${applicationScope.BUILD_TS}"></script>
</head>
<body>
	<form id="office_form" name="office_form" target="office_frame"
		  action="${requestScope.EDIT_URL}" method="post">
		<input name="access_token" value="${requestScope.ACCESS_TOKEN}" type="hidden"/>
		<input name="access_token_ttl" value="${requestScope.ACCESS_TOKEN_TTL}" type="hidden"/>
	</form>

	<span id="frameholder"></span>

	<script type="text/javascript" nonce="${sessionScope.cspNonce}" >
		var frameholder = document.getElementById('frameholder');
		var office_frame = document.createElement('iframe');
		office_frame.name = 'office_frame';
		office_frame.id ='office_frame';
		// The title should be set for accessibility
		office_frame.title = 'Office Online Frame';
		// This attribute allows true fullscreen mode in slideshow view
		// when using PowerPoint Online's 'view' action.
		office_frame.setAttribute('allowfullscreen', 'true');
		frameholder.appendChild(office_frame);
		document.getElementById('office_form').submit();

		var shareFolderId = "${requestScope.SHARE_FOLDER_ID}";

		//Listener for post messages from office online iframe
		window.addEventListener('message', handlePostMessage, false);

		//Post message handler
		function handlePostMessage(e)
		{
			// Allow only messages originated from office online
			var origin = e.origin;
			var expectedOrigin = "${requestScope.EDIT_URL}";

			if(!expectedOrigin.toLowerCase().includes(origin.toLowerCase()))
				return;

			// The actual message is contained in the data property of the event.
			var msg = JSON.parse(e.data);

			// The message ID is a property of the message object.
			var msgId = msg.MessageId;

			//Handle sharing message
			if("UI_Sharing" == msgId)
			{
				var params = [];
				var isCreateFolder = false;

				if (shareFolderId !== null && typeof (shareFolderId) !== "undefined" && shareFolderId.trim().length > 0) {
					params.push(cvUtil.createParamString("shareFolderId", shareFolderId));
					params.push(cvUtil.createParamString("isCreateFolder", false));
					isCreateFolder = false;
				} else {
					params.push(cvUtil.createParamString("isCreateFolder", true));
					params.push(cvUtil.createParamString("clientId", "${requestScope.CLIENT_ID}"));
					params.push(cvUtil.createParamString("clientName", "${requestScope.CLIENT_NAME}"));
					params.push(cvUtil.createParamString("subclientId", "${requestScope.SUBCLIENT_ID}"));
					params.push(cvUtil.createParamString("browseParentShareId", "${requestScope.PARENT_SHARE_ID}"));
					isCreateFolder = true;
				}
				params.push(cvUtil.createParamString("isPublicLink", false));
				params.push(cvUtil.createParamString("appType", "${requestScope.appType}"));
				params.push(cvUtil.createParamString("selections", "${requestScope.selections}"));

				params.push(cvUtil.createParamString("showPublicLink", true));
				params.push(cvUtil.createParamString("isEdgeClient", true));

				var target = cvUtil.createUrlWithParams("shareFileDialog.do", params);

				var options = {
					width : 510,
					height : 600,
					title : localMsg.shareTitle,
					href : target,
					iframe : true
				};

				var closeListener = function(res) {
					if (typeof res === "undefined") {
						return;
					}

					if (res.folderDeleted) {
						//After un-share reset the shareFolderId to null so that we don't try to access the same share when user clicks on share button again
						shareFolderId = null;
						//Remove url parameter to cover page refresh cases
						var newUrl = window.location.search.substring(1);
						var prefix= "shareFolderId=";
						var pars= newUrl.split(/[&;]/g);
						for (var i= pars.length; i-- > 0;) {
							if (pars[i].lastIndexOf(prefix, 0) !== -1) {
								pars.splice(i, 1);
							}
						}
						newUrl = (pars.length > 0 ? '?' + pars.join('&') : "");
						if(history.replaceState) {
							history.replaceState(null, null, newUrl);
						} else {
							window.location.search = newUrl;
						}
					} else if (res.shareSubmitted && res.shareFolderId !== null) {
						//After sharing set the shareFolderId
						shareFolderId = res.shareFolderId;
						//Add url parameter to cover page refresh cases
						var newUrl = window.location.search + "&" + cvUtil.createParamString("shareFolderId", shareFolderId);
						if(history.replaceState) {
							history.replaceState(null, null, newUrl);
						} else {
							window.location.search = newUrl;
						}
					}
				};

				cvUtil.showModal(options, null, closeListener);
			}
		}
	</script>
</body>
</html>
