<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>

<link rel="stylesheet" href="${pageContext.request.contextPath}/browse/css/edgeStyle.css?${applicationScope.BUILD_TS}" />
<link rel="stylesheet" href="${pageContext.request.contextPath}/browse/css/dataPane.css?${applicationScope.BUILD_TS}" />

<div class="sechead dynamicDropDown">
<div class="clrfloat"></div>

<c:if test="${param.sourcePage == 'browse'}">
	<fmt:bundle basename="localization.BackupBrowseMessages">
		<div id="buttonsDivHolder">
			<div id="secTitleDiv">
				<span id="sectionTitle" class="sectiontitle  vw-page-title vw-page-title_browse">${fn:escapeXml(param.headerTitle)}</span>
			</div>
			<div id="aButtons" class="browsetools">
					<div class="vw-action-menu-wrapper pull-left">
						<div class="action-menu">
							<a href="javascript:void(0)" class="js-smartMenuToggle vw-btn vw-btn-secondary"><fmt:message key="backupBrowse.action.actions" /><span class="sprite icon-arrow-dropdown hideOnSmallScreens" alt="^"></span></a>
						</div>
					<ul id="firstControl">
					</ul>
				</div>


					<ul class="fltright browseOptList vw-browse-right-menu pull-right" >
						<li class="edgeDriveQuotaTop">
						<div id="fsSummaryTopSection" class="vw-disk-usage-wrapper vw-start-hidden">
							<div id="quota-info-div" class="vw-disk-usage">
								<div id="quotaLocalized" class="quota-info-title vw-disk-usage_title"><fmt:message key='edge.drive.quota'/></div>
								<div class="quota-info-data vw-disk-usage_data">
									<span id="subsec-quota"></span>
									<div id="totalFsQuota" class="vw-status-bar">
										<div id="usedFsQuota" class="vw-status-bar_percentage">
										</div>
									</div>
								</div>
							</div>
						</div>
						</li>
						<c:if
							test="${empty param.shareFolderId && requestScope.hasEdgeDriveEnabledLaptop != null && requestScope.hasEdgeDriveEnabledLaptop == true}">
							<c:choose>
								<c:when
									test="${requestScope.hasSyncBlackListedLaptop == null || requestScope.hasSyncBlackListedLaptop == false}">
									<li><a href="#" class="noText vw-btn vw-btn-secondary"
										id="mydriveSettings"
										title="<fmt:message key='backupBrowse.title.openSettings'/>"><span
											class="sprite icon-settings-drive-new showOnMediumScreens"></span></a>
									</li>
								</c:when>
								<c:otherwise>
									<li><a href="#" class="noText vw-btn vw-btn-secondary"
										id="mydriveSettings"
										title="<fmt:message key='backupBrowse.title.openSettings'/>"><span
											class="sprite icon-settings-drive-alert showOnMediumScreens"></span></a>
									</li>
								</c:otherwise>
							</c:choose>
					</c:if>
					<c:if test="${requestScope.browse.features.isDataPaneAvailable()}">
							<li><a href="#"
								class="noText hideOnMediumScreens vw-btn vw-btn-secondary"
								id="toggleInfoPaneLink"
								title="<fmt:message key='dataPane.iconTitle.show'/>"><span
									class="sprite icon-info-pane-show showOnMediumScreens"></span></a>
						</li>
					</c:if>
				</ul>
			</div>
		</div>
	</fmt:bundle>
</c:if>
</div>

