<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<fmt:bundle basename="localization.BackupBrowseMessages">
	<fmt:message key="backupBrowse.label.ok" var="ok" />
	<fmt:message key="backupBrowse.label.cancel" var="cancel" />
</fmt:bundle>
<c:set var="clientIdParam" value="${fn:escapeXml(param.clientId)}" />
<c:set var="isClientLocked" value="${fn:escapeXml(param.isClientLocked)}" />
<c:set var="isPrivacyFeatureDisabled" value="${fn:escapeXml(param.isPrivacyFeatureDisabled)}" />
<fmt:message key="Register_Password_error" var="passwordsDontMatch"/>
<fmt:bundle basename="localization.ClientDetailsMessages">
	<fmt:message key="clientlock.dialog.adminDisabledNote" var="adminDisabledNote" />
	<fmt:message key="clientlock.dialog.error" var="passwordNotValid"/>
	<fmt:message key='clientlock.dialog.subtitle' var="passwordLabel"/>
</fmt:bundle>
<script nonce="${sessionScope.cspNonce}" >
var clientId = "${clientIdParam}";
var isClientLocked = ("true" === "${isClientLocked}");
var isPrivacyFeatureDisabled = "${isPrivacyFeatureDisabled}";

function passwordsMatch(pass1,pass2)
{
	return (pass1 === pass2);
}
function showThisError(msg)
{
	$("#privacyErrDiv").html(msg);
	$("#privacyErrDiv").show();
	$("#okButton").removeClass("loading");
}
function clearAllErrorMsgs()
{
	$("#okButton").removeClass("loading");
	$("#privacyErrDiv").html("");
	$("#privacyErrDiv").hide();
}


$("#passwordText").keyup(function(event) {
	if (event.keyCode == 13) {
		submitThis();
	}
});
$("#okButton").on("click keydown",function(e){
	if (e.which == 13 || e.type == "click"){
		submitThis();
	}
});
function submitThis(){
	clearAllErrorMsgs();
	browseMain.privacyChanged = false;

	//validations
	if (isClientLocked && isPrivacyFeatureDisabled == "true") {
		showThisError("${adminDisabledNote}");
		return;
	}
	if (!$.trim($("#passwordText").val())){
		showThisError("${passwordNotValid}");
		return;
	}
	//validations done

	$("#okButton").addClass("loading");

	//call api to disable privacy password
	var params = {
			clientId : clientId,
			clientLockStatus : !isClientLocked,
			password : Base64.encode($.trim($("#passwordText").val())),
			authType : 1
		};

	var result = cvUtil.loadSynchronously('lockClient.do', params, function(
			data) {
		showThisError("${passwordNotValid}");
	});
	$("#okButton").removeClass("loading");
	if (result == "Success") {
		browseMain.privacyChanged = true;
		cvUtil.closeModal();
	}else{
		if (result != ""){
			showThisError(result);
		}
	}
};
$("#cancelButton").on("click keydown", function(e) {
	if (e.which == 13 || e.type == "click"){
		cvUtil.closeModal();
	}
})
</script>


<div id="privacyErrDiv" class="vw-alert vw-message alert-danger vw-start-hidden margin-right-15"></div>
<fmt:bundle basename="localization.ClientDetailsMessages">
<div id="privacyDiv" class="clientLockMain margin-right-15">
		<div class="infotype pull-left">${passwordLabel}</div>
		<input id="passwordText" type="password" class="textbox form-control" autofocus tabindex="1"/>
</div>
<br/>
</fmt:bundle>
<div class="btns pull-right margin-right-15 margin-bottom-15">
				<a type="button" id="cancelButton" class="vw-btn vw-btn-default" tabindex="3">${cancel}</a>
				<a type="button" id="okButton" class="okSaveButton mainBtn vw-btn vw-btn-primary" tabindex="2"><span class="vw-btn-text">${ok}</span><svg xmlns="http://www.w3.org/2000/svg" width="23px" height="23px" viewBox="0 0 100 100" preserveAspectRatio="xMidYMid" class="uil-spin"><g transform="translate(50 50)"><g transform="rotate(0) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.44167 1.44167)"><animate attributeName="opacity" from="1" to="0.1" begin="0s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g><g transform="rotate(45) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.00167 1.00167)"><animate attributeName="opacity" from="1" to="0.1" begin="0.12s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0.12s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g><g transform="rotate(90) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.06667 1.06667)"><animate attributeName="opacity" from="1" to="0.1" begin="0.25s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0.25s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g><g transform="rotate(135) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.12667 1.12667)"><animate attributeName="opacity" from="1" to="0.1" begin="0.37s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0.37s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g><g transform="rotate(180) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.19167 1.19167)"><animate attributeName="opacity" from="1" to="0.1" begin="0.5s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0.5s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g><g transform="rotate(225) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.25167 1.25167)"><animate attributeName="opacity" from="1" to="0.1" begin="0.62s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0.62s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g><g transform="rotate(270) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.31667 1.31667)"><animate attributeName="opacity" from="1" to="0.1" begin="0.75s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0.75s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g><g transform="rotate(315) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.37667 1.37667)"><animate attributeName="opacity" from="1" to="0.1" begin="0.87s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0.87s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g></g></svg></a>
</div>