<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"%>
<%@  taglib prefix="f" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@  taglib uri="../WEB-INF/cvtaglib.tld" prefix="cv"%>

<div class="sechead dynamicDropDown">
	<c:if
		test="${param.secHeadertopRightButtonHolder != null && param.secHeadertopRightButtonHolder == true}">
		<ul id="secHeadertopRightButtonHolder"
			class="secHeadertopRightButtonHolder rghtFloat hideOnExportFriendly">
		</ul>
	</c:if>

	<c:if test="${requestScope.headerLinks != null}">
		<div class="headerLinks">
			<c:forEach var="item" items="${requestScope.headerLinks}"
				varStatus="loop">
				<a href="${item[1] }">${item[0] }</a>
			</c:forEach>
		</div>
	</c:if>
	<div class="clrfloat"></div>


	<f:bundle basename="localization.BackupBrowseMessages">
		<div id="buttonsDivHolder">
			<div id="secTitleDiv">
				<span id="sectionTitle" class="sectiontitle vw-page-title vw-page-title_browse">${fn:escapeXml(param.headerTitle)}</span>
			</div>
			<div id="aButtons" class="browsetools">
				<ul id="firstControl">
				</ul>
				<ul class="fltright browseOptList pull-right">
					<c:if test='${requestScope.APPTYPE != "SHAREFOLDER"}'>
						<c:if test="${!requestScope.IS_SYNC_FOLDER}">
							<li class="timeRangeMenu">
								<a href="#" class="vw-btn vw-btn-secondary">
									<span class="dropdownOpener vw-drop-down-toggle"
								data-url="/browse/timeRangeMenu.jsp?isLiveBrowseAvailable=${requestScope.browse.features.isLiveBrowseAvailable()}&
								disableTimeRangeAdv=true">
									<!-- <img class="date-icon" src="../common/img/date.png" alt="date"> -->
										<span id="timeRangeText"></span>
										<span class="sprite icon-arrow-dropdown" alt="^"></span>
										<span class="dropdown vw-drop-down"></span>
									</span>
								</a>
							</li>
							<c:if test="${!requestScope.IS_ARCHIVER}">
								<li id="hideDeletedItemsLi"><a id="hideDeletedItems" class="vw-btn vw-btn-secondary"
									href="#"><f:message key="backupBrowse.action.hideDeleted" /></a></li>
								<li id="showDeletedItemsLi" style="display: none"><a
									id="showDeletedItems" class="vw-btn vw-btn-secondary" href="#"><f:message
											key="backupBrowse.action.showDeleted" /></a></li>
							</c:if>
						</c:if>
					</c:if>
					<c:if test="${requestScope.browse.features.isPreviewAvailable()}">
						<li class="maybeNobar"><a href="#" id="previewToggle"><f:message
									key="backupBrowse.action.previewToggle" /></a></li>
					</c:if>
					<c:if test='${requestScope.browse.features.isIconViewAvailable()}'>
						<li>
							<div class="switchViewsFull fltright">
								<div class="listSwitchButton">
									<span class="sprite icon-view-list"></span>
								</div>
								<div class="iconSwitchButton">
									<span class="sprite icon-view-grid"></span>
								</div>
							</div> <c:if
								test='${requestScope.browse.features.isPieChartAvailable()}'>
								<script nonce="${sessionScope.cspNonce}" >
									var showPieChart = false;
								</script>
								<div class="pieChartButton fltright vw-btn vw-btn-secondary">
									<div class="showPieButton">
										<span class="sprite icon-piechart"></span>
									</div>
								</div>
							</c:if>
						</li>
					</c:if>
				</ul>
			</div>
		</div>
	</f:bundle>
</div>