<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@  taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"%>

<fmt:bundle basename="localization.BackupBrowseMessages">
		<%-- <jsp:param value="css/upload.css" name="css" /> --%>
	
	<fmt:message key="upload.label.untitledFolder" var="untitledFolder" />
	<fmt:message key="upload.text.hasBeenCreated" var="hasBeenCreated" />
	<fmt:message key="upload.text.errorCreatingFolder" var="errorCreatingFolder" />
	<fmt:message key="upload.error.folderNameCannotBeEmpty" var="emptyFolder"/>
	<fmt:message key="upload.error.folderNameNotValid" var="notValidName"/>

	<div class="createDiv vw-start-hidden">
			<div class="createFolderDiv vw-form-horizontal">
				<div class="line form-group">
					<label class="infoTitle col-sm-4 control-label" for="folderLocation"><fmt:message key="upload.label.folderName" /></label>
					<div class="col-sm-8">
						<input type="text" id="folderLocation" value="${untitledFolder}" class="form-control">
					</div>
				</div>
				<span id="folderLocationError" class="text-danger"></span>
			</div>
	</div>

<script nonce="${sessionScope.cspNonce}" >
var createFolderText = {'create': '<fmt:message key="upload.label.createFolder" />', 'cancel': '<fmt:message key="upload.label.cancel" />'};
var resultMessages = {'success':'<fmt:message key="upload.text.hasBeenCreated" />', 'error':'<fmt:message key="upload.text.errorCreatingFolder" />'};
var okButtonClass = 'createFolderSaveClick';
var notValidName = '${notValidName}';
var emptyFolder = '${emptyFolder}';
var untitledFolder = '${untitledFolder}';

$("#parentLocation").text($("#parentLocation").text().replace(/\\\\/g,"\\"));

$("#folderLocation").keyup(function(e){
	if(e.keyCode == 13){
	       $("." + okButtonClass).click();
	    }
});

</script>
</fmt:bundle>