<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>

<fmt:bundle basename="localization.BackupBrowseMessages">
<fmt:message key="sharing.label.notifyEmailPlaceHolderText" var="notifyEmailPlaceHolderText" />
<fmt:message key="sharing.label.never" var="neverText" />
<fmt:message key="share.label.addCommaSepEmailsText" var="addCommaSepEmailsText" />
<fmt:message key='sharing.label.days' var='daysText' />
<fmt:message key='sharing.label.expired' var='expired' />
<fmt:message key='share.label.setNewExpiry' var='setNewExpiry' />
<fmt:message key='share.label.pleaseEnterPasswordError' var='pleaseEnterPasswordError' />
<fmt:message key='email.error.text2' var='invalidEmailText' />
<fmt:message key="share.label.expireLinkIn" var="expireLinkIn"/>
<c:set var="defaultExpiry" value="7" />
<c:if test="${applicationScope.defaultShareExpiry != null}">
	<c:set var="defaultExpiryOn" value="true" />
	<c:set var="defaultExpiry" value="${applicationScope.defaultShareExpiry}" />
</c:if>
<div class="advancedOptionsShareDivEdit">
	<table id="advanceSTable">
		<tr class="advanceRow expireLi">
			<td id="expiration-label"><fmt:message key="share.label.whenDoesItExpire" /></td>
			<td>
				<ul class="selectMode" role="radiogroup" aria-labelledby="expiration-label">
					<li aria-checked="true" role="radio" tabindex="0"><div class="custom-rb checked-rb noexpiry-rb-edit" data-state="checked" data-id="3"></div><span class="custom-rb-label" >${neverText}</span></li>
	                <li aria-checked="false" role="radio" tabindex="-1">
	                	<div class="custom-rb unchecked-rb expiry-rb-edit" data-state="unchecked"  data-id="3"></div>
	                	<span class="custom-rb-label linkTextEdit" >${expireLinkIn}</span>
	                	<div id="expTextEdit" class="disabled">
	                		<span id="dayValueEdit">
	                		<c:choose>
	                			<c:when test="${param.timeValueUpload != '' && param.timeValueUpload != '0'}">
	                				${fn:escapeXml(param.timeValueUpload)}
	                			</c:when>
	                			<c:otherwise>
	                				${defaultExpiry} ${daysText}
	                			</c:otherwise>
	                		</c:choose>
	                		</span>
	                		<div class="dropdownExpList">
								<div class="triborder vw-triangle-border" style="right: 10px;"><div class="triarea vw-triangle-innards" ></div></div>
									<ul class="optionsList settingsbox">
										<li class="preSetDaysEdit" data-id="7">7 ${daysText}</li>
										<li class="preSetDaysEdit" data-id="30">30 ${daysText}</li>
										<li id="expirationTimeEdit"><span><fmt:message key="share.label.custom" /></span></li>
									</ul>
							</div>
	                	</div>
	                </li>
                 </ul>
			</td>
		</tr>
		<tr class="advanceRow passwordLi">
			<c:choose>
	  			<c:when test="${sessionScope.isPublicShareGeneratedPass == null || sessionScope.isPublicShareGeneratedPass != true }">
					<fmt:message key="share.label.peopleWithPassword" var="UserEnteredPassword" />
				</c:when>
       			<c:otherwise>
					<fmt:message key="share.label.generatedPlusUserPassword" var="UserEnteredPassword" />
	  			</c:otherwise>
       		</c:choose>
			<td id="whoCanAccess-label"><fmt:message key="share.label.whoCanAccess" /></td>
			<td>
				<ul class="selectMode" role="radiogroup" aria-labelledby="whoCanAccess-label">
					<c:choose>
               			<c:when test="${sessionScope.isPublicShareGeneratedPass == null || sessionScope.isPublicShareGeneratedPass != true }">
			                <li aria-checked="true" role="radio" tabindex="0"><div class="custom-rb checked-rb nopassword-rb-edit" data-state="checked" data-id="4"></div><span id="anyOneWithLinkEdit" class="custom-rb-label" ><fmt:message key="share.label.anyOneWithLink" /></span></li>
               			</c:when>
               			<c:otherwise>
			                <li aria-checked="true" role="radio" tabindex="0"><div class="custom-rb checked-rb generatedpassword-rb-edit" data-state="checked" data-id="4"></div><span id="generatedLinkPasswordEdit" class="custom-rb-label" ><fmt:message key="share.label.generatedLinkPassword" /></span></li>
               			</c:otherwise>
               		</c:choose>
	                <li aria-checked="false" role="radio" tabindex="-1">
	                	<div class="custom-rb unchecked-rb password-rb-edit" data-state="unchecked" data-id="4"></div><span class="custom-rb-label" >${UserEnteredPassword}</span>
						<c:set var="pValue" value="" />
						<c:set var="pClass" value="disabled" />
						<c:if test="${param.isPwdSetUpload == 'true' && param.isPwdGeneratedUpload != 'true'}">
							<c:set var="pValue" value="````" />
							<c:set var="pClass" value="" />
						</c:if>
						<div id="passwordEdit" class="password-input"><input id="inputPasswordEdit" ${pClass} type="password" placeholder="" value="${pValue}" onfocus="this.select();" /></div>
	                </li>
                </ul>
			</td>
		</tr>
		<tr class="advanceRow emailLi">
			<td><fmt:message key="share.label.emailLinkNow" /></td>
			<td>
				<ul class="selectMode">
	                <li><textarea id="emailList" placeHolder="${addCommaSepEmailsText}"></textarea></li>
                </ul>
			</td>
		</tr>

		<c:if test="${param.isReshareFeatureEnabled == 'true'}">
		<tr class="advanceRow reshareLi">
			<td id="resharesEnabled-label"><fmt:message key="share.label.resharesEnabled"/></td>
			<td>
				<ul class="selectMode reshareUl">
	                <li>
	                	<c:set var="reshareChecked" value="unchecked" />
	                	<fmt:bundle basename="localization.messages">
							<ul class="selectMode" role="radiogroup" aria-labelledby="resharesEnabled-label">
								<li aria-checked="false" role="radio" tabindex="-1"><div class="custom-rb unchecked-rb reshare-rb-edit" data-state="unchecked" data-id="2"></div><span class="custom-rb-label" ><fmt:message key="common.action.yes" /></span></li>
		                		<li aria-checked="true" role="radio" tabindex="0"><div class="custom-rb checked-rb noReshare-rb-edit" data-state="checked" data-id="2"></div><span class="custom-rb-label" ><fmt:message key="common.action.no" /></span></li>
	                		</ul>
                		</fmt:bundle>
	                </li>
                </ul>
			</td>
		</tr>
		</c:if>

		<tr class="advanceRow emailNoteLi">
			<td><fmt:message key="share.label.addAMessage" /></td>
			<td>
				<ul class="selectMode notifyByEmailDiv">
	                <li>
		                <div class="custom-cb checked" data-state="checked" tabindex="0" role="checkbox" aria-checked="true" aria-labelledby="notifyByEmail-label"></div><div class="custom-cb-label" id="notifyByEmail-label"><fmt:message key="sharing.label.notifyByEmail" /></div>
		                <textarea id="notifyEmailsTextDiv" class="textarea" placeholder="${notifyEmailPlaceHolderText}" ></textarea>
	                </li>
                </ul>
			</td>
		</tr>
	</table>
</div>
</fmt:bundle>


<script nonce="${sessionScope.cspNonce}" src="${pageContext.request.contextPath}/browse/js/commonShareInfoEdit.js?${applicationScope.BUILD_TS}"></script>
<script nonce="${sessionScope.cspNonce}" >
var localMsg = localMsg || {};
localMsg.pleaseEnterPasswordError = "${pleaseEnterPasswordError}";
localMsg.invalidEmailText = "${invalidEmailText}";
localMsg.daysText = "${daysText}";
localMsg.expireLinkIn = "${expireLinkIn}";
localMsg.expired = "${expired}";
localMsg.setNewExpiry = "${setNewExpiry}";

var commonShareInfoEdit = commonShareInfoEdit || {};
commonShareInfoEdit.fromDate = new Date();
commonShareInfoEdit.contextPath = "${pageContext.request.contextPath}";
commonShareInfoEdit.isPwdSet = ("true" === "${fn:escapeXml(param.isPwdSetUpload)}");
commonShareInfoEdit.isPwdGeneratedUpload = ("true" === "${fn:escapeXml(param.isPwdGeneratedUpload)}");
commonShareInfoEdit.timeValue = "${fn:escapeXml(param.timeValueUpload)}";
commonShareInfoEdit.isReshared = ("true" == "${fn:escapeXml(param.isReshareEnabledUpload)}");
commonShareInfoEdit.expiryDate = null;
commonShareInfoEdit.expirationDate = null;
commonShareInfoEdit.defaultExpiryOn = ("true" == "${fn:escapeXml(defaultExpiryOn)}");
commonShareInfoEdit.isNewShare = ("true" === "${fn:escapeXml(param.isNewShare)}");
commonShareInfoEdit.defaultExpiry = "${defaultExpiry}";
commonShareInfoEdit.defaultSharePassword = ("${applicationScope.defaultSharePassword}" === "true");
</script>

<link rel="stylesheet" href="${pageContext.request.contextPath}/browse/css/commonShareInfo.css?${applicationScope.BUILD_TS}" />