<script type="text/template" id="browseControlsTemplate">
	{{#controlList}}
	{{#fixedButton}}
	<li>
		<a href='{{target}}'
			class='{{#disabled}}hiddenActions{{/disabled}} selections {{classes}} {{#isReviewSelections}}reviewSelections{{/isReviewSelections}}'
			id='{{id}}'
			title='{{title}}'
			>{{label}}<span class='sprite {{spriteClasses}} showOnMediumScreens'></span></a>
	</li>
	{{/fixedButton}}
	{{/controlList}}
</script>
<script type="text/template" id="browseControlsDropdownTemplate">
	{{#controlList}}
	{{^fixedButton}}
	<li>
		<a href='{{target}}'
			class='{{#disabled}}hiddenActions{{/disabled}} selections {{classes}} {{#isReviewSelections}}reviewSelections{{/isReviewSelections}}'
			id='{{id}}'
			title='{{title}}'
			>{{label}}<span class='sprite {{spriteClasses}} showOnMediumScreens'></span></a>
	</li>
	{{/fixedButton}}
	{{/controlList}}
</script>

<script type="text/template" id="fixedBreadcrumbsTemplate">
	{{#breadcrumbList}}
	<li{{#detailsLink}} class="detailsLink"{{/detailsLink}}>
		<a class="smartLink" href='{{target}}'>{{label}}{{#showArrow}}<svg xmlns="http://www.w3.org/2000/svg" width="5" height="8" viewBox="0 0 5 8" class="vw-breadcrumb-arrow"><path d="M0,8V6L3,4,0,2V0L5,4Z"></path></svg>{{/showArrow}}</a>
	</li>
	{{/breadcrumbList}}
</script>

<script type="text/template" id="propertyTemplate">
	{{#propertyList}}
	<dt>{{propertyName}}</dt>
	<dd>{{propertyValue}}</dd>
	{{/propertyList}}
</script>

<script type="text/template" id="sharesTemplate">
	{{#list}}
		<div class="user_icon" data-toggle="tooltip" data-html="true" data-placement="bottom" title="{{tooltipText}}" >
			<div class="icon_container">
	    			<img class="center vw-tooltip sharesPaneImg" data-type="{{type}}" data-name="{{name}}" data-loginname="{{loginname}}" src="{{imgUrl}}" />
			</div>
	  	</div>
	{{/list}}
</script>

<script type="text/template" id="tagsTemplate">
	{{#tagsList}}
	<div class="tag-wrap" data-tag="{{tag}}">
		<a href="#" class="tag-search-js" title="{{searchLabel}}">{{tag}}</a>&nbsp;<span class="sprite icon-delete-tag tag-remove-js" title="{{removeLabel}}"></span>
	</div>
	{{/tagsList}}
</script>

<script type="text/template" id="tagsTemplateReadOnly">
	{{#tagsList}}
	<div class="tag-wrap full-width" data-tag="{{tag}}">
		<a href="#" class="tag-search-js" title="{{searchLabel}}">{{tag}}</a>&nbsp;
	</div>
	{{/tagsList}}
</script>

<script type="text/template" id="commentsTemplate">
	{{#moreComments}}<a href="#" class="loadMorePostsJs add-wrapper center">{{seeAll}}</a>{{/moreComments}}
	{{#comments}}
	<div class="js-comment comment-wrapper" data-id={{commentId}}>
		<div class="comments-image-dynamic">
			<img class="dynamic-image commentsPaneImg" src="{{contextPath}}/getProfileImg.do?USERID={{owner.userId}}" />
		</div>
		<p class="commenter" data-after="{{commentSaid}}"><b>{{owner.newName}}</b> <span>{{elapsedTime}}</span></p>
		<div class="comment-text-wrapper">
			<span class="comment-text">
				<span class="fullText" style="display:{{#expandComment}}none{{/expandComment}}">{{#replaceLineBreak}}{{content}}{{/replaceLineBreak}} </span>
				{{#expandComment}}
					<span class="lessText">{{#replaceLineBreak}}{{lessContent}}{{/replaceLineBreak}} </span><span class="comments comments-show">{{expandText}}</span>
				{{/expandComment}}
				<span class="sprite-action-wrapper">
					{{#editEnabled}}<span class='sprite icon-comment-edit openEditPostJs' title='{{editTitle}}'></span>{{/editEnabled}}{{#replyEnabled}}<span class='sprite icon-comment-reply replyJs' title='{{replyTitle}}'></span>{{/replyEnabled}}{{#deleteEnabled}}<span class='sprite icon-comment-delete deletePostJs' title='{{deleteTitle}}'></span>{{/deleteEnabled}}
				</span>
			</span>
		</div>
		<div id="editTextDiv" class="editTextDiv" style="display:none;">
			<textarea  class="comment-edit-textbox editBox" title="Edit Comment">{{content}}</textarea>
			<input class="editPostJs" type="submit" value="Save" />
			<input class="closeEditPostJs" type="submit" value="Cancel" />
		</div>
		<div id="comments-wrapper-{{commentId}}" class="comments-wrapper-div" id="reply1" style="display:none;" >
			<textarea class="newReply myReplyAutoGrowTextarea comment-textarea-autogrow"  rows="1" placeholder="Add reply" />
			<input type="submit" class="addPostJs" name="reply" value="Reply" id="reply" />
			<input class="closeReplyPostJs" type="submit" value="Cancel" />
		</div>
		{{#moreReplies}}<a href="#" class="loadMorePostsJs add-wrapper center">{{seeAllReplies}}</a>{{/moreReplies}}
		{{#replies}}
		<div class="js-reply indent" data-id={{commentId}}>
			<div class="comments-image-dynamic">
				<img class="dynamic-image commentsPaneImg" src="{{contextPath}}/getProfileImg.do?USERID={{owner.userId}}" />
			</div>
			<p class="commenter reply-comment" data-after="{{commentReplied}}"><b>{{owner.newName}}</b> <span>{{elapsedTime}}</span></p>
			<div class="comment-text-wrapper">
				<span class="comment-text-reply"><span class="fullText" style="display:{{#expandReply}}none{{/expandReply}}">{{#replaceLineBreak}}{{content}}{{/replaceLineBreak}} </span>
				{{#expandReply}}
					<span class="lessText">{{#replaceLineBreak}}{{lessContent}}{{/replaceLineBreak}} </span><span class="comments comments-show">{{expandText}}</span>
				{{/expandReply}}
				<span class="sprite-action-wrapper">
					{{#editReplyEnabled}}<span class='sprite icon-comment-edit openEditPostJs' title='{{editTitle}}'></span>{{/editReplyEnabled}}{{#deleteReplyEnabled}}<span class='sprite icon-comment-delete deletePostJs' title='{{deleteTitle}}'></span>{{/deleteReplyEnabled}}					</span>
				</span>
			</div>
			<div id="editTextDiv" class="editTextDiv" style="display:none;">
				<textarea  class="comment-edit-textbox editBox" title="Edit Reply">{{content}}</textarea>
				<input class="editPostJs" type="submit" value="Save" />
				<input class="closeEditPostJs" type="submit" value="Cancel" />
			</div>
		</div>
		{{/replies}}
	</div>
	{{/comments}}
</script>

<!-- Permissions Modal  -->
<div class="modal fade" id="permissionsModal" tabindex="-1"
	role="dialog" aria-labelledby="myModalLabel" data-backdrop="static">
	<div class="modal-dialog" role="document">
		<div class="modal-content">
			<div class="tabbable">
				<div class="modal-header">
					<button type="button" class="close" data-dismiss="modal"
						aria-label="Close">
						<span aria-hidden="true">&times;</span>
					</button>
					<h4 class="modal-title">
						Advanced Permissions
					</h4>
				</div>
				<div class="modal-body">
					<div class="inherited-message">
						All the users/groups shown have access to this file. This includes users with whom this file (or its parents) is shared and users (if any) added by advanced permissions option from its parents.
					</div>
					<div class="form-horizontal">
						<div class="form-group">
							<div class="col-lg-12">
								<div class="share-body">
									<div class="invite-people">
										<div class="row">
											<div class="col-lg-12">
												<div class="divForSelectize"  id="divForSelectize">
													<input type="text" class="contacts" id="selectedUsers" data-load-type="callback" placeholder='Add people' tabindex="2"/>
												</div>
												<div class="invite-button">
													<button type="button" class="vw-btn" id="js-add-user">
														Add
													</button>
												</div>
											</div>
										</div>
										<div class="row">
											<div class="col-md-12 col-lg-12">
												<table
													class="table table-condensed table-striped dt-responsive nowrap vw-data-table dataTable no-footer dtr-inline"
													id="propertiesPermissionTable">
												</table>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
					<div class="custom-message">
						Note: In order to give users access, the file/folder or its parent should be shared.
					</div>
				</div>
				<div class="modal-footer">
					<div class="inherited-message">
						Please use this button to stop inheriting settings from its parent and change them manually.
					</div>
					<button type="button" class="vw-btn vw-btn-default revertBtn" id="revertPermissions" data-dismiss="modal">
						Restore Inheritance
					</button>
					<button type="button" class="vw-btn vw-btn-default" id="cancelPermissions" data-dismiss="modal">
						Cancel
					</button>
					<button type="button" class="vw-btn vw-btn-primary disabled" id="updatePermissions" >
						Update
					</button>
					<button type="button" class="vw-btn vw-btn-primary overrideBtn" id="overridePermissions" >
						Stop Inheritance
					</button>
				</div>
			</div>
		</div>
	</div>
</div>

<script type="text/template" id="propertyDetailedTemplate">
	{{#propertyList}}
		<span class='custProp'>
		<dt>{{name}}</dt>

		<dd>
			<li class='values'>
			{{#values}}<span>{{.}}</span>{{/values}}
			</li>
			<li class='actions'>
				<span class='sprite-action-wrapper'>
					<span class='sprite icon-comment-edit editCustPropJs'></span>
					<span class='sprite icon-comment-delete deleteCustPropJs' title='Delete'></span>
				</span>
			</li>
		</dd>
	</span>
	{{/propertyList}}
</script>
<script type="text/template" id="editPropertyTemplate">
		<div class="vw-custprop-select">
			<select class='custPropSListJs'>
				<option value=''></option>
				{{#newPropList}}
					<option value='{{propertyName}}' data-default='{{defaultValue}}'>{{propertyName}}</option>
				{{/newPropList}}
			</select>
		</div>
		<div class='vw-custprop-values'>
			{{#values}}
				<div class="vw-custprop-value">
					<input type="text" class="custPropValueJs"  data-value='{{.}}' value='{{.}}'/><span class='sprite icon-content-delete deleteCustPropertyVal' title='Delete'></span>
				</div>
			{{/values}}
		</div>

</script>
<!-- Custom property Add and Edit Dialog holder -->
<div class="edit-custProp vw-hidden">

	<div class="edit-custProp-holder">
		<div class="edit-custProp-select-holder"></div>
		<div class="add-wrapper edit-custProp-add-value addMultipleValueJs"><span class="sprite icon-blue-plus"></span><a href="#" class="">Add More Values</a></div>
	</div>
</div>