<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<fmt:bundle basename="localization.BackupBrowseMessages">
	<fmt:message key="backupBrowse.label.ok" var="ok" />
	<fmt:message key="backupBrowse.label.cancel" var="cancel" />
	<fmt:message key="privacy.info.authorizeNeededForBrowseNote" var="authorizeNeededForBrowseNote" />
</fmt:bundle>
<c:set var="clientIdParam" value="${fn:escapeXml(param.clientId)}" />
<c:set var="isBrowse" value="${fn:escapeXml(param.isBrowse)}" />
<fmt:bundle basename="localization.ClientDetailsMessages">
	<fmt:message key="clientDetails.label.note" var="note" />
	<fmt:message key="clientlock.label.passKey" var="passKeyLabel" />
	<fmt:message key="clientlock.placeholder.passKey" var="passKeyPlaceholder" />
	<fmt:message key="clientlock.info.authorizeForRestore" var="authorizeInfoNote" />
	<fmt:message key="clientlock.info.authorizeInfoCustomNote" var="authorizeInfoCustomNote" />
	<fmt:message key="clientlock.error.passkeyEmpty" var="passkeyEmpty" />
	<fmt:message key="clientlock.error.invalidIntervalValue" var="invalidIntervalValue" />
</fmt:bundle>
<script nonce="${sessionScope.cspNonce}" >
var clientId = "${clientIdParam}";
var passkeyEmpty = "${passkeyEmpty}";
var invalidIntervalValue = "${invalidIntervalValue}";
var isBrowse = "${isBrowse}";
var showAuthForRestoreDuration = false;
function showThisError(msg)
{
	$("#authorizeErrDiv").html(msg);
	$("#authorizeErrDiv").show();
	$("#okButton").removeClass("loading");
}
function clearAllErrorMsgs()
{
	$("#okButton").removeClass("loading");
	$("#authorizeErrDiv").html("");
	$("#authorizeErrDiv").hide();
}
$("#passKey").keyup(function(event) {
	if (event.keyCode == 13) {
		submitThis();
	}
});
$("#okButton").on("click keydown",function(e){
	if (e.which == 13 || e.type == "click"){
		submitThis();
	}
});
function submitThis(){
	clearAllErrorMsgs();
 	var passKey = null;
 	browseMain.privacyChanged = false;
 	//validations
	if ($("#passKey")&&($.trim($("#passKey").val()))){
		passKey = cvUtil.toByteArray($.trim($("#passKey").val()));
	}else{
		showThisError(passkeyEmpty);
		return;
	}

	$("#okButton").addClass("loading");
	var authForRestoreInfo = {};
	authForRestoreInfo.passkey = passKey;
	var toTime = 30 * 60;//authorization for restore is 30 mins by default
	var intervalValue = 0;

	//if user is allowed to enter the interval value validate it
	if (showAuthForRestoreDuration){
		if ($("#intervalValue")&&($.trim($("#intervalValue").val()))){
			intervalValue = $.trim($("#intervalValue").val());
		}
		if ((!$.isNumeric(intervalValue)) || (intervalValue<= 0))
		{
			showThisError(invalidIntervalValue);
			return;
		}
		var intervalUnit = $("#intervalUnit").val();
		if (intervalUnit == "days"){
			toTime = intervalValue * 24 * 60 * 60;
		}else{ //hours
			toTime = intervalValue * 60 * 60;
		}
	}

	authForRestoreInfo.passkeySettings = {
		'enableAuthorizeForRestore' : true,
		'passkeyExpirationInterval' :  {
			'toTime' : toTime
		}
	};

	//make the api call
	var result = browseUtil.authorizeForRestore(clientId, authForRestoreInfo);
	if (result == "Success"){
		browseMain.privacyChanged = true;
		$("#okButton").removeClass("loading");
		cvUtil.closeModal();
	}else{
		showThisError(result);
		$("#okButton").removeClass("loading");
	}
};
$("#cancelButton").on("click keydown", function(e) {
	if (e.which == 13 || e.type == "click"){
		cvUtil.closeModal();
	}
});
$(document).ready(function() {
	$("#showAuthForRestoreDurationDiv").hide();

	//show the custom restore fields only if additional setting present (or we default it to 30 mins)
	if (cv && cv.additionalSettings && cv.additionalSettings.AdminConsole && cv.additionalSettings.AdminConsole.showAuthForRestoreDuration){
		showAuthForRestoreDuration = true;
		$("#showAuthForRestoreDurationDiv").show();
	}
	var noteLabel = showAuthForRestoreDuration ? "${authorizeInfoCustomNote}":"${authorizeInfoNote}" ;
	if (isBrowse == "true"){
		noteLabel = "${authorizeNeededForBrowseNote}";
	}

	$("#noteLabel").html(noteLabel);
});
</script>

<div id="authorizeErrDiv" class="vw-alert vw-message alert-danger vw-start-hidden margin-right-15"></div>
<div id="authorizeDiv" class="vw-form-horizontal margin-right-15">
	<div class="form-group">
		<div class="col-sm-12 control-label">
			<div class="vw-help-text"><small><span class="vw-underline">${note}</span>&nbsp;<span id="noteLabel"></span></small></div>
		</div>
	</div>
	<div class="form-group">
		<div class="col-sm-12 control-label">${passKeyLabel}</div>
		<div class=" col-sm-12">
			<input id="passKey" type="password" class="textbox form-control" autofocus placeholder="${passKeyPlaceholder}" tabindex="1"/>
		</div>
	</div>
	<fmt:bundle basename="localization.ClientDetailsMessages">
	<div id="showAuthForRestoreDurationDiv" class="form-group">
		<div class="col-sm-12 control-label"><fmt:message key="clientlock.label.authorizeFor"/></div>
		<div class="col-sm-8">
			<input id="intervalValue" type="number" maxlength="2" size="2" value="1" class="number form-control" tabindex="2"/>
		</div>
		<div class=" col-sm-4" >
			<select id="intervalUnits" class="form-control" tabindex="3">
				<option value="days"><fmt:message key="clientlock.label.days"/></option>
				<option value="hours"><fmt:message key="clientlock.label.hours"/></option>
			</select>
		</div>
	</div>
	</fmt:bundle>
</div>
<br/>
<div class="btns pull-right margin-right-15 margin-bottom-15">
				<a type="button" id="cancelButton" class="vw-btn vw-btn-default" tabindex="5">${cancel}</a>
				<a type="button" id="okButton" class="okSaveButton mainBtn vw-btn vw-btn-primary" tabindex="4"><span class="vw-btn-text">${ok}</span><svg xmlns="http://www.w3.org/2000/svg" width="23px" height="23px" viewBox="0 0 100 100" preserveAspectRatio="xMidYMid" class="uil-spin"><g transform="translate(50 50)"><g transform="rotate(0) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.44167 1.44167)"><animate attributeName="opacity" from="1" to="0.1" begin="0s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g><g transform="rotate(45) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.00167 1.00167)"><animate attributeName="opacity" from="1" to="0.1" begin="0.12s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0.12s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g><g transform="rotate(90) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.06667 1.06667)"><animate attributeName="opacity" from="1" to="0.1" begin="0.25s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0.25s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g><g transform="rotate(135) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.12667 1.12667)"><animate attributeName="opacity" from="1" to="0.1" begin="0.37s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0.37s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g><g transform="rotate(180) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.19167 1.19167)"><animate attributeName="opacity" from="1" to="0.1" begin="0.5s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0.5s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g><g transform="rotate(225) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.25167 1.25167)"><animate attributeName="opacity" from="1" to="0.1" begin="0.62s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0.62s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g><g transform="rotate(270) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.31667 1.31667)"><animate attributeName="opacity" from="1" to="0.1" begin="0.75s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0.75s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g><g transform="rotate(315) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.37667 1.37667)"><animate attributeName="opacity" from="1" to="0.1" begin="0.87s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0.87s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g></g></svg></a>
</div>