function addNewFile(currentInput, curFile, index) {
	fieldVals.push(cvUtil.createParamString("file" + index + "_" + currentInput.inputName + "_destPath",
			encodeURIComponent(getDestPathOfCurrInput(currentInput.inputName) + curFile.name)));
	fieldVals.push(cvUtil.createParamString("file" + index + "_" + currentInput.inputName + "_size", curFile.size));
	fieldVals.push(cvUtil.createParamString("file" + index + "_" + currentInput.inputName + "_fileName",
			encodeURIComponent(curFile.name)));
	fieldVals.push(cvUtil.createParamString(currentInput.inputName, "file" + index));
	uploadFileList.push(curFile);
}

function getFilePreventionStatus(e) {

	var containers = [ "fileType", "wfupload-draggable-area", "upload-selected-files", "upload-list" ];
	var $tagNames = [ "span", "h3" ];

	var enableOp = false;
	if ($tagNames.indexOf(e.target.tagName.toLowerCase()) != -1) {
		var $parent = $(e.target);
		jQuery.each(containers, function() {
			if ($parent.parents("." + this.trim()).length > 0) {
				enableOp = true;
				return false;
			}
		});
	} else {
		var $classList = e.target.classList;
		jQuery.each($classList, function() {
			$desiredClass = this.trim();
			if (containers.indexOf($desiredClass) != -1) {
				enableOp = true;
				return false;
			}
		});
	}
	return enableOp;
}

function addFilePreventListeners() {

	var $document = $(document.body);

	$document.off("dragover");
	$document.on("dragover", function(e) {
		e.stopPropagation();
		e.preventDefault();
		return getFilePreventionStatus(e);
	});

	$document.off("drop");
	$document.on("drop", function(e) {
		e.stopPropagation();
		e.preventDefault();
		return getFilePreventionStatus(e);
	});

}

function showCurrentInputFiles($container, inputName, currentInputFiles) {
	if (currentInputFiles.length > 0) {
		var noOfFiles = 0;
		var curRow = "";
		var fileInfoMap = wfInputEntryFileUploadMap[inputName];
		var inputJSON = {};
		inputJSON["inputName"] = inputName;
		var isDuplicateFile = false;
		jQuery.each(currentInputFiles, function(index) {
			var curFile = currentInputFiles[index];
			if (fileInfoMap[curFile.name] == undefined) {
				inputJSON["fileName"] = curFile.name;
				fileInfoMap[curFile.name] = curFile;
				curRow = getHtml(inputJSON, templateClass[SELECTED_FILEROW_TEMPLATE]);
				$container.prepend(curRow);
				noOfFiles++;
			} else {
				isDuplicateFile = true;
			}
		});

		if (isDuplicateFile) {
			var errorMsg = parent.wf_localMsg.duplicateFileWarningMsg;
			showError(errorMsg);
		}

		resizeForm();

		wfInputEntryFileUploadMap[inputName] = fileInfoMap;

		var $fileCount = $container.parents(".upload-selected-files").find(".upload-num-files");
		var totalCount = parseInt($fileCount.html()) + noOfFiles;
		$fileCount.html(totalCount);

		$(".upload-list-item").off("click");
		$(".upload-list-item").on("click", function(e) {
			e.preventDefault();
			var isDeletionAllowed = $(e.target).attr("data-cross");
			if (isDeletionAllowed != undefined && isDeletionAllowed == "true") {
				var curInputName = $(this).attr("data-inputName");
				var fileName = $(this).attr("data-fileName");
				delete wfInputEntryFileUploadMap[curInputName][fileName];
				var $fileNum = $(this).parents(".upload-selected-files").find(".upload-num-files");
				$(this).remove();
				var curFileCount = parseInt($.trim($fileNum.html())) - 1;

				var isMultiple = $("#" + curInputName + "DragArea").attr("data-multiple");
				if (isMultiple == "false") {
					addFileListeners(curInputName);
				}

				if (curFileCount == 0) {
					$("#" + curInputName).val("");
					$("#" + curInputName + "WidgetArea").show();
					$("#" + curInputName + "selectedFilesArea").hide();
					resizeForm();
				}
				$fileNum.html(curFileCount);
			}
		});
	}
	$(".clearFiles").off("click");
	$(".clearFiles").on("click", function(e) {
		e.preventDefault();
		var curInputName = $(this).attr("data-inputName");
		var $selectedFilesArea = $(this).parents(".upload-selected-files");
		var $fileNum = $selectedFilesArea.find(".upload-num-files");
		delete wfInputEntryFileUploadMap[curInputName];

		var isMultiple = $("#" + curInputName + "DragArea").attr("data-multiple");
		if (isMultiple == "false") {
			addFileListeners(curInputName);
		}

		$("#" + curInputName).val("");
		$selectedFilesArea.find(".upload-list").empty();
		$fileNum.html(0);
		$("#" + curInputName + "WidgetArea").show();
		$("#" + curInputName + "selectedFilesArea").hide();
		resizeForm();
	});

}

function showErrorIfAlreadyHavingFile($fileNum, curSelectedFiles, inputName, displaName) {
	if ((parseInt($.trim($fileNum.html())) + curSelectedFiles) > 1) {
		var errorMessage = parent.wf_localMsg.multipleFileUploadError + " " + displaName;
		showError(errorMessage);
		return true;
	}
	return false;
}

function switchOffDragDropListeners(desiredInputId) {
	$(desiredInputId).off('dragenter');
	$(desiredInputId).off('dragover');
	$(desiredInputId).off('dragleave');
	$(desiredInputId).off('drop');

}

function initializeCurInputFileControlState(inputObj, isInitial) {

	var isMultiple = inputObj.isMultiple;
	var fileCount = inputObj.fileCount;
	var inputName = inputObj.inputName;
	var $fileNum = inputObj.fileNum;
	var displayName = inputObj.displayName;
	var selectedFilesArea = inputObj.selectedFilesArea;

	if (isMultiple == "false") {
		if (showErrorIfAlreadyHavingFile($fileNum, fileCount, inputName, displayName)) {
			return false;
		} else {
			$("#" + inputName + "WidgetArea").css("display", "none");
			//switchOffDragDropListeners(desiredInputId);
		}
	}

	$(selectedFilesArea).show();

	return true;
}

function addFileListeners(inputName) {
	var desiredInputId = "#" + inputName + "DragArea";
	var selectedFilesArea = "#" + inputName + "selectedFilesArea";
	var $fileNum = $(selectedFilesArea).find(".upload-num-files");
	var displayName = $(desiredInputId).attr("data-displayName");

	//var $dragArea = $(desiredInputId).find(".wfupload-draggable-area");

	$("#" + inputName + "FilePicker").off("click." + APP_NAMESPACE);
	$("#" + inputName + "FilePicker").on("click." + APP_NAMESPACE, function(e) {
		e.preventDefault();
		$("#" + inputName).click();
	});

	$("#" + inputName).off("change." + APP_NAMESPACE);
	$("#" + inputName).on("change." + APP_NAMESPACE, function(e) {
		e.preventDefault();
		var elementFiles = e.target.files;

		var inputObj = {};
		inputObj.isMultiple = $(desiredInputId).attr("data-multiple");
		inputObj.fileCount = elementFiles.length;
		inputObj.inputName = inputName;
		inputObj.fileNum = $fileNum;
		inputObj.displayName = displayName;
		inputObj.selectedFilesArea = selectedFilesArea;

		if (!initializeCurInputFileControlState(inputObj)) {
			$(this).val("");
			return;
		}

		$(".error").hide();
		//$dragArea.hide();
		$(desiredInputId).removeClass("active");
		if (wfInputEntryFileUploadMap[inputName] == undefined) {
			wfInputEntryFileUploadMap[inputName] = {};
		}
		showCurrentInputFiles($("#" + inputName + "selectedFilesArea .upload-list"), inputName, elementFiles);
		return true;
	});

	$(desiredInputId).off('dragenter.' + APP_NAMESPACE);
	$(desiredInputId).on('dragenter.' + APP_NAMESPACE, function(e) {
		e.stopPropagation();
		e.preventDefault();
		$(this).addClass("active");
	});

	$(desiredInputId).off('dragover.' + APP_NAMESPACE);
	$(desiredInputId).on('dragover.' + APP_NAMESPACE, function(e) {
		e.stopPropagation();
		e.preventDefault();
		$(this).addClass("active");
	});

	$(desiredInputId).off('dragleave.' + APP_NAMESPACE);
	$(desiredInputId).on('dragleave.' + APP_NAMESPACE, function(e) {
		e.preventDefault();
		$(this).removeClass("active");
	});

	$(desiredInputId).off('drop.' + APP_NAMESPACE);
	$(desiredInputId).on('drop.' + APP_NAMESPACE, function(e) {
		e.preventDefault();
		var elementFiles = e.originalEvent.dataTransfer.files;

		var inputObj = {};
		inputObj.isMultiple = $(this).attr("data-multiple");
		inputObj.fileCount = elementFiles.length;
		inputObj.inputName = inputName;
		inputObj.fileNum = $fileNum;
		inputObj.displayName = displayName;
		inputObj.selectedFilesArea = selectedFilesArea;

		if (!initializeCurInputFileControlState(inputObj)) {
			$(this).removeClass("active");
			return;
		}
		//$dragArea.hide();
		$(this).removeClass("active");
		resizeForm();

		$(".error").hide();
		if (wfInputEntryFileUploadMap[inputName] == undefined) {
			wfInputEntryFileUploadMap[inputName] = {};
		}
		showCurrentInputFiles($("#" + inputName + "selectedFilesArea .upload-list"), inputName, elementFiles);
	});
}
