var currentPagedInput;

function isIE() {
	  var userAgent = navigator.userAgent;
	  return userAgent.indexOf("MSIE ") > -1 || userAgent.indexOf("Trident/") > -1 || userAgent.indexOf("Edge/") > -1;
}

//var parentWindow = cvUtil.getTopWindow().parent;
var wfUtils = undefined;

if(isIE()){
	//var parent = $.extend(true,{},window.top);
	wfUtils = window.top.wfUtils;
}
else
{
	wfUtils = parent.wfUtils;	
//var parent = $.extend(true,{},parentWindow);
}

parent.userInteractionResp = parent.Forms.getUserInteractionResp();
parent.currentResp = parent.Forms.getCurrentResp();
var paginationURL = parent.wfUtils.constants.START_FORMS_URL;
var interactiveParams = {};
var PageControl = {
	FIRST : "FIRST",
	NEXT : "NEXT",
	PREVIOUS : "PREVIOUS",
	LAST : "LAST",
	SELECTION : "SELECTION",
	SEARCH : "SEARCH"
};
var INPUT_PAGE = 5;
var currentPagedInputName;
var localMap = {};
var isListType = false;
var searchableResp = undefined;
var showSelectedListMode = "false";

parent.clearUserInteractionParams = function() {
	var interactionParams = $.extend(true, {}, parent.userInteractionResp);
	interactionParams = interactionParams.request;
	interactionParams.inputForm = "";
	interactionParams.description = "";
	interactionParams.title = "";
	interactionParams.completedForm = "";
	return interactionParams;
}

parent.clearPopUpResponseParams = function() {
	var interactionParam = $.extend(true, {}, parent.currentResp);
	interactionParam.response.subject = "";
	interactionParam.response.description = "";
	interactionParam.response.inputForm = "";
	return interactionParam;
}

function getData() {
	return searchableResp;
}

function getResults(pageAction, pageVal) {
	var params = [];
	params.push(cvUtil.createParamString("interactionParams", JSON.stringify(interactiveParams)));
	params.push(cvUtil.createParamString("inputEntry", currentPagedInput));
	params.push(cvUtil.createParamString("pageControl", pageAction));
	params.push(cvUtil.createParamString("searchTerm", $("#SearchresultSearch").val()));
	params.push(cvUtil.createParamString("pageVal", $(".customPagInput").val()));

	var inputParams = cvUtil.createParamsString(params);

	cvUtil.loadPage(paginationURL, inputParams, function(data) {
		if (data != undefined && data.response.input != undefined) {
			currentPagedInput = $.extend({}, true, data.response.input);

			if (currentPagedInput.totalPages == 0) {
				$("#Searchresult .secrows").html('<div class="noResults">No results found</div>');
				$(".customPagInput").val(0);
				$(".totalPageCount").html(0);
				$(".prev").addClass("statusDisabled");
				$(".next").addClass("statusDisabled");
			} else {
				if (currentPagedInput.currentPage == 1) {
					$(".prev").addClass("statusDisabled");
				} else {
					$(".prev").removeClass("statusDisabled");
				}

				if (currentPagedInput.currentPage == currentPagedInput.totalPages) {
					$(".next").addClass("statusDisabled");
				} else {
					$(".next").removeClass("statusDisabled");
				}
				$(".customPagInput").val(currentPagedInput.currentPage);
				$(".totalPageCount").html("/ " + currentPagedInput.totalPages);
				isListType = currentPagedInput.listType;
				displayResults(currentPagedInput.options);
			}
			currentPagedInput.options = undefined;
			currentPagedInput.alignment = undefined;
			currentPagedInput.controlType = 2;
			currentPagedInput.documentation = "";
			currentPagedInput = JSON.stringify(currentPagedInput);
		}
	});
}

function applyAlreadySelectedList(list) {
	jQuery.each(list,
			function() {
				var currenKeyword = this;
				var desiredCheckBoxID = $("#searchList .secrows").find("[value='" +
						escapeSpecialSymbols(currenKeyword) + "']");
				if (desiredCheckBoxID.length != 0) {
					desiredCheckBoxID.attr('checked', true);
				}
			});
}

function escapeSpecialSymbols(currentKey) {
	currentKey = currentKey.replace(/\./g, "\\.");
	currentKey = currentKey.replace(/:/g, "\\:");
	currentKey = currentKey.replace(/::/g, "\\::");
	currentKey = currentKey.replace(/,/g, "\\,");

	currentKey = currentKey.replace(/!/g, "\\!");
	currentKey = currentKey.replace(/@/g, "\\@");
	currentKey = currentKey.replace(/#/g, "\\#");
	currentKey = currentKey.replace(/\$/g, "\\$");
	currentKey = currentKey.replace(/%/g, "\\%");
	currentKey = currentKey.replace(/\^/g, "\\^");
	currentKey = currentKey.replace(/&/g, "\\&");
	currentKey = currentKey.replace(/\*/g, "\\*");
	currentKey = currentKey.replace(/\(/g, "\\(");
	currentKey = currentKey.replace(/\)/g, "\\)");
	currentKey = currentKey.replace(/\"/g, '\\"');
	currentKey = currentKey.replace(/\+/g, "\\+");
	// currentKey = currentKey.replace(/\//g,"\\");
	currentKey = currentKey.replace(/~/g, "\\~");
	currentKey = currentKey.replace(/`/g, "\\`");
	currentKey = currentKey.replace(/</g, "\\<");
	currentKey = currentKey.replace(/>/g, "\\>");
	currentKey = currentKey.replace(/\?/g, "\\?");
	currentKey = currentKey.replace(/\[/g, "\\[");
	currentKey = currentKey.replace(/]/g, "\\]");
	currentKey = currentKey.replace(/{/g, "\\{");
	currentKey = currentKey.replace(/}/g, "\\}");
	//currentKey = currentKey.replace(/\\/g,"\\");
	currentKey = currentKey.replace(/'/g, "\\'");
	currentKey = currentKey.replace(/;/g, "\\;");
	currentKey = currentKey.replace(/\|/g, "\\|");

	return currentKey;
}

function displayResults(options) {
	var container = $("#Searchresult .secrows");
	container.empty();
	var baseHTML = '<li class="li1" style="list-style: none;"><label><input type="checkbox"';

	if (showSelectedListMode == "true") {
		baseHTML += ' checked="checked"';
	}

	baseHTML += 'name="" value="';

	jQuery(options).each(function(index) {
		var curOption = this.trim().replace(/\"/g, "&quot;");
		container.append(baseHTML + curOption + '" title="' + curOption + '"/><span class="itemname">' + curOption +
				'</span>');
	});
	applyAlreadySelectedList(parent.searchableEntryMap[currentPagedInputName]["tempList"]);
	$('#searchList input[type="checkbox"]').off("change");
	$('#searchList input[type="checkbox"]').on("change",
			function() {

				if ($(this).prop('checked')) {
					var selectedCheckBox = $(this);
					if (!isListType) {
						$('#searchList input[type="checkbox"]').attr("checked", false);
						parent.searchableEntryMap[currentPagedInputName]["unSelectedList"] = [];
						parent.searchableEntryMap[currentPagedInputName]["unSelectedList"] = $.extend([],
								parent.searchableEntryMap[currentPagedInputName]["tempList"]);
						parent.searchableEntryMap[currentPagedInputName]["tempList"] = [];
						parent.searchableEntryMap[currentPagedInputName]["tempList"].push($(this).val());
						selectedCheckBox.attr("checked", true);
					} else {
						parent.searchableEntryMap[currentPagedInputName]["tempList"].push($(this).val());
					}
				} else {
					var desiredIndex = parent.searchableEntryMap[currentPagedInputName]["tempList"].indexOf($(this)
							.val());
					if (desiredIndex != -1) {
						parent.searchableEntryMap[currentPagedInputName]["unSelectedList"].push($(this).val());
						parent.searchableEntryMap[currentPagedInputName]["tempList"].splice(desiredIndex, 1);
					}
				}
			});
}

function initPagination(options) {
	displayResults(options);
	$(".prev").off("click");
	$(".prev").on("click", function(e) {
		e.preventDefault();
		getResults(PageControl.PREVIOUS);
	});

	$(".next").off("click");
	$(".next").on("click", function(e) {
		e.preventDefault();
		getResults(PageControl.NEXT);
	});

	$("#okButton").off("click");
	$("#okButton").on("click", function(e) {
		e.preventDefault();
		searchableResp = "";
		cvUtil.closeModal();
		return searchableResp;
	});

	$(".customPagInput").off("keydown");
	$(".customPagInput").on("keydown", function(e) {
		if (e.keyCode == 13 && !e.shiftKey) {
			e.preventDefault();
			getResults(PageControl.SELECTION, $(this).val());
		}
	});

	$("#SearchresultSearch").off("keydown");
	$("#SearchresultSearch").on("keydown", function(e) {
		if (e.keyCode == 13 && !e.shiftKey) {
			e.preventDefault();
			getResults(PageControl.SEARCH);
		}
	});

	$(".icon-search").off("click");
	$(".icon-search").on("click", function(e) {
		e.preventDefault();
		getResults(PageControl.SEARCH);
	});

}

$(document)
		.ready(function() {
			currentPagedInputName = cvUtil.getParameterByName("currentInput", null, undefined, false, true);
			showSelectedListMode = cvUtil.getParameterByName("showSelectedList", null, undefined, false, true);
			var options;

			if (showSelectedListMode == "true") {
				options = parent.searchableEntryMap[currentPagedInputName]["tempList"];
				$(".next").addClass("statusDisabled");
				$("#headerArea").css("display", "none");
			} else {
				var curInteraction = (parent.userInteractionResp != undefined &&
						parent.userInteractionResp.request != undefined && parent.userInteractionResp.request != "") ? parent.userInteractionResp.request.interactionId
						: undefined;
				if (curInteraction != undefined && curInteraction != "") {
					var interactiveRsp = parent.clearUserInteractionParams();
					interactiveParams["response"] = interactiveRsp;
				} else {
					interactiveParams = parent.clearPopUpResponseParams();
				}

				currentPagedInput = $.extend({}, true, parent.searchableEntryMap[currentPagedInputName]);
				currentPagedInput.documentation = "";
				isListType = currentPagedInput.listType;
				options = currentPagedInput.options;
				interactiveParams.respType = INPUT_PAGE;
				var totalPages = currentPagedInput.totalPages;
				currentPagedInput.controlType = 2;
				currentPagedInput.options = undefined;
				currentPagedInput.alignment = undefined;
				currentPagedInput = JSON.stringify(currentPagedInput);
				if (totalPages <= 1) {
					$(".next").addClass("statusDisabled");
				}
				$(".customPagInput").val("1");
				$(".totalPageCount").html("/ " + totalPages);
			}
			$(".prev").addClass("statusDisabled");
			initPagination(options);
		});