<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>  
<fmt:bundle basename="localization.formsMessages">
<fmt:message key="Workflow_Success" var="successfulWorkflow" />
<fmt:message key="Action_Success" var="successfulAction" />
<fmt:message key="Invalid_Workflow" var="invalidWorkflow" />
<fmt:message key="Workflow" var="pageTitle" />
<fmt:message key="Actions" var="actionsTitle" />
<fmt:message key="No_Pending_Label" var="noPendingActions" />
<fmt:message key="No_Completed_Label" var="noCompletedActions" />
<fmt:message key="No_ReDeployed_Workflows" var="noRedeployedForms" />
<fmt:message key="Invalid_Interaction" var="invalidInteraction" />
<fmt:message key="Unauthorized_Action" var="unauthorizedAction" />
<fmt:message key="Already_Completed_Interaction" var="completedAction" />
<fmt:message key="Already_Killed_Interaction" var="killedAction" />
<fmt:message key="Form_Error_Message" var="formErrorMsg" />
<fmt:message key="POPUP_INPUT_RESP_TITLE" var="popUpInputRespTitle" />
<fmt:message key="INFO_RESP_TITLE" var="infoRespTitle" />
<fmt:message key="Date_Label" var="dateLabel" />
<fmt:message key="Invalid_Date_Format_Label" var="invalidDateFormat" />
<fmt:message key="Invalid_Time_Format_Label" var="invalidTimeFormat" />
<fmt:message key="Empty_Date_Label" var="emptyDateMsg" />
<fmt:message key="Empty_Time_Label" var="emptyTimeMsg" />
<fmt:message key="Required_Value_Label" var="requiredValMsg" />
<fmt:message key="Required_File_Label" var="requiredFileMsg" />
<fmt:message key="Duplicate_File_Warning" var="duplicateFileWarningMsg" />
<fmt:message key="Multiple_File_Upload_Error" var="multipleFileUploadError" />
<fmt:message key="Start_Form_TimeOut_Warning" var="startFormTimeoutWarning" />
<fmt:message key="Workflow_File_Upload_Error" var="wfFileUploadError" />
<fmt:message key="Searchable_Results_Title" var="searchableResultsTitle" />
<fmt:message key="Searchable_Selected_Options_Title" var="searchableSelectedOptionsTitle" />
<fmt:message key="Searchable_Items_Selected_Label" var="searchableItemsselectedLbl" />
<fmt:message key="Submit_Request_Label" var="submitReqLbl" />
<c:set var="userGUID" value="<%=session.getId()%>"></c:set>
<c:set var="workflowReqTimeout" value="${cvConfig.workflowRequestTimeout}"></c:set>
<c:set var="useNewForms" value="${cvConfig.isUseV2Forms()}"></c:set>

<fmt:message key="OK_Label" var="okButtonLbl"></fmt:message>
<fmt:message key="Next_Btn_Label" var="nextButtonLbl"></fmt:message>
<fmt:message key="Back_Btn_Label" var="backButtonLbl"></fmt:message>

<c:if test="${param.pageTitle != null && param.pageTitle != ''}">
	<c:set var="pageTitle" value="${param.pageTitle}"/>
</c:if>

<c:set var="wfMobileView" value='<%= request.getParameter("mobileView") %>'/>

<c:if test="${param.isMobileView != null && param.isMobileView == true}">
	<c:set var="wfMobileView" value="true"/>
</c:if>

<c:if test="${wfMobileView != '' && wfMobileView == true}">
	<c:set value="dialog" var="hideHeader"/>
</c:if>
 
<jsp:include page="../common/header.jsp">
	<jsp:param value="${pageTitle}" name="titleLocalized" />
	<jsp:param value="../applications/css/applicationstyles.css" name="css" />
	<jsp:param value="${pageContext.request.contextPath}/forms/css/common.css" name="css" />
	<jsp:param value="${pageContext.request.contextPath}/forms/css/workflowstyles.css" name="css" />
	<jsp:param value="true" name="includeHistory" />
	<jsp:param value="true" name="includeJqueryUI" />
	<jsp:param value="true" name="includeMask" />
	<jsp:param value="true" name="bootstrapped"/>
	<jsp:param value="${hideHeader}" name="displayMode"/> 
</jsp:include>

<input id="reqFromOutsideForms" type="hidden" value='${requestScope.reqFromOutsideForms}'/>
<input id="successUrl" type="hidden" value='${requestScope.onSuccessURL}'/>
<input id="failureUrl" type="hidden" value='${requestScope.onFailureURL}'/>
<input id="backUrl" type="hidden" value='${requestScope.backURL}'/>

<c:if test="${wfMobileView != '' && wfMobileView == true}">
	<meta name="viewport" content="initial-scale=1.0, maximum-scale=1.0"/>
</c:if>
	<div id="wfFormsPopup" data-backdrop="static" data-keyboard="false" class="modal fade hideOnExportFriendly vw-hidden-export" tabindex="-1" role="dialog">
	 <div class="modal-dialog" role="document">
	    <div class="modal-content">
		<div class="modal-header">
			<button type="button" class="close" data-dismiss="modal">x</button>
				<h4 style="margin-top:0px;margin-bottom:0px"></h4>
		</div>
		<div class="modal-body" id="inputFormArea">
	        <div class="center"><img src="${pageContext.request.contextPath}/common/img/loader.gif"/></div>
		</div>
		<div class="modal-footer" id="wfModalFooter">
<!-- 	        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
	        <button type="button" class="btn btn-primary">Save changes</button> -->
		</div>
		</div>
		</div>
	</div>
 
	<div id="wfSearchablePopUp"  data-backdrop="static"  data-keyboard="false"  class="modal fade hideOnExportFriendly vw-hidden-export" tabindex="-3" data-focus-on="input:first">
		 <div class="modal-dialog" role="document" style="left:0px;top: 7%;">
	    <div class="modal-content" style="max-width: 506px;">
  <div class="modal-header">
    <button type="button" class="close" data-dismiss="modal">x</button>
    <h4 style="margin-top:0px;margin-bottom:0px"></h4>
  </div>
  <div class="modal-body" style="height: auto;padding-bottom:0px;/* overflow-y: auto; */">
  <div class="checkboxes">
  </div>
  </div>
  <div class="modal-footer">
    <button type="button" data-dismiss="modal" class="btn">Close</button>
    <button id="searchableOkButton" type="button" class="btn btn-primary">OK</button>
  </div>
  </div>
  </div>
</div>

	<div id="wfWarningMessageDialog"  data-backdrop="static"  data-keyboard="false"  class="modal fade" tabindex="-3" data-focus-on="input:first"  role="dialog">
		 <div class="modal-dialog" role="document" style="left:0%;top: 10%;">
	    <div class="modal-content" style="max-width: 506px;">
  <div class="modal-header">
    <button type="button" class="close" data-dismiss="modal">x</button>
    <h4 style="margin-top:0px;margin-bottom:0px"></h4>
  </div>
  <div class="modal-body" style="max-height: 350px;overflow-y: auto;">
  </div>
  <div class="modal-footer">
    <button id="warningMsgNoBtn" type="button" class="btn">No</button>
    <button id="warningMsgYesBtn" type="button" class="btn btn-primary">Yes</button>
  </div>
  </div>
  </div>
</div>


<div class="wfTemplate" style="display:none">
<ul>
<li>
<span class="sprite app-workflow-gray"></span>
<label class="showBackups"></label>
<div class="displayText">

		<a data-target="#wfFormsPopup" data-toggle="modal" clientId="{{clientId}}" clientName="{{clientName}}" name="{{workflowName}}" id="{{workflowId}}" href="{{target}}" class="run" title="{{workflowName}}" data-useV1Forms="{{useV1Forms}}">{{workflowName}}</a>
<span class="ellip">...</span><p class="disp">{{description}}</p></div>
</li>
</ul>
</div>
 
 <c:if test="${wfMobileView != '' && wfMobileView != true}">
 
<div id="tabs">
  <ul>
    <li><a id="tab1" href="#formsTabs">${pageTitle}</a></li>
    <li><a id="tab2" href="#actionTabs">${actionsTitle}</a>
    	<div class="activeActionsCount"></div>
	</li>
	<div id="wFsearchBox" class="">
			    <span id="wFsearchBoxImg" class="wFfilterSearch"></span>
				<input type="text" placeholder="Search" id="wFreportFilterSearch" autofocus>
	</div>
  </ul>

  <div id="formsTabs">
	<div class="laptopList">
	<div class="sub-section"></div>
	<div class="cvApps">
	<div class="secureGroups">
	<ul class="apps licenseApps">
	<div class="center wfFormsLoader"><img src="../common/img/loader.gif"/></div>
	</ul>
	</div>
	</div>
	</div>
  </div>

  <div id="actionTabs">
    <div class="laptopList">
<%--    	 <a href="#" id="open" class="active"><fmt:message key="Open_Label" /></a>
  	 <a href="#" id="completed" class=""><fmt:message key="Close_Label" /></a> --%>
      <div class="openActions">
      	<div class="center wfActionsLoader"><img src="../common/img/loader.gif"/></div>
          <jsp:include page="actions.jsp"/>      
<%-- 	<thead>
		<tr class="secrowhead secrows"> 
				<th><fmt:message key="Subject_Col_Title" /></th> 
				<th><fmt:message key="Submitted_Col_Title" /></th>
		</tr>
	</thead> 
	<tbody id="openActionsTableBody"/> --%>
    </div>
    </div>
  </div>
</div>
</c:if>

<c:if test="${param.isPreviewPage != null && param.isPreviewPage == 'true'}">
<div id="tabs">
  <div id="actionTabs">

          <jsp:include page="actions.jsp"/>      
		  </div>
		  </div>
</c:if>

<div id="dialog" class="wfBottomArea">
<p class="alert"></p>
<a class="okSaveButton" id="warning" href="#" style="margin: 10px 118px 10px 0 "><fmt:bundle basename="localization.messages"><fmt:message key="common.action.ok" /></fmt:bundle></a>
</div>

		<jsp:include page="reactFormIndex.jsp">
			<jsp:param value="false" name="includeBootstrapLib" />
			<jsp:param value="true" name="includeFormsJS" />
			<jsp:param value="${wfMobileView}" name="mobileView"/>
		</jsp:include>

	<c:choose>
		<c:when test="${param.isPreviewPage != null && param.isPreviewPage == 'true'}">
			<jsp:include page="../common/footer.jsp">
				<jsp:param value="../common/js/jquery.corner.js" name="js" />
				<jsp:param value="../common/js/mustache.js" name="js" />
			    <jsp:param value="${pageContext.request.contextPath}/forms/preview/js/main.js" name="js"/>
			   	<jsp:param value="true" name="bootstrapped"/>
			</jsp:include>  
		</c:when>
		<c:otherwise>
		<jsp:include page="../common/footer.jsp">
			<jsp:param value="../common/js/jquery.corner.js" name="js" />
			<jsp:param value="../common/js/mustache.js" name="js" />
		    <jsp:param value="js/reactMain.js" name="js"/>
		   	<jsp:param value="true" name="bootstrapped"/>
		</jsp:include>
		</c:otherwise>
	</c:choose>

</fmt:bundle>

<script nonce="${sessionScope.cspNonce}" >
	var wf_localMsg = wf_localMsg || {}; 
	wf_localMsg.formsTab = "${pageTitle}";
	wf_localMsg.actionsTab = "${actionsTitle}";
	wf_localMsg.successfulWorkflow = "${successfulWorkflow}";
	wf_localMsg.successfulAction = "${successfulAction}";
	wf_localMsg.invalidWorkflow = "${invalidWorkflow}";
	wf_localMsg.noPendingActions = "${noPendingActions}";
	wf_localMsg.noCompletedActions = "${noCompletedActions}";
	wf_localMsg.noRedeployedForms = "${noRedeployedForms}";
	wf_localMsg.invalidInteraction = "${invalidInteraction}";
	wf_localMsg.unauthorizedAction = "${unauthorizedAction}";
	wf_localMsg.completedAction = "${completedAction}";
	wf_localMsg.killedAction = "${killedAction}";
	wf_localMsg.formError="${formErrorMsg}";
	wf_localMsg.popUpInputRespTitle="${popUpInputRespTitle}";
	wf_localMsg.infoRespTitle="${infoRespTitle}";
	wf_localMsg.dateLabel="${dateLabel}";
	wf_localMsg.invalidDateFormat="${invalidDateFormat}";
	wf_localMsg.invalidTimeFormat="${invalidTimeFormat}";
	wf_localMsg.emptyDateMsg="${emptyDateMsg}";
	wf_localMsg.emptyTimeMsg="${emptyTimeMsg}";
	wf_localMsg.requiredValMsg="${requiredValMsg}";
	wf_localMsg.requiredFileMsg="${requiredFileMsg}";
	wf_localMsg.duplicateFileWarningMsg="${duplicateFileWarningMsg}";
	wf_localMsg.multipleFileUploadError="${multipleFileUploadError}";
	wf_localMsg.startFormTimeoutWarning = "${startFormTimeoutWarning}";
	wf_localMsg.wfFileUploadError = "${wfFileUploadError}";
	wf_localMsg.searchableResultsTitle = "${searchableResultsTitle}";
	wf_localMsg.searchableSelectedOptionsTitle = "${searchableSelectedOptionsTitle}";
	wf_localMsg.searchableItemsselectedLbl = "${searchableItemsselectedLbl}";
	wf_localMsg.submitReqLbl = "${submitReqLbl}";
	wf_localMsg.okButtonLbl = "${okButtonLbl}";
	wf_localMsg.nextButtonLbl="${nextButtonLbl}";
	wf_localMsg.backButtonLbl="${backButtonLbl}";
 
	var userGUID = "${userGUID}";
	var wfReqTimeOut = (parseInt("${workflowReqTimeout}") * 60 * 1000) + ( 60 * 1000); 
 
</script>