<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<fmt:bundle basename="localization.EventMessages">
<div class='question-{{questionInfo.questionid}} question-panel' data-id='{{questionInfo.questionid}}'>
    <div class="row noMarginLftRght">
        <div id="edit-question{{questionInfo.questionid}}" ng-show='isEditQuestion' class="question-edit-sidebar col-xs-4 col-sm-4 col-md-4 col-lg-4">
            <form action="" method="POST" class="form-horizontal" role="form" name="editform">
                <div class="edit-question-header">
                    <div class="form-group">
                        <input type="text" name="title" id="questionTitle{{questionInfo.questionid}}" class="form-control floating-label question-title" value=" " title="" ng-model='questionInfo.questionTitle' placeholder='<fmt:message key="QuestionTitle"/>' />
                    </div>
                    <div class="form-group">                        
                        <textarea name="" id="questionDesc{{questionInfo.questionid}}" value="{{questionInfo.shortdesc}}" ng-model='questionInfo.shortdesc' class="form-control floating-label" rows="1" placeholder='<fmt:message key="QuestionDescription"/>'></textarea>
                    </div>
                    <div class="togglebutton requiredbutton">
                        <label>
                            <input type="checkbox" ng-click='questionInfo.isRequired=!questionInfo.isRequired'  ng-checked="questionInfo.isRequired"> <fmt:message key="Mandatory"/>
                        </label>
                    </div>
                </div>
                <div class="edit-question-footer">
                    <div class="form-group label-floating" ng-repeat='qoption in questionInfo.options'>
                        <div class="input-group">
                            <input type="text" name="" id="question{{questionInfo.questionid}}Option{{$index}}" class="form-control floating-label col-xs-8 col-sm-8 col-md-8 col-lg-8" value=" " title="" placeholder='<fmt:message key="Option"/> {{$index+1}}' ng-model='qoption.optionTitle'>
                            <span class="input-group-btn">
                                <a class="mdi-content-add-circle sur-ico" ng-click="questionInfo.options.splice($index+1,0,{optionTitle: '',questionOptionType: questionInfo.optionsType,optionValue: '',showUrlInput : false,showFileInput : qoption.showFileInput, isDefault : false})"  title='<fmt:message key="Add"/>'></a>
                                <a class="mdi-content-remove-circle sur-ico" ng-click='questionInfo.options.splice($index,1)' ng-class='{"disabled":questionInfo.options.length==1}'  title='<fmt:message key="Remove"/>'></a>
                            </span>
                        </div>
                    </div>
                </div>
            </form>
        </div>
        <div class='panel' ng-class="{'question-edit-panel col-xs-8 col-sm-8 col-md-8 col-lg-8' : questioneditpanel}" ng-show='!ishideeverything || isEditQuestion'>
            <div class='panel-heading question-title' ng-click="editQuestion($event)">
                <div class="row">
                    <div class="col-xs-8 col-sm-8 col-md-9 col-lg-10">
                        <h4>{{questionInfo.questionno}}. {{questionInfo.questionTitle}}<span ng-show='questionInfo.isRequired' style='color:red;'> *</span></h4>
                        <small><div class='question-shortdesc'> {{questionInfo.shortdesc}} </div></small>
                    </div>
                    <div class="col-xs-4 col-sm-4 col-md-3 col-lg-2 question-panel-icons" ng-hide='ishideeverything'>
                        <!-- <a class='mdi-content-add-circle sur-panel-ico sur-ico' /> -->
                        <a class='mdi-content-create sur-panel-ico sur-ico' ng-click='showEditQuestion()' title='<fmt:message key="Edit"/>'/>
                        <a class='mdi-action-delete sur-panel-ico sur-ico' ng-click='questionDeleteInsideScope()' title='<fmt:message key="Delete"/>'/>
                        <a class='mdi-action-open-with sur-panel-ico sur-ico move-handle' title='<fmt:message key="Move"/>'/>
                        <a class='sur-panel-ico sur-ico' ng-click='showQuestionBody=!showQuestionBody' ng-class='{"mdi-hardware-keyboard-arrow-down" : !showQuestionBody, "mdi-hardware-keyboard-arrow-up" : showQuestionBody}' ng-attr-title="{{!showQuestionBody?'<fmt:message key="Expand"/>':'<fmt:message key="Collapse"/>'}}" />
                    </div>
                </div>
            </div>
            <div class='panel-body' ng-show='showQuestionBody'>
                <div class="form-group">
                    <select class='question{{questionInfo.questionid}}-options form-control' ng-click="toggleDefault()">
                        <option class="question-{{questionInfo.questionid}}-options" value="{{qoption.optionTitle}}" ng-repeat='qoption in questionInfo.options' ng-selected="qoption.isDefault">{{qoption.optionTitle}}</option>
                    </select>
                </div>
            </div>
            <div class="question-footer" ng-show='isEditQuestion' style='margin:10px'>
                <a class='btn btn-raised btn-primary' ng-click='questionInfo.questionStatus=="created"? showQuestionEditDialog() :doneEditingQuestion()' ng-class='{"disabled": questionInfo.questionTitle.trim()=="" || (questionInfo.options.length==0 || questionInfo.options[0].optionTitle.trim()=="")}'><fmt:message key="Done"/></a>
                <a class='btn btn-raised btn-default' ng-click='cancelEditingQuestion()'><fmt:message key="Cancel"/></a>
            </div>
        </div>
    </div>
    </div>
</fmt:bundle>