<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<fmt:bundle basename="localization.EventMessages">
<div class='question-{{questionInfo.questionid}} question-panel' data-id='{{questionInfo.questionid}}'>
    <div class="row noMarginLftRght">
        <div id="edit-question{{questionInfo.questionid}}" ng-show='isEditQuestion' class="question-edit-sidebar col-xs-4 col-sm-4 col-md-4 col-lg-4">
            <form action="" method="POST" class="form-horizontal" role="form" name="editform">
                <div class="edit-question-header">
                    <div class="form-group">
                        <input type="text" name="title" id="questionTitle{{questionInfo.questionid}}" class="form-control floating-label question-title" value=" " title="" ng-model='questionInfo.questionTitle' placeholder='<fmt:message key="QuestionTitle"/>' />
                    </div>
                    <div class="form-group">                        
                        <textarea name="" id="questionDesc{{questionInfo.questionid}}" value="{{questionInfo.shortdesc}}" ng-model='questionInfo.shortdesc' class="form-control floating-label" rows="1" placeholder='<fmt:message key="QuestionDescription"/>'></textarea>
                    </div>
                    <div class="togglebutton requiredbutton">
                        <label>
                            <input type="checkbox" ng-click='questionInfo.isRequired=!questionInfo.isRequired' ng-checked="questionInfo.isRequired"> <fmt:message key="Mandatory"/>
                        </label>
                    </div>
                </div>
                <div class="edit-question-footer">
                    <div class="form-group" ng-class="{'has-error': editform.stars.$invalid}">
                        <input type="number" name="stars" id="questionTitle{{questionInfo.questionid}}" class="form-control floating-label" value="1" title="" ng-model='questionInfo.ratingVal' placeholder='<fmt:message key="NumberOfStars"/>' min="1" max="10" ng-pattern="/^[0-9]+$/" required/>
                        <span ng-show="!editform.stars.$error.pattern && (editform.stars.$invalid-min || editform.stars.$invalid-max)" class="help-block"><fmt:message key="ValidNumberOfStars"/></span>
                        <span ng-show="editform.stars.$error.pattern" class="help-block"><fmt:message key="ValidIntegerNumber"/></span>
                    </div>
                </div>
            </form>
        </div>
        <div class='panel' ng-class="{'question-edit-panel col-xs-8 col-sm-8 col-md-8 col-lg-8' : questioneditpanel}" ng-show='!ishideeverything || isEditQuestion'>
            <div class='panel-heading question-title' ng-click="editQuestion($event)">
                <div class="row">
                    <div class="col-xs-8 col-sm-8 col-md-9 col-lg-10">
                        <h4>{{questionInfo.questionno}}. {{questionInfo.questionTitle}}<span ng-show='questionInfo.isRequired' style='color:red;'> *</span></h4>
                        <small><div class='question-shortdesc'> {{questionInfo.shortdesc}} </div></small>
                    </div>
                    <div class="col-xs-4 col-sm-4 col-md-3 col-lg-2 question-panel-icons" ng-hide='ishideeverything'>
                        <!-- <a class='mdi-content-add-circle sur-panel-ico sur-ico' /> -->
                        <a class='mdi-content-create sur-panel-ico sur-ico' ng-click='showEditQuestion()' title='<fmt:message key="Edit"/>'/>
                        <a class='mdi-action-delete sur-panel-ico sur-ico' ng-click='questionDeleteInsideScope()' title='<fmt:message key="Delete"/>'/>
                        <a class='mdi-action-open-with sur-panel-ico sur-ico move-handle' title='<fmt:message key="Move"/>'/>
                        <a class='sur-panel-ico sur-ico' ng-click='showQuestionBody=!showQuestionBody' ng-class='{"mdi-hardware-keyboard-arrow-down" : !showQuestionBody, "mdi-hardware-keyboard-arrow-up" : showQuestionBody}' ng-attr-title="{{!showQuestionBody?'<fmt:message key="Expand"/>':'<fmt:message key="Collapse"/>'}}" />
                    </div>
                </div>
            </div>
            <div class='panel-body' ng-show='showQuestionBody'>
                <ul class='question-options rating question{{questionInfo.questionid}}-options' style="pointer-events:none;">
                    <li class='question-option' ng-repeat='star in getRangeArray(questionInfo.ratingVal)'>
                        <i class="mdi-action-star-rate stars" data-starindex='{{$index}}' ng-click='ratingClick($index)'></i>
                    </li>
                </ul>
            </div>
            <div class="question-footer" ng-show='isEditQuestion' style='margin:10px'>
                <a class='btn btn-raised btn-primary' ng-click='questionInfo.questionStatus=="created"? showQuestionEditDialog() :doneEditingQuestion()' ng-class='{"disabled": questionInfo.questionTitle.trim()=="" || editform.stars.$invalid}'><fmt:message key="Done"/></a>
                <a class='btn btn-raised btn-default' ng-click='cancelEditingQuestion()'><fmt:message key="Cancel"/></a>
            </div>
        </div>
    </div>
</div>
</fmt:bundle>