<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<fmt:bundle basename="localization.EventMessages">
<div class='question-{{questionInfo.questionid}} question-panel' data-id='{{questionInfo.questionid}}'>
    <div class="row noMarginLftRght">
        <div id="edit-question{{questionInfo.questionid}}" ng-show='isEditQuestion' class="question-edit-sidebar col-xs-4 col-sm-4 col-md-4 col-lg-4">
            <form action="" method="POST" class="form-horizontal" role="form" name="editform">
                <div class="edit-question-header">
                    <div class="form-group">
                        <input type="text" name="title" id="questionTitle{{questionInfo.questionid}}" class="form-control floating-label question-title" value=" " title="" ng-model='questionInfo.questionTitle' placeholder='<fmt:message key="QuestionTitle"/>' />
                    </div>
                    <div class="form-group">
                        <textarea name="" id="questionDesc{{questionInfo.questionid}}" value="{{questionInfo.shortdesc}}" ng-model='questionInfo.shortdesc' class="form-control floating-label" rows="1" placeholder='<fmt:message key="QuestionDescription"/>'></textarea>
                    </div>
                    <div class="row margin-bottom-20">
                        <div class="togglebutton requiredbutton col-sm-6">
                            <label>
                                <input type="checkbox" ng-click='questionInfo.isRequired=!questionInfo.isRequired' ng-checked="questionInfo.isRequired"> 
                                <fmt:message key="Mandatory"/>
                            </label>
                        </div>
                        <div class="togglebutton addLabelsButton col-sm-6">
                        <label>
                                 <input type="checkbox" ng-click='questionInfo.labels.length == 0 ? addLabel(0) : questionInfo.labels.splice(0,questionInfo.labels.length)' ng-checked="questionInfo.labels.length != 0">
                                 <fmt:message key="AddLabels"/>
                            </label>
                        </div>
                    </div>
                    <div ng-show="questionInfo.labels.length == 0" class="form-group" ng-class="{'has-error': editform.stars.$invalid}">
                        <input type="number" name="stars" id="questionTitle{{questionInfo.questionid}}" class="form-control floating-label" value="1" title="" ng-model='questionInfo.ratingVal' placeholder='<fmt:message key="NumberOfStars"/>' min="1" max="10" ng-pattern="/^[0-9]+$/" required/>
                        <span ng-show="!editform.stars.$error.pattern && (editform.stars.$invalid-min || editform.stars.$invalid-max)" class="help-block"><fmt:message key="ValidNumberOfStars"/></span>
                        <span ng-show="editform.stars.$error.pattern" class="help-block"><fmt:message key="ValidIntegerNumber"/></span>
                    </div>
                    <div ng-show="questionInfo.labels.length != 0" class="form-group label-floating input-group" ng-repeat='(indx,label) in questionInfo.labels track by indx'>
                        
                            <input type="text" name="" id="question{{questionInfo.questionid}}Option{{indx}}" class="form-control floating-label col-xs-8 col-sm-8 col-md-8 col-lg-8" value=" " title="" placeholder='<fmt:message key="Label"/> {{$index+1}}' ng-model='questionInfo.labels[indx]'>
                            <span class="input-group-btn" ng-show='true'>

                                <a class="mdi-content-add-circle sur-ico" ng-click="addLabel(indx+1)" title='<fmt:message key="Add"/>'></a>
                                <a class="mdi-content-remove-circle sur-ico" ng-click='questionInfo.labels.splice(indx,1)' ng-class='{"disabled":questionInfo.labels.length==1}' title='<fmt:message key="Remove"/>'></a>
                            </span>
                       
                </div>
                <div class="edit-question-footer marginLeftRight">
                    <div class="form-group label-floating" ng-repeat='option in questionInfo.options'>
                        <div class="input-group"> 
                            <input type="text" name="" id="question{{questionInfo.questionid}}Option{{$index}}" class="form-control floating-label col-xs-8 col-sm-8 col-md-8 col-lg-8" value=" " title="" placeholder='<fmt:message key="SubQue"/>{{$index+1}}' ng-model='option.optionTitle'>
                            <span class="input-group-btn" ng-show='true'>
                                <a class="mdi-image-camera-alt sur-ico" ng-click='showImageOption(option,$index)' title='<fmt:message key="Image"/>'></a>
                                <a class="mdi-action-language sur-ico" ng-click='showUrlOption(option,$index)' title='<fmt:message key="URL"/>'></a>
                                <a class="mdi-content-add-circle sur-ico" ng-click="questionInfo.options.splice($index+1,0,{optionTitle: '',questionOptionType:'',optionValue: '',showUrlInput : false,showFileInput : false})" title='<fmt:message key="Add"/>'></a>
                                <a class="mdi-content-remove-circle sur-ico" ng-click='questionInfo.options.splice($index,1)' ng-class='{"disabled":questionInfo.options.length==1}' title='<fmt:message key="Remove"/>'></a>
                            </span>
                        </div>
                            <input type="text" name="" id="q{{questionInfo.questionid}}o{{$index}}" class="form-control" value="" title="" ng-show='option.showUrlInput' placeholder='<fmt:message key="PasteUrl"/>' ng-class="{'inputUrlField':option.showUrlInput}" ng-model='option.optionValue'>
                            <input id="fileInputq{{questionInfo.questionid}}o{{$index}}" class='inputFile' type="file" accept="image/gif, image/jpeg, image/png" style="display: none">
                        </div>
                        
                    </div>

                </div>
            </form>
        </div>
        <div class='panel' ng-class="{'question-edit-panel col-xs-8 col-sm-8 col-md-8 col-lg-8' : questioneditpanel}" ng-show='!ishideeverything || isEditQuestion'>
            <div class='panel-heading question-title' ng-click="editQuestion($event)">
                <div class="row">
                    <div class="col-xs-8 col-sm-8 col-md-9 col-lg-10">
                        <h4>{{questionInfo.questionno}}. {{questionInfo.questionTitle}}<span ng-show='questionInfo.isRequired' style='color:red;'> *</span></h4>
                        <small><div class='question-shortdesc'> {{questionInfo.shortdesc}} </div></small>
                    </div>
                    <div class="col-xs-4 col-sm-4 col-md-3 col-lg-2 question-panel-icons" ng-hide='ishideeverything'>
                       
                        <a class='mdi-content-create sur-panel-ico sur-ico' ng-click='showEditQuestion()' title='<fmt:message key="Edit"/>'/>
                        <a class='mdi-action-delete sur-panel-ico sur-ico' ng-click='questionDeleteInsideScope()' title='<fmt:message key="Delete"/>'/>
                        <a class='mdi-action-open-with sur-panel-ico sur-ico move-handle' title='<fmt:message key="Move"/>'/>
                        <a class='sur-panel-ico sur-ico' ng-click='showQuestionBody=!showQuestionBody' ng-class='{"mdi-hardware-keyboard-arrow-down" : !showQuestionBody, "mdi-hardware-keyboard-arrow-up" : showQuestionBody}' ng-attr-title="{{!showQuestionBody?'<fmt:message key="Expand"/>':'<fmt:message key="Collapse"/>'}}" />
                    </div>
                </div>
                </div>
                <div class='panel-body' ng-show='showQuestionBody'>
                    <div ng-show="questionInfo.labels.length != 0" class="form-group col-lg-9 floatRight row" >
                        <label class="col-lg-2 textAlignCenter no-left-padding wordBreakLabel" ng-repeat='label in questionInfo.labels'>
                             {{label}}

                        </label>
                    </div>
                    <ul class='sub-questions'>
                        <li class='sub-question' ng-hide='option.optionTitle == ""' ng-repeat='option in questionInfo.options'>
                            <div class='form-group'>
                                <div class="row">
                                    <div class='col-lg-12 no-padding'>
                                            <div ng-class="questionInfo.labels.length == 0 ? 'col-lg-3 margin-top-15' : 'col-lg-3'">
                                            <label class="wordBreakLabel">
                                                 {{option.optionTitle}}

                                            </label>
                                            </div>
                                            <div ng-show="questionInfo.labels.length != 0" class="form-group col-lg-9">
                                                 <input ng-repeat='label in questionInfo.labels' type='radio' class="col-lg-2 question-{{questionInfo.questionid}}-labels" id='question{{questionInfo.questionid}}Label{{$index}}' ng-readonly='true'>
                                            </div>
                                            <div ng-show="questionInfo.labels.length == 0" class='col-lg-9'>
                                                <ul class='question-options rating question{{questionInfo.questionid}}-options' style="pointer-events:none;">
                                                    <li class='question-option' ng-repeat='star in getRangeArray(questionInfo.ratingVal)'>
                                                        <i class="mdi-action-star-rate stars" data-starindex='{{$index}}' ng-click='ratingClick($index)'></i>
                                                    </li>
                                                </ul>
                                            </div>
                                    </div>
                                </div>
                            </div>
                            <div ng-class="{'url-preview sur-hide': true}" class="{{'urlOptionPreviewPaneq' + questionInfo.questionid + 'o' + $index}}">
                                <span class='ico-close url-close-btn' ng-show='isEditQuestion' ng-click="removeUrl(option,$index)"></span>
                                <div class="url-prev"></div>
                            </div>
                            <div ng-class="{'image-preview sur-hide': true}" class="{{'imageOptionPreviewPanefileInputq' + questionInfo.questionid + 'o' + $index}}" ng-click="getImageData(option,$index)">
                                <span class="ico-close image-close-btn" ng-show='isEditQuestion' ng-click="removeImage($event,option,$index)"></span>
                                <div class="overlay sur-hide"></div>
                                <div class="image-prev"></div>
                            </div>
                        </li>
                    </ul>
                </div>
                <div class="question-footer" ng-show='isEditQuestion' style='margin:10px'>
                    <a class='btn btn-raised btn-primary' ng-click='questionInfo.questionStatus=="created"? showQuestionEditDialog() :doneEditingQuestion()' ng-class='{"disabled": questionInfo.questionTitle.trim()=="" || (questionInfo.options.length==0 || questionInfo.options[0].optionTitle.trim()=="")}'><fmt:message key="Done"/></a>
                    <a class='btn btn-raised btn-default' ng-click='cancelEditingQuestion()'><fmt:message key="Cancel"/></a>
                </div>
            </div>
        </div>
    </div>
</fmt:bundle>