<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<fmt:bundle basename="localization.EventMessages">
<div class='question-{{questionInfo.questionid}} question-panel' data-id='{{questionInfo.questionid}}'>
    <div class="row noMarginLftRght">
        <div id="edit-question{{questionInfo.questionid}}" ng-show='isEditQuestion' class="question-edit-sidebar col-xs-4 col-sm-4 col-md-4 col-lg-4">
            <form action="" method="POST" class="form-horizontal" role="form" name="editform">
                <div class="edit-question-header">
                    <div class="form-group">
                        <input type="text" name="title" id="questionTitle{{questionInfo.questionid}}" class="form-control floating-label question-title" value=" " title="" ng-model='questionInfo.questionTitle' placeholder='<fmt:message key="QuestionTitle"/>' />
                    </div>
                    <div class="form-group">                        
                        <textarea name="" id="questionDesc{{questionInfo.questionid}}" value="{{questionInfo.shortdesc}}" ng-model='questionInfo.shortdesc' class="form-control floating-label" rows="1" placeholder='<fmt:message key="QuestionDescription"/>'></textarea>
                    </div>
                    <div class="togglebutton requiredbutton">
                        <label>
                            <input type="checkbox" ng-click='questionInfo.isRequired=!questionInfo.isRequired' ng-checked="questionInfo.isRequired"> <fmt:message key="Mandatory"/>
                        </label>
                    </div>
                    <div class="form-group">
                         <div class="select-template-label"><fmt:message key="SelectTemplate"/></div>
                        <select class="questionTemplate form-control" ng-model='questionInfo.questionTemplate' ng-change="questionTemplateChange()">
                            <option value=""><fmt:message key="None"/></option>
                            <option value="yes"><fmt:message key="YesNo"/></option>
                            <option value="agree"><fmt:message key="AgreeDisagree"/></option>
                            <option value="satisfied"><fmt:message key="SatisfiedDissatisfied"/></option>
                        </select>
                    </div>                                        
                </div>
                <div class="edit-question-footer">
                    <div class="form-group label-floating" ng-repeat='qoption in questionInfo.options'>
                        <div ng-class='{"input-group":qoption.questionOptionType.toUpperCase()!="OTHER"}'>
                            <input type="text" name="" id="question{{questionInfo.questionid}}Option{{$index}}" class="form-control floating-label col-xs-8 col-sm-8 col-md-8 col-lg-8 question-option1" value=" " title="" placeholder='<fmt:message key="Option"/> {{$index+1}}' ng-model='qoption.optionTitle' ng-readonly='qoption.questionOptionType.toUpperCase()=="OTHER"'>
                            <span class="input-group-btn" ng-show='qoption.questionOptionType.toUpperCase()!="OTHER"'>
                                <a class="mdi-image-camera-alt sur-ico" ng-click='showImageOption(qoption,$index)' title='<fmt:message key="Image"/>'></a>
                                <a class="mdi-action-language sur-ico" ng-click='showUrlOption(qoption,$index)' title='<fmt:message key="URL"/>'></a>
                                <a class="mdi-content-add-circle sur-ico" ng-click="questionInfo.options.splice($index+1,0,{optionTitle: '',questionOptionType: (questionInfo.optionsType.toUpperCase()!='OTHER'?questionInfo.optionsType:''),optionValue: '',showUrlInput : false,showFileInput : qoption.showFileInput,isDefault: false})"  title='<fmt:message key="Add"/>'></a>
                                <a class="mdi-content-remove-circle sur-ico" ng-click='questionInfo.options.splice($index,1)' ng-class='{"disabled":questionInfo.options.length==1 || (questionInfo.options.length==2 && questionInfo.otherOption==true)}'  title='<fmt:message key="Remove"/>'></a>
                            </span>
                        </div>
                        <input type="text" name="" id="q{{questionInfo.questionid}}o{{$index}}" class="form-control" value="" title="" ng-show='qoption.showUrlInput' placeholder='<fmt:message key="PasteUrl"/>' ng-class="{'inputUrlField':qoption.showUrlInput}" ng-model='qoption.optionValue'>
                        <input id="fileInputq{{questionInfo.questionid}}o{{$index}}" class='inputFile' type="file" accept="image/gif, image/jpeg, image/png" style="display: none">                        
                    </div>
                    <div class="togglebutton otherbutton">
                        <label>
                            <input type="checkbox" ng-click="addOtherOption()" ng-checked="questionInfo.otherOption"> <fmt:message key="OtherWriteInChoice"/>
                        </label>
                    </div>
                </div>
            </form>
        </div>
        <div class='panel' ng-class="{'question-edit-panel col-xs-8 col-sm-8 col-md-8 col-lg-8' : questioneditpanel}" ng-show='!ishideeverything || isEditQuestion' >
            <div class='panel-heading question-title' ng-click="editQuestion($event)">
                <div class="row">
                    <div class="col-xs-8 col-sm-8 col-md-9 col-lg-10">
                        <h4>{{questionInfo.questionno}}. {{questionInfo.questionTitle}}<span ng-show='questionInfo.isRequired' style='color:red;'> *</span></h4>
                        <small><div class='question-shortdesc'> {{questionInfo.shortdesc}} </div></small>
                    </div>
                    <div class="col-xs-4 col-sm-4 col-md-3 col-lg-2 question-panel-icons" ng-hide='ishideeverything'>
                        <!-- <a class='mdi-content-add-circle sur-panel-ico sur-ico' /> -->
                        <a class='mdi-content-create sur-panel-ico sur-ico' ng-click='showEditQuestion()' title='<fmt:message key="Edit"/>'/>
                        <a class='mdi-action-delete sur-panel-ico sur-ico' ng-click='questionDeleteInsideScope()' title='<fmt:message key="Delete"/>'/>
                        <a class='mdi-action-open-with sur-panel-ico sur-ico move-handle' title='<fmt:message key="Move"/>'/>
                        <a class='sur-panel-ico sur-ico' ng-click='showQuestionBody=!showQuestionBody' ng-class='{"mdi-hardware-keyboard-arrow-down" : !showQuestionBody, "mdi-hardware-keyboard-arrow-up" : showQuestionBody}' ng-attr-title="{{!showQuestionBody?'<fmt:message key="Expand"/>':'<fmt:message key="Collapse"/>'}}" />
                    </div>
                </div>
            </div>
            <div class='panel-body' ng-show='showQuestionBody'>
                <ul class='question-options'>
                    <li class='question-option' ng-hide='qoption.optionTitle == "" ' ng-repeat='qoption in questionInfo.options'>
                        <div class='form-group'>
                            <div class="row">
                                <div class='col-lg-12'>
                                    <div class='radio radio-primary'>
                                        <label>
                                            <input type='radio' class="question-{{questionInfo.questionid}}-options" name='question{{questionInfo.questionid}}Option' id='question{{questionInfo.questionid}}Option{{$index}}' ng-click="toggleDefault()" ng-checked="{{qoption.isDefault}}"> {{qoption.optionTitle}}
                                            <input type="text" name="" class="form-control" value="" title="" ng-show='qoption.questionOptionType.toUpperCase().toUpperCase()=="OTHER"' readonly>
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div ng-class="{'url-preview sur-hide': true}" class="{{'urlOptionPreviewPaneq' + questionInfo.questionid + 'o' + $index}}">
                            <span class='ico-close url-close-btn' ng-show='isEditQuestion' ng-click="removeUrl(qoption,$index)"></span>
                            <div class="url-prev"></div>
                        </div>
                        <div ng-class="{'image-preview sur-hide': true}" class="{{'imageOptionPreviewPanefileInputq' + questionInfo.questionid + 'o' + $index}}" ng-click="getImageData(qoption,$index)">
                            <span class="ico-close image-close-btn" ng-show='isEditQuestion' ng-click="removeImage($event,qoption,$index)"></span>
                            <div class="overlay sur-hide"></div>
                            <div class="image-prev"></div>
                        </div>
                    </li>
                </ul>
            </div>
            <div class="question-footer" ng-show='isEditQuestion' style='margin:10px'>
                <a class='btn btn-raised btn-primary' ng-click='questionInfo.questionStatus=="created"? showQuestionEditDialog() :doneEditingQuestion()' ng-class='{"disabled": questionInfo.questionTitle.trim()=="" || (questionInfo.options.length==0 || questionInfo.options[0].optionTitle.trim()=="")}'><fmt:message key="Done"/></a>
                <a class='btn btn-raised btn-default' ng-click='cancelEditingQuestion()'><fmt:message key="Cancel"/></a>
            </div>
        </div>
    </fmt:bundle>