<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<fmt:bundle basename="localization.EventMessages">

<div class="proposalWrapper">

	<!-- Proposal organizer template -->

	<div class='col-xl-3 col-lg-4 col-md-4 col-sm-6 tileWrapper tiles proposalOrganizer' style="margin-top:20px;">
		<div class='panel panel-default proposal-button tile-button {{category}}'>
			<div class='panel-heading'>
				<div class="eventId" style="display:none">{{eventId}}</div>
				<div class="eventType" style="display: none">{{eventType}}</div>
				<h5 style='color:white;'>
				<span class="ico-cog3 ico-st-tile admin-options" data-button='.proposal-button'></span> <a href="{{viewProposalUrl}}"
						title="{{fullProposalTitle}}"> {{proposalTitle}} </a> <span
						class="ico-envelope-o ico-st-tile btnNotification {{notification}}"
						style="float: right;"
						title="{{notificationTitle}}"></span> <span
						class="ico-favorite-outline ico-st-tile btnFavorite {{favorite}}"
						style="float: right;" title="Favorite"></span> <span
						class="{{visibility}}"
						style="float: right; cursor:default;" title="{{visibilityTitle}}"></span>
				</h5>
			</div>
			<div class="adminOptions" style="display: none;">
				<ul>
					<li class="{{edit}}">
						<a href="{{editProposalUrl}}">
							<span class="ico-edit2 ico-st-tile" title='<fmt:message key="Edit"/>'></span>						
						</a>	
					</li>
					<li class="{{reorganize}}">
						<a href="{{cloneProposalUrl}}">					
							<span class="ico-restore ico-st-tile" title='<fmt:message key="ReOrganize"/>'></span>
						</a>	
					</li>
					<li>
						<a onclick="{{cancelProposalFunction}}"><span
							class="ico-st-tile {{deleteOrCancelIcon}}" title="{{deleteOrCancel}}" ></span>
						</a>
					</li>
					<li class="{{inviteMore}}">
						<a onclick="{{inviteMoreFunction}}"><span
							class="ico-person-add ico-st-tile" title='<fmt:message key="InviteMore"/>'></span>
						</a>
					</li>
					<li class="{{organize}}"><a href="{{organizeEventUrl}}"><span
							class="ico-loop3 ico-st-tile" title='<fmt:message key="ConvertToEvent"/>'></span></a></li>						
				</ul>
			</div>
			<div class='panel-body main-panel-body'>
				<div class="location {{location-show}}" title="{{fullLocation}}">
						<span class="ico-location-on ico-st-tile"
								></span> {{location}}
				</div>
				<div class="{{startEnd}}" title="When" style="margin-bottom:5px">
					<span class="ico-calendar ico-st-tile" style='vertical-align:baseline'>							
					</span> {{scheduledDate}} - {{scheduledEndDate}}						
				</div>								
				<div class="{{progress}} text-center viewresponse">
					<a href="{{viewResponseUrl}}" title='<fmt:message key="ViewResponse"/>' style='font-size:2.8em;font-weight:lighter'>							
							{{respondCount}}							
					</a>
					<div>
						<a href="{{viewResponseUrl}}" style="font-size:0.9em;">
							(<fmt:message key="ViewResponse"/>)			
						</a>
					</div>
				</div>	
															
				<div class="proposal-question {{question}}">				
						<input id="{{questionId}}" type="checkbox" name='interestedUser' class="cvToggle"><label for="{{questionId}}"  style="margin-top:0px;" title='<fmt:message key="AreYouInterested"/>'></label>							
							<div class='eventType' style='display:none'>{{eventType}}</div>
							<div class='questionId' style='display:none'>{{questionId}}</div>										
							<div class='yesOptionId' style='display:none'>{{yesOptionId}}</div>
							<div class='noOptionId' style='display:none'>{{noOptionId}}</div>
							<div class='eventId' style='display:none'>{{proposalId}}</div>
				</div>
				<div class="{{participant}}">
					<div class="response">
							{{{participationMessage}}}
					</div>
				</div>														
				<div class="{{reminder}}">
					<a onclick="{{sendReminderFunction}}"> <span
						class="ico-alarm ico-st-tile"></span> <fmt:message key="SendReminder"/> </a>
				</div>
				<div class="{{notRespondedShow}}">
						<a onclick="{{notRespondedParticipants}}"><span class="ico-list2 ico-st-tile"></span> <fmt:message key="ListNotRespondedParticipants"/> 
						</a>
				</div>	
			</div>
			<div class='panel-body'>
				<hr>
				<div class={{expired}} style='display:none;' title='<fmt:message key="RSVPBy"/>'>
					<span class="ico-clock ico-st-tile"></span>
					<span> {{expiryDate}}</span>
				</div>
		</div>
	</div>
</div>

	<!-- Proposal participant template -->

	<div class='col-xl-3 col-lg-4 col-md-4 col-sm-6 tileWrapper tiles proposalParticipant' style="margin-top:20px;">
		<div class='panel panel-default proposal-button tile-button {{category}}'>
			<div class='panel-heading'>
				<div class="eventId" style="display:none">{{eventId}}</div>
				<div class="eventType" style="display: none">{{eventType}}</div>
				<h5 style='color:white;'>
				<a href="{{viewProposalUrl}}"
						title="{{fullProposalTitle}}"> {{proposalTitle}} </a> <span
						class="ico-envelope-o ico-st-tile btnNotification {{notification}}"
						style="float: right;"
						title="{{notificationTitle}}"></span> <span
						class="ico-favorite-outline ico-st-tile btnFavorite {{favorite}}"
						style="float: right;" title="Favorite"></span> <span
						class="{{visibility}}"
						style="float: right; cursor:default;" title="{{visibilityTitle}}"></span>
				</h5>
			</div>		
			<div class='panel-body main-panel-body'>		
				<div class="location  {{location-show}}" title="{{fullLocation}}">
						<span class="ico-location-on ico-st-tile"
								></span> {{location}}
				</div>
				<div class="{{startEnd}}" title="When" style="margin-bottom:5px">
						<span class="ico-calendar ico-st-tile" style='vertical-align:baseline'>			
						</span> {{scheduledDate}} - {{scheduledEndDate}}						
					</div>
				<div class="viewresponse"></div>				
																		
				<div class="proposal-question {{question}}">				
						<input id="{{questionId}}" type="checkbox" name='interestedUser' class="cvToggle"><label for="{{questionId}}"  style="margin-top:0px;" title='<fmt:message key="AreYouInterested"/>'></label>							
							<div class='eventType' style='display:none'>{{eventType}}</div>
							<div class='questionId' style='display:none'>{{questionId}}</div>										
							<div class='yesOptionId' style='display:none'>{{yesOptionId}}</div>
							<div class='noOptionId' style='display:none'>{{noOptionId}}</div>
							<div class='eventId' style='display:none'>{{proposalId}}</div>
				</div>
				<div class="{{participant}}">
					<div class="response">
							{{{participationMessage}}}
					</div>
				</div>														
			</div>
			<div class='panel-body'>
				<hr>
				<div class={{expired}} style='display:none;' title='<fmt:message key="RSVPBy"/>'>
					<span class="ico-clock ico-st-tile"></span>
					<span> {{expiryDate}}</span>
				</div>
		</div>
	</div>
 </div>

	<!-- Proposal Draft template -->

	<div class="col-xl-3 col-lg-4 col-md-4 col-sm-6 tileWrapper tiles proposalDraft" style="margin-top:20px;">
		<div class="panel panel-default proposal-draft-button tile-button drafts">
			<div class="panel-heading">

				<h5 style='color: white;'>
					<span class="ico-cog3 ico-st-tile admin-options" data-button='.proposal-draft-button'></span>
					 <a href="{{viewProposalUrl}}" title="{{fullProposalTitle}}">
						{{proposalTitle}} </a> 
						 <span
						class="{{visibility}}" style="float: right; cursor:default;"
						title="{{visibilityTitle}}"></span> 
				</h5>
			</div>
			<div class="adminOptions" style="display: none;">
				<ul>
					<li><a href="{{editProposalUrl}}"><span
						class='ico-edit2 ico-st-tile' title='<fmt:message key="Edit"/>' ></span></a>
					</li>
					<li>
						<a
						onclick="{{cancelProposalFunction}}"><span
						class='ico-trashcan ico-st-tile' title="{{deleteOrCancel}}" ></span></a>
					</li>
				</ul>	
			</div>	
			<div class='panel-body main-panel-body'>
				<div class="location {{location-show}}" title="{{fullLocation}}">
						<span class="ico-location-on ico-st-tile"
								></span> {{location}}
					</div>
					<div class="{{startEnd}}" title="When" style="margin-bottom:5px">
						<span class="ico-calendar ico-st-tile" style='vertical-align:baseline'>		
						</span> {{scheduledDate}} - {{scheduledEndDate}}						
				</div>
				<div class="viewresponse"></div>
		
			</div>
			<div class="panel-body">
				<hr>
				<div class={{expired}} style='display: none;' title='<fmt:message key="RSVPBy"/>'>
					<span class="ico-clock ico-st-tile"></span>
					<span> {{expiryDate}}</span>
				</div>

			</div>
		</div>
	</div>
</div>
</fmt:bundle>