<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<fmt:bundle basename="localization.EventMessages">

<div class="eventWrapper">
	<!-- Event organizer template -->
	<div class="col-xl-3 col-lg-4 col-md-4 col-sm-6 tileWrapper tiles eventOrganizer" style="margin-top: 20px;">
			<div class="panel panel-default event-button tile-button {{category}}">
				<div class="panel-heading">
					<div class="eventId" style="display: none">{{eventId}}</div>
					<div class="eventType" style="display: none">{{eventType}}</div>
					<h5>
						<span class="ico-cog3 ico-st-tile admin-options" data-button='.event-button'></span> 
							<a href="{{viewEventUrl}}" title="{{fullEventTitle}}"> {{eventTitle}} </a> <span
							class="ico-envelope-o ico-st-tile btnNotification {{notification}}"
							style="float: right;"
							title="{{notificationTitle}}"></span> <span
							class="ico-favorite-outline ico-st-tile btnFavorite {{favorite}}"
							style="float: right;" title="Favorite"></span>
					</h5>
				</div>
				<div class="adminOptions" style="display: none;">
					<ul>
						<li class="{{edit}}">
							<a href="{{editEventUrl}}"> <span
									class="ico-edit2 ico-st-tile" title='<fmt:message key="Edit"/>' ></span>
							</a>
						</li>
						<li class="{{reorganize}}">
							<a href="{{cloneEventUrl}}"> <span
								class="ico-restore ico-st-tile" title='<fmt:message key="ReOrganize"/>' ></span>
							</a>
						</li>
						<li>
							<a class="cancelEventFunction" data-params="{{cancelEventParams}}"><span
								class="ico-st-tile {{deleteOrCancelIcon}}" title="{{deleteOrCancel}}" ></span></a>
						</li>
						<li class="{{inviteMore}}">
							<a class="inviteMoreFunction" data-params="{{inviteMoreParams}}"><span
								class="ico-person-add ico-st-tile" title='<fmt:message key="InviteMore"/>' ></span>
							</a>
						</li>
					</ul>
				</div>
				<div class="panel-body main-panel-body">
					<div class="location {{location-show}}" title="{{fullLocation}}">
						<span class="ico-location-on ico-st-tile"
								></span> {{location}}
					</div>
					<div class="{{startEnd}}" title="When" style="margin-bottom:5px">
						<span class="ico-calendar ico-st-tile" style='vertical-align:baseline'>						
						</span> {{scheduledDate}} - {{scheduledEndDate}}						
					</div>
					<div class="{{progress}} text-center viewresponse">
						<a href="{{viewResponseUrl}}" title='<fmt:message key="ViewResponse"/>' style='font-size:2.8em;font-weight:lighter'>							
								{{respondCount}}							
						</a>
						<div>
							<a href="{{viewResponseUrl}}" style="font-size:0.9em;">
								(<fmt:message key="ViewResponse"/>)			
							</a>
						</div>
					</div>					
					<div class="{{participant}}">
						<div class="response">{{{participationMessage}}}
						</div>
					</div>
					<div class="{{reminder}}">
						<a class="sendReminderFunction" data-params="{{sendReminderParams}}"><span
							class="ico-alarm ico-st-tile"></span> <fmt:message key="SendReminder"/> </a>
					</div>
					<div class="{{defaultSelection}}">
						<a class="sendDefaultSelectionFunction" data-params="{{sendDefaultSelectionFunctionParams}}"><span class="ico-check-square-o ico-st-tile"></span> <fmt:message key="SendDefaultSelection"/> 
						</a>
					</div>
					<div class="{{sendSelectionShow}}">
						<a class="sendSelectionMailToRespParticipants" data-params="{{sendSelectionMailToRespParticipantsParams}}"><span class="ico-check-square-o ico-st-tile"></span> <fmt:message key="SendSelection"/> 
						</a>
					</div>
					<div class="{{notRespondedShow}}">
						<a class="notRespondedParticipants" data-params="{{notRespondedParticipantsParams}}"><span class="ico-list2 ico-st-tile"></span> <fmt:message key="ListNotRespondedParticipants"/> 
						</a>
					</div>					
				</div>
				<div class="panel-body" >
					<hr>
					<div class={{expired}} style='display: none;' title='<fmt:message key="RSVPBy"/>'>
						<span class="ico-clock ico-st-tile"></span>
						<span> {{expiryDate}}</span>
					</div>

				</div>
			</div>
	</div>


	<!-- Event participants template-->
	<div class="col-xl-3 col-lg-4 col-md-4 col-sm-6 tileWrapper tiles eventParticipant" style="margin-top:20px;">
		<div class="panel panel-default event-button tile-button {{category}}">
			<div class="panel-heading">
			<div class="eventId" style="display:none">{{eventId}}</div>
			<div class="eventType" style="display: none">{{eventType}}</div>
			<h5>
					<a href="{{viewEventUrl}}"
						title="{{fullEventTitle}}"> {{eventTitle}} </a> <span
						class="ico-envelope-o ico-st-tile btnNotification {{notification}}"
						style="float: right;"
						title="{{notificationTitle}}"></span> <span
						class="ico-favorite-outline ico-st-tile btnFavorite {{favorite}}"
						style="float: right;" title="Favorite"></span> 
					<!-- <span class="ico-calendar" style="float: right;" title='<fmt:message key="Event"/>'></span> -->
				</h5>
			</div>
			<div class="panel-body main-panel-body">
				<div class="location  {{location-show}}" title="{{fullLocation}}">
						<span class="ico-location-on ico-st-tile"
								></span> {{location}}
					</div>
					<div class="{{startEnd}}" title="When" style="margin-bottom:5px">
						<span class="ico-calendar ico-st-tile" style='vertical-align:baseline'>						
						</span> {{scheduledDate}} - {{scheduledEndDate}}						
					</div>
					<div class="viewresponse"></div>
				<div>
					<div class="response">
							{{{participationMessage}}}
					</div>
				</div>			
			</div>
			<div class="panel-body">
				<hr>
				<div class="{{expired}}" style='display:none;' title='<fmt:message key="RSVPBy"/>'>
					<span class="ico-clock ico-st-tile"></span>
					<span> {{expiryDate}}</span>
				</div>
				
			</div>
		</div>
	</div>

	<!-- Event draft template -->

	<div class="col-xl-3 col-lg-4 col-md-4 col-sm-6 tileWrapper tiles eventDraft" style="margin-top:20px;">
		<div class="panel panel-default event-draft-button tile-button drafts">
			<div class="panel-heading">

				<h5 style='color: white;'>
					<span class="ico-cog3 ico-st-tile admin-options" data-button='.event-draft-button'></span>
					<a href="{{viewEventUrl}}" title="{{fullEventTitle}}">
						{{eventTitle}} </a> 
						 <!-- <span
						class="ico-calendar"
						style="float: right; margin-right: 10px;" title='<fmt:message key="Event"/>'></span> -->
				</h5>
			</div>
			<div class="adminOptions" style="display: none;">
					<ul>
						<li><a href="{{editEventUrl}}"> <span
								class="ico-edit2 ico-st-tile {{edit}}" title='<fmt:message key="Edit"/>' ></span>
						</a></li>
						<li><a class="cancelEventFunction" data-params="{{cancelEventParams}}"><span
								class="ico-trashcan ico-st-tile" title={{deleteOrCancel}} ></span></a></li>
					</ul>
				</div>
			<div class='panel-body main-panel-body'>
				<div class="location {{location-show}}" title="{{fullLocation}}">
						<span class="ico-location-on ico-st-tile"
								></span> {{location}}
					</div>
					<div class="{{startEnd}}" title="When" style="margin-bottom:5px">
						<span class="ico-calendar ico-st-tile" style='vertical-align:baseline'>						
						</span> {{scheduledDate}} - {{scheduledEndDate}}						
				</div>
				<div class="viewresponse"></div>
				
			</div>
			<div class="panel-body">
				<hr>
				<div class="{{expired}}" style='display: none;' title='<fmt:message key="RSVPBy"/>'>
					<span class="ico-clock ico-st-tile"></span>
					<span> {{expiryDate}}</span>
				</div>		

			</div>
		</div>
	</div>
</div>

</fmt:bundle>