<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@  taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"%>
<c:if test="${!fn:containsIgnoreCase(pageContext.request.contextPath, 'adminconsole')}">
	<jsp:include page="/cvevents/surveysHeader.jsp" />
	<c:set var="applicationName" value="webconsole"></c:set>
</c:if>
<link href='${pageContext.request.contextPath}/cvevents/css/eventstyles.css?${applicationScope.BUILD_TS}' rel='stylesheet' />
<link href='${pageContext.request.contextPath}/cvevents/thirdparty/css/ripples.min.css?${applicationScope.BUILD_TS}' rel='stylesheet' />
<link href='${pageContext.request.contextPath}/cvevents/thirdparty/css/material.min.css?${applicationScope.BUILD_TS}' rel='stylesheet' />
<link href='${pageContext.request.contextPath}/cvevents/css/surveystyle.css?${applicationScope.BUILD_TS}' rel='stylesheet' />
<script id="QuestionTemplate" type="text/x-jquery-tmpl">
	<div class="panel panel-primary">
	<div class="row">
		<div  class="ques_id" style="display:none">{{= quesId}}</div>
		<div  class="ques_type" style="display:none">{{= questionType}}</div>
		<div  class="ques_isRequired" style="display:none">{{= questionXml.isRequired}}</div>
	</div>
	<div class="panel-heading">
	<div class="row"><div class="col-sm-12 col-md-12 col-xs-12 col-lg-12">
		<div  class="QuesTitle "> {{= questionno}}. {{= questionTitle}}
		{{if questionXml.isRequired == true }}
			<span style='color:red'>*</span>
		{{/if}}
		{{if (questionXml.questionDescription || '').trim() != '' }}
			<div><small><i>{{= questionXml.questionDescription}}</i></small></div>
		{{/if}}
		</div>
	</div>
	</div>
	</div>
	<div id="questionWrapper_{{= quesId}}" class="panel-body">
	{{if questionType == "radio" }}
		{{each(i,option) questionOptions}}
			{{if option.isDefault == true}}
				<div class="row">
					<div class="QuesOption">
						<div class='form-group'>
                            <div class='radio radio-primary'>
                                <label>
                                	<input  type="radio" name="{{= quesId}}" value="{{= option.questionOptionId}}" checked data-option-type="{{= option.questionOptionType}}">{{= option.optionTitle}}
                                </label>
                            </div></div>
			{{else}}
				<div class="row">
					<div class="QuesOption">
						<div class='form-group'>
                            <div class='radio radio-primary'>
                                <label>
                                	<input  type="radio" name="{{= quesId}}" value="{{= option.questionOptionId}}" data-option-type="{{= option.questionOptionType}}">{{= option.optionTitle}}
                                </label>
                            </div></div>
			{{/if}}
			{{if questionXml.isOtherOption == true && (option.questionOptionType || "").toUpperCase() == "OTHER" }}
				<div class='otherOption'><input type="text" class="form-control" name="{{= quesId}}" id={{= option.questionOptionId}} value="{{= customResponse}}"/></div>
			{{/if}}
			</div></div>
			{{if option.questionOptionType == "URL" }}
				<div class="row">
					<div class="col-md-6 col-lg-6 col-sm-6 optionURLPreview optionUrlField" style="margin-left: 60px; display: block;">
						{{html getParsedURL(questionTitle,option.optionTitle,option.optionValue,option.optionId) }}
				</div>
			</div>
			{{else option.questionOptionType == "IMAGE" }}
				<div class="row">
					<div class="col-md-12 col-sm-12 col-lg-12 col-xs-12 optionPreview optionFileField" style="margin-left: 60px; display: block;">
						<div class="optionPreviewPane"><img src="{{= option.optionValue}}"></div>
				</div>
			</div>
			{{/if}}
		{{/each}}
	{{else questionType == "checkbox" }}
		{{each(i,option) questionOptions}}
			{{if option.isDefault == true}}
				<div class="row"><div class="QuesOption "><div class='checkbox checkbox-primary'><label><input  type="checkbox" name="{{= quesId}}" value="{{= option.questionOptionId}}" checked data-option-type="{{= option.questionOptionType}}">{{= option.optionTitle}}</label></div>
			{{else}}
				<div class="row"><div class="QuesOption "><div class='checkbox checkbox-primary'><label><input  type="checkbox" name="{{= quesId}}" value="{{= option.questionOptionId}}" data-option-type="{{= option.questionOptionType}}">{{= option.optionTitle}}</label></div>
			{{/if}}
			{{if questionXml.isOtherOption == true && (option.questionOptionType || "").toUpperCase() == "OTHER" }}
				<div class='otherOption'><input type="text" class='form-control' name="{{= quesId}}" id={{= option.questionOptionId}} value="{{= customResponse}}"/></div>
			{{/if}}
			</div></div>
			{{if option.questionOptionType == "URL" }}
					<div class="row">
						<div class="col-md-6 col-lg-6 col-sm-6 optionURLPreview optionUrlField" style="margin-left: 60px; display: block; ">
							{{html getParsedURL(questionTitle,option.optionTitle,option.optionValue,option.optionId) }}
					</div>
				</div>
			{{else option.questionOptionType == "IMAGE" }}
				<div class="row">
					<div class="col-md-12 col-sm-12 col-lg-12 col-xs-12 optionPreview optionFileField" style="margin-left: 60px; display: block;">
						<div class="optionPreviewPane"><img src="{{= option.optionValue}}"></div>
					</div>
				</div>
			{{/if}}
		{{/each}}
	{{else questionType == "select" }}
		<div class="row"><div class="QuesOption col-sm-12 col-md-4 col-xs-12 col-lg-4"><select class="form-control" name="{{= quesId}}">
		{{each(i,option) questionOptions}}
			{{if option.isDefault == true}}
				<option value="{{= option.questionOptionId}}" selected>{{= option.optionTitle}}</option>
			{{else}}
				<option value="{{= option.questionOptionId}}">{{= option.optionTitle}}</option>
			{{/if}}
		{{/each}}
		</select>
		</div></div>
	{{else questionType == "text" }}
		<div class="row"><div class="QuesOption col-sm-10 col-md-7 col-xs-10 col-lg-5">
		{{if questionXml.questionSubType == "Email"}}
			<input type="email" class="form-control question-email" name="{{= quesId}}" value="{{= customResponse}}"/>
		{{else questionXml.questionSubType == "Number"}}
			<input type="number" class="form-control" name="{{= quesId}}" value="{{= customResponse}}" min="0"/>
		{{else questionXml.questionSubType == "DateTime"}}
			<div class='input-group dateQuestions' id="{{= quesId}}">
				 <span class="input-group-addon">
					 <span class="glyphicon glyphicon-calendar date-icon"></span>
				 </span>
				<input type='text'
					class="form-control inputTypePadding dateTimePickerObj"
					name="{{= quesId}}" value="{{= customResponse}}" />
			</div>
		{{else questionXml.questionSubType == "Address"}}
			<div class="input-group addressQuestions">
				<span class="input-group-addon"><span
					class="glyphicon glyphicon-map-marker"></span> </span>
				<input type="text" class="form-control inputTypePadding addressQuestion"
					name="{{= quesId}}" value="{{= customResponse}}" id="{{= quesId}}" placeholder='Enter a location'/>
			</div>
		{{else}}
			<input type="text" class="form-control" name="{{= quesId}}" value="{{= customResponse}}"/>
		{{/if}}

		</div></div>
	{{else questionType == "textarea" }}
		<div class="row"><div class="QuesOption col-sm-10 col-md-10 col-xs-10 col-lg-10"><textarea class="form-control survey-textarea" style="height:100px" class="" name="{{= quesId}}">{{= customResponse}}</textarea></div></div>
	{{else questionType == "rating" }}
		<div class="row"><div class="QuesOption col-sm-10 col-md-10 col-xs-10 col-lg-10">
			<div class="ratingQuestion" id="{{= quesId}}" data-rating-val="{{= customResponse}}">
				<div class='customResponse' style='display:none;'>{{= customResponse}}</div>
			{{each(i,star) Array.apply(null, Array(questionXml.ratingVal)).map(Number.prototype.valueOf,0)}}
				{{if typeof customResponse !='undefined' && (i+1) <= customResponse }}
					<i class="mdi-action-star-rate view-page-stars stars-active" data-rating="{{= i+1}}"></i>
				{{else}}
					<i class="mdi-action-star-rate view-page-stars" data-rating="{{= i+1}}"></i>
				{{/if}}
			{{/each}}
			</div>
		</div></div>
	{{else questionType == "multiselect_rating" }}
		{{if (questionXml.subQuestionLabels || []).length != 0 }}
			<div class="form-group col-lg-9 floatRight row" >
			{{each(i,label) questionXml.subQuestionLabels}}


			            <label class="col-lg-2 textAlignCenter">
			                 {{= label}}

			            </label>


	         {{/each}}
	         </div>
	      {{/if}}
		{{each(o,option) questionOptions}}

			<div class="row"><div class="option col-lg-12">
			{{if (questionXml.subQuestionLabels || []).length != 0 }}
				<label class="col-lg-3">{{= option.optionTitle}}</label>
				<div class="optionRadioBtns form-group col-lg-9">
				{{each(i,label) questionXml.subQuestionLabels}}
					{{if typeof option.customResponse !='undefined' && (i+1) == option.customResponse}}
	             		<input class="col-lg-2" type='radio' name="{{= quesId}}_{{= option.questionOptionId}}" value="{{= option.questionOptionId}}" data-option-index = "{{= i+1}}" data-option-type="{{= option.optionType}}" checked>
	             	{{else}}
	             		<input class="col-lg-2" type='radio' name="{{= quesId}}_{{= option.questionOptionId}}" value="{{= option.questionOptionId}}" data-option-index = "{{= i+1}}" data-option-type="{{= option.optionType}}">
	             	{{/if}}
	             {{/each}}
	        	</div>
	        {{else}}
	        	<label class="col-lg-3 margin-top-15">{{= option.optionTitle}}</label>
	        	<div class="ratingQuestion col-lg-9 {{= quesId}}"  data-rating-val="{{= option.customResponse}}" data-option-type="{{= option.optionType}}" data-option-id="{{= option.questionOptionId}}">
					<div class='customResponse' style='display:none;'>{{= option.customResponse}}</div>
				{{each(i,star) Array.apply(null, Array(questionXml.ratingVal)).map(Number.prototype.valueOf,0)}}
					{{if typeof option.customResponse !='undefined' && (i+1) <= option.customResponse }}
						<i class="mdi-action-star-rate view-page-stars stars-active" data-rating="{{= i+1}}"></i>
					{{else}}
						<i class="mdi-action-star-rate view-page-stars" data-rating="{{= i+1}}"></i>
					{{/if}}
				{{/each}}
				</div>
			{{/if}}
        	</div>
			</div>


			{{if option.questionOptionType == "URL" }}
					<div class="row">
						<div class="col-md-6 col-lg-6 col-sm-6 optionURLPreview optionUrlField" style="margin-left: 60px; display: block; ">
							{{html getParsedURL(questionTitle,option.optionTitle,option.optionValue,option.questionOptionId) }}
					</div>
				</div>
			{{else option.questionOptionType == "IMAGE" }}
				<div class="row">
					<div class="col-md-12 col-sm-12 col-lg-12 col-xs-12 optionPreview optionFileField" style="margin-left: 60px; display: block;">
						<div class="optionPreviewPane"><img src="{{= option.optionValue}}"></div>
					</div>
				</div>
			{{/if}}
		{{/each}}
	{{/if}}
	</div>
	</div>
</script>

<fmt:bundle basename="localization.EventMessages">
<div class="sechead eventpagetitle">
	<div class="clrfloat"></div>
	<div id="secTitleDiv" class="col-lg-6 col-md-6 col-sm-6 col-xs-6" style="padding:0">
			<span id="sectionTitle" class="sectiontitle">
				<a href="../cvevents"><fmt:message key="EventsOrganizer"/></a><i class="ico-keyboard-arrow-right ico-st-title"></i><span class="viewpagetitle"></span>
			</span>
	</div>
	<div class="col-lg-6" style="padding-right:0">
		<div class="pull-right">
			<div id="AdminActions" style="display: none;">
				<button class="btn btn-primary dropdown-toggle" data-toggle="dropdown">
				<span class='ico-list4 ico-st-title' style='color:white'></span>&nbsp;
				<fmt:message key="Action" />
					<span class="caret"></span></button>
					<ul class="dropdown-menu pull-right" role="menu">
						<li><a id="inviteMore" href="#"><fmt:message
									key="InviteMore" /></a></li>
						<li><a id="extendSurvey" href="#" style="display:none"><fmt:message
									key="EditSurvey" /></a></li>
						<li><a id="editEvent" href="#"><fmt:message
									key="EditSurvey" /></a></li>
						<li><a id="deleteEvent" href="#"><fmt:message
									key="CancelSurvey" /></a></li>
					</ul>
			</div>
		</div>
	</div>
	<div class="clrfloat"></div>
</div>
	<body>

		<div id="eventID" style="display: none"></div>
		<div id="full_preview_bar" style="display: none"
			class="navbar navbar-inverse navbar-fixed-top" role="navigation">
			<div class="inner" style="margin:10px 15px 10px 15px">
				<button id="closeWndwBtn" class="btn btn-success pull-right" ><fmt:message key="CloseWindow"/></button>
				<h4><fmt:message key="SurveyPreviewMessage"/></h4>
				<p><fmt:message key="EditSurveyInvitation"/></p>
			</div>

		</div>

		<div class="PageContent" id="mainBody">
			<div class="PageTbl">
				<div id="ajaxCall">
					<div>
						<div id="ajaxBusyMail" class="center_it">
							<img src="../common/img/loader.gif" />
						</div>
					</div>
				</div>
				<div id="events_grid" class="respMarginMain margin-top-0" style="display: none;">
					<div class="row">
						<h3 class="event_title margin-left-5">
							<span id="event_title"></span>
						</h3>
					</div>
					<div class="row">
						<div id="event_image" class="backgroundImage"></div>

					</div>
					<div class="row respMarginMain margin-left-5">
					<div class="col-lg-5 col-md-5 col-sm-5 noLeftPadding">
						<div id="event_details" class="eventDetailsStyle">

						<div class="row">
							<label
								class="col-sm-2 col-md-2 col-xs-2 col-lg-2 control-label noLeftPadding"><fmt:message
									key="Host" />:</label>
							<div class="col-sm-10 col-md-10 col-xs-10 col-lg-10">
								<p id="host_name"></p>
							</div>
						</div>
						<div class="row">
							<label
								class="col-sm-2 col-md-2 col-xs-2 col-lg-2 control-label noLeftPadding"><fmt:message
									key="RSVPBy" />:</label>
							<div class="col-sm-10 col-md-10 col-xs-10 col-lg-10">
								<p id="event_expires"></p>
							</div>

						</div>


						</div>
					</div>
					<div class="col-lg-7 col-md-7 col-sm-7 noLftRghtPadding">
						<div class="row">
							<div id="event_desc" class=""></div>
						</div>
						<div class="row">
							<div class="alert"
								id="participant-info"></div>
						</div>
					</div>
				</div>

				</div>
			</div>
				<div class="">
					<div class="ErrMsgDivQuestion" style="display: none"></div>
					<div id="questions_table" data-isSurvey='true'>
						<form role="form">
							<div id="questions_grid"></div>
						</form>
					</div>
				</div>
				<div class="" data-templateId="tmplShowPreview"
					style="display: none">
					<img class="previewIcon" alt="" onerror="this.style.display='none'"><a
						target="_blank" rel="noopener noreferrer" class="previewLink"></a>
					<div class="previewDesc"></div>
				</div>

				<div class="modal-footer viewModelFooter">
					<div class="GridTotalCnt viewTotalCount"></div>
				</div>
			</div>
	</div>
		<div class="PageContent" id="errorDiv" style="display: none">
			<div class="ErrMsgDiv"></div>
	</div>
	<div class="mainContainer modal-footer margins"
				style="border-top: 0px solid #CFC2C2 !important; display: none;">
				<div class="row" style="float: right;">
					<div class="respond-msg" style='margin-bottom: 0'></div>
					<button class="btn btn-primary" id="btn_submit">
						<fmt:message key="Submit" />
					</button>
					<button class="btn btn-material-grey" id="btn_reset">
						<fmt:message key="Reset" />
					</button>
					<button class="btn btn-material-grey" id="btn_cancel">
						<fmt:message key="Cancel" />
					</button>
			</div>
		</div>
		</div>

		<div class="modal fade" id="progressDlg" tabindex="-1" role="dialog"
			aria-labelledby="myModalLabel" aria-hidden="true">
			<div class="modal-dialog model-sm">
				<div class="modal-content">
					<div class="modal-header">
						<button type="button" class="close" data-dismiss="modal"
							aria-hidden="true">&times;</button>
						<h4 class="modal-title" id="modelHeading">
							<fmt:message key="PleaseWait" />
						</h4>
					</div>
					<div class="modal-body">
						<div class="progress">
							<div
								class="progress-bar progress-bar-success progress-bar-striped"
								role="progressbar" aria-valuenow="100" aria-valuemin="0"
								aria-valuemax="100" style="width: 100%"></div>
						</div>
					</div>
				</div>
			</div>
		</div>

		<div id="cancelEventDlg" class="modal fade" tabindex="-1"
			role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
			<div class="modal-dialog modal-md">
				<div class="modal-content">
					<div class="modal-header">
						<button type="button" class="close" data-dismiss="modal">
							<span aria-hidden="true">&times;</span><span class="sr-only">Close</span>
						</button>
						<h4 class="modal-title" id="myModalLabel">
							<fmt:message key="CancelSurveyMessage" />
						</h4>
					</div>
					<div class="modal-body" id="cancelReason">
						<div style="padding: 5px 0px 10px">
							<fmt:message key="SpecifyReason" />
							:
						</div>
						<textarea class="survey-textarea" id="cancelReasonTxt"></textarea>
						<div>
							<input id="intimateCancelChkBox" type="checkbox" />
							<fmt:message key="NotifyParticipants" />
						</div>

					</div>
					<div class="modal-footer" style="margin: 0px 10px 0px;">
						<button type="button" class="btn btn-primary" data-dismiss="modal"
							id="btn_cancel_yes">
							<fmt:message key="Yes" />
						</button>
						<button type="button" class="btn btn-default" data-dismiss="modal">
							<fmt:message key="No" />
						</button>


					</div>
				</div>
			</div>
		</div>

		<div id="responseOverwriteWarning" class="modal fade" tabindex="-1"
			role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
			<div class="modal-dialog modal-md">
				<div class="modal-content">
					<div class="modal-header">
						<button type="button" class="close" data-dismiss="modal">
							<span aria-hidden="true">&times;</span><span class="sr-only">Close</span>
						</button>
						<h4 class="modal-title" id="myModalLabel">
							<fmt:message key="ResponseOverwriteWarning" />
						</h4>
					</div>
					<div class="modal-footer">
						<button type="button" class="btn btn-primary" data-dismiss="modal"
							id="btn_overwrite_yes">
							<fmt:message key="Yes" />
						</button>
						<button type="button" id="btn_overwrite_no" class="btn btn-default" data-dismiss="modal">
							<fmt:message key="No" />
						</button>
					</div>
				</div>
			</div>
		</div>



		<div id="editMail" class="modal fade" tabindex="-1" role="dialog"
			aria-labelledby="editMailLabel" aria-hidden="true">
			<div class="modal-dialog modal-lg">
				<div class="modal-content">
					<div class="modal-header">
						<button type="button" class="close" data-dismiss="modal">
							<span aria-hidden="true">&times;</span><span class="sr-only">Close</span>
						</button>

						<h4 class="modal-title" id="editMailLabel" style="margin-bottom:10px;">
							<fmt:message key="PreviewInvitation" />
						</h4>
						<div id="autocompleteSelecter"
							class="input-group sendMailPreviewDiv sendMailPrevFromFieldHidden"  style="margin-bottom:10px;">
<!-- 							<span class="input-group-addon mailFields"><fmt:message
									key="FromAddress" /></span> -->
							<textarea class="form-control inputTypePadding ui-front floating-label" placeholder='<fmt:message
									key="FromAddress" />' rows=1
								id="fromAddr"
								style="resize: none; padding: 5px 0px 5px 0px !important;">${sessionScope.LOGIN_TOKEN_INFO.smtpAddress}</textarea>
						</div>
						<div class="input-group sendMailPreviewDiv">
	<!-- 						<span class="input-group-addon mailFields"><fmt:message
									key="Subject" /></span>  -->
									<input type="text" class="form-control floating-label" id="emailSubj" value=' ' placeholder='<fmt:message
									key="Subject" />'>
						</div>
					</div>
					<div class="modal-body">
						<label>Message </label>
						<iframe id="previewMailIFrame" src="" width="100.0%"
							frameborder="0" height="350px"></iframe>
					</div>
					<div class="modal-footer ">
						<div class="margins">
							<div class="checkbox checkbox-primary pull-left mailEditCheck">
								<label style="width: auto;"> <input id="editChkBox"
									type="checkbox" />
								<fmt:message key="EditMessage" />
								</label>
							</div>
							<div class="checkbox checkbox-primary pull-left saveEditContentDiv"
								style="margin-top: 0px;">
								<label style="width: auto;"> <input
									class="saveEditContentDiv" id="saveEditContent" type="checkbox">
								<fmt:message key="SaveEditedContent" />
								</label>
							</div>
                        <div class="pull-right">
                            <button type="button" id="btn_send" class="btn btn-raised btn-primary"><fmt:message key="Send" /></button>
                            <button type="button" class="btn btn-raised btn-default"
                                data-dismiss="modal"><fmt:message key="Cancel" /></button>
						</div>
					</div>
				</div>
			</div>
		</div>
	 </div>

		<div id="invMoreDlg" class="modal fade" tabindex="-1" role="dialog"
			aria-labelledby="myModalLabel" aria-hidden="true">
			<div class="modal-dialog modal-lg">
				<div class="modal-content">
					<div class="modal-header">
						<button type="button" class="close" data-dismiss="modal">
							<span aria-hidden="true">&times;</span><span class="sr-only">Close</span>
						</button>
						<h4 class="modal-title" id="myModalLabel">
							<fmt:message key="InviteMoreParticipants" />
						</h4>
					</div>
					<div class="modal-body">
						<div class="form-horizontal">
							<div class="form-group">
								<label for="inputEmail3"
									class="col-sm-3 col-md-3 col-xs-3 col-lg-3 control-label"><fmt:message
										key="InvitedParticipants" /></label>
								<div class="col-offset-1 col-sm-7 col-md-7 col-lg-7 col-xs-6 participants userinput">
									<textarea id="invPartList"
										class="form-control inputTypePadding" rows="5"></textarea>
								</div>
							</div>
							<div class="form-group ">
								<label for="inputEmail3"
									class="col-sm-3 col-md-3 col-xs-3 col-lg-3 control-label"><fmt:message
										key="NewParticipants" /></label>
								<div class="col-offset-1 col-sm-7 col-md-7 col-lg-7 col-xs-6 participants userinput">
									<textarea id="partSuggestBox"
										class="form-control inputTypePadding ui-autocomplete-input"
										rows="5"></textarea>
								</div>
							</div>
						</div>
					</div>

					<div class="modal-footer" style="margin: 0px 10px 0px;">
						<div class="pull-left" style="font-size: 12px; color: green;">
							*
							<fmt:message key="MailOnlyNewlyInvited" />
							.
						</div>
						<button type="button" class="btn btn-primary" data-dismiss="modal"
							id="btn_send_more">
							<fmt:message key="Ok" />
						</button>
						<button type="button" class="btn btn-default" data-dismiss="modal">
							<fmt:message key="Close" />
						</button>


					</div>
				</div>
			</div>
		</div>
	</body>
</fmt:bundle>
<script nonce="${sessionScope.cspNonce}" src="${pageContext.request.contextPath}/cvevents/js/viewEvent.js?${applicationScope.BUILD_TS}"></script>
<script nonce="${sessionScope.cspNonce}" >
	$.material.init();
</script>
<c:if test="${applicationName != null && applicationName == 'webconsole'}" >
	<jsp:include page="/common/footer.jsp">
		<jsp:param value="../common/thirdPartyV2/purify.min.js" name="js" />
	</jsp:include>
</c:if>
