<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@  taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"%>
<c:if test="${!fn:containsIgnoreCase(pageContext.request.contextPath, 'adminconsole')}">
	<jsp:include page="/cvevents/surveysHeader.jsp" />
	<c:set var="applicationName" value="webconsole"></c:set>
</c:if>
<link href="${pageContext.request.contextPath}/common/datatables/css/dataTables.bootstrap.css?${applicationScope.BUILD_TS}" rel="stylesheet" />
<link href="${pageContext.request.contextPath}/common/bootstrap/css/bootstrap.min.css?${applicationScope.BUILD_TS}" rel="stylesheet" />
<link href="${pageContext.request.contextPath}/common/bootstrap/css/bootstrap-wc.css?${applicationScope.BUILD_TS}" rel="stylesheet" />
<link href="${pageContext.request.contextPath}/common/bootstrap/css/icomoon.css?${applicationScope.BUILD_TS}" rel="stylesheet" />
<link href="${pageContext.request.contextPath}/cvevents/css/eventstyles.css?${applicationScope.BUILD_TS}" rel="stylesheet" />
<script id="ResponseTemplate" type="text/x-jquery-tmpl">
	<tr>
		<td class="QuesOption" width="50%"><pre>{{html option}}</pre></td>
		<td>{{each(ii,users) usersParticipated}} {{= users}} {{/each}}</td>
	</tr>
</script>
<body>
<fmt:bundle basename="localization.EventMessages">


<div class="sechead eventpagetitle">
	<div class="clrfloat"></div>
	<div id="secTitleDiv" class="col-lg-6 col-md-6 col-sm-6 col-xs-6" style="padding:0">
			<span id="sectionTitle" class="sectiontitle">
				<a href="../cvevents"><fmt:message key="EventsOrganizer"/></a><i class="ico-keyboard-arrow-right ico-st-title"></i><fmt:message key="ViewResponse"/>
			</span>
		</div>
	<div class="col-lg-6" style="padding-right:0">
		<button class="btn btn-primary pull-right" id="btn_excel">
		<span class="glyphicon glyphicon-export"></span>
		<fmt:message key="ExportSummaryToExcel"/></button>
	</div>
	<div class="clrfloat"></div>
</div>

	<div id="eventID" style="display: none"></div>

	<div class="PageContent" id="mainBody">
		<div class="PageTbl">
		<div id="ajaxBusyMail" class="center_it">
				<img src="../common/img/loader.gif" />
			</div>
			<div id="events_grid" class="respMarginMain margin-top-0" style="display: none;">
				<div class="row">
					<h3 class="event_title margin-left-5">
						<span id="event_title"></span>
					</h3>
				</div>

				<div class="row">
					<div id="event_image" class="backgroundImage"></div>
				</div>
				<div class="row respMarginMain margin-left-5">
					<div class="col-lg-5 col-md-5 col-sm-5 noLeftPadding">
						<div id="event_details" class="eventDetailsStyle">

							<div class="row">
								<label
									class="col-sm-2 col-md-2 col-xs-2 col-lg-2 control-label noLeftPadding"><fmt:message
										key="Host" />:</label>
								<div class="col-sm-10 col-md-10 col-xs-10 col-lg-10">
									<p id="host_name"></p>
								</div>
							</div>
							<div class="row">
								<label
									class="col-sm-2 col-md-2 col-xs-2 col-lg-2 control-label noLeftPadding"><fmt:message
										key="RSVPBy" />:</label>
								<div class="col-sm-10 col-md-10 col-xs-10 col-lg-10">
									<p id="event_expires"></p>
								</div>

							</div>
							<div class="time-venue" style="display:none;">
								<div class="row">
									<label
										class="col-sm-2 col-md-2 col-xs-2 col-lg-2 control-label noLeftPadding"><fmt:message
											key="When" />:</label>
									<div class="col-sm-10 col-md-10 col-xs-10 col-lg-10">
										<p id="event_date_time"></p>
									</div>

								</div>

								<div class="row">
									<label
										class="col-sm-2 col-md-2 col-xs-2 col-lg-2 control-label noLeftPadding"><fmt:message
											key="Where" />:</label>
									<div class="col-sm-10 col-md-10 col-xs-10 col-lg-10">
										<p id="event_location"></p>
									</div>

								</div>
							</div>

						</div>
					</div>
					<div class="col-lg-7 col-md-7 col-sm-7 noLftRghtPadding">
						<div class="row">
							<div id="event_desc" class=""></div>
						</div>
						<div class="row">
							<div class="alert"
								id="participant-info"></div>
						</div>
					</div>
				</div>
			</div>
		</div>

			<!--div class="ErrMsgDiv" style="display: none"></div-->

			<div id="responses_table" class="PageTbl">
				<div id="responses_grid"></div>
			</div>

			<table class="PageTbl BottomBar">
				<tr>
					<td class="GridTotalCnt"></td>
				</tr>

			</table>
		</div>
	</div>
	<div class="PageContent" id="errorDiv" style="display: none">
		<div class="ErrMsgDiv" style='text-align:center;'></div>
	</div>
	<div id="showParticipants" class="dialog" style="display: none">
		<div class="DlgContent">
			<div style="text-align: right" class="DlgCloseBtn"></div>
			<ul id="showParticipantsList" class="DlgContentDiv"></ul>
			<div>
				<div class="dialogStatus"></div>
				<div style="text-align: right;">
					<button id="btn_ok"><fmt:message key="Ok"/></button>
				</div>
			</div>
		</div>
	</div>
	<iframe id="downloadFile" class="" style="display: none;"></iframe>


	<div id="showOption" class="modal fade" tabindex="-1" role="dialog"
		aria-labelledby="optionTitle" aria-hidden="true">
		<div class="modal-dialog modal-md">
			<div class="modal-content">
				<div class="modal-header">
					<button type="button" class="close" data-dismiss="modal">
						<span aria-hidden="true">&times;</span><span class="sr-only">Close</span>
					</button>
					<h4 class="modal-title" id="optionTitle"></h4>
				</div>
				<div class="modal-body">
					<div>
						<img id="optionImageID" class="imageMargins" src=""
							style="display: none;" />
						<iframe id="optionURLID" src="" style="zoom: 0.60;" width="100.0%"
							frameborder="0" height="350px"></iframe>
					</div>
				</div>
				<div class="modal-footer" style="margin: 0px 10px 0px;">
					<button type="button" class="btn btn-primary" data-dismiss="modal"> <fmt:message key="Ok"/> </button><button type="button" class="btn btn-default" data-dismiss="modal"><fmt:message key="Cancel"/></button>
				</div>
			</div>
		</div>
	</div>
	<div class="modal fade" id="participantInfoModel" role="dialog">
    <div class="modal-dialog">
       <div class="modal-content">
        <div class="modal-header">
          <button type="button" class="close" data-dismiss="modal">&times;</button>
          <h4 class="modal-title"><fmt:message key="ParticipantInformation"/></h4>
        </div>
        <div class="modal-body participantDTStyle">
          <div id="participantDTWrapper">
          	<table class="table-bordered dataTable" id="participantDT" style="width:100%;"></table>
          </div>
          <div id="noParticipantMsgWrapper" style="display:none">
          		<b id="noParticipantMsg"><fmt:message key="NoParticipantResponded"/></b>
          </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-default" data-dismiss="modal"><fmt:message key="Close"/></button>
        </div>
       </div>

    </div>
  	</div>
</fmt:bundle>
</body>
	<script nonce="${sessionScope.cspNonce}" src="${pageContext.request.contextPath}/common/js/table/jquery.dataTables-1.10.min.js?${applicationScope.BUILD_TS}" ></script>
	<script nonce="${sessionScope.cspNonce}" src="${pageContext.request.contextPath}/common/js/highcharts/hm.js?${applicationScope.BUILD_TS}" ></script>
	<script nonce="${sessionScope.cspNonce}" src="${pageContext.request.contextPath}/common/datatables/js/dataTables.bootstrap.js?${applicationScope.BUILD_TS}" ></script>
	<script nonce="${sessionScope.cspNonce}" src="${pageContext.request.contextPath}/cvevents/js/viewResponse.js?${applicationScope.BUILD_TS}"></script>
<c:if test="${applicationName != null && applicationName == 'webconsole'}" >
	<jsp:include page="/common/footer.jsp">
		<jsp:param value="../common/thirdPartyV2/purify.min.js" name="js" />
	</jsp:include>
</c:if>
