<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@  taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"%>
<c:if test="${!fn:containsIgnoreCase(pageContext.request.contextPath, 'adminconsole')}">
	<jsp:include page="/cvevents/surveysHeader.jsp" />
	<c:set var="applicationName" value="webconsole"></c:set>
</c:if>
<link href="${pageContext.request.contextPath}/common/css/ckEditor.css?${applicationScope.BUILD_TS}" rel="stylesheet" />
<link href="${pageContext.request.contextPath}/common/bootstrap/css/bootstrap.min.css?${applicationScope.BUILD_TS}" rel="stylesheet" />
<link href="${pageContext.request.contextPath}/common/bootstrap/css/bootstrap-datetimepicker.css"
	rel="stylesheet" />
<link href="${pageContext.request.contextPath}/common/bootstrap/css/bootstrap-tagsinput.css?${applicationScope.BUILD_TS}" rel="stylesheet" />
<link href="${pageContext.request.contextPath}/common/bootstrap/css/bootstrap-wc.css?${applicationScope.BUILD_TS}" rel="stylesheet" />
<link href="${pageContext.request.contextPath}/cvevents/thirdparty/css/jquery-ui-1.10.1.custom.min.css?${applicationScope.BUILD_TS}" rel="stylesheet" />
<link href="${pageContext.request.contextPath}/cvevents/thirdparty/css/ripples.min.css?${applicationScope.BUILD_TS}" rel="stylesheet" />
<link href="${pageContext.request.contextPath}/cvevents/thirdparty/css/material.min.css?${applicationScope.BUILD_TS}" rel="stylesheet" />
<link href="${pageContext.request.contextPath}/common/bootstrap/css/icomoon.css?${applicationScope.BUILD_TS}" rel="stylesheet" />
<link href="${pageContext.request.contextPath}/cvevents/thirdparty/css/owl.theme.css?${applicationScope.BUILD_TS}" rel="stylesheet" />
<link href="${pageContext.request.contextPath}/cvevents/css/surveystyle.css?${applicationScope.BUILD_TS}" rel="stylesheet" />
<link href="${pageContext.request.contextPath}/cvevents/css/eventstyles.css?${applicationScope.BUILD_TS}" rel="stylesheet" />
</head>
<body>
<fmt:bundle basename="localization.EventMessages">
	<div class="sechead eventpagetitle">

		<div id="secTitleDiv" class="col-lg-6 col-md-6 col-sm-6 col-xs-6" style="padding:0">
			<span id="sectionTitle" class="sectiontitle">
				<a href="../cvevents"><fmt:message key="EventsOrganizer"/></a><i class="ico-keyboard-arrow-right ico-st-title"></i><span class="newpagetitle"><fmt:message key="NewSurvey"/></span>
			</span>
		</div>
		<div class="col-xs-6 col-sm-6 col-md-6 col-lg-6 sur-hide" style='text-align:right; padding: 0; margin:-16px 0 -14px 0'>
			<button type="button" class="btn btn-primary" class="btn-save-survey"><fmt:message key="Save"/></button>
			<button type="button" class="btn btn-default" class="btn-cancel"><fmt:message key="Cancel"/></button>
		</div>
		<div class="clrfloat"></div>
	</div>
	<div ng-app='surveyApp' ng-controller="newcontroller" class='survey-container'>
		<div class="sur-hide" id="surveyID"></div>
		<div class="survey-details">
			<div class="row noMarginLftRght">
				<div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 sur-box-title">
					<h4 class="sur-hide"><fmt:message key="SurveyDetails"/></h4>
				</div>
				<div class="col-xs-12 col-sm-12 col-md-12 col-lg-12" style="padding:0;">
					<form action="" method="POST" class="form-horizontal" role="form">
							<div id="surveyImageWrapper" class="hidden margin-bottom-30 form-group">

	    						<div id='surveyDefaultImgDiv'><img id="themeImage" src="img/themes/theme-survey.jpg" class="defaultImgDivStyle"/>
	    						</div>

		    						<div id="image-cropper" class="hidden">

									  <div class="cropit-preview"></div>
									  <input type="range" class="cropit-image-zoom-input hidden" />
									</div>


	    						<div class="themeBtnWrapperStyle"><input type="button" class="btn btn-default btn-sm themeBtnStyle" value='<fmt:message key="ChooseTheme"/>' data-toggle="modal" data-target="#surveyImageModal" ng-click="getThemeDefaultImages()"></div>

	    						<div id="zoomBtnsWrapper" class="zoomBtnWrapperStyle hidden">
					                <div class="btn btn-default btn-zoom-in zoomBtnStyle" ng-mousedown="startZoomIn()" ng-mouseup="stopZoomIn()" title='<fmt:message key="ZoomIn"/>'>
					                        <i class="glyphicon glyphicon-resize-full"></i>
					                </div>
					                <div class="btn btn-default btn-zoom-out zoomBtnStyle" ng-mousedown="startZoomOut()" ng-mouseup="stopZoomOut()" title='<fmt:message key="ZoomOut"/>'>
					                        <i class="glyphicon glyphicon-resize-small"></i>
					                </div>
								</div>

							</div>
							<div id="loader" class="center_it heightStyle">
								<img src="../common/img/loader.gif" />
							</div>
							<div class="form-group">
	    						<input class="form-control floating-label" value="" name="surveyTitle" id="surveyTitle" type="text" placeholder='<fmt:message key="SurveyTitle"/>' ng-model="form1[0].surveytitle" autofocus>
							</div>
							<div class="form-group">
								<label for="surveyDesc" class="survey-desc-label"><fmt:message key="SurveyDescription"/></label>
	    						<textarea value="" name="surveyDesc" id="surveyDesc"  rows='1'></textarea>
							</div>
					</form>
				</div>
			</div>
		</div>
		<div class="survey-questions">
			<div class="row noMarginLftRght">
				<div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 sur-box-title">
					<h4 class="sur-hide"><fmt:message key="Questions"/></h4>
				</div>
		        <question-types pos='left' addquestion='addquestion(questionType)' ishideeverything='ishideeverything' form1='form1'></question-types>
		        <question-drop addquestion='addquestion(questionType)' ishideeverything='ishideeverything' form1='form1'></question-drop>
		    </div>
		</div>
		<div class="survey-other-details" style='padding: 15px;padding-top:0;'>
			<div class="row noMarginLftRght">
				<div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 sur-box-title">
					<h4 class="sur-hide"><fmt:message key="Invite"/></h4>
				</div>
				<div class="col-xs-12 col-sm-12 col-md-12 col-lg-12" style="padding:0;">
					<form action="" class="form-horizontal" role="form">
							<div class="form-group">
	    						<div class="input-group date col-xs-12 col-sm-10 col-md-6 col-lg-4" id="survey_expiry">
									<input type="text" class="form-control floating-label inputTypePadding dateTimePickerObj" id='surveyRSVP' placeholder='RSVP By'  ng-model="form1[0].surveyExpiry"/>
									<span class="input-group-addon">
										<button type="button" class="btn btn-fab btn-fab-mini" style="margin-top:-15px">
											<i class="mdi-notification-event-available"></i>
										</button>
									</span>
								</div>
							</div>
							<div class="form-group userinput organizers">
								<div class="select-template-label"><fmt:message key="Organizers" /></div>
								<c:if test="${applicationName != null && applicationName == 'webconsole'}" >
									<textarea name="" class="form-control" rows="1"  id='orgSuggestBox' spellcheck="false">${sessionScope.username}(${sessionScope.LOGIN_TOKEN_INFO.smtpAddress}),</textarea>
								</c:if>
	    						<c:if test="${applicationName == null}" >
									<textarea name="" class="form-control" rows="1"  id='orgSuggestBox' spellcheck="false">${loginContext.userInfo.userName}(${loginContext.userInfo.smtpAddress}),</textarea>
								</c:if>
							</div>
							<div class="form-group userinput participants">
								<div class="select-template-label">
									<span><fmt:message key="Participant" /></span>
									<a class="btn btn-info btn-fab ico ico-copy" id="orgcopy" title='<fmt:message key="AddOrganizersToParticipantsList" />'></a>
								</div>
								<textarea name="" value="" class="form-control" rows="1" id='partSuggestBox' spellcheck="false"></textarea>
							</div>
							<div class="form-group">
								<div class="togglebutton login-required">
						          <label>
						            <fmt:message key="Signinrequired" />   <input type="checkbox" id='loginRequired' checked>
						          </label>
						        </div>
						        <div class="login-warning item-hide"><fmt:message key="DisableLoginRequiredMsg" /></div>
							</div>
					</form>
				</div>
			</div>
		</div>
	    <div class='sur-hide'><pre>{{form1 | json}}</pre></div>
	    <div class="survey-footer">
	    	<div class="pull-left">
		    	<button type="button" class="btn btn-raised btn-material-light-blue btn-preview-survey" ng-click="savesurvey(false,true)"><fmt:message key="Preview"/></button>
	    		<button type="button" class="btn btn-raised btn-material-light-blue btn-save-draft-survey" ng-hide='!form1[0].isDraft&&form1[0].surveyStatus=="edit"' ng-click="savesurvey(true,false)"><fmt:message key="SaveAsDraft"/></button>
	    		<div class="draft-save-message"></div>
	    	</div>
		    <div class="pull-right">
		    	<button type="button" class="btn btn-raised btn-primary btn-save-survey" ng-click="savesurvey(false,false)"><fmt:message key="Save"/></button>
				<button type="button" class="btn btn-raised btn-default btn-cancel" ng-click="cancelsurvey()"><fmt:message key="Cancel"/></button>
			</div>
	    </div>
	    <div class="modal fade" id="surveyImageModal" role="dialog">
		  <div class="modal-dialog">
		    <div class="modal-content">
		      <div class="modal-header">
		        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
		        <h4 class="modal-title"><fmt:message key="ChooseTheme"/></h4>
		      </div>
		      <div class="modal-body" class="modalBodyStyle">
		      	<div id='theme-Image' class="theme-image-section-scroll-y">
		       	</div>

			  </div>

		    </div>
		  </div>
		</div>
    </div>


    <canvas id="imageCanvas" style="display: none"></canvas>
    <div class="modal fade" id="progressDlg" tabindex="-1" role="dialog"
			aria-labelledby="myModalLabel" aria-hidden="true">
			<div class="modal-dialog model-sm">
				<div class="modal-content">
					<div class="modal-header">
						<button type="button" class="close" data-dismiss="modal"
							aria-hidden="true">&times;</button>
						<h4 class="modal-title" id="modelHeading">
							<fmt:message key="PleaseWait" />
						</h4>
					</div>
					<div class="modal-body">
						<div class="progress">
							<div
								class="progress-bar progress-bar-success progress-bar-striped active"
								role="progressbar" aria-valuenow="100" aria-valuemin="0"
								aria-valuemax="100" style="width: 100%"></div>
						</div>
					</div>
				</div>
			</div>
	</div>
	</div>
	<div class="modal fade" id="editSurveyQues" tabindex="-1" role="dialog"
			aria-labelledby="editLabelModal" aria-hidden="true">
	  <div class="modal-dialog">
	    <div class="modal-content">
	      <div class="modal-header">
	        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
	        <h4 class="modal-title"><fmt:message key='ResponseDeletionWarning'/></h4>
	      </div>
	      <div class="modal-footer">
	        <button type="button" id="btn_edit_yes" class="btn btn-primary"><fmt:message key="Yes" /></button>
	        <button type="button" id="btn_edit_no" class="btn btn-default"  data-dismiss="modal"><fmt:message key="No" /></button>
	      </div>
	    </div>
	  </div>
	</div>
	<div class="modal fade" id="deleteSurveyQues" tabindex="-1" role="dialog"
			aria-labelledby="editLabelModal" aria-hidden="true">
	  <div class="modal-dialog">
	    <div class="modal-content">
	      <div class="modal-header">
	        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
	        <h4 class="modal-title"><fmt:message key='DEL_QUES_CONFIRM'/></h4>
	      </div>
	      <div class="modal-footer">
	        <button type="button" id="btn_delete_yes" class="btn btn-primary"><fmt:message key="Yes" /></button>
	        <button type="button" id="btn_delete_no" class="btn btn-default"  data-dismiss="modal"><fmt:message key="No" /></button>
	      </div>
	    </div>
	  </div>
	</div>
	<div id="editMail" class="modal fade" tabindex="-1" role="dialog"
			aria-labelledby="editMailLabel" aria-hidden="true">
			<div class="modal-dialog modal-lg">
				<div class="modal-content">
					<div class="modal-header">
						<button type="button" class="close" aria-hidden="true">&times;</button>
						<h4 class="modal-title" id="editMailLabel" style="margin-bottom:10px;">
							<fmt:message key="PreviewInvitation" />
						</h4>
						<div id="autocompleteSelecter"
							class="input-group sendMailPreviewDiv sendMailPrevFromFieldHidden" style="margin-bottom:10px;">
<!-- 							<span class="input-group-addon mailFields"><fmt:message
									key="FromAddress" /></span> -->
							<textarea class="form-control inputTypePadding ui-front floating-label" placeholder='<fmt:message
									key="FromAddress" />' rows="1" id="fromAddr" style="resize: none; padding: 5px 0px 5px 0px !important;">${sessionScope.LOGIN_TOKEN_INFO.smtpAddress}</textarea>
						</div>
						<div class="input-group sendMailPreviewDiv">
							<!-- <span class="input-group-addon mailFields"><fmt:message
									key="Subject" /></span> -->
									<input type="text" class="form-control floating-label"
								id="emailSubj" value=' ' placeholder='<fmt:message
									key="Subject" />'>
						</div>
					</div>
					<div class="modal-body">
						<label><fmt:message key="Message"/> </label>
						<iframe id="previewMailIFrame" src="" width="100.0%"
							frameborder="0" height="350px"></iframe>
					</div>
					<div class="modal-footer ">
						<div class="margins">
							<div class="checkbox checkbox-primary pull-left mailEditCheck">
								<label style="width: auto;"> <input id="editChkBox"
									type="checkbox" />
								<fmt:message key="EditMessage" />
								</label>
							</div>
							<div class="checkbox checkbox-primary pull-left saveEditContentDiv"
								style="margin-top: 0px;">
								<label style="width: auto;"> <input
									class="saveEditContentDiv" id="saveEditContent" type="checkbox">
								<fmt:message key="SaveEditedContent" />
								</label>
							</div>
							<div class="pull-right">
								<button type="button" id="btn_send" class="btn btn-raised btn-primary"><fmt:message key="Invite" /></button>
								<button type="button" class="btn btn-raised btn-default"
									data-dismiss="modal"><fmt:message key="Cancel" /></button>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>

</fmt:bundle>
</body>
<c:if test="${applicationName != null && applicationName == 'webconsole'}" >
	<jsp:include page="/common/footer.jsp">
		<jsp:param value="../common/thirdPartyV2/purify.min.js" name="js" />
	</jsp:include>
</c:if>
