<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@  taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"%>
<jsp:include page="../common/header.jsp">
	<jsp:param value="CvEvents_Header" name="title" />
	<jsp:param value="../common/css/headerstyles.css" name="css" />
	<jsp:param value="true" name="includeLatestJquery" />
	<jsp:param value="CvEvents_Header" name="title" />
	<jsp:param value="CvEvents_Header" name="headerTitle" />
	<jsp:param value="thirdparty/css/owl.theme.css" name="css" />
	<jsp:param value="thirdparty/css/fuelux.css" name="css" />
	<jsp:param value="../common/bootstrap/css/bootstrap.min.css" name="css" />
	<jsp:param value="thirdparty/css/jquery-ui-1.10.1.custom.min.css"
		name="css" />
	<jsp:param value="../common/bootstrap/css/bootstrap-tagsinput.css"
		name="css" />
	<jsp:param value="../common/bootstrap/css/bootstrap-datetimepicker.css"
		name="css" />
	<jsp:param value="../common/bootstrap/css/bootstrap-wc.css" name="css" />

	<jsp:param value="../common/bootstrap/css/icomoon.css" name="css" />

	<jsp:param value="../common/css/ckEditor.css" name="css" />
	<jsp:param value="css/eventstyles.css" name="css" />

</jsp:include>
<jsp:include page="localization.jsp"/>
<c:set var="eventsOrgFeatures" value="${requestScope.eventsOrgFeatures}"/>
<script nonce="${sessionScope.cspNonce}" >
var eventsOrgs={};

eventsOrgs="${requestScope.eventsOrgFeatures}";
featuresEnabled={};
featuresEnabled.event=true;
featuresEnabled.proposal=true;
featuresEnabled.survey=true;

if(eventsOrgs.trim()!=""){
if(eventsOrgs.indexOf("meetup")==-1)
	featuresEnabled.proposal=false;

if(eventsOrgs.indexOf("event")==-1)
	featuresEnabled.event=false;

if(eventsOrgs.indexOf("survey")==-1)
	featuresEnabled.survey=false;
}
</script>
<meta name="description"
	content="Events Organizer helps to create,organize and participant events combined with survey.">
<style type="text/css">
<!--
[if lte IE 9]>.txtFldWdthIE {
	width: 96%;
}
<!
[
endif
]


-->
</style>
<script nonce="${sessionScope.cspNonce}" >
	var b = document.documentElement;
	b.setAttribute('data-useragent', navigator.userAgent);
</script>
</head>
<fmt:bundle basename="localization.EventMessages">
	<div class="sechead eventpagetitle">

		<div id="secTitleDiv" class="col-lg-6 col-md-6 col-sm-6 col-xs-6" style="padding:0">
			<span id="sectionTitle" class="sectiontitle">
				<a href="../cvevents"><fmt:message key="EventsOrganizer"/></a><i class="ico-keyboard-arrow-right ico-st-title"></i><span class="newpagetitle"></span>
			</span>
		</div>
		<div class="clrfloat"></div>
	</div>
<body>

		<div id='hiddenDiv' style="display: none"></div>
		<div class="contentBdr">
			<div class="PageContent errorDiv" style="display: none">
				<div class="ErrMsgDiv" style="display: none"></div>
				<div class="goBackLink">
					<fmt:message key="ClickToViewEventsAndMeetups">
						<fmt:param value="<a href='../cvevents'>" />
						<fmt:param value="</a>" />
					</fmt:message>.
				</div>
			</div>
			<div class="mainContainer">
				<div class="fuelux">
					<div class="wizard">
						<ul class="steps">
							<li id="themeLi"
								class="active col-md-3 cols-lg-3 col-sm-6 col-xs-6"
								data-accordion="#collapseOne"><span
								class="badge badge-info">1</span>
							<fmt:message key="ChooseTheme" /><span class="chevron"></span></li>
							<li id="eventDetailLi"
								class="col-md-3 cols-lg-3 col-sm-6 col-xs-6"
								data-accordion="#collapseTwo"><span class="badge">2</span>
							<fmt:message key="EventDetails" /><span class="chevron"></span></li>
							<li id="QuesDetailLi"
								class="col-md-3 cols-lg-3 col-sm-6 col-xs-6"
								data-accordion="#collapseThree"><span class="badge">3</span>
							<fmt:message key="QuestionDetails" /><span class="chevron"></span></li>
							<li id="PartDetailLi"
								class="col-md-3 cols-lg-3 col-sm-6 col-xs-6"
								data-accordion="#collapseFour"><span class="badge">4</span>
							<fmt:message key="ParticipantDetails" /><span class="chevron"></span></li>
						</ul>
					</div>
				</div>
				<div class="panel-group" id="accordion">
					<div class="panel panel-default panel-active">
						<div id="collapseOne" class="panel-collapse collapse">
							<div class="panel-body padding-bottom-0">
								<div class="row height-300">
									<div id="eventImageWrapper" class="hidden margin-bottom-0 form-group">

			    						<div id='eventDefaultImgDiv'><img id="themeImage" src="img/themes/theme-default.jpg" class="defaultImgDivStyle"/>
			    						</div>

				    						<div id="image-cropper" class="hidden">

											  <div class="cropit-preview"></div>
											  <input type="range" class="cropit-image-zoom-input hidden" />
											</div>


			    						<div class="themeBtnWrapperStyle"><input id="chooseThemeBtn" type="button" class="btn btn-default btn-sm themeBtnStyle" value='<fmt:message key="ChooseTheme"/>' data-toggle="modal" data-target="#eventImageModal"></div>

			    						<div id="zoomBtnsWrapper" class="zoomBtnWrapperStyle hidden">
							                <div id="zoomInBtn" class="btn btn-default btn-zoom-in zoomBtnStyle" ng-mousedown="startZoomIn()" title='<fmt:message key="ZoomIn"/>'>
							                        <i class="glyphicon glyphicon-resize-full"></i>
							                </div>
							                <div id="zoomOutBtn" class="btn btn-default btn-zoom-out zoomBtnStyle" ng-mousedown="startZoomOut()" ng-mouseup="stopZoomOut()" title='<fmt:message key="ZoomOut"/>'>
							                        <i class="glyphicon glyphicon-resize-small"></i>
							                </div>
										</div>

									</div>
									<div id="loader" class="center_it heightStyle">
										<img src="../common/img/loader.gif" />
									</div>
											<!-- <div id="theme-Image" class="owl-carousel"></div> -->

								</div>
							</div>
						</div>
					</div>
					<div class="panel panel-default" style="display: none;">
						<div id="collapseTwo" class="panel-collapse collapse">
							<div class="panel-body">
								<form class="form-horizontal">
									<input type="hidden" id="eventID">
									<div class="form-group">
										<label class="col-lg-2 control-label"> <fmt:message
												key="EventTitle" />
										</label>
										<div class="col-lg-10">
											<input class="form-control" type="text" id="EventTitle" placeholder='<fmt:message key="EventTitle" />' title='<fmt:message key="EventTitle" />' >
										</div>
									</div>


									<div class="form-group">
										<label class="col-lg-2 control-label"> <fmt:message
												key="EventDescription" />
										</label>
										<div class="col-lg-10 CvCkEditor">
											<textarea class="form-control inputTypePadding" rows=5
												id="event_desc" placeholder='AboutTheEvent'
												title='<fmt:message key="EventDetails" />'></textarea>
										</div>
									</div>

							<!-- 		<div class="form-group">
										<label class="col-lg-2 control-label"> Event Tags </label>
										<div class="col-lg-10">
											<input class="form-control" type="text" id="EventTags"
												placeholder="tags" title="Event Tags" data-role="tagsinput">
											<div id="tagss" style="margin-top: 8px"></div>
										</div>


									</div> -->

									<div class="form-group">
										<label class="col-md-2 col-lg-2 control-label"> <fmt:message
												key="EventStartTime" />
										</label>
										<div class="col-md-3 col-lg-3 col-xl-3">
											<div class='input-group date' id='event_schedule'>
												<input type='text'
													class="form-control inputTypePadding dateTimePickerObj"
													placeholder='<fmt:message key="EventStartTime" />' /> <span
													class="input-group-addon"><span
													class="glyphicon glyphicon-calendar"></span> </span>
											</div>
										</div>
									</div>
									<div class="form-group">
										<label class="col-md-2 col-lg-2 control-label"> <fmt:message
												key="EventEndTime" />
										</label>
										<div class="col-md-3 col-lg-3 col-xl-3">
											<div class='input-group date' id='event_schedule_end'>
												<input type='text'
													class="form-control inputTypePadding dateTimePickerObj"
													placeholder='<fmt:message key="EventEndTime" />' /> <span
													class="input-group-addon"><span
													class="glyphicon glyphicon-calendar"></span> </span>
											</div>
										</div>
									</div>

									<div class="form-group">
										<label class="col-md-2 col-lg-2 control-label"> <fmt:message
												key="EventVenue" />
										</label>
										<div class="col-md-3 col-lg-3 col-xl-3">
											<div class="input-group">
												<input type="text" class="form-control inputTypePadding "
													placeholder='<fmt:message key="Location" />' title='<fmt:message key="Location" />' id="event_location" />
												<span class="input-group-addon"><span
													class="glyphicon glyphicon-map-marker"></span> </span>
											</div>
										</div>
									</div>

									<div class="form-group">
										<label class="col-md-2 col-lg-2 control-label"> <fmt:message
												key="RSVPBy" />
										</label>
										<div class="col-md-3 col-lg-3 col-xl-3">
											<div class="input-group date" id="event_expiry">
												<input type="text"
													class="form-control inputTypePadding dateTimePickerObj"
													placeholder='<fmt:message key="RSVPBy" />' /> <span class="input-group-addon"><span
													class="glyphicon-calendar glyphicon"></span></span>
											</div>
										</div>
									</div>

									<div class="form-group">
										<label class="col-lg-2 control-label"> <fmt:message
												key="GuestsAllowed" />
										</label>
										<div class="col-lg-4">
											<div class="input-group col-sm-4 col-xs-6">
												<input id="guestAllowedCheckBox" type="checkbox"
													class="cvToggle"><label for="guestAllowedCheckBox"></label>
											</div>
										</div>
									</div>

									<div class="form-group">

										<div class="alert alert-info" id="msgOrg">
											<strong><fmt:message key="HeadsUp" />!</strong>
											<fmt:message key="DefaultOrganizerMessage" />
											<button type="button" id="btnEditOrg"
												class="btn btn-default btnMarginRight">
												<fmt:message key="ClickEditAddMore" />
											</button>
										</div>
										<div class="alert alert-success" id="msgOrgDone"
											style="display: none">
											<button type="button" class="close" data-dismiss="alert"
												style="margin-top: -5px">&times;</button>
											<strong><fmt:message key="DoneWithExclamation" /></strong>
											<fmt:message key="AddMoreOrganizers" />
										</div>
										<label class="col-lg-2 control-label orgSuggestBoxLabel"
											style="display: none"> <fmt:message key="Organizers" />
										</label>
										<div class="col-lg-10 userinput organizers">
											<textarea class="form-control inputTypePadding" rows=3
												id="orgSuggestBox"
												placeholder='<fmt:message key="OrganizerPlaceholder" />'
												style="display: none" title='<fmt:message key="Organizer" /><fmt:message key="S" />'>${sessionScope.username}(${sessionScope.LOGIN_TOKEN_INFO.smtpAddress}),</textarea>
										<c:if test="${fn:contains(eventsOrgFeatures,'meetup')}">
											<a id="createGroupOrg"
												class="btn btn-default create-group-btn"
												style="display: none; margin-top: 5px;"><span
												class="glyphicon glyphicon-user"
												style="font-size: 11px; margin: 0 0px 0 0;"></span><span
												class="glyphicon glyphicon-user"
												style="margin: 0px 9px 0 -4px; font-size: 14px;"></span><fmt:message key="NewGroup" /></a>
										</c:if>
										</div>
									</div>
								</form>
							</div>
						</div>
					</div>
					<div class="panel panel-default" style="display: none;">
						<div id="collapseThree" class="panel-collapse collapse">
							<div class="panel-body">
								<div class="panel-group" id="accordionQuestions"></div>
							</div>
						</div>
					</div>
					<div class="panel panel-default" style="display: none;">
						<div id="collapseFour" class="panel-collapse collapse">
							<div class="panel-body">
								<form class="form-horizontal">
									<%-- <div class="form-group">
										<label class="col-lg-2 control-label"> <fmt:message
												key="Visibility" /> (<span id="visibilityType"><fmt:message
													key="Public" /></span>)
										</label>
										<div class="col-lg-4">
											<div class="input-group col-sm-4 col-xs-6"
												style="margin-top: 15px">
												<input id="visibility" type="checkbox" class="cvToggle"><label
													for="visibility"></label>
											</div>

										</div>
									</div> --%>

									<div class="form-group">

										<div class="alert alert-info" id="msgCopyOrg">
											<strong>Heads up!</strong>
											<fmt:message key="OrganizersNotAddedToParticipants" />
											.
											<button type="button" id="btnCopyOrg"
												class="btn btn-default btnMarginRight">
												<fmt:message key="ClickToAdd" />
											</button>
										</div>
										<div class="alert alert-success" id="msgCopyOrgDone"
											style="display: none">
											<button type="button" class="close" data-dismiss="alert"
												style="margin-top: -5px">&times;</button>
											<strong><fmt:message key="DoneWithExclamation" /></strong>
											<fmt:message key="OrganizersAddedToParticipants" />
											.
										</div>
										<label class="col-lg-2 control-label partSuggestBoxLabel"> <fmt:message key="Participant" />
										</label>
										<div class="col-lg-10 participants userinput">
											<textarea class="form-control inputTypePadding" rows=3
												id="partSuggestBox"
												placeholder='<fmt:message key="ParticipantPlaceholder" />'
												title='<fmt:message key="ParticipantTitle" />'></textarea>
										<c:if test="${fn:contains(eventsOrgFeatures,'meetup')}">
											<a id="createGroupPart"
												class="btn btn-default create-group-btn"
												style="margin-top: 5px;"><span
												class="glyphicon glyphicon-user"
												style="font-size: 11px; margin: 0 0px 0 0;"></span><span
												class="glyphicon glyphicon-user"
												style="margin: 0px 9px 0 -4px; font-size: 14px;"></span>New
												group</a>
										</c:if>
										</div>
									</div>
									<div class="form-group">
										<label class="col-lg-2 control-label"> <fmt:message key="Signinrequired" /> </label>
										<div class="col-lg-10">
											<div class="input-group col-sm-4 col-xs-6">
												<input id="loginRequired" type="checkbox" class="cvToggle" checked="checked">
												<label for="loginRequired"></label>
											</div>
											<div class="login-warning item-hide"><fmt:message key="DisableLoginRequiredMsg" /></div>
										</div>
									</div>
								</form>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>

		<div class="mainContainer form-actions btmBtnAlign">
			<div class="row noMarginLftRght">
				<div class="pull-left">
					<button class="btn btn-primary" id="btnPreview"><fmt:message key="Preview" /></button>
					<button class="btn btn-primary" id="btnDraft"><fmt:message key="SaveAsDraft" /></button>
				</div>
				<div class="pull-right">
					<button id="btnPrv" class="btn btn-default btn-prev"
						data-accordion="" disabled=""><fmt:message key="Previous" /></button>
					<button id="btnNext" class="btn btn-success btn-next"
						data-accordion="#collapseTwo"><fmt:message key="Next" /></button>
					<button class="btn btn-success" id="btnSave" style="display: none"><fmt:message key="Save" /></button>
					<button class="btn btn-default" id="btnCancel"><fmt:message key="Cancel" /></button>
				</div>
			</div>
			<div class="pull-left" id="eventDraft" style="display: none"></div>
		</div>
		<div class="panel panel-default accordion-group"
			data-templateId="tmplQuestion" style="display: none">
			<div class="panel-heading" data-toggle="collapse">
				<div class="panel-title titleAlign">
					<div class="accordion-toggle" data-toggle="collapse"></div>
				</div>
				<div class="btn-group pull-right btnQuestionGroup">
					<button class="btn btn-primary btnEditQues gropubtnAlign"
						style="display: none;"><fmt:message key="Edit" /></button>
					<button class="btn btn-primary btnAddQues gropubtnAlign">
						<fmt:message key="AddNew" />
					</button>
					<button class="btn btn-primary btnDelQues gropubtnAlign">
						<fmt:message key="Delete" />
					</button>
				</div>
			</div>

			<div class="accordion-body panel-collapse collapse in">
				<div class="panel-body">
					<form class="form-horizontal formQuestions">
						<div class="form-group">
							<div class="col-lg-10">
								<input class="form-control inputTypePadding inputQuesTitle"
									type="text" placeholder='<fmt:message key="QuestionTitle" />' title='<fmt:message key="QuestionTitle" />'>
							</div>
						</div>
						<div class="form-group">
							<div class="">
								<div class="btn-group">
									<button class="btn btn-primary dropdown-toggle btnQuestions"
										data-toggle="dropdown">
										<fmt:message key="ChooseQuestionType" />
										<span class="caret"></span>
									</button>
									<ul class="dropdown-menu menuQuestions">
										<li><a data-quesType="1"><fmt:message key="Choice" /></a></li>
										<li><a data-quesType="2"><fmt:message
													key="CheckBoxes" /></a></li>
										<li><a data-quesType="3"><fmt:message
													key="SimpleText" /></a></li>
										<li><a data-quesType="4"><fmt:message key="LargeText" /></a></li>
									</ul>
								</div>
							</div>
						</div>
					</form>
					<div class="row-fluid">
						<div class="col-md-10">
							<form class="form-horizontal formOptions"></form>
						</div>
					</div>

				</div>
			</div>
		</div>
	  </div>
		<div class="form-group" data-templateId="tmplMultiValueOption"
			style="display: none" data-isDefault="false">
			<div class="questionOption">
				<div class="input-group col-md-12 col-sm-12 col-lg-12 col-xs-12">
					<span class="input-group-addon noBdr-bg"> <input
						type="radio" class="multioption optionType_1"
						style="display: none" title='<fmt:message key="SetAsDefault" />'> <input
						type="checkbox" class="multioption optionType_2"
						style="display: none" title='<fmt:message key="SetAsDefault" />'>
					</span> <input
						class="form-control inputTypePadding inputOptionTitle txtFldWdth"
						type="text" placeholder='<fmt:message key="OptionTitle" />' title='<fmt:message key="OptionTitle" />'>
					<input class="inputFile" type="file"
						accept="image/gif, image/jpeg, image/png"
						placeholder='<fmt:message key="SelectAnImage" />' style="display: none"> <span
						class="input-group-addon optBtn" title='<fmt:message key="AddImage" />'
						data-optionAction="add_image"><i
						class="glyphicon glyphicon-upload"></i></span> <span
						class="input-group-addon optBtn" title='<fmt:message key="AddLink" />'
						data-optionAction="add_link"><i
						class="glyphicon glyphicon-globe"></i></span> <span
						class="input-group-addon optBtn" title='<fmt:message key="AddNewOption" />'
						data-optionAction="add_new"><i
						class="glyphicon glyphicon-plus"></i></span> <span
						class="input-group-addon optBtn" title='<fmt:message key="DeleteThisOption" />'
						data-optionAction="del_opt"><i
						class="glyphicon glyphicon-trash"></i></span>
				</div>

			</div>
		</div>
		<canvas id="imageCanvas" style="display: none">
					</canvas>
		<div
			class="col-md-12 col-sm-12 col-lg-12 col-xs-12 optionPreview optionUrlField"
			data-templateId="tmplUrlInputField"
			style="display: none; margin-left: 0px; width: 100%;">
			<div class="removePreview removeBtn" title='<fmt:message key="Remove" />'></div>

			<input class="form-control inputTypePadding inputUrlField"
				type="text" placeholder='<fmt:message key="UrlPlaceholder" />'>
			<div class="optionPreviewPane"></div>
		</div>

		<div
			class="col-md-12 col-sm-12 col-lg-12 col-xs-12 optionPreview optionFileField"
			data-templateId="tmplImagePreviewField"
			style="display: none; margin-left: 0px;">
			<div class="removePreview removeBtn" title="<fmt:message key="Remove" />" ></div>
			<div class="optionPreviewPane"></div>
		</div>
		<div class="" data-templateId="tmplShowPreview" style="display: none">
			<img class="previewIcon" alt="" onerror="this.style.display='none'"><a
				target="_blank" rel="noopener noreferrer" class="previewLink"></a>
			<div class="previewDesc"></div>
		</div>
		</div>
		<div id="progressDialog" class="modal hide" data-backdrop="static">
			<div class="modal-body">
				<div class="progress progress-striped active">
					<div class="bar" style="width: 100%;"></div>
				</div>
				<div class="progressMsg"><fmt:message key="Saving" />...</div>
			</div>
		</div>
		<div class="modal fade" id="eventImageModal" role="dialog">
		  <div class="modal-dialog">
		    <div class="modal-content">
		      <div class="modal-header">
		        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
		        <h4 class="modal-title"><fmt:message key="ChooseTheme"/></h4>
		      </div>
		      <div class="modal-body" class="modalBodyStyle">
		      	<div id='theme-Image' class="theme-image-section-scroll-y">
		       	</div>

			  </div>

		    </div>
		  </div>
		</div>


		<div id="editMail" class="modal fade" tabindex="-1" role="dialog"
			aria-labelledby="editMailLabel" aria-hidden="true">
			<div class="modal-dialog modal-lg">
				<div class="modal-content">
					<div class="modal-header">
						<button type="button" class="close" aria-hidden="true">&times;</button>
						<h4 class="modal-title" id="editMailLabel">
							<fmt:message key="PreviewInvitation" />
						</h4>
						<div id="autocompleteSelecter"
							class="input-group sendMailPreviewDiv sendMailPrevFromFieldHidden">
							<span class="input-group-addon mailFields"><fmt:message
									key="FromAddress" /></span>
							<textarea class="form-control inputTypePadding ui-front" rows=1
								id="fromAddr"
								style="resize: none; padding: 5px 0px 5px 10px !important;">${sessionScope.LOGIN_TOKEN_INFO.smtpAddress}</textarea>
						</div>
						<div class="input-group sendMailPreviewDiv">
							<span class="input-group-addon mailFields"><fmt:message
									key="Subject" /></span> <input type="text" class="form-control"
								id="emailSubj">
						</div>
					</div>
					<div class="modal-body">
						<label>Message </label>
						<iframe id="previewMailIFrame" src="" width="100.0%"
							frameborder="0" height="350px"></iframe>
					</div>
					<div class="modal-footer ">
						<div class="margins">
							<div class="checkbox pull-left mailEditCheck">
								<label style="width: auto;"> <input id="editChkBox"
									type="checkbox" />
								<fmt:message key="EditMessage" />
								</label>
							</div>
							<div class="checkbox pull-left saveEditContentDiv"
								style="margin-top: 0px;">
								<label style="width: auto;"> <input
									class="saveEditContentDiv" id="saveEditContent" type="checkbox">
								<fmt:message key="SaveEditedContent" />
								</label>
							</div>
							<div class="pull-right">
								<button type="button" id="btn_send" class="btn btn-primary"><fmt:message key="Invite" /></button>
								<button type="button" class="btn btn-default"
									data-dismiss="modal"><fmt:message key="Cancel" /></button>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>

		<div class="modal fade" id="progressDlg" tabindex="-1" role="dialog"
			aria-labelledby="myModalLabel" aria-hidden="true">
			<div class="modal-dialog model-sm">
				<div class="modal-content">
					<div class="modal-header">
						<button type="button" class="close" data-dismiss="modal"
							aria-hidden="true">&times;</button>
						<h4 class="modal-title" id="modelHeading">
							<fmt:message key="PleaseWait" />
						</h4>
					</div>
					<div class="modal-body">
						<div class="progress">
							<div
								class="progress-bar progress-bar-success progress-bar-striped active"
								role="progressbar" aria-valuenow="100" aria-valuemin="0"
								aria-valuemax="100" style="width: 100%"></div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<div id="cancelEventDlg" class="modal fade" tabindex="-1"
			role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
			<div class="modal-dialog modal-md">
				<div class="modal-content">
					<div class="modal-header">
						<button type="button" class="close" data-dismiss="modal">
							<span aria-hidden="true">&times;</span><span class="sr-only">Close</span>
						</button>
						<h4 class="modal-title" id="myModalLabel">
							<fmt:message key="CancelEventMessage" />
							?
						</h4>
					</div>
					<div class="modal-body" id="cancelReason">

						<div class="cancelReasonDiv">
							<fmt:message key="SpecifyReason" />
							:
						</div>
						<textarea class="" id="cancelReasonTxt"></textarea>
						<div>
							<input id="intimateCancelChkBox" type="checkbox" />
							<fmt:message key="IntimateParticipants" />
						</div>


					</div>
					<div class="modal-footer" style="margin: 0px 10px 0px;">
						<button type="button" class="btn btn-primary" data-dismiss="modal"
							id="btn_cancel_yes">
							<fmt:message key="Yes" />
						</button>
						<button type="button" class="btn btn-default" data-dismiss="modal"
							id="btn_cancel_no">
							<fmt:message key="No" />
						</button>
					</div>
				</div>
			</div>
		</div>

		<div id="editEventQues" class="modal fade" tabindex="-1" role="dialog"
			aria-labelledby="editLabelModal" aria-hidden="true">
			<div class="modal-dialog modal-md">
				<div class="modal-content">
					<div class="modal-header">
						<button type="button" class="close" data-dismiss="modal">
							<span aria-hidden="true">&times;</span><span class="sr-only">Close</span>
						</button>
						<h4 class="modal-title" id="editLabelModal"></h4>
					</div>
					<div class="modal-footer mdlFooter" style="margin: 0px 10px 0px;">
						<button type="button" class="btn btn-primary" data-dismiss="modal"
							id="btn_edit_yes">
							<fmt:message key="Yes" />
						</button>
						<button type="button" class="btn btn-default" data-dismiss="modal"
							id="btn_edit_no">
							<fmt:message key="No" />
						</button>

					</div>
				</div>
			</div>
		</div>
		<div id="newGroupDlg" class="modal fade" tabindex="-1"
			role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
			<div class="modal-dialog modal-md">
				<div class="modal-content">
					<div class="modal-header">
						<button type="button" class="close" data-dismiss="modal">
							<span aria-hidden="true">&times;</span><span class="sr-only">Close</span>
						</button>
						<h4 class="modal-title" id="myModalLabel">
							New Group
						</h4>
					</div>
					<div class="modal-body" id="cancelReason">
						<form class="form-horizontal">
								<input type="hidden" id="groupId">
								<div class="form-group" id="group_name">
									<label class="col-lg-2 control-label"> <fmt:message key="GroupName"/> </label>
									<div class="col-lg-10">
										<input class="form-control" type="text" id="GroupName"
											placeholder='<fmt:message key="GroupName"/>' title='<fmt:message key="GroupName" />'>
										<span class="nameError" style="color:rgb(187, 68, 66);opacity:0"><fmt:message key="GroupNameExist"/>....</span>
									</div>
								</div>


								<div class="form-group">
									<label class="col-lg-2 control-label"> <fmt:message key="GroupDescription"/> </label>
									<div class="col-lg-10">
										<textarea class="form-control inputTypePadding" rows=5
											id="group_desc" placeholder='<fmt:message key="GroupDescPlaceholder" />'
											title='<fmt:message key="GroupDetails" />'></textarea>
									</div>
								</div>
								<div class="form-group interest-tags">
									<label class="col-lg-2 control-label"> <fmt:message key="Tags"/> </label>
									<div class="col-lg-10">
										<input class="form-control" type="text" id="GroupTags"
											placeholder='<fmt:message key="Tags" />' title='<fmt:message key="Tags" />' data-role="tagsinput">
											<div id="tagss" style="margin-top:8px"></div>
									</div>

								</div>


								<%-- <div class="form-group">
									<label class="col-lg-2 control-label"> <fmt:message key="Visibility"/> (<span id="visibilityType"><fmt:message key="Public"/></span>)</label>
									<div class="col-lg-4">
										<div class="input-group col-sm-4 col-xs-6" style="margin-top:15px">
											<input id="visibility" type="checkbox"
												class="cvToggle"><label for="visibility"></label>
										</div>

									</div>
								</div> --%>

	<%-- 								<div class="form-group">
									<label class="col-lg-2 control-label orgSuggestBoxLabel"><fmt:message key="Admin"/></label>
									<div class="col-lg-10">
										<textarea class="form-control inputTypePadding" rows=3
											id="adminSuggestBox"
											placeholder="Specify one or more admin's mail IDs"
											title="Admin(s)"></textarea>

									</div>
								</div> --%>

								<div class="form-group">
									<label class="col-lg-2 control-label orgSuggestBoxLabel"><fmt:message key="Members"/></label>
									<div class="col-lg-10">
										<textarea class="form-control inputTypePadding" rows=3
											id="memberSuggestBox"
											placeholder='<fmt:message key="MemberPlaceholder" />'
											title='<fmt:message key="Member" /><fmt:message key="S" />'></textarea>

									</div>
								</div>
							</form>
					</div>
					<div class="modal-footer" style="margin: 0px 10px 0px;">
							<button class="btn btn-success" id="btnGroupSave"><fmt:message key="Save"/></button>
							<button type="button" class="btn btn-default" data-dismiss="modal"><fmt:message key="Cancel"/></button>
					</div>
				</div>
			</div>
		</div>
		
	</fmt:bundle>
</body>
<jsp:include page="../common/footer.jsp">
	<jsp:param value="js/cvEventsCommon.js" name="js" />
	<jsp:param value="js/newEvent.js" name="js" />
	<jsp:param value="js/controller.js" name="js" />
	<jsp:param value="js/actions.js" name="js" />
	<jsp:param value="js/util.js" name="js" />
	<jsp:param value="js/newGroup.js" name="js" />
	<jsp:param value="thirdparty/js/jquery-ui-1.10.1.custom.min.js"
		name="js" />
	<jsp:param value="thirdparty/js/ckeditor/ckeditor.js" name="js" />
	<jsp:param value="thirdparty/js/ckeditor/adapters/jquery.js" name="js" />
	<jsp:param value="../common/bootstrap/js/bootstrap.min.js" name="js" />
	<jsp:param value="../common/thirdParty/moment.min.js" name="js" />
	<jsp:param value="../common/js/cvFormatters.js" name="js" />
	<jsp:param value="../common/bootstrap/js/bootstrap-datetimepicker.js"
		name="js" />
	<jsp:param value="../common/bootstrap/js/bootstrap-tagsinput.min.js" name="js" />
	<jsp:param value="../common/thirdParty/jquery.cropit.js" name="js" />
	<jsp:param value="../common/thirdPartyV2/purify.min.js" name="js" />
</jsp:include>
