<!doctype html>
<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<c:set var="wcPreview" value="false" />
<c:if test="${requestScope.wcPreview != null && requestScope.wcPreview == 'true'}">
	<c:set var="wcPreview" value="${requestScope.wcPreview}"/>
</c:if>
<c:choose>
<c:when test="${wcPreview == 'true'}">
	<meta charset="utf-8" />
	<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1" />
	<script nonce="${sessionScope.cspNonce}" type="text/javascript" src="${pageContext.request.contextPath}/clientLoggingJs.do?${applicationScope.BUILD_TS}"></script>
	<jsp:include page="../common/jqueryV2.jsp" />
	<script nonce="${sessionScope.cspNonce}" src="${pageContext.request.contextPath}/emailrecall/js/ckeditor/ckeditor.js" type = "text/javascript"></script>
    <script nonce="${sessionScope.cspNonce}" src="${pageContext.request.contextPath}/emailrecall/js/email.js?${applicationScope.BUILD_TS}" type = "text/javascript"></script>
    <link rel="stylesheet" href="../common/css/templatestyles.css" />
    <link rel="stylesheet" href="../common/css/sprites.css" />
	<link rel="stylesheet" href="${pageContext.request.contextPath}/emailrecall/css/wcemail.css" />
</c:when>
<c:otherwise>
	<jsp:include page="../common/headerV2.jsp">
		  <jsp:param value="${pageContext.request.contextPath}/emailrecall/css/wcemail.css" name="css" />
		  <jsp:param value="${pageContext.request.contextPath}/emailrecall/css/email.css" name="css" />
		  <jsp:param value="${headerTitle}" name="titleLocalized" />
		  <jsp:param value="${titleName}" name="headerTitleLocalized" />
		  <jsp:param value="${pageContext.request.contextPath}/emailrecall/js/email.js" name="js"/>
		  <jsp:param value="${pageContext.request.contextPath}/emailrecall/js/ckeditor/ckeditor.js" name="js"/>
	</jsp:include>
</c:otherwise>

</c:choose>

<fmt:bundle basename="localization.RecallMessages">
<c:set var="fromInfo" value="${requestScope.From}" />
<c:set var="toInfo" value="${requestScope.To}" />
<c:set var="ccInfo" value="${requestScope.Cc}" />
<c:set var="attachmentInfo" value="${requestScope.Attachments}" />
<c:set var="importanceVal" value="${requestScope.Importance}" />
<c:set var="escapedSubjectValue" value="${fn:escapeXml(requestScope.Subject)}" />
<c:set var="downloadMSG" value="${requestScope.DownloadMSG}" />
<c:if test="${ importanceVal eq 0}">
  <fmt:message key="emailrecall.LowImp" var="importanceLevel" />
  </c:if>
<c:if test="${ importanceVal eq 2}">
  <fmt:message key="emailrecall.HighImp" var="importanceLevel" />
</c:if>

<c:set var="showReply" value="false"/>
<c:if test="${requestScope.showReply != null && requestScope.showReply == 'true'}">
<c:set var="showReply" value="${requestScope.showReply}" />
</c:if>
<c:set var="popup" value="false" />
<c:if test="${requestScope.popup != null && requestScope.popup == 'true'}">
<c:set var="popup" value="${requestScope.popup}" />
</c:if>
<fmt:message key="email.attach.folderUploadError" var="folderUploadError" />
<fmt:message key="emailrecall.SendingMail" var="sendingMail" />

<script nonce="${sessionScope.cspNonce}" >
var localMsg = localMsg || {};
var folderUploadError = "${folderUploadError}";
var wcPreview="${wcPreview}";
var popup="${popup}";
var sendingMail="${sendingMail}";
var loggedinUserSmtp ="${sessionScope.LOGIN_TOKEN_INFO.smtpAddress}";
var nonceVar="${sessionScope.cspNonce}";
</script>
<body id="emailBody">
<form action="#"<%-- "${pageContext.request.contextPath}/server/sendMail" --%> method="post">
  <div id="emailcontainer">

		<div id="emailcontent">

		    <div class="contentHeader borderBottom" id="emailTopHeader">
		    <c:if test="${wcPreview == 'false' || (wcPreview == 'true' && showReply=='true')}">
				<div id="menu" class="previewShowDiv borderBottom previewMenu">
				      <ul class="leftSet">
				      		<c:if test="${showReply == 'true'}">
								<li class="mailActions"><a id="reply"> <fmt:message key="emailrecall.Reply"/></a></li>
								<li class="mailActions"><a id="replyAll"> <fmt:message key="emailrecall.ReplyAll"/></a></li>
								<li class="mailActions"><a id="forward"><fmt:message key="emailrecall.Forward"/> </a></li>
							</c:if>
							<c:if test="${wcPreview == 'false'}">
								<li class="mailActions"><a href="${downloadMSG}"><span class="sprite icon-download-grey"></span><span id="downloadMsg"><fmt:message key="emailrecall.DownloadAsMsg"/></span> </a></li>
							</c:if>

					  </ul>
					 <c:if test="${wcPreview == 'true' && popup=='false'}">
						<a class='openOut rightSet' href='#'></a>
					</c:if>

				 </div>
				 <div id="menu2" class="actionShowDiv borderBottom">
                    <ul class="leftSet">
                        <li class="mailActions2" id="sendButton"><a id="send">  <fmt:message key="emailrecall.Send"/></a> </li>
                        <li class="mailActions2"><a id = "discard"><fmt:message key="emailrecall.Discard"/>  </a></li>
                        <li class="mailActions2"><a id="insertButton"><fmt:message key="emailrecall.Insert"/> </a></li>
						<li class="mailActionMenu">
                       		   <ul id="nav">
								   <li style="font-size: inherit;" ><a href="#"  id="optionsButton"><fmt:message key="emailrecall.Options"/> </a>
								        <ul id="subMenu">
								        <li class="mailActionSubMenu"><a href="#" id="setimportance"><fmt:message key="emailrecall.SetImportance"/></a>
								            <ul id="importanceSelected">
								                <li><a href="#" data-img="${pageContext.request.contextPath}/emailrecall/img/highImp.png" data-impvalue="2"><fmt:message key="emailrecall.HighImp"/></a></li>
								                <li><a href="#"data-img="" data-impvalue="1"><fmt:message key="emailrecall.NormalImp"/></a></li>
								                <li><a href="#" data-img="${pageContext.request.contextPath}/emailrecall/img/lowImp.png" data-impvalue="0"><fmt:message key="emailrecall.LowImp"/></a></li>

								            </ul>
								        </li>

								        </ul>
								    </li>
			 				    </ul>
					    </li>
                    </ul>


                </div>
                <div class="email previewShowDiv">
	                 <div class="emailHeaders previewSubjectDiv boldFont" >
		                        <label for="Subject:" id="SubjectLabel1" class="minWidthLbl "> <fmt:message key="emailrecall.subject"/></label>
		                        <div id="SubjectSpan1" id = "SubjectId1">${requestScope.Subject}</div>
		             </div>
	             </div>
	          </c:if>
	          <c:if test="${wcPreview == 'true' && showReply=='false' && popup=='true'}">
	         	 <div class="email previewShowDiv">
	                 <div class="emailHeaders previewSubjectDiv boldFont" >
		                        <label for="Subject:" id="SubjectLabel1" class="minWidthLbl "> <fmt:message key="emailrecall.subject"/></label>
		                        <div id="SubjectSpan1" id = "SubjectId1">${requestScope.Subject}</div>
		             </div>
	             </div>
	          </c:if>
				<div class="email">
				    <div class="emailHeaders previewShowDiv" >
	                     <label for="From" id="FromLabel" class="minWidthLbl"><fmt:message key="emailrecall.from"/> </label>
	                     <div id="fromVal" class="leftSet">
			                <c:forEach var="item" items="${fromInfo}">
			                	<span class="singleToField showAsHyperLink fromField emailBoldBlueFont" title="${item.smtpAddress}" contenteditable="false" data-smtp="${item.smtpAddress}">${item.displayName}</span><label class="rightSet actionShowDiv" id="semiColon">;</label>
			                </c:forEach>
		                </div>
		                <label id="SentTimeLabel" class="hideElement"><fmt:message key="emailrecall.sentTime"/></label>
	            	    <div style="text-align:right" class="previewShowDiv emailBoldBlueFont rightSet" id="SentTime">${requestScope.SentReceivedTime}</div>

	                </div>
	                 <c:if test="${fn:length(toInfo) gt 0}">
		                 <div class="emailHeaders"><div id="ToLabel" class="leftSet minWidthLbl pickRecipient"><fmt:message key="emailrecall.to"/></div>
		                 <div class="editableDiv" id="toVal">
		                     <c:forEach var="item" items="${toInfo}">
						       <span class="singleToField showAsHyperLink"  title="${item.smtpAddress}" contenteditable="false" data-smtp="${item.smtpAddress}">${item.displayName}</span><label class="rightSet" id="semiColon">;</label>
		             	    </c:forEach>

		                  </div>
		                </div>
				    </c:if>
	                <c:if test="${fn:length(toInfo) == 0}">
	                    <div class="emailHeaders actionShowDiv"><label for="to" id="ToLabel" class="minWidthLbl pickRecipient"><fmt:message key="emailrecall.to"/></label>
		                  <div id="toVal" class="editableDiv">
		                  </div>
		                </div>
	                </c:if>
	                <c:if test="${fn:length(ccInfo) gt 0}">
	                    <div class="emailHeaders"><label for="cc" id="ccLabel" class="minWidthLbl pickRecipient"><fmt:message key="emailrecall.cc"/></label>
						    <div id="ccVal" class="editableDiv">
						    <c:forEach var="item" items="${ccInfo}">
							       <span class="singleCCField showAsHyperLink" title="${item.smtpAddress}" contenteditable="false" data-smtp="${item.smtpAddress}">${item.displayName}</span><label id="semiColon">;</label>
			             	</c:forEach>
			                </div>
		                </div>
	                </c:if>
	                <c:if test="${fn:length(ccInfo) == 0}">
	                  <div class="emailHeaders actionShowDiv"><label for="cc" id="ccLabel" class="minWidthLbl pickRecipient"><fmt:message key="emailrecall.cc"/></label>
					    <div id="ccVal" class="editableDiv">
		                  </div>
		                </div>
	                </c:if>
	                <div class="emailHeaders actionShowDiv"><label for="bcc" id="bccLabel" class="minWidthLbl pickRecipient"><fmt:message key="emailrecall.bcc"/></label>
					    <div id="bccVal" class="editableDiv">
		                </div>
		            </div>

	               <div class="emailHeaders actionShowDiv" >
	                        <label for="Subject:" id="SubjectLabel" class="minWidthLbl boldFont"> <fmt:message key="emailrecall.subject"/></label>
	                        <img  id="importanceImg"/>
	                        <div id="SubjectSpan"><input type="text" id = "SubjectId" name="SubjectVal" value="${requestScope.Subject}"/></div>
	                        <label  id="ReSubject" class="hideElement"><fmt:message key="emailrecall.resubject"/></label>
	                        <label  id="FWSubject" class="hideElement"><fmt:message key="emailrecall.fwsubject"/></label>
					</div>

                    <c:if test="${fn:length(attachmentInfo) gt 0}">

	                    <div class="emailHeaders" id="divAttachment">
	                        <label for="AttachLbl:" class="minWidthLbl boldFont"><fmt:message key="emailrecall.attachment"/></label>
	                        <div id="Attachment" >
		                        <c:forEach var="item" items="${attachmentInfo}">
		                        <div id="AttachDiv" class="leftSet AttachDivCls">
		                        <c:choose>
										<c:when test="${wcPreview == 'true'  && fn:length( item.ciPreviewLink) gt 0 }">
										   <a href="${item.ciPreviewLink}" target="_blank" data-downloadlink="${item.downloadLink}" class="AttachVal">${item.name}</a>
								       </c:when>
								       <c:otherwise>
								          <a href="${item.downloadLink}"  class="AttachVal">${item.name}</a>
								       </c:otherwise>
								       </c:choose>
								       <div class="AttachValImg actionShowDiv" contenteditable="false"> ;</div>

								</div>
				             	</c:forEach>
			               </div>
	                    </div>
	                </c:if>
	                 <c:if test="${fn:length(attachmentInfo) == 0}">
                    <div class="emailHeaders actionShowDiv"  id="divAttachment">
                        <label for="AttachLbl:" class="minWidthLbl boldFont"><fmt:message key="emailrecall.attachment"/></label>
                            <div id="Attachment" ></div>

                    </div>
                      </c:if>
                      <!--   if the importance is not normal, then display it -- Normal -1 , Low -0 , High-2>-->

	                <c:if test="${ importanceVal eq 0 || importanceVal eq 2 }">
	                    <div style="text-align:right" class="previewShowDiv"><fmt:message key="emailrecall.messageimportance"/>${importanceLevel}<fmt:message key="emailrecall.importance"/></div>
	                </c:if>
				</div>
             </div>
             <div id="emaileditor" contenteditable="false">${requestScope.Body}</div>
             <iframe class="previewShowDiv" id="emailPreviewIframe"> </iframe>
             <div class="uploadProgress">

		          <div class="uploadInProgress" style="display:none">
					<%-- <div class="text"><fmt:message key="emailrecall.label.uploading" /></div>
					<img src="${pageContext.request.contextPath}/upload/img/sending_progress.gif"> --%>
				  </div>
				  <div class="uploadCompleted" style="display:none">
						<%-- <div class="ctext"><span class="fNames"></span> <fmt:message key="upload.label.hasBeenUploaded" /> <span class="destLocation"></span> !</div> --%>
						<!-- Files Attached -->
				   </div>
			      	<%-- <div class="uploadCancel" style="display:none">
						<div class="ctext_canceling"><fmt:message key="upload.label.cancellingUpload" /></div>
						<div class="ctext_cancelled"><fmt:message key="upload.label.uploadHasBeenCancelled" /></div>
					</div> --%>
				  <div class="uploadFailed" style="display:none">
					<div class="ctext_Failed"></div>

				   </div>
				  <div class="closeDiv">
		          </div>
		     </div>
		</div>

  </div>
</form>
<c:choose>
<c:when test="${wcPreview == 'false'}">
<jsp:include page="../common/footer.jsp"/>
</c:when>
</c:choose>
	 <div id="searchDlg" title="Search Contacts">
	        <div class="DlgContent ">
	             <input type="text" name="userHint" id="userSearchTxt" class="leftSet" />
	             <!-- <img src="emailrecall/img/search_app.png" alt="Search" style="-webkit-transform: scale(0.5)"/>  -->
	 			 <input type="button" name="searchBut" value=<fmt:message key="emailrecall.Search"/> id="searchButton" class="dialogbutton"/>
	             <input id="caller" type="hidden" class="hideElement"/>
	             <!-- <textarea class="dialogTextArea" id="resultList"></textarea> -->
	             <div id="UserNameResult" class="DlgContentDiv">
		             <div id="ajaxBusySearch" class="center_it"></div>
		             <div id="selectable"> </div>
		             <label id="NoItems"><fmt:message key="emailrecall.NoMatches"/></label>
				</div>
	            <div class="rightSet">
	                 <button id="btn_OK" class="addButton"><fmt:message key="emailrecall.Add"/></button>
	                 <button id="btn_cancel" class="resetButton"><fmt:message key="emailrecall.Cancel"/></button>
	            </div>
	        </div>
	</div>

</fmt:bundle>
<c:if test="${wcPreview == 'true'}">
	<div id="notificationContainer" style="display:none; z-index:9999; top: auto; right: 0px; bottom: 0px; margin: 0px 10px 10px 0px;">
			<div id="notificationTemplateInfo">
				<a class="ui-notify-cross ui-notify-close" href="#">x</a>
				<div style="float:left;margin:0 10px 0 0">
					<span class="sprite icon-notif-info" alt="Information" title="Information"></span>
				</div>
				<p><%="#"%>{text}</p>

			</div>
			<div id="notificationTemplateError">
				<a class="ui-notify-cross ui-notify-close" href="#">x</a>
				<div style="float:left;margin:0 10px 0 0">
					 <span class="sprite icon-notif-error" alt="Error" title="Error"></span>
				</div>
				<p><%="#"%>{text}</p>
			</div>
			<div id="notificationTemplateServerError">
				<a class="ui-notify-cross ui-notify-close" href="#">x</a>
				<div style="float:left;margin:0 10px 0 0">
					 <span class="sprite icon-notif-error" alt="Error" title="Error"></span>
				</div>
				<p>${exceptionText}</p>
				<p><span style="font-size: 0.8em;"><%="#"%>{text}</span></p>
			</div>
	</div>
</c:if>
  <input id="upload_trigger_btn" type="file"  multiple/> <!-- name="files[]" -->
</body>