<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"%>

<c:set var="isAFullImportNeeded"  value="${requestScope.isAFullImportNeeded}"/>
<fmt:message key="Download_Center" var="pageTitle" />
<fmt:bundle basename="localization.DownloadCenterMessages">
	
	<jsp:include page="../common/headerV3.jsp">		
		<jsp:param value="true" name="bootstrapped" />
		<jsp:param value="true" name="downloadCenterApp" />
		<jsp:param value="true" name="enableLoginLink" />
		<jsp:param value="true" name="includeSecHeader" />
		<jsp:param value="true" name="includeHistory" />
		<jsp:param value="../common/css/headerstyles.css" name="css" />		
		<jsp:param value="../common/css/jquery.loadmask.css" name="css" />	
		<jsp:param value="../common/css/custom-cb.css" name="css" />	
		<jsp:param value="../common/bootstrap/css/bootstrap-wc.css" name="css" />	
		<jsp:param value="../common/bootstrap/css/icomoon.css" name="css" />	
		<jsp:param value="../common/css/table.css" name="css" />
		<jsp:param value="css/dc.css" name="css" />
		<jsp:param value="css/downloadPackage.css" name="css" />		
		
		<jsp:param value="${pageTitle}" name="titleLocalized" />
		<jsp:param value="${pageTitle}" name="headerTitleLocalized" />
		<jsp:param value="${sessionScope.LOGGED_IN_USER_CAP}" name="includeDCConfigOpts" />
		
	</jsp:include>
	
	
	<script nonce="${sessionScope.cspNonce}" >
		var isAFullImportNeeded = "${isAFullImportNeeded}";
		var dc = dc || {};
		dc.isOpenAccessDC = '${sessionScope.isDownloadCenterOpenAccess}' === 'true' ? true : false;
	</script>

	<div class="container-fluid">
		<div class="row content-min-height" id="dcContents">
			<div class="col-sm-2 col-md-2 col-lg-3 dcFilterPanelWrapper">
				<div class="resetFiltersDiv">
					<a class="disabled resetFilters">Reset filters</a>
				</div>	
				<div id="filterPanel">
					<!-- facet content -->
				</div>
			</div>
			<div class="col-sm-10 col-md-10 col-lg-9 dcPackageDetailsWrapper">
				<div id="packageResults">
					<!-- Grid tools -->
					<div id="gridInfoBar" class="breadcrumbs row">
						<jsp:include page="templates/gridtools.html"></jsp:include>
					</div>
					<!-- search result -->
					<div id="packageResultGrid" class="row" ></div>
					<div id="paginationBar" class="col-md-12"></div>
				</div>
			</div>
			<!-- <div class="col-sm-12 col-md-4 col-lg-4">
				
				<div class="portlet contbox gray-haze tasks-widget">
					<div class="portlet-title">
						<div class="caption">Activites</div>
					</div>
					<div class="portlet-body">
						<div class="task-body">
							<div class="slimScrollDiv"
								style="position: relative; overflow: hidden; width: auto; height: 305px;">
								<div class="scroller"
									style="height: 305px; overflow: hidden; width: auto;">
									
									<ul class="task-list">
										<li>
											<div class="task-title">
												<span class="task-title-sp"> Data is currently
													unavailable.</span>
											</div>
										</li>
									</ul>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>-->
		</div>
	<iframe id="downloadIframe" style="display:none;"></iframe>
	</div>

	<jsp:include page="../common/footerV3.jsp">
		<jsp:param value="true" name="bootstrapped" />
		<jsp:param value="../downloadcenter/includes.jsp" name="jsp" />
		<jsp:param value="../common/js/ba-debug.min.js" name="js" />
		<jsp:param value="js/subsystems/downloadcenter.js" name="js" />
	</jsp:include>
</fmt:bundle>