<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"%>

<!--escape url params to avoud XSS vulnerability  -->
<c:set var="isStore"  value="${fn:escapeXml(param.isStore)}"/>
<c:set var="packageId"  value="${fn:escapeXml(param.packageId)}"/>
<c:set var="packageType"  value="${fn:escapeXml(param.packageType)}"/>
<c:set var="packageStatus"  value="${fn:escapeXml(param.packageStatus)}"/>
<c:set var="status"  value="${fn:escapeXml(param.status)}"/>
<c:set var="platformId"  value="${fn:escapeXml(param.platformId)}"/>
<c:set var="statusStr"  value="${fn:escapeXml(param.statusStr)}"/>

<c:set var="reportsStoreParams" value=""/>
<c:set var="subCatName" value ="${requestScope.fn_SUBCATEGORY_NAME_val}" />
<c:set var="dcSearchUrl" value="downloadcenter/dc.do"/>
<c:choose>
	<c:when test="${isStore=='true'}" >
		<fmt:message key="Software_Store" var="pageTitle" />
		<c:set var="dcSearchUrl" value="downloadcenter/dc.do?isStore=true&packageType=${packageType}&packageStatus=${packageStatus}"/>		
	</c:when>
	<c:otherwise>
		<fmt:message key="Download_Center" var="pageTitle" />
	</c:otherwise>
</c:choose>
<c:set var="packageName" value="${requestScope.packageName}"/>

<fmt:message key="Download_Center_ReadMe" var="headerTitle"/>

<c:url value="downloadcenter/packageDetails.do" var="packageDetailsUrl"
	scope="request">
	<c:param name="packageId" value="${packageId}" />	
	<c:param name="status" value="${status}" />
	<c:param name="type" value="details" />
	<c:param name="isStore" value="${isStore}" />
	<c:param name="packageType" value="${packageType}" />
	<c:param name="statusStr" value="${statusStr}" />
	<c:param name="packageStatus" value="${packageStatus}" />
</c:url>
	
<fmt:bundle basename="localization.DownloadCenterMessages">
	<jsp:include page="../common/headerV3.jsp">
		<jsp:param value="true" name="bootstrapped" />
		<jsp:param value="true" name="downloadCenterApp" />
		<jsp:param value="true" name="enableLoginLink" />
		<jsp:param value="${pageTitle}" name="titleLocalized" />
		<jsp:param value="${headerTitle}" name="headerTitleLocalized" />
		<jsp:param value="true" name="includeSecHeader" />
		<jsp:param value="${pageTitle}:${dcSearchUrl},${packageName}:${packageDetailsUrl}" name="breadCrumbValues" />		
		<jsp:param value="${pageContext.request.contextPath}/common/css/headerstyles.css" name="css" />
		<jsp:param value="${pageContext.request.contextPath}/common/bootstrap/css/bootstrap-wc.css" name="css" />		
		<jsp:param value="${pageContext.request.contextPath}/downloadcenter/css/dc.css" name="css" />
	</jsp:include>
<div class="readMeFrame">
	<iframe class="readMeContent" id="readMeContent" onload= "setIframeHeight(this.id)" scrolling="no" frameBorder="0" src="readmePreview.do?packageId=${packageId}&packageName=${requestScope.packageName}&platformId=${platformId}&isStore=${isStore}" sandbox="allow-same-origin allow-forms">
	</iframe>	
</div>
</fmt:bundle>
<script nonce="${sessionScope.cspNonce}" >

	function setIframeHeight(iframeId)
	{
		setTimeout(function() {
			 var ifDoc, ifRef = document.getElementById( iframeId );
			 try
			 {
			  ifDoc = ifRef.contentWindow.document.body;
			 }
			 catch( e )
			 {
			  
			}
			 if(ifDoc)
			 {
			  var addHeight = 20; 
			  ifRef.style.height = 1;
			  ifRef.style.height = ifDoc.scrollHeight + addHeight + "px";	  
			 }
			 var cssLink = document.createElement("link") 
				cssLink.href = "css/dcReadme.css"; 
				cssLink.rel = "stylesheet"; 
				cssLink.type = "text/css"; 
			  	ifRef.contentWindow.document.body.appendChild(cssLink);
		}, 400);

	}


</script>
<jsp:include page="../common/footerV3.jsp">
	<jsp:param value="true" name="bootstrapped" />
</jsp:include>
