<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"%>

<c:set var="rankingModeEnabled"
	value="${sessionScope.dcRankingModeEnabled}" />
<fmt:message key="Download_Center" var="pageTitle" />
<fmt:bundle basename="localization.DownloadCenterMessages">
<jsp:include page="../common/headerV3.jsp">	
	<jsp:param value="true" name="includeSecHeader" />
	<jsp:param value="true" name="includeHistory" />	
	<jsp:param value="true" name="bootstrapped" />
	<jsp:param value="true" name="downloadCenterApp" />
	<jsp:param value="${pageContext.request.contextPath}/common/css/headerstyles.css" name="css" />
	<jsp:param value="${pageContext.request.contextPath}/common/css/jquery.loadmask.css" name="css" />
	<jsp:param value="${pageContext.request.contextPath}/common/css/custom-cb.css" name="css" />	
	<jsp:param value="${pageContext.request.contextPath}/common/css/table.css" name="css" />
	 <jsp:param value="${pageContext.request.contextPath}/common/bootstrap/css/bootstrap-datetimepicker.css"  name="css" />
	<jsp:param value="${pageContext.request.contextPath}/common/bootstrap/css/bootstrap-wc.css" name="css" />
	
	<jsp:param value="${pageContext.request.contextPath}/common/bootstrap/css/icomoon.css" name="css" />
	<jsp:param value="${pageContext.request.contextPath}/common/css/ckEditor.css" name="css" />
	<jsp:param value="${pageContext.request.contextPath}/downloadcenter/css/dc.css" name="css" />
	<jsp:param value="${pageContext.request.contextPath}/downloadcenter/css/dcPackageDetails.css" name="css" />
	<jsp:param value="${pageTitle}" name="titleLocalized" />
	<jsp:param value="Download Information" name="headerTitleLocalized" />
	<jsp:param value="Download Center:downloadcenter/dc.do"	name="breadCrumbValues" />	
	<jsp:param value="downloadcenter/includes.jsp" name="jsp" />
</jsp:include>

<div class="container-fluid">
	<div class="row">
		<div id="dcPackageDetailsForm" class="col-lg-12 col-md-12 padding-top-5">
			<div class="form-horizontal" style="display: block;">
				<!-- Package Name -->
				<div class="formSectionalHeader col-lg-12 nopadding">
								Label Your Download 
				</div>
				<div class="form-group required">
					<label	for="packageName" class="col-lg-3 control-label">Name
					</label>
					<div class="col-lg-6">
						<input type="text" id="packageName" class="form-control"
							data-required="true">
						<span id="hint_packageName" class="errorMsg noDisplay"><fmt:message
												key="package.this.field.is.mandatory" /></span>		
					</div>
				</div>
				<!-- Package Description -->
				<div class="form-group CvCkEditor">
					<label for="description" class="col-lg-3 control-label"><fmt:message key="software.th.description"/></label>
					<div class="col-lg-6">
						<textarea id="description" name="description" class="form-control" autocomplete="off"></textarea>
					</div>
				</div>
				<!-- Package ReadMe -->
				<div class="form-group">
					<label for="readmeLocation" class="col-lg-3 control-label"><fmt:message
												key="package.read.me.location" />
					
					</label>
					<div class="col-lg-6">
						<div class="input-group">
						<input type="text" id="readmeLocation" name="readmeLocation" class="form-control" autocomplete="off" data-validate="true" data-required="true" data-readmevalidation="true">					
					<span class="input-group-btn">
						<button id="packageReadMeBrowse" type="button" class="btn btn-default locationBrowseBtn detailsBtnAlign " data-browsetype="readMeLocation">
									<span class="ico-folder"></span>
						</button>
					</span>
						
					</div>
					<span id="invalid_readmeLocation" class="errorMsg noDisplay"><fmt:message
												key="package.readMe.location.invalid" /></span>		
				</div>
				<dcreadmedata></dcreadmedata> <!-- custom tag -->
				</div>
		
				<div class="formSectionalHeader col-lg-12 nopadding">
								<fmt:message key="package.details.text"></fmt:message>
				</div>
				<!-- Package Category -->
				<div class="form-group required">
					<label for="category" class="col-lg-3 control-label"><fmt:message key="dc.facet.category"></fmt:message>					
					</label>
					<div class="col-lg-6">
						<div class="input-group">
							<select id="categorySelection" class="form-control"
								data-required="true"></select> 
						<span class="input-group-btn">
							<button type="button" id="editCategoryBtn" class="btn btn-default editEntities detailsBtnAlign" data-entity="category">
									<span class="ico-edit"></span>
								</button>
							<button type="button" class="btn btn-default addEntities detailsBtnAlign"	data-entity="category">
									<span class="ico-add"></span>
							</button>
						</span>						
						</div>
						<span id="hint_categorySelection" class="errorMsg noDisplay"><fmt:message
												key="package.choose.a.valid.option" /></span>
				</div>
				</div>

				<!-- Package SubCategory -->
				<div class="form-group">			
					<label for="subCategory" class="col-lg-3 control-label"><fmt:message key="dc.facet.subcategory"></fmt:message>
						
					</label>
					<div class="col-lg-6">
						<div class="input-group">
						<select id="subCategorySelection" class="form-control"></select>
						<span class="input-group-btn">
						<button type="button" id="editSubCategoryBtn" class="btn btn-default editEntities detailsBtnAlign" data-entity="subcategory">
									<span class="ico-edit"></span>
								</button>
								<button type="button"
									class=" btn btn-default addEntities detailsBtnAlign"
									data-entity="subcategory">
									<span class="ico-add"></span>
								</button>
						</span>						
						</div>
						 <span id="hint_subCategorySelection" class="errorMsg noDisplay"><fmt:message
												key="package.choose.a.valid.option" /></span>
					</div>
				</div>
				
				<!-- Package Vendor -->
				<div class="form-group">			
					<label for="vendor" class="col-lg-3 control-label"><fmt:message key="software.th.vendor"></fmt:message></label>
					<div class="col-lg-6">
						<select id="vendorSelection" class="form-control"></select>
					</div>
				</div>
				
				<!-- Package Version & Rank-->
				<div class="form-group required">			
					<label for="version" class="col-lg-3 control-label"><fmt:message key="dc.facet.productversion"></fmt:message></label>
					<div class="col-lg-6">
						<div class="row">
							<div class="col-md-5 " >	
							<select id="versionSelection" class="form-control" data-required="true"></select> 
							<!--<div class="input-group">							
								
								  <span class="input-group-btn">
											<button type="button"
												class=" btn btn-default addEntities detailsBtnAlign"
												data-entity="productVersion">
												<span class="ico-add"></span>
											</button>
										</span>
							</div>-->
							<span id="hint_versionSelection" class="errorMsg noDisplay"><fmt:message
												key="package.choose.a.valid.option" /></span>							
							</div>
							 
							<div class="col-md-1">
								<label for="rank" class="control-label no-asterisk"><fmt:message key="package.list.sort.rank"></fmt:message></label>
							</div>
							<div class="col-md-6">								
									<input type="text" id="rank" name="rank" class="form-control" autocomplete="off">								
							</div>
						</div>
					</div>
				</div>
				
				<!-- Software icon -->
				<div class="form-group">
					<label for="softwareIcon" class="col-lg-3 control-label"><fmt:message key="package.package.image"></fmt:message><span id="valid_msg" class="errorFont"> </span>
					</label>
					<div class="col-lg-6">
						<div class="input-group">
								<input type="text" id="packageImageLocationText"
									name="packageImageLocationText" class="form-control" value=""
									readonly="" alt=""/>
							 <input type="file"
									id="packageImageLocation" name="packageImageLocation"
									class="packageFileBrowseTextStyle" accept="image/*"/>
							
							<span class="input-group-btn">
								<button class="btn btn-default detailsBtnAlign" type="button"
									id="packageImageBrowse" title="Browse">
									<span class="ico-folder"></span>
								</button>
							</span>
						
					</div>
					<span id="hint_softwareIcon" class="errorMsg noDisplay"></span>	
				</div>
				</div>
				<dcsoftwareicon></dcsoftwareicon>
				<!--  valid TO/FROM-->
				<div class="form-group required">
					<label for='validfrom' class='col-lg-3 control-label'><fmt:message key="package.valid.From"></fmt:message></label>
					<div class="col-lg-6">
					<div class="row">					
							<div class="col-md-5">
							<div class='input-group date' id='validFrom'>
                                 <input type="text"
									class="form-control" autocomplete="off" id="validFromIp" data-required="true">
									<span class="input-group-addon">
										<span class="glyphicon glyphicon-calendar"></span> 
                                     </span>
                                     
                              </div>
								 <span id="hint_validFromIp" class="errorMsg noDisplay"><fmt:message key="package.this.field.is.mandatory" /></span>   
							</div>
							<div class="col-md-1">
								<label for='validto' class='control-label no-asterisk'><fmt:message key="package.valid.to"></fmt:message></label>
							</div>
							<div class="col-md-6">
								<div class='input-group date' id="validTo">
                                   <input type="text" class="form-control"id="validToIp" autocomplete="off" >
                                	<span class="input-group-addon"><span class="glyphicon glyphicon-calendar"></span> </span>
                                 </div>
							</div>						
					</div>						
					</div>
				</div>
				
				<c:if test="${requestScope.isCVStore eq true}"> 
					<div class="formSectionalHeader col-lg-12 nopadding">
						<fmt:message key="package.details.softwarestore.props"></fmt:message>
					</div>
					
					<!--  Weightage-->
					<div class="form-group">
						<label for='weightage' class='col-lg-3 control-label'><fmt:message key="package.weightage"></fmt:message></label>
						<div class="col-lg-6">
							<select id="weightageSelection" class="form-control"></select>
						</div>
					</div>
					<!-- Package minimumSupportedVersion -->
					<div class="form-group">			
						<label for="ss-minversionselection" class="col-lg-3 control-label"><fmt:message key="software.th.minRelease"></fmt:message></label>
						<div class="col-lg-6">
							<div class="row">
								<div class="col-md-5 " >	
									<select id="ss-minversionselection" class="form-control"></select> 
								</div>
								 
								<div class="col-md-3">
									<label for="ss-minsp" class="control-label no-asterisk"><fmt:message key="package.list.min.service.pack"></fmt:message></label>
								</div>
								<div class="col-md-4">								
										<select id="ss-minsp" name="ss-minsp" class="form-control"></select>								
								</div>
							</div>
						</div>
					</div>
					<!-- Package what's new -->
					<div class="form-group">
						<label for="ss-whatsnew" class="col-lg-3 control-label"><fmt:message key="software.th.whatsNew"/></label>
						<div class="col-lg-6">
							<textarea id="ss-whatsnew" name="ss-whatsnew" class="form-control" style="resize: none;"></textarea>
						</div>
					</div>
					
					<!-- Package Certified -->
					<div class="form-group">			
						<label for="ss-certified-switch" class="col-lg-3 control-label"><fmt:message key="software.th.certified" /></label>
						<div class="col-lg-2">
							<div class="ss-certified">
								<label id="ss-certified-switch" class="sprite icon-switch-yes"></label>
							</div>
							<div class="clearFloat"></div>
						</div>
					</div>
					
					<!-- Package Push-Install -->
					<%-- Hiding this option until we find a solution for the autoupdates. This feature is not in use currently. --%>
					<%--  
					<div class="form-group">			
						<label for="ss-pullable-switch" class="col-lg-3 control-label"><fmt:message key="software.th.pullEnabled" /></label>
						<div class="col-lg-2">
							<div class="ss-pullable">
								<label id="ss-pullable-switch" class="sprite icon-switch-no"></label>
							</div>
							<div class="clearFloat"></div>
						</div>
					</div> 
					--%>
					
				</c:if>
				<!-- Download Type & Locations-->
				<div class="formSectionalHeader col-lg-12 nopadding">
								<fmt:message key="package.details.locations"/>
				</div>
				<!-- Package Platform -->
				<div class="form-group required">			
					<label for="platform" class="col-lg-3 control-label"><fmt:message key="dc.facet.platform"/>					 
					</label>
					<div class="col-lg-6">
						<select id="platformSelection" class="form-control" data-required="true" data-skipvalidationon="dcpackageplatforms"></select>
						<span id="hint_platformSelection" class="errorMsg noDisplay">
									<fmt:message key="package.choose.a.valid.option" /></span>
					</div>
				</div>
				<!-- Package Download Type -->
				<div class="form-group required">			
					<label for="downloadType" class="col-lg-3 control-label"><fmt:message key="package.download.type"/>
						
					</label>
					<div class="col-lg-6">
						<select id="downloadTypeSelection" class="form-control" data-required="true" data-skipvalidationon="dcpackageplatforms"></select>
						 <span id="hint_downloadTypeSelection" class="errorMsg noDisplay">
									<fmt:message key="package.choose.a.valid.option" /></span>
					</div>
				</div>
				<!-- Package Location -->
				<div class="form-group required">
					<label for="location" class="col-lg-3 control-label"><fmt:message key="package.location"/>						
					</label>
					<div class="col-lg-6">
						<div class="input-group">							
								<input type="text" id="location" name="location"
									class="form-control" data-toggle="tooltip" autocomplete="off" data-required="true" data-skipvalidationon="dcpackageplatforms"
									readonly="readonly" />							
							<span class="input-group-btn">
							
								<button id="packageBrowse" type="button"
									class=" btn btn-default locationBrowseBtn detailsBtnAlign"
									data-browsetype="packageLocation">
									<span class="ico-folder"></span>
								</button>
							</span>							
						</div>
						<span id="hint_location" class="errorMsg noDisplay"><fmt:message
												key="package.this.field.is.mandatory" /></span> 
							<span id="invalid_location" class="errorMsg noDisplay invalid"><fmt:message
												key="package.location.invalid" /></span> 	
					</div>
					<dclocationdata></dclocationdata> <!-- custom tag -->
				</div>
				<!-- MD5 Checksum-->
				<div class="form-group">			
					<label for="md5hash" class="col-lg-3 control-label"><fmt:message key="package.checksum"></fmt:message></label>
					<div class="col-lg-6">
						<input type="text" id="md5hash" class="form-control" data-required="true" disabled="true">
						 
					</div>
				</div>

				  <div class="form-group">
					<div class="col-lg-offset-3 col-lg-6">
						<button id="btn_add" class="btn btn-success addPlatforms"><fmt:message key="dc.platform.save"></fmt:message></button>
						<button class="btn btn-cancel clearPlatformFields"><fmt:message key="package.cancel.button.text"></fmt:message></button>
					</div>
				</div>
				<dcpackageplatforms><!-- custom tag -->
				<div class="row platformList">
						<div class="col-lg-9">
							<table id="dcPlatformsTbl"
								class="table table-striped table-bordered dt-responsive" cellspacing="0"
								width="100%">
								<thead>
									<tr>
										<th><fmt:message key="package.platform"></fmt:message></th>
										<th><fmt:message key="package.download.type"></fmt:message></th>
										<th><fmt:message key="package.location"></fmt:message></th>
										<th><fmt:message key="package.checksum"></fmt:message></th>
										<th><fmt:message key="dc.table.th.actions"></fmt:message></th>
									</tr>
								</thead>
								<tbody class="addedPlatforms">
									
								</tbody>
							</table>
						</div>
				</div>
				</dcpackageplatforms>
				<!--Share your download-->
				<div class="formSectionalHeader col-lg-12 nopadding">
								<fmt:message key="package.validity.visiblity.info.text"></fmt:message>
				</div>
				<!--  visibled TO-->
					<div class="form-group">
						<label for='visibleTo' class='col-lg-3 control-label'><fmt:message key="package.visible.to"></fmt:message></label>
						<div class="col-lg-6">
							<div class="userGroupInfoWrapper ">
							<input type="text" placeholder="<fmt:message key="dc.userentity.placeholder"></fmt:message>" class="userEntitySuggestions"
								autocomplete="off" style="resize: none;" data-suggestiontype="visibleto"/>
							<div id="visibleto_entity"></div>
							</div>
						</div>
					</div>

					<!--  Not Visibled To-->
					<div class="form-group">
						<label for='visibleTo' class='col-lg-3 control-label'><fmt:message key="package.not.visible.to"></fmt:message></label>
						<div class="col-lg-6">
							<div class="userGroupInfoWrapper ">
							<input type="text" placeholder="<fmt:message key="dc.userentity.placeholder"></fmt:message>" class="userEntitySuggestions"
								autocomplete="off" style="resize: none;" data-suggestiontype="notvisibleto"/>
								<div id="notvisibleto_entity"></div>
							</div>
						</div>
					</div>
					<!--  Early Preview User-->
					<div class="form-group">
						<label for='visibleTo' class='col-lg-3 control-label'><fmt:message key="package.early.preview.users"></fmt:message></label>
						<div class="col-lg-6">
							<div class="userGroupInfoWrapper ">
							<input type="text" placeholder="<fmt:message key="dc.userentity.placeholder"></fmt:message>" class="userEntitySuggestions"
								autocomplete="off" style="resize: none;" data-suggestiontype="earlypreviewusers"/>
								<div id="earlypreviewusers_entity"></div>
							</div>
						</div>
					</div>
					<dcextraprops></dcextraprops>
					<!-- save/cancel buttons -->
					<div class="form-group">
						<div class="col-lg-offset-3 col-lg-6">
							<button id="btn_savePackage" class="btn btn-primary"><fmt:message key="package.apply.button.text"></fmt:message> </button>
							<button class="btn btn-cancel cancelAndRedirect"><fmt:message key="package.cancel.button.text"></fmt:message></button>
						</div>
					</div>
			</div>
		</div>
	</div>
</div>
<jsp:include page="../common/footerV3.jsp">
	<jsp:param value="true" name="bootstrapped" />
	<jsp:param value="../common/bootstrap/js/bootstrap-datetimepickerV3.js"  name="js" />	
	<jsp:param value="../cvevents/thirdparty/js/ckeditor/ckeditor.js" name="js" />
	<jsp:param value="../cvevents/thirdparty/js/ckeditor/adapters/jquery.js" name="js" />
	<jsp:param value="js/fsMachineBrowseDC.js" name="js" />
	<jsp:param value="js/subsystems/dcpackagedetails.js" name="js" />
</jsp:include>
</fmt:bundle>