<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<fmt:message key="Download_Center" var="pageTitle" />
<fmt:bundle basename="localization.DownloadCenterMessages">
	<fmt:message key="dc.manage.info" var="manageInfo" />
	<jsp:include page="../common/headerV3.jsp">
		<jsp:param value="true" name="includeSecHeader" />
		<jsp:param value="true" name="includeHistory" />
		<jsp:param value="true" name="bootstrapped" />
		<jsp:param value="${pageContext.request.contextPath}/common/css/headerstyles.css" name="css" />
		<jsp:param value="${pageContext.request.contextPath}/common/css/jquery.loadmask.css" name="css" />
		
		<jsp:param value="${pageContext.request.contextPath}/common/bootstrap/css/bootstrap-wc.css" name="css" />
		<jsp:param value="${pageContext.request.contextPath}/common/datatables/css/dataTables.bootstrap.css" name="css" />
		<jsp:param value="${pageContext.request.contextPath}/downloadcenter/css/dc.css" name="css"	/>
		<jsp:param value="${pageTitle}" name="titleLocalized" />
		<jsp:param value="${manageInfo}" name="headerTitleLocalized" />
		<jsp:param value="Download Center:downloadcenter/dc.do"	name="breadCrumbValues" />

	</jsp:include>
	<jsp:include page="dclocale.jsp"></jsp:include>
	<jsp:include page="templates/dcdialogs.jsp"></jsp:include>
	<div class="container-fluid margin-left-10 margin-top-10">
		<div id="categoryManageWrapper" class="row">
			<div class="form-horizontal" style="display: block;">
				<div class="formSectionalHeader col-lg-12 nopadding fullWidth">
								<fmt:message key="dc.package.manage.category"/>
					<div id="createCategoryBtnWrapper" class="pull-right" style="display:none"><button id="createCategoryButton" class="btn btn-primary"><fmt:message key="dc.package.createcategory.button"/></button></div>
				</div>
				<div id="loader" class="center_it"
						style="margin: 0 auto; display: none;">
						<img src="../common/img/loader.gif" />
				</div>
				<div>
				 	<table class = "table table-bordered dataTable no-footer fullWidth" id="categoryTable"></table>
				</div>
			</div>
		</div>
		<div id="subCategoryManageWrapper" class="row margin-top-30" style="display:none;">
			<div class="form-horizontal" style="display: block;">
				<div class="formSectionalHeader col-lg-12 nopadding fullWidth">
							<fmt:message key="dc.package.manage.subCategory"/>
							<span class="normalFontStyle"><fmt:message key="dc.package.select.category.msg"/></span>
					<div id="createSubCategoryBtnWrapper" class="pull-right" style="display:none"><button id="createSubCategoryButton" class="btn btn-primary"><fmt:message key="dc.package.createsubcategory.button"/></button></div>
				</div>
				<div id="loader" class="center_it"
							style="margin: 0 auto; display: none;">
							<img src="../common/img/loader.gif" />
				</div>
				<div>
				 	<table class = "table table-bordered dataTable no-footer fullWidth" id="subCategoryTable"></table>
				</div>
			</div>
		</div>
		
		<c:if test="${applicationScope.SWStoreIsCVStore eq true}">
			<div id="productVersionManageWrapper" class="row margin-top-30" style="display:none;">
				<div class="form-horizontal" style="display: block;">
					<div class="formSectionalHeader col-lg-12 nopadding fullWidth">
								<fmt:message key="dc.package.manage.productVersion"/>
						<%-- <div id="createProductVersionBtnWrapper" class="pull-right" style="display:none"><button id="createProductVersionButton" class="btn btn-primary"><fmt:message key="dc.package.createproductversion.button"/></button></div> --%>
					</div>
					<div id="loader" class="center_it"
								style="margin: 0 auto; display: none;">
								<img src="../common/img/loader.gif" />
					</div>
					<div>
					 	<table class = "table table-bordered dataTable no-footer fullWidth" id="productVersionTable"></table>
					</div>
				</div>
			</div>
		</c:if>
	</div>
	
	<script nonce="${sessionScope.cspNonce}" >
		var dc = dc || {};
		dc.isCVStore = ${applicationScope.SWStoreIsCVStore};
	</script>

	<jsp:include page="../common/footerV3.jsp">
	<jsp:param value="true" name="bootstrapped" />
	<jsp:param value="../common/js/table/jquery.dataTables-1.10.minV3.js"	name="js" />
	<jsp:param value="../common/datatables/js/dataTables.bootstrap.js" name="js" />
	<jsp:param value="js/subsystems/dcEntityHandler.js" name="js" />
	<jsp:param value="js/subsystems/dcevents.js" name="js" />
	<jsp:param value="js/subsystems/dcservices.js" name="js" />
	<jsp:param value="js/subsystems/dcsettings.js" name="js" />
	<jsp:param value="js/dcutil.js" name="js" />
	</jsp:include>
</fmt:bundle>