<%@ page isErrorPage="true"%>
<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<fmt:message key="Download_Center" var="headerTitle" />	

<fmt:bundle basename="localization.DownloadCenterMessages">
	<c:if test="${param.showWelcomeMsg=='true'}" >
		<fmt:message key="downloadcenter.welcome.msg" var="headerTitle" />
	</c:if>
	
	<jsp:include page="../common/headerV3.jsp">
		<jsp:param value="${headerTitle}" name="titleLocalized" />
		<jsp:param value="${headerTitle}" name="headerTitleLocalized" />
		<jsp:param value="true" name="includeSecHeader" />
		<jsp:param value="true" name="showOnlyHelp" />
		<jsp:param value="css/dc.css" name="css" />
		<jsp:param value="css/downloadPackage.css" name="css" />
		<jsp:param value="../common/css/templatestyles.css" name="css" />
		<jsp:param value="../common/css/headerstyles.css" name="css" />		
	</jsp:include>
	<div class="MainDiv">
		<div class="innerMainDiv">
			<c:choose>
  				<c:when test="${param.isError=='true' && sessionScope.LOGGED_IN_USER_CAP}">
				<div class="dcNotConfigured">
					<p>Sorry, Download Center is currently unavailable. Please try again later					
					</p>
				</div>
			</c:when>
			
			<c:otherwise>
			<c:choose>
  				<c:when test="${sessionScope.LOGGED_IN_USER_CAP}">
					<!-- show this to admins only -->
					<div class="configHeader">To make your software available
							from Download Center, please complete the following steps:</div>
											
						<div class="detailsDiv">
								
								<c:set var="done" value="display:none;"/>	
								<c:set var="notDone" value="display:inline;"/>	
								<c:set var="status" value="cgrey"/>							
							<c:if test="${param.engineEnabled=='true'}">		
								<c:set var="done" value="display:none;"/>	
								<c:set var="notDone" value="display:inline;"/>	
								<c:set var="status" value="cgrey"/>
									<c:if test="${param.repositoryConfigured=='true'}"> 
										<c:set var="notDone" value="display:none;"/>
										<c:set var="done" value="display:inline;"/>	
										
										<c:set var="status" value="cgreen"/>	
									</c:if>	
							<div style="height: 90px;">		
								<div class="number-circle">
													<i class="icon-chart ${status}">1</i>
													<div class="stepTxt" style="${notDone}">
														<a class="configureDC" href="dcConfig.jsp">Create A Download Repository</a>
													</div>
													<div  class="stepTxt" style="${done}">
													Click<a class="configureDC"
													href="dcConfig.jsp?manage=true"> here</a> to manage your
													repositories
												</div>
											</div>	 
								<span class="teaser">Specify where your downloads are located</span>
							</div>	
							<c:set var="uploadLinkDisabledClass" value="disabled"/>
							<c:if test="${param.repositoryConfigured=='true'}"> 
									<c:set var="uploadLinkDisabledClass" value=""/>
							</c:if>
								<c:set var="done" value="display:none;"/>	
								<c:set var="notDone" value="display:inline;"/>	
								<c:set var="status" value="cgrey"/>
								<c:if test="${param.packagesSaved=='true'}"> 
										<c:set var="notDone" value="display:none;"/>
										<c:set var="done" value="display:inline;"/>	
										<c:set var="status" value="cgreen"/>
								</c:if>	
							<div style="height: 90px;">
									<div class="number-circle">
												<i class="icon-chart ${status}">2</i>
									<div  class="stepTxt" style="${notDone}">									
										<a class="uploadFirstPackage ${uploadLinkDisabledClass}" >Add Information About Your Downloads</a>
									</div>													
								</div>
								<span class="teaser" style="${notDone}">Label, classify, and set permissions for your downloads</span>
							</div>	
								<!-- 
								<c:set var="refreshDCDataDisabledClass" value="disabled"/>
								
								<c:if test="${param.packagesSaved=='true'}"> 
								 <c:set var="refreshDCDataDisabledClass" value=""/>
								</c:if>
								<div class="listItem packagesSaved"><i class="icon-ok" style="display:none;"></i> <i class="icon-cancel"></i><a class="importPackages ${refreshDCDataDisabledClass}">Sync</a> the package repository.</div>
								 -->
							</c:if>	
							
						</div>
					
  				</c:when>
  <c:otherwise>
   	<div class="dcNotConfigured">
		<p>
			Sorry, but there are no downloads in your Download Center, yet. Contact your administrator for more information. 	
		</p>
	</div>
 		</c:otherwise>
</c:choose>
	</c:otherwise>	
	</c:choose>
	</div>
	</div>
</fmt:bundle>

<jsp:include page="../common/footerV3.jsp">
<jsp:param value="js/dcconfigstatus.js" name="js" />		
</jsp:include>