<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"%>

<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>

<fmt:message key="Download_Center" var="pageTitle" />
<fmt:bundle basename="localization.DownloadCenterMessages">
	<jsp:include page="../common/headerV3.jsp">
		<jsp:param value="true" name="includeSecHeader" />
		<jsp:param value="true" name="includeHistory" />
		<jsp:param value="true" name="bootstrapped" />
		<jsp:param value="${pageContext.request.contextPath}/common/css/headerstyles.css" name="css" />
		<jsp:param value="${pageContext.request.contextPath}/common/css/jquery.loadmask.css" name="css" />
		<jsp:param value="${pageContext.request.contextPath}/common/bootstrap/css/bootstrap-wc.css" name="css" />
		<jsp:param value="${pageContext.request.contextPath}/common/datatables/css/dataTables.bootstrap.css" name="css" />
		<jsp:param value="${pageContext.request.contextPath}/common/css/table.css" name="css" />
		<jsp:param value="${pageContext.request.contextPath}/common/bootstrap/css/icomoon.css" name="css" />
		<jsp:param value="${pageContext.request.contextPath}/downloadcenter/css/dc.css" name="css" />
		<jsp:param value="${pageTitle}" name="titleLocalized" />
		<jsp:param value="Manage Repositories" name="headerTitleLocalized" />
		<jsp:param value="Download Center:downloadcenter/dc.do" name="breadCrumbValues" />
		<jsp:param value="downloadcenter/dclocale.jsp" name="jsp"/>
	</jsp:include>
	<div class="container-fluid nopadding padding-top-5">
			<div class="row content-min-height">
				<div class="dcConfigMainDiv col-lg-12 col-md-12">
					<div class="form-horizontal" style="display: block;">
						<div class="formSectionalHeader col-lg-12 nopadding addARepository">
							<fmt:message key="dc.config.addrepository"/>
						</div>
						<div class="formSectionalHeader col-lg-12 nopadding editARepository" style="display:none;">

						</div>
					<div class="dcConfigPropsDiv">
						<div class="form-group">
						<label for="repositoryOpts" class="col-lg-3 control-label"  id="repositoryOptions">
							<fmt:message key="dc.config.typeofreportsitory"/>
						</label>
						<div class="col-lg-6">
							<select name="packageRepositorySelect"	id="packageRepositorySelect" class="form-control">
								<option value="1" id="customWS"><fmt:message key="dc.config.repository.option.web"/></option>
								<option value="3" id="networkLocation"><fmt:message key="dc.config.repository.option.network"/></option>
								<option value="4" id="webconsoleUrl"><fmt:message key="dc.config.repository.option.webconsole"/></option>

							</select>
						</div>
					</div>

					<div class="form-group">
						<label for="reporsitoryAlias" class="col-lg-3 control-label"><fmt:message key="dc.config.repository.label.name" /> </label>
					<div class="col-lg-6">
						 <input type="text" id="repositoryAlias" name="repositoryAlias"	class="form-control" />
						 <span id="repositoryAlias_hint" class="errorMsg noDisplay hint"><fmt:message key="package.this.field.is.mandatory" /></span>
						<span id="repositoryAlias_info" class="info form_info">
							<fmt:message key="dc.config.repository.alias.info" />
						</span>
					</div>
					</div>

				<div class="form-group">
						<label for="webservers" id="repositoryLabel" class="col-lg-3 control-label"><fmt:message key="dc.config.repository.type.label.webServer" /></label>
					<div class="col-lg-6">
						 <input type="text" id="wsName" name="wsName"
							class="form-control dcConfigText" value="" placeholder="\\ServerComputerName\ShareName"/>
						<span id="wsName_hint" class="errorMsg noDisplay hint" style=""><fmt:message
									key="package.this.field.is.mandatory" /></span>
						<span id="wsName_info" class="info form_info">
							<fmt:message key="dc.config.repository.type.info" />
						</span>

						<select
							name="webServersList" id="webServersList"
							class="form-control webserverLst"
							style="display: none;">
						</select>
					</div>
				</div>

				<!-- <div class="form-group webserverFavouritePath">
					<label for="webserverFavouritePath"
						class="col-lg-3 control-label" id="repositoryLabel">Browse Location</label>
					<div class="col-lg-6">
						 <input type="text" id="wsFavouritePath" name="wsFavouritePath"
							class="form-control dcConfigText" value="" placeholder=""/>

						<span id="wsFavouritePath_info" class="info form_info">
							You can add a most frequently used location for browse.
						</span>
					</div>
				</div> -->

				<div class="form-group credentialInputs">
					<label for="name" class="col-lg-3 control-label"><fmt:message key="dc.config.repository.user.label" /></label>
					<div class="col-lg-6">
					<input type="text" id="username" name="username" class="form-control dcConfigText" value="" />
					<span id="username_hint" class="errorMsg noDisplay hint"
						style=""><fmt:message key="package.this.field.is.mandatory" /></span>
					</div>
				</div>

				<div class="form-group credentialInputs">
					<label for="password" class="col-lg-3 control-label"><fmt:message key="dc.config.repository.password.label" /> </label>
					<div class="col-lg-6">
					<input type="password" id="password" name="password" class="form-control dcConfigText" value="" />
					 <span id="password_hint" class="errorMsg noDisplay hint"><fmt:message key="package.this.field.is.mandatory" /></span>
					 <span id="password_invalid" class="errorMsg noDisplay hint" style="margin-left: 185px;"><fmt:message key="dc.config.repository.password.hint" /> </span>
					</div>
				</div>
				</div>

				<!-- buttons -->
				<div class="form-group">
				<div class="col-lg-offset-3 col-lg-9 pull-right">
					<button type="button" name="saveRepositoryConfig" class="btn btn-primary" id="saveRepositoryConfig" data-editmode=false><fmt:message key="dc.config.repository.save" /></button>
					<button type="button" name="validateNetworkReporsitory" class="btn btn-success disabled" id="validateNetworkReporsitory" data-editmode=false><fmt:message key="dc.config.repository.validate" /></button>
					<button type="button" name="cancelRepositoryConfig" class="btn btn-default"	id="cancelRepositoryConfig"><fmt:message key="package.cancel.button.text" /></button>
					<label id="addPackageRespMsg"></label>
					<div id="ajaxBusy">
						<p><img src="../login/img/spinner.gif"></p>
					</div>
				</div>
				</div>
				<div class="formSectionalHeader col-lg-12 nopadding">
						<fmt:message key="dc.repositories.title" />
				</div>
				<div class="form-group" style="padding-left:15px;">

					<div id="tableDataBusy" class="center_it" style="margin:0 auto;"><img src="../common/img/loader.gif" /></div>
					<div id="packageRepositories">

					<table id="dcPackageRepository_table" class="tablesorter dtable cell-border">
						<thead>
							<tr>
								<th class="col-name"><fmt:message key="dc.repositories.table.name" /></th>
								<th class="col-hostName"><fmt:message key="dc.repositories.table.host" /></th>
								<th class="col-editRepository borderless" ><fmt:message key="dc.table.th.actions" /></th>
							</tr>
						</thead>
						<tbody id="filetablebody"></tbody>
					</table>
					<div id="browsepager"></div>
		</div>
	</div>
</div>
</div>
</div>
</div>
<div class="dcConfigNoPermission">
	<p> You do not have permission to view this page.</p>
</div>
<div id="deleteConfirmBox" style="display:none;">
	<fmt:message key="package.repository.deletion.alert"/>
</div>
</fmt:bundle>

<jsp:include page="../common/footerV3.jsp">
	<jsp:param value="true" name="bootstrapped" />
	<jsp:param value="../common/js/table/jquery.dataTables-1.10.minV3.js"	name="js" />
	<jsp:param value="../common/datatables/js/dataTables.bootstrap.js" name="js" />
    <jsp:param value="../common/js/jquery.loadmask.cv.js" name="js"/>
    <jsp:param value="../common/js/jquery.corner.js" name="js"/>
    <jsp:param value="../common/js/encoder.js" name="js"/>
    <jsp:param value="js/subsystems/dcsettings.js" name="js"/>
    <jsp:param value="js/subsystems/dcservices.js" name="js"/>
    <jsp:param value="js/dcconfig.js" name="js"/>
</jsp:include>
