<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"%>

<fmt:message key="Download_Center" var="pageTitle" />
<c:set var="isStore"  value="${fn:escapeXml(param.isStore)}"/>
<c:set var="breadCrumbs" value="Download Center:downloadcenter/dc.do" />
<c:set var="showDCSubTitle" value="false"></c:set>
<c:if test="${sessionScope.LOGGED_IN_USER_CAP && isStore != true}">
<c:set var="showDCSubTitle" value="true"></c:set>
</c:if>
<c:if test="${isStore == true}" >
    <fmt:message key="Software_Store" var="pageTitle" />
    <c:set var="breadCrumbs" value="Software Store:downloadcenter/dc.do?isStore=true&packageStatus=${fn:escapeXml(param.packageStatus)}&packageType=${fn:escapeXml(param.packageType)}&sp=relDateDesc" />
</c:if>
<c:choose>
	<c:when test="${sessionScope.CR_VERSION == 'true'}">
		<c:set var="viewReportURL" value="/customreports/viewReport.jsp" />
	</c:when>
	<c:otherwise>
		<c:set var="viewReportURL" value="/reportsplus/reportViewer.jsp" />
	</c:otherwise>
</c:choose>
<fmt:bundle basename="localization.DownloadCenterMessages">
	<jsp:include page="../common/headerV3.jsp">
		<jsp:param value="true" name="bootstrapped" />
		<jsp:param value="true" name="downloadCenterApp" />
		<jsp:param value="true" name="includeSecHeader" />
		<jsp:param value="true" name="includeHistory" />
		<jsp:param value="${pageTitle}" name="titleLocalized" />
		<jsp:param value="${param.packageName}" name="headerTitleLocalized" />
		<jsp:param value="${breadCrumbs}" name="breadCrumbValues" />
		<jsp:param value="true" name="enableLoginLink" />
		<jsp:param value="${showDCSubTitle}" name="showDCSubTitle" />
		<jsp:param value="../common/css/headerstyles.css" name="css" />
		<jsp:param value="../common/css/jquery.loadmask.css" name="css" />
		<jsp:param value="../common/css/custom-cb.css" name="css" />
		<jsp:param value="../common/bootstrap/css/bootstrap-wc.css" name="css" />
		<jsp:param value="../common/css/ckEditor.css" name="css" />
		<jsp:param value="css/dc.css" name="css" />
		<jsp:param value="downloadcenter/includes.jsp" name="jsp" />
	</jsp:include>

	<div class="container-fluid nopadding padding-top-5">
		<div class="row">
			<div id="packageDetails" class="padding-left-25 col-sm-12 col-md-12 col-lg-11">
				<div class="form-horizontal" style="display: block;">
					<div class="formSectionalHeader col-lg-12 nopadding">Download Details</div>
					<div id="downloadDetails">

					</div>

					<div class="formSectionalHeader col-lg-12 nopadding">
								File Info
					</div>
					<div id="dcFileInfo">
						<div class="row platformList"  style="display:none;">
							<div class="col-lg-12">
								<table id="dcPlatformsTbl"
									class="table table-striped table-bordered dt-responsive" cellspacing="0"
									width="100%">
									<thead>
										<tr>
											<th><fmt:message key="package.platform"></fmt:message></th>
											<th><fmt:message key="package.download.type"></fmt:message></th>
											<th><fmt:message key="package.fileName"></fmt:message></th>
										<c:choose>
  											<c:when test="${sessionScope.LOGGED_IN_USER_CAP}">
												<th><fmt:message key="package.readMe"></fmt:message></th>
											</c:when>
										</c:choose>
											<th><fmt:message key="package.details.file.size"></fmt:message></th>
											<th><fmt:message key="package.checksum"></fmt:message></th>
											<th><fmt:message key="dc.table.th.actions"></fmt:message></th>
										</tr>
									</thead>
									<tbody class="addedPlatforms">

									</tbody>
								</table>
							</div>
						</div>
					</div>
					<div class="formSectionalHeader col-lg-12 nopadding"><fmt:message key="package.details.quick.link.overview"/></div>
					<div>
						<div id="dcPackageOverview" class="form-group CvCkEditor">

					</div>
					</div>
					<c:if test="${isStore != true}" >
					<div class="dcRelatedLinkSection" style="display:none">
						<div class="formSectionalHeader col-lg-12 nopadding">
							<fmt:message key="package.details.related.links" />
						</div>
						<div>
							<div id="dcRelatedLinks" class="form-group">

						</div>
						</div>
					</div>
					</c:if>
				</div>


			</div>

		</div>
		<iframe id="downloadIframe" style="display:none;"></iframe>
	</div>
	<script nonce="${sessionScope.cspNonce}" >
		var viewReportURL = "${viewReportURL}";
		var dc = dc || {};
		dc.isOpenAccessDC = '${sessionScope.isDownloadCenterOpenAccess}' === 'true' ? true : false;
	</script>
	<jsp:include page="../common/footerV3.jsp">
		<jsp:param value="true" name="bootstrapped" />
		<jsp:param value="js/downloadPackage.js" name="js" />
	</jsp:include>
</fmt:bundle>