<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>

<fmt:bundle basename="localization.DBListMessages">
	<fmt:message key="no_Data" var="noDataText"/>
	<fmt:message key="Computer_Name" var="computerName"/>
	<fmt:message key="OSName" var="oSName"/>
	<fmt:message key="Platform_Info" var="platformInfo"/>
	<fmt:message key="Product_Version" var="productVersion"/>
	<fmt:message key="List_Computers" var="listComputers"/>
	<fmt:message key="Databases" var="databases"/>
	<fmt:message key="My_Applications" var="myApplications"/>
	
<jsp:include page="../common/header.jsp">
	<jsp:param value="${databases}" name="title" />
	<jsp:param value="../common/css/headerstyles.css" name="css" />
	<jsp:param value="true" name="includeSecHeader" />
	<jsp:param value="true" name="includeTableSupport" />
	<jsp:param value="../common/css/table.css" name="css" />
	<jsp:param value="${listComputers}" name="headerTitleLocalized" />
	<jsp:param value="${myApplications}:applications" name="breadCrumbValues" />
</jsp:include>

<jsp:include page="../common/mask.jsp" />
<link rel="stylesheet" href="${pageContext.request.contextPath}/database/css/database.css" />

<div id="data">
</div>
<div id="clientListTable_Filter" class="reports_Filter">
    <input id="clientListTable_FilterButton" class="tableFilter" type="button" value=""  title="<fmt:message key="Filter"/>" />
	<input type="hidden" id="clientListTable_FilterSelected" />	                
</div>

<div id="clientList" class="reportTable">	
	<table id="clientListTable" class="display tablesorter">
		<col width='20%'>
		<col width='40%'>
		<col width='25%'>
		<col width='15%'>
	 </table>
</div>
</fmt:bundle>

<script nonce="${sessionScope.cspNonce}" >
	var noDataText='${noDataText}';
	var computerName='${computerName}';
	var osName='${oSName}';
	var platformInfo ='${platformInfo}';
	var productVersion ='${productVersion}';
</script>
<jsp:include page="../common/footer.jsp">
	<jsp:param value="js/dbClientList.js" name="js" />
</jsp:include>
