<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>

<fmt:bundle basename="localization.DBListMessages">
	<fmt:message key="no_Data" var="noDataText"/>
	<fmt:message key="LastBackup" var="lastBackup"/>
	<fmt:message key="Size" var="size"/>
	<fmt:message key="Instance_Name" var="instanceName"/>
	<fmt:message key="Database_Name" var="databaseName"/>
	<fmt:message key="List_Databases" var="listDatabases"/>
	<fmt:message key="Databases" var="Databases"/>
	<fmt:message key="List_Computers" var="listComputers"/>
	<fmt:message key="Connect_To_DB" var="connectDB"/>
	<fmt:message key="Cancel" var="cancel"/>
	<fmt:message key="Connect" var="connect"/>
	<fmt:message key="Waiting_for_operation" var="waitingOperation"/>
	<fmt:message key="Operation_completed" var="operationCompleted"/>
 	<fmt:message key="Operation_failed" var="operationFailed"/>
	
<jsp:include page="../common/header.jsp">
	<jsp:param value="${Databases}" name="title" />
	<jsp:param value="true" name="includeSecHeader" />
	<jsp:param value="true" name="includeTableSupport" />
	<jsp:param value="../common/css/table.css" name="css" />
	<jsp:param value="${listDatabases}" name="headerTitleLocalized" />
	<jsp:param value="${listComputers}:database" name="breadCrumbValues" />
	<jsp:param value="../common/css/headerstyles.css" name="css" />
	<jsp:param value="../common/css/custom-cb.css" name="css"/>
	<jsp:param value="../common/js/encoder.js" name="js"/>
</jsp:include>


<jsp:include page="../common/mask.jsp" />
<link rel="stylesheet" href="${pageContext.request.contextPath}/database/css/database.css" />

<div id="data">

</div>
<div id="dbListTable_Filter" class="reports_Filter">
	  <ul class="dbActions">
	    <%-- <li id="QUERY_DATABASE" class="dbActions dummyicon" title="<fmt:message key="Query_Database" />"><img src="img/queryDB.png" width="20px" height="20px"/></li> --%>
	    <li id="LIST_CLONE" class="dbActions dummyicon" title="<fmt:message key="List_Clone" />"><img src="img/listClone.png" width="20px" height="20px"/></li>
	    <input id="dbListTable_FilterButton" class="tableFilter" type="button" value=""  title="<fmt:message key="Filter"/>" />
		<input type="hidden" id="dbListTable_FilterSelected" />	                
	 </ul>
</div>

<div id="databaseList" class="reportTable">	
	<table id="dbListTable" class="display tablesorter">
		<col width='3%'>
		<col width='22%'>
		<col width='35%'>
		<col width='20%'>
		<col width='20%'>
	 </table>
</div>
<div style="visibility:hidden;">
			<div id="userCredentialsDialog" title="${connectDB}">
			<span class="entity"> <label class="dbFormLabel"><fmt:message key="User_name" /></label><input class="dbFormInput required" type="text" 
			name="username" />
			</span> 
			</br>
			</br>
			<span class="entity"> <label class="dbFormLabel"><fmt:message key="Password" /></label><input class="dbFormInput" type="password"
			name="pwd" />
			</span>
			</div>
</div>
</fmt:bundle>

<script nonce="${sessionScope.cspNonce}" >
	var noDataText='${noDataText}';
	var lastBackup='${lastBackup}';
	var size='${size}';
	var instanceName='${instanceName}';
	var databaseName='${databaseName}';
	var connectDB = '${connectDB}';
	var cancel='${cancel}';
	var connect='${connect}';
	var waitingOperation='${waitingOperation}';
	var	operationCompleted='${operationCompleted}';
	var	operationFailed='${operationFailed}';
	var listDatabases = '${listDatabases}';
	var clientId = cvUtil.getParameter('client', 0);
</script>
<jsp:include page="../common/footer.jsp">
<jsp:param value="../common/js/custom-cb.js" name="js"/>
<jsp:param value="js/databaseList.js" name="js"/>
<jsp:param value="../clone/js/cloneOperations.js" name="js" />
</jsp:include>
