<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@ taglib prefix="enhance" uri="/WEB-INF/webenhance.tld" %>

<fmt:bundle basename="localization.CreateCloneMessages">
	<fmt:message key="no_Data" var="noDataText"/>
	<fmt:message key="CreateClone" var="createClone"/>
	<fmt:message key="Job_Running" var="jobRunning"/>
	<fmt:message key="List_Clone" var="listClone"/>
	<fmt:message key="Select_All" var="SelectAll"/>
	<fmt:message key="Database_Name" var="DatabaseName"/>
	<fmt:message key="Client_Name" var="ClientName"/>
	<fmt:message key="Instance_Name" var="InstanceName"/>
	<fmt:message key="Date_Crearted" var="DateCrearted"/>
	<fmt:message key="Date_Expired" var="DateExpired"/>
	<fmt:message key="Clone_Status" var="CloneStatus"/>
	<fmt:message key="User" var="UserName"/>
	<fmt:message key="List_Databases" var="listDatabases"/>
	<fmt:message key="CloneDetails.label.Extend" var="extendTitle"/>
	<fmt:message key="CloneOperations.label.yes" var="yes"/>
	<fmt:message key="CloneOperations.label.no" var="no"/>
	<fmt:message key="CloneOperations.label.cancel" var="cancel"/>
	<fmt:message key="CloneOperations.label.submit" var="submit"/>
	<fmt:message key="CloneOperations.label.confirm_delete" var="confirmDelete"/>
	<fmt:message key="CloneOperations.label.confirm_delete_clone" var="confirmCloneDelete"/>
	<fmt:message key="CloneOperations.label.Waiting_for_operation" var="waitingOperation"/>
 	<fmt:message key="CloneOperations.label.Operation_completed" var="operationCompleted"/>
 	<fmt:message key="CloneOperations.label.Operation_failed" var="operationFailed"/>
 	<fmt:message key="CloneOperations.label.Connect_To_DB" var="connectDB"/>
	<fmt:message key="CloneOperations.label.Connect" var="connect"/>
	<c:set var="breadCrumbValues" value="${listDatabases}:./database/databaseList.jsp?client=${fn:escapeXml(param.client)}" />

<jsp:include page="../common/header.jsp">
	<jsp:param value="List_Clone" name="title" />
	<jsp:param value="true" name="includeSecHeader" />
	<jsp:param value="true" name="includeTableSupport" />
	<jsp:param value="true" name="includeHistory"/>
	<jsp:param value="../common/css/table.css" name="css" />
	<jsp:param value="${listClone}" name="headerTitleLocalized" />
	<jsp:param value="${breadCrumbValues}" name="breadCrumbValues" />
	<jsp:param value="css/clone.css" name="css" />
	<jsp:param value="../common/css/headerstyles.css" name="css" />
	<jsp:param value="../common/css/custom-cb.css" name="css"/>
	<jsp:param value="../common/js/encoder.js" name="js"/>
</jsp:include>

<jsp:include page="../common/mask.jsp" />
<jsp:include page="../jobs/JobManager.jsp" />
<div id="data">

</div>
<div id="CreateNewClone" class="add">
<span id="createClone" class="someLink"><fmt:message key="CreateClone" /></span>
</div>
<%-- <div class="CreateNewClone"><a id="create" href="#"><span class="addWF"><img src="../summary/img/add_16px.png"><fmt:message key="CreateClone" /></span></a></div>
 --%>
 <div class="clearFloat"></div>
<div id="cloneListTable_Filter" class="reports_Filter">
	  <ul class="cloneActions">
		<li id="DELETE_CLONEOP" class="cloneActions dummyicon" title="<fmt:message key="CloneDetails.actions.delete" />"><img src="img/delete.png" width="20px" height="20px"/></li>
	    <li id="EXTEND_CLONEOP" class="cloneActions dummyicon" title="<fmt:message key="CloneDetails.actions.extend" />"><img src="img/extend.png" width="20px" height="20px"/></li>
	    <%-- <li id="QUERY_DATABASE" class="cloneActions dummyicon" title="<fmt:message key="CloneDetails.actions.queryDatabase" />"><img src="img/queryDB.png" width="20px" height="20px"/></li> --%>
	    <input id="cloneListTable_FilterButton" class="tableFilter" type="button" value=""  title="<fmt:message key="Filter"/>" />
		<input type="hidden" id="cloneListTable_FilterSelected" />
	 </ul>
</div>
<br>
<div id="cloneList" class="reportTable">
	<table id="cloneListTable" class="display tablesorter">
	 </table>
</div>
<div style="visibility:hidden;">
			<div id="extendDialog" title="${extendTitle}">
			<label for="newexpirationdate"><fmt:message key="CloneDetails.label.expiryDate" /></label>
			<input style="position: relative; z-index: 9999;" class="datepicker" name="newexpirationdate" id="newexpirationdate" />
			</div>
</div>
<div style="visibility:hidden;">
			<div id="userCredentialsDialog" title="${connectDB}">
			<span class="entity"> <label class="dbFormLabel"><fmt:message key="User_name" /></label><input class="dbFormInput required" type="text"
			name="username" />
			</span>
			</br>
			</br>
			<span class="entity"> <label class="dbFormLabel"><fmt:message key="Password" /></label><input class="dbFormInput" type="password"
			name="pwd" />
			</span>
			</div>
</div>
</fmt:bundle>
<script nonce="${sessionScope.cspNonce}" >
	<enhance:out escapeXml="false">
		var noDataText='${noDataText}';
		var createClone='${createClone}';
		var jobRunning='${jobRunning}';
		var selectAll ='${SelectAll}';
		var databaseName ='${DatabaseName}';
		var clientName ='${ClientName}';
		var instanceName ='${InstanceName}';
		var dateCrearted ='${DateCrearted}';
		var dateExpired ='${DateExpired}';
		var cloneStatus ='${CloneStatus}';
		var userName ='${UserName}';
		var client = cvUtil.getParameter('client', 0);
		var instance = cvUtil.getParameter("instance", 0);
		var subClient = cvUtil.getParameter("subClient", 0);
		var database = cvUtil.getParameter("database", null);
		var extendTitle='${extendTitle}';
		var yes='${yes}';
		var no='${no}';
		var cancel='${cancel}';
		var submit='${submit}';
		var confirmDelete='${confirmDelete}';
		var confirmCloneDelete='${confirmCloneDelete}';
		var waitingOperation='${waitingOperation}';
		var	operationCompleted='${operationCompleted}';
		var	operationFailed='${operationFailed}';
		var connectDB = '${connectDB}';
		var connect='${connect}';
	</enhance:out>
</script>
<jsp:include page="../common/footer.jsp">
	<jsp:param value="js/cloneOperations.js" name="js" />
	<jsp:param value="../common/js/custom-cb.js" name="js"/>
	<jsp:param value="js/listClone.js" name="js"/>
</jsp:include>
