 <%@  taglib uri="../WEB-INF/cvtaglib.tld" prefix="cv" %>
 <%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
 <%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
 <%@ taglib prefix="enhance" uri="/WEB-INF/webenhance.tld" %>

<html>
<head>
<jsp:include page="/common/search-engine.jsp" />
</head>
<body>
<jsp:include page="../common/jquery.jsp" />
<jsp:include page="../common/customSelect.jsp"/>
<jsp:include page="../common/table.jsp" />
<jsp:include page="../common/mask.jsp" />
<link rel="stylesheet" href="${pageContext.request.contextPath}/common/css/templatestyles.css?${applicationScope.BUILD_TS}" />
<link rel="stylesheet" href="${pageContext.request.contextPath}/common/css/table.css?${applicationScope.BUILD_TS}" />
<link rel="stylesheet" href="${pageContext.request.contextPath}/clone/css/clone.css?${applicationScope.BUILD_TS}" />
<link rel="stylesheet" href="${pageContext.request.contextPath}/common/css/ui.spinner.css?${applicationScope.BUILD_TS}" />

<fmt:bundle basename="localization.CreateCloneMessages">
	<fmt:message key="no_Data" var="noDataText"/>
	<fmt:message key="Select_Instance" var="createInstance"/>
	<fmt:message key="Select_DataBase" var="createDatabase"/>
	<fmt:message key="Job_Id" var="JobId"/>
	<fmt:message key="Data_Modified" var="dataModified"/>

	<c:set var="existingSnap" value="${requestScope.existingSnap}" />
	<c:set var="newSnap" value="${requestScope.newSnap}" />
	<c:set var="latestSnap" value="${requestScope.latestSnap}" />

	<div id="wizHolder">
	<div id="wizard1" class="panel" data-next="#wizard2" >

		<div class="clearFloat sourceClone-title"><h2><fmt:message key="Choose_Source"/></h2></div>
		<ul class="selectSource">
		<div class="clearFloat clientCb-title" ><fmt:message key="Choose_Client"/></div>

		<ul id="ClientCb">
	  		<li data-value="0"><fmt:message key="Select_Client"/></li>
	  	</ul>
	  	</ul>
	  	<ul class="selectSource">
	  	<div class="clearFloat instanceCb-title" ><fmt:message key="Choose_Instance"/></div>

		<ul id="InstanceCb">
	  		<li data-value="0"><fmt:message key="Select_Instance"/></li>
	  	</ul>
	  	</ul>
		<ul class="selectSource">
		  	<div class="clearFloat databaseCb-title" ><fmt:message key="Choose_Database"/></div>

		<ul id="DataBaseCb">
	  		<li data-value="0"><fmt:message key="Select_DataBase"/></li>
	  	</ul>
	  	</ul>
	</div>

	<div id="wizard2" class="panel" data-next="#wizard3"  data-prev="#wizard1">
		<div class="clearFloat sourceClone-title"><h2><fmt:message key="Choose_Source"/></h2></div>
		<div class="clearFloat option">
			<c:if test = "${latestSnap}">
				<ul class="selectSource">
					<input id="chooseSnapLatest" name="chooseSnap" type="radio" value='2'><label for="chooseSnapLatest"><fmt:message key="Latest_Snap"/></label>
				</ul>
			</c:if>
			<c:if test = "${existingSnap}">
				<ul class="selectSource">
					<input id="chooseSnapExisting" name="chooseSnap" type="radio" value='0'><label for="chooseSnapExisting"><fmt:message key="Existing_Snap"/></label>
					<br>
					<label style="margin-left: 30px" for="fromdate"><fmt:message key="From" /></label>
					<input style="position: relative; width: 130px" class="datepicker" name="fromdate" id="fromdate" />
					<label style="margin-left: 10px"for="todate"><fmt:message key="To" /></label>
					<input style="position: relative; width: 130px" class="datepicker" name="todate" id="todate" />
				</ul>
			</c:if>
			<c:if test = "${newSnap}">
				<ul class="selectSource">
					<input id="chooseNewSnap" name="chooseSnap" type="radio" value='1'><label for="chooseNewSnap"><fmt:message key="New_Snap"/></label>
				</ul>
			</c:if>
		 </div>
	</div>

	<div id="wizard3" class="panel" data-next="#wizard4" data-prev="#wizard2">
	<div class="clearFloat listClone-title"><h2><fmt:message key="Select_Snap_JobId"/></h2></div>
		<form><table id="snapJobListTable" class="clearFloat reportTable tablesorter">
		</table></form>
	</div>

	<div id="wizard4" class="panel" data-prev="#wizard3">
		<div class="clearFloat destClone-title"><h2><fmt:message key="Choose_Destination"/></h2></div>
		<ul class="selectSource">
		<div class="clearFloat destClientCb-title" ><fmt:message key="Choose_Client"/></div>

		<ul id="DestClientCb">
	  		<li data-value="0"><fmt:message key="Select_Client"/></li>
	  	</ul>
	  	</ul>

	  	<ul class="selectSource">
	  	<div class="clearFloat destInstanceCb-title" ><fmt:message key="Choose_Instance"/></div>

		<ul id="DestInstanceCb">
	  		<li data-value="0"><fmt:message key="Select_Instance"/></li>
	  	</ul>
	  	</ul>

	  	<ul class="selectSource">
	  	<div class="clearFloat destDatabaseText-title" ><fmt:message key="Choose_Database"/></div>
		<div id="destDatabase" class="clearFloat option">
			<input type="text" id="destDatabaseText" data-subClientId="0" class="textbox">
		</div>
	  	</ul>
	  	<ul class="selectSource">
	  	<div id="refreshClone">
            <class="option-title" ><fmt:message key="Expire_After"/>
            <input type="text" id="refreshDays" value="0"/>
            <span><fmt:message key="Days"/></span>
            <input type="text" id="refreshHours" value="0"/>
            <span><fmt:message key="Hours"/></span>
         </div>
        </ul>
<!--   <ul class="navHldr rightAligned">
	  	  <input id="btncreate" type="button" value='<fmt:message key="CreateNewClone" />'>
	  </ul> -->
	</div>

	</div>
	<div class="navHldr">
	<a href="#" id="prev" class="ctlBtn prev">Prev</a>
	<a href="#" id="next" class="ctlBtn next rightAligned">Next</a>
	<input id="btncreate" type="button" class="rightAligned mainBtn" value='<fmt:message key="CreateNewClone" />'>
	</div>
</fmt:bundle>
<script nonce="${sessionScope.cspNonce}" >
	<enhance:out escapeXml="false">
	var noDataText='${noDataText}';
	var createDatabase='${createDatabase}';
	var createInstance='${createInstance}';
	var aData ='${requestScope.Source_Target_List}';
	var client = cvUtil.getParameter('client', 0);
	var instance = cvUtil.getParameter("instance", 0);
	var subClient = cvUtil.getParameter("subClient", 0);
	var database = cvUtil.getParameter("database", null);
	var jobId = '${JobId}';
	var data_Modified = '${dataModified}';
	</enhance:out>
</script>

<script nonce="${sessionScope.cspNonce}" src="../common/js/ui.spinner.min.js"></script>
<script nonce="${sessionScope.cspNonce}" src="js/createClone.js"></script>
<script nonce="${sessionScope.cspNonce}" src="js/cloneOperations.js"></script>

