<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn"%>
 <%@ taglib prefix="enhance" uri="/WEB-INF/webenhance.tld" %>

<fmt:bundle basename="localization.CreateCloneMessages">
	<fmt:message key="List_Clone" var="listClone"/>
	<fmt:message key="CloneDetails.label.Extend" var="extendTitle"/>
	<fmt:message key="CloneOperations.label.yes" var="yes"/>
	<fmt:message key="CloneOperations.label.no" var="no"/>
	<fmt:message key="CloneOperations.label.cancel" var="cancel"/>
	<fmt:message key="CloneOperations.label.submit" var="submit"/>
	<fmt:message key="CloneOperations.label.confirm_delete" var="confirmDelete"/>
	<fmt:message key="CloneOperations.label.confirm_delete_clone" var="confirmCloneDelete"/>
	<fmt:message key="CloneOperations.label.Waiting_for_operation" var="waitingOperation"/>
 	<fmt:message key="CloneOperations.label.Operation_completed" var="operationCompleted"/>
 	<fmt:message key="CloneOperations.label.Operation_failed" var="operationFailed"/>

<enhance:out escapeXml="false">
	<c:set var="clone" value="${requestScope.Clone_Details}" />
	<c:set var="cloneObject" value="${requestScope.Clone_Details_Json}" />
	<c:set var="cloneCreationExpriyTime" value="${requestScope.Clone_Time}" />
	<c:set var="headerTitleLocalized" value="&nbsp;${clone.tgtDatabase.name}" />
	<c:set var="breadCrumbValues" value="${listClone}:./clone/index.jsp?client=${fn:escapeXml(param.client)}&instance=${fn:escapeXml(param.instance)}&database=${fn:escapeXml(param.database)}&subClient=${fn:escapeXml(param.subClient)}" />
</enhance:out>

	<jsp:include page="../common/header.jsp">
		<jsp:param value="../clientDetails/css/summarystyles.css" name="css" />
		<jsp:param value="../common/css/custom-cb.css" name="css" />
		<jsp:param value="../common/css/headerstyles.css" name="css" />
    	<jsp:param value="../common/smartwizard/css/smart_wizard_vertical.css" name="css" />
		<jsp:param value="../common/dynatree/ui.dynatree.css" name="css"/>
		<jsp:param value="../common/css/jquery.loadmask.css" name="css"/>
		<jsp:param value="../common/css/custom-cb.css" name="css"/>
		<jsp:param value="true" name="includeSecHeader" />
		<jsp:param value="Clone_Details" name="title" />
		<jsp:param value="true" name="includeJqueryUI" />
		<jsp:param value="true" name="includeHistory" />
		<jsp:param value="${headerTitleLocalized }" name="headerTitleLocalized" />
		<jsp:param value="${breadCrumbValues}" name="breadCrumbValues" />
		<jsp:param value="css/clone.css" name="css" />
	</jsp:include>

	<div class="cloneDetails">
		<br>

		<ul class="cloneActions">
					<li id="DELETE_CLONE" class="cloneActions dummyicon" title="<fmt:message key="CloneDetails.actions.delete" />"><img src="img/delete.png" width="20px" height="20px"/></li>
	                <li id="EXTEND_CLONE" class="cloneActions dummyicon" title="<fmt:message key="CloneDetails.actions.extend" />"><img src="img/extend.png" width="20px" height="20px"/></li>
        </ul>
        <hr class="blockline"/>

		<ul class="blockrows">
					<li class="infotype"><fmt:message key="CloneDetails.label.appType" /></li>
					<li class="infodesc">${clone.appType.appName}</li>
					<li class="infotype"><fmt:message key="CloneDetails.label.sourceClient" /></li>
					<li class="infodesc">${clone.sourceClient.clientName}</li>
					<li class="infotype"><fmt:message key="CloneDetails.label.sourceInstance" /></li>
					<li class="infodesc">${clone.sourceInstance.instanceName}</li>
					<li class="infotype"><fmt:message key="CloneDetails.label.sourceDatabase" /></li>
					<li class="infodesc">${clone.sourceDatabase.name}</li>
					<li class="infotype"><fmt:message key="CloneDetails.label.tgtClient" /></li>
					<li class="infodesc">${clone.tgtClient.clientName}</li>
					<li class="infotype"><fmt:message key="CloneDetails.label.tgtInstance" /></li>
					<li class="infodesc">${clone.tgtInstance.instanceName}</li>
					<li class="infotype"><fmt:message key="CloneDetails.label.tgtDatabase" /></li>
					<li class="infodesc">${clone.tgtDatabase.name}</li>
					<li class="infotype"><fmt:message key="CloneDetails.label.cloneStatus" /></li>
					<li class="infodesc">${clone.cloneStatus.name}</li>
					<li class="infotype"><fmt:message key="CloneDetails.label.creationDate" /></li>
					<li id="cloneexpiration" class="infodesc">${cloneCreationExpriyTime[0]}</li>
					<li class="infotype"><fmt:message key="CloneDetails.label.expiryDate" /></li>
					<li id="cloneexpiration" class="infodesc">${cloneCreationExpriyTime[1]}</li>
					<%-- <li class="infotype"><fmt:message key="CloneDetails.label.user" /></li>
					<li class="infodesc">${clone.user.userName}</li> --%>
					<li class="infotype"><fmt:message key="CloneDetails.label.array" /></li>
					<li class="infodesc">${clone.array.name}</li>
					<li class="infotype"><fmt:message key="CloneDetails.label.mountPath" /></li>
					<li class="infodesc">${clone.mountPath}</li>
		</ul>
	</div>
		<div style="visibility:hidden;">
			<div id="extendDialog" title="${extendTitle}">
			<label for="newexpirationdate"><fmt:message key="CloneDetails.label.expiryDate" /></label>
			<input style="position: relative; z-index: 9999;" class="datepicker" name="newexpirationdate" id="newexpirationdate" />
			</div>
		</div>

	<jsp:include page="../common/footer.jsp">
	<jsp:param value="../common/js/jquery.loadmask.min.js" name="js"/>
	<jsp:param value="../common/js/jquery-ui-min.js" name="js"/>
	<jsp:param value="../common/js/custom-cb.js" name="js"/>
	<jsp:param value="../common/js/encoder.js" name="js"/>
	<jsp:param value="js/cloneOperations.js" name="js" />
</jsp:include>

<script nonce="${sessionScope.cspNonce}" >
<enhance:out escapeXml="false">
var clone = '${cloneObject}';
var extendTitle='${extendTitle}';
var yes='${yes}';
var no='${no}';
var cancel='${cancel}';
var submit='${submit}';
var confirmDelete='${confirmDelete}';
var confirmCloneDelete='${confirmCloneDelete}';
var waitingOperation='${waitingOperation}';
var	operationCompleted='${operationCompleted}';
var	operationFailed='${operationFailed}';
var aData ='${requestScope.Clone_Details}';
var client = cvUtil.getParameter('client', 0);
var instance = cvUtil.getParameter("instance", 0);
var subClient = cvUtil.getParameter("subClient", 0);
var database = cvUtil.getParameter("database", null);
</enhance:out>
</script>

</fmt:bundle>