<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>

<fmt:bundle basename="localization.DRBackupMessages">
<!-- Main Content -->
<!-- Header row -->
<div id="headerRow">
    <div class="clear-both"></div>
    <div>
        <span class="sec-title" id="companyName" title="{{company_name}}">
            {{company_name}}
        </span>
    </div>
    <div id="headerSearch" class="search nav navbar-nav">
        <!-- Search -->
        <div id="search">
            <input type="text" ng-model="search" id="searchInput" placeholder="<fmt:message key='topbar.label.search' />" dr-escape="search = ''">
            <span id="sb">
                <svg id="search-icon" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" width="24" height="22"
                viewBox="0 0 34 34" style="fill: #505050;">
                <path
                d="M33,31.5,22.4,20.9a11.5,11.5,0,0,0,2.7-7.5A11.7,11.7,0,1,0,13.4,25.1,11.5,11.5,0,0,0,21,22.3L31.6,32.9ZM13.4,23.1a9.7,9.7,0,1,1,9.7-9.7A9.6,9.6,0,0,1,13.4,23.1Z">
                </path>
                </svg>
            </span>
        </div>
        <!-- /Search -->
    </div>
    <div class="clear-both"></div>
</div>
<!-- /Header row -->
<div id="centercol" class="ui-layout-center">
    <!-- Navigation Breadcrumb -->
    <div class="breadcrumb">
        <ul>
            <div ng-repeat="crumb in breadcrumb">
                <li ng-class="{'currentbc' : crumb.isActive}" ng-click="changeView(crumb.view)">{{crumb.name}}</li>
                <svg ng-if="!crumb.isActive" xmlns="http://www.w3.org/2000/svg" width="5" height="8" viewBox="0 0 5 8" class="vw-breadcrumb-arrow"><path d="M0,8V6L3,4,0,2V0L5,4Z"></path></svg>
            </div>
        </ul>
    </div>
    <!-- /Navigation Breadcrumb -->
    <!-- DR Browse Table -->
    <div ng-include="'cvDrTable.jsp'"></div>
    <!-- /DR Browse Table -->
    <!-- Table Pagination Controls -->
    <dir-pagination-controls
    template-url="js/views/dirPagination.tpl.html"
    direction-links="true"
    boundary-links="true" >
    </dir-pagination-controls>
    <!-- /Table Pagination Controls -->
</div>
<!-- /Main Content -->
</fmt:bundle>
