<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv" %>

<fmt:bundle basename="localization.DRBackupMessages">
<md-dialog class="cv-dialog view-requests-dialog" aria-label="Access Requests">
    <form name="AccessRequestsApprovalForm" ng-cloak>
        <md-toolbar class="cv-theme">
            <div class="md-toolbar-tools">
                <h2><span ng-bind="selected.name"></span> <fmt:message key="dialog.view_requests_title" /></h2>
                <span flex></span>
                <md-button class="cv-close-btn" ng-click="hide()" aria-label="Close">
                    <svg id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 19.94 19.94"><defs><style>.cls-1{fill:#fff;}</style></defs><path class="cls-1" d="M20,2l-2-2L10,8,2,0,0,2l8,8-8,8,2,2,8-8,8,8,2-2-8-8Z" transform="translate(-0.01 0.01)"/></svg>
                </md-button>
            </div>
        </md-toolbar>

        <md-dialog-content>
            <div class="md-dialog-content">
                <md-list flex>
                    <!-- Loader -->
                    <div ng-if="!data_loaded" layout="row" layout-sm="column" layout-align="space-around">
                        <md-progress-circular md-mode="indeterminate"></md-progress-circular>
                    </div>
                    <div class="request-item" ng-repeat="request in requestArr">
                        <md-list-item class="md-3-line secondary-button-padding access-request">
                            <div class="md-list-item-text" layout="column">
                                <h3 ng-bind="request.requestor.name"></h3>
                                <h4 ng-bind="request.requestor.email"></h4>
                                <p ng-bind="formatDate(request.requested_time, date_formats.DATE_ONLY)"></p>
                            </div>
                            <md-button class="cv-button-plain md-secondary" ng-click="toggleExpand($index)" ng-disabled="!data_loaded"><fmt:message key="dialog.button.details" /></md-button>
                            <md-button class="cv-button md-secondary approve" ng-click="approveRejectDialog($event, request, actions.APPROVE)" ng-disabled="!data_loaded">&#10003; <fmt:message key="dialog.button.approve" /></md-button>
                            <md-button class="cv-button md-secondary reject" ng-click="approveRejectDialog($event, request, actions.REJECT)" ng-disabled="!data_loaded">&#x2715; <fmt:message key="dialog.button.reject" /></md-button>
                        </md-list-item>
                        <div class="request-details" ng-show="isExpanded($index)">
                            <table class = "request-details-table">
                                <tbody>
                                    <tr>
                                        <td><fmt:message key="dialog.tableColumn.name" /></td>
                                        <td ng-bind="request.requestor.name"></td>
                                    </tr>
                                    <tr>
                                        <td><fmt:message key="dialog.tableColumn.email" /></td>
                                        <td ng-bind="request.requestor.email"></td>
                                    </tr>
                                    <tr>
                                        <td><fmt:message key="dialog.tableColumn.requestedSet" /></td>
                                        <td ng-bind="request.set_name"></td>
                                    </tr>
                                    <tr>
                                        <td><fmt:message key="dialog.tableColumn.requestTime" /></td>
                                        <td ng-bind="formatDate(request.requested_time, date_formats.UPTO_MINUTE_12H)"></td>
                                    </tr>
                                    <tr ng-if="request.requestor_comments">
                                        <td><fmt:message key="dialog.tableColumn.requestComments" /></td>
                                        <td ng-bind="request.requestor_comments"></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div ng-if="data_loaded && requestArr.length == 0" class="cv-empty">
                        <svg class="svg-primary-fill" xmlns="http://www.w3.org/2000/svg" x="0" y="0" viewBox="0 0 64 64" xml:space="preserve"><style>.st0{fill:none}</style><path class="st0" d="M55.2 49.9c0-.5.4-.9.9-.9h3.3c-.4-5.1-4.5-9.3-9.7-9.7v3.2c0 .5-.4.9-.9.9s-.8-.3-.8-.8v-3.3c-5.2.4-9.3 4.5-9.7 9.7h3.3c.5 0 .9.4.9.9s-.4.8-.9.8h-3.3c.4 5.1 4.6 9.3 9.7 9.7v-3.3c0-.5.4-.9.9-.9s.9.4.9.9v3.3c5.2-.4 9.3-4.5 9.7-9.7h-3.3c-.6.1-1-.3-1-.8zm-.1-2.7c0 .2-.2.4-.4.5l-5 3.2c-.1.1-.3.1-.5.1s-.4-.1-.6-.2l-6.3-5.7c-.2-.2-.3-.4-.3-.6 0-.2.1-.5.2-.6.3-.4.9-.4 1.2-.1l5.8 5.3 4.4-2.8c.4-.3.9-.1 1.2.3.3.2.3.4.3.6zM15.9 43.5H8.6v10h9.9v-10h-2.6z"></path><path d="M24.3 16.6h13.5c.5 0 .8-.4.8-.8s-.4-.8-.8-.8H24.3c-.5 0-.8.4-.8.8s.4.8.8.8zM24.3 21.4h18.4c.5 0 .8-.4.8-.8s-.4-.8-.8-.8H24.3c-.5 0-.8.4-.8.8s.4.8.8.8zM24.4 30.9c-.5 0-.8.4-.8.8s.4.8.8.8h13.5c.5 0 .8-.4.8-.8s-.4-.8-.8-.8H24.4zM43.6 36.4c-.1-.4-.4-.6-.8-.6H24.4c-.5 0-.8.4-.8.8s.4.8.8.8h17.1c.7-.4 1.4-.7 2.1-1zM24.4 49h10c0-.6.1-1.1.2-1.6H24.4c-.5 0-.8.4-.8.8s.3.8.8.8zM24.4 53.9H35c-.2-.5-.3-1.1-.4-1.6H24.4c-.5 0-.8.4-.8.8s.3.8.8.8z"></path><path d="M5.6 60.4c-.6 0-1.1-.6-1.1-1.3V4.9c0-.7.5-1.3 1.1-1.3h41.3c.6 0 1.1.6 1.1 1.3v30.5h1.4V4.9c0-1.6-1.1-2.9-2.6-2.9H5.6C4.2 2 3 3.3 3 4.9v54.2C3 60.7 4.2 62 5.6 62h35.9c-.8-.5-1.5-1-2.2-1.6H5.6z"></path><path d="M16 11.1V9.8H8.7c-.7 0-1.3.6-1.3 1.3v10c0 .7.6 1.3 1.3 1.3h10c.7 0 1.3-.6 1.3-1.3v-3.3h-1.3v3.3h-10v-10H16z"></path><path d="M23.1 10c-.3-.4-.8-.4-1.1-.1L15.8 16l-2.2-2.2c-.1-.1-.3-.2-.5-.2s-.4.1-.5.2c-.1.1-.2.3-.2.5s.1.4.2.5l2.7 2.7c.1.1.3.2.5.2s.4-.1.5-.2L23 11c.1-.1.2-.3.2-.5s0-.4-.1-.5zM20 33.9h-1.3v3.3h-10v-10H16v-1.3H8.7c-.7 0-1.3.6-1.3 1.3v10c0 .7.6 1.3 1.3 1.3h10c.7 0 1.3-.6 1.3-1.3v-3.3z"></path><path d="M23.2 26.5c0-.2-.1-.3-.2-.5-.3-.3-.8-.3-1.1 0l-6.1 6.1-2.2-2.2c-.1-.1-.3-.2-.5-.2s-.4.1-.5.2c-.1.1-.2.3-.2.5s.1.4.2.5l2.7 2.7c.1.1.3.2.5.2s.4-.1.5-.2l6.7-6.7c.2 0 .2-.2.2-.4zM18.5 42.2H8.6c-.5 0-1 .3-1.2.8-.1.2-.1.3-.1.5v10c0 .7.6 1.3 1.3 1.3h10c.4 0 .7-.1.9-.4.2-.2.4-.6.4-.9v-10c-.1-.7-.6-1.3-1.4-1.3zm0 8v3.3H8.6v-10h10v6.7zM48.8 37.8v.5-.5c-6.7 0-12.2 5.4-12.2 12.1S42.1 62 48.8 62C55.5 62 61 56.6 61 49.9c0-6.6-5.5-12.1-12.2-12.1zm.9 22.6v-3.3c0-.5-.4-.9-.9-.9s-.8.5-.8 1v3.3c-5.2-.4-9.3-4.5-9.7-9.7h3.3c.5 0 .9-.4.9-.8s-.4-.9-.9-.9h-3.3c.4-5.2 4.6-9.3 9.7-9.7v3.3c0 .5.4.9.9.9s.9-.4.9-.9v-3.2c5.2.4 9.3 4.5 9.7 9.7h-3.3c-.5 0-.9.4-.9.9s.4.8.9.8h3.3c-.5 5-4.7 9.1-9.8 9.5z"></path><path d="M53.8 46.3l-4.4 2.8-5.8-5.3c-.4-.3-.9-.3-1.2.1-.2.2-.2.4-.2.6 0 .2.1.4.3.6l6.3 5.7c.2.1.4.2.6.2.2 0 .3 0 .5-.1l5-3.2c.2-.1.3-.3.4-.5 0-.2 0-.5-.1-.6-.5-.4-1-.5-1.4-.3z"></path></svg>
                        <h3 class="no-margin"><fmt:message key="dialog.no_requests" /></h3>
                    </div>
                </md-list>
            </div>
        </md-dialog-content>

        <md-dialog-actions layout="row">
            <span flex></span>
            <md-button class="cv-button" ng-click="hide()">
                <fmt:message key="dialog.close" />
            </md-button>
        </md-dialog-actions>
    </form>
</md-dialog>
</fmt:bundle>
