<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv" %>

<fmt:bundle basename="localization.DRBackupMessages">
<md-dialog class="cv-dialog" aria-label="Request Access">
    <form name="requestAccessForm" ng-cloak>
        <md-toolbar class="cv-theme">
            <div class="md-toolbar-tools">
                <h2><fmt:message key="dialog.request_title" /></h2>
                <span flex></span>
                <md-button class="cv-close-btn" ng-click="hide()" aria-label="Close">
                    <svg id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 19.94 19.94"><defs><style>.cls-1{fill:#fff;}</style></defs><path class="cls-1" d="M20,2l-2-2L10,8,2,0,0,2l8,8-8,8,2,2,8-8,8,8,2-2-8-8Z" transform="translate(-0.01 0.01)"/></svg>
                </md-button>
            </div>
        </md-toolbar>

        <md-dialog-content>
            <div class="md-dialog-content">
                <p ng-if="validForSubmit" ng-bind-html="i8nText.request_message">
                </p>
                <p ng-if="!validForSubmit && selected.access_value == access_status.SUBMITTED" ng-bind-html="i8nText.already_submitted">
                </p>
                <p ng-if="!validForSubmit && selected.access_value == access_status.APPROVED" ng-bind-html="i8nText.already_have_access">
                </p>
                <br />
                    <md-input-container ng-show="validForSubmit" class="md-block" md-no-float>
                        <label><fmt:message key="dialog.comments_label" /></label>
                        <textarea name="comments" ng-model="formFields.comments" ng-disabled="formProcessing" rows="1" required md-autofocus></textarea>
                        <div ng-messages="requestAccessForm.comments.$error">
                            <div ng-message="required"><fmt:message key="errors.enter_comments" /></div>
                        </div>
                    </md-input-container>
                    <div class="form-error" ng-if="isError"><span ng-bind="errorText"></span></div>
            </div>
        </md-dialog-content>

        <md-dialog-actions layout="row">
            <span flex></span>
            <md-button class="cv-button-plain" ng-click="hide()" ng-if="!validForSubmit">
                <fmt:message key="dialog.close" />
            </md-button>
            <md-button class="cv-button-plain" ng-click="hide()" ng-if="validForSubmit" ng-disabled="formProcessing">
                <fmt:message key="dialog.cancel" />
            </md-button>
            <md-button class="cv-button" ng-if="validForSubmit" ng-disabled="!validForSubmit || formProcessing" ng-click="submitForm()">
                <fmt:message key="dialog.submit" />
            </md-button>
        </md-dialog-actions>
    </form>
</md-dialog>
</fmt:bundle>
