<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv" %>

<fmt:bundle basename="localization.DRBackupMessages">
<md-dialog class="cv-dialog approve-reject-dialog" aria-label="Approve/Reject Access">
    <form name="approveRejectForm" ng-cloak>
        <md-toolbar class="cv-theme">
            <div class="md-toolbar-tools">
                <h2 ng-if="action == actions.APPROVE"><fmt:message key="dialog.approve_title" /></h2>
                <h2 ng-if="action == actions.REJECT"><fmt:message key="dialog.reject_title" /></h2>
                <span flex></span>
                <md-button class="cv-close-btn" ng-click="cancel()" aria-label="Close">
                    <svg id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 19.94 19.94"><defs><style>.cls-1{fill:#fff;}</style></defs><path class="cls-1" d="M20,2l-2-2L10,8,2,0,0,2l8,8-8,8,2,2,8-8,8,8,2-2-8-8Z" transform="translate(-0.01 0.01)"/></svg>
                </md-button>
            </div>
        </md-toolbar>

        <md-dialog-content>
            <div class="md-dialog-content">
                <p ng-bind-html="i8nText.approval_message">
                </p>
                <br />
                <div layout-gt-sm="row" ng-if="action == actions.APPROVE">
                    <md-input-container class="md-block" flex-gt-sm>
                        <md-checkbox class="bottom-hint" ng-model="formFields.isValidityLimited" ng-disabled="formProcessing" aria-label="Set access expiry">
                            <fmt:message key="dialog.access_expiry" />
                        </md-checkbox>
                        <div class="hint" ng-if="!formFields.isValidityLimited"><fmt:message key="dialog.no_expiry" /></div>
                        <div class="hint" ng-if="formFields.isValidityLimited" ng-bind="getLocalizedExpiryMessage(formFields.validUptoDate)"></div>
                    </md-input-container>
                    <md-input-container class="md-block" flex-gt-sm ng-show="formFields.isValidityLimited">
                        <md-datepicker name="validUptoDate" ng-model="formFields.validUptoDate" ng-required="formFields.isValidityLimited" ng-disabled="formProcessing" md-min-date="minDate" md-placeholder="Select validity" md-open-on-focus></md-datepicker>
                        <div ng-messages="approveRejectForm.validUptoDate.$error">
                            <div ng-message="valid"><fmt:message key="errors.invalid_date" /></div>
                            <div ng-message="mindate"><fmt:message key="errors.future_date" /></div>
                        </div>
                    </md-input-container>
                </div>
                <md-input-container class="md-block" md-no-float>
                    <label><fmt:message key="dialog.comments_label" /></label>
                    <textarea name="comments" ng-model="formFields.comments" ng-required="action == actions.REJECT" ng-disabled="formProcessing" rows="1" md-autofocus></textarea>
                    <div ng-messages="approveRejectForm.comments.$error">
                        <div ng-message="required"><fmt:message key="errors.enter_comments" /></div>
                    </div>
                </md-input-container>
                <div class="form-error" ng-if="isError"><span ng-bind="errorText"></span></div>
            </div>
        </md-dialog-content>

        <md-dialog-actions layout="row">
            <span flex></span>
            <md-button ng-disabled="formProcessing" class="cv-button-plain" ng-click="cancel()">
                <fmt:message key="dialog.cancel" />
            </md-button>
            <md-button ng-disabled="formProcessing" class="cv-button" ng-click="approveDenyRequest(request.company_id, request.request_id, action)">
                <fmt:message key="dialog.submit" />
            </md-button>
        </md-dialog-actions>
    </form>
</md-dialog>
</fmt:bundle>
